/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.PartitionMapType2;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.util.List;

public class PartitionMapSparable
extends PartitionMapType2 {
    public Integer packetLength;
    public Integer numberOfSparingTables;
    public Long sizeOfEachSparingTable;
    public List<Long> locationsOfSparingTables;
    public static final int LENGTH = 64;

    public PartitionMapSparable(byte[] bytes) throws InvalidDescriptor {
        super(bytes);
        this.deserialize(bytes);
    }

    private void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 64) {
            throw new InvalidDescriptor("Partition map type 2 too short");
        }
        this.packetLength = UDFUtil.getUInt16(bytes, 40);
        this.numberOfSparingTables = UDFUtil.getUInt8(bytes, 42);
        this.sizeOfEachSparingTable = UDFUtil.getUInt32(bytes, 44);
        int pos = 0;
        for (int i = 0; i < this.numberOfSparingTables; ++i) {
            pos = 48 + i * 4;
            this.locationsOfSparingTables.add(UDFUtil.getUInt32(bytes, pos));
        }
    }

    @Override
    public String toString() {
        return "PartitionMapSparable [packetLength=" + this.packetLength + ", numberOfSparingTables=" + this.numberOfSparingTables + ", sizeOfEachSparingTable=" + this.sizeOfEachSparingTable + ", locationsOfSparingTables=" + this.locationsOfSparingTables + ", " + super.toString() + "]";
    }
}

