/*
 * Decompiled with CFR 0.152.
 */
package com.floreysoft.jmte;

import com.floreysoft.jmte.ErrorHandler;
import com.floreysoft.jmte.ModelAdaptor;
import com.floreysoft.jmte.ModelBuilder;
import com.floreysoft.jmte.Processor;
import com.floreysoft.jmte.ScopedMap;
import com.floreysoft.jmte.TemplateContext;
import com.floreysoft.jmte.message.ErrorMessage;
import com.floreysoft.jmte.message.NoLogErrorHandler;
import com.floreysoft.jmte.token.InvalidToken;
import com.floreysoft.jmte.token.Token;
import com.floreysoft.jmte.util.Util;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class DefaultModelAdaptor
implements ModelAdaptor {
    private static final String DEFAULT_SPECIAL_ITERATOR_VARIABLE = "_it";
    private static final String ERROR_STRING = "";
    protected final Map<Class<?>, Map<String, Member>> cache = new HashMap();
    private final LoopMode loopMode;
    private final String specialIteratorVariable;
    private final boolean enableSlowMapAccess;

    public DefaultModelAdaptor() {
        this(LoopMode.DEFAULT);
    }

    public DefaultModelAdaptor(LoopMode loopMode) {
        this(loopMode, DEFAULT_SPECIAL_ITERATOR_VARIABLE, true);
    }

    public DefaultModelAdaptor(LoopMode loopMode, String specialIteratorVariable, boolean enableSlowMapAccess) {
        this.loopMode = loopMode;
        this.specialIteratorVariable = specialIteratorVariable;
        this.enableSlowMapAccess = enableSlowMapAccess;
    }

    public Object getValue(Map<String, Object> model, String expression) {
        String[] split = expression.split("\\.");
        List<String> segments = Arrays.asList(split);
        NoLogErrorHandler errorHandler = new NoLogErrorHandler();
        InvalidToken token = new InvalidToken();
        Object value = this.traverse(segments, model, errorHandler, token);
        return value;
    }

    @Override
    public Object getValue(TemplateContext context, Token token, List<String> segments, String expression) {
        Object value = this.traverse(segments, context.model, context.errorHandler, token);
        if (value instanceof Processor) {
            value = ((Processor)value).eval(context);
        } else if (value instanceof Callable) {
            try {
                value = ((Callable)value).call();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    @Override
    public Iterable<Object> getIterable(Object value) {
        List<Object> arrayAsList;
        Iterable<Object> iterable = value == null ? Collections.emptyList() : (value instanceof Map ? (this.loopMode == LoopMode.LIST ? Collections.singletonList(value) : ((Map)value).entrySet()) : (value instanceof Iterable ? (Iterable)value : ((arrayAsList = Util.arrayAsList(value)) != null ? arrayAsList : Collections.singletonList(value))));
        return iterable;
    }

    @Override
    public String getSpecialIteratorVariable() {
        return this.specialIteratorVariable;
    }

    protected Object traverse(List<String> segments, Map<String, Object> model, ErrorHandler errorHandler, Token token) {
        return this.traverse(model, segments, 0, errorHandler, token);
    }

    protected Object traverse(Object o, List<String> attributeNames, int index, ErrorHandler errorHandler, Token token) {
        Object result;
        if (index >= attributeNames.size()) {
            result = o;
        } else {
            if (o == null) {
                return null;
            }
            String attributeName = attributeNames.get(index);
            Object nextStep = this.nextStep(o, attributeName, errorHandler, token);
            result = this.traverse(nextStep, attributeNames, index + 1, errorHandler, token);
        }
        return result;
    }

    protected Object nextStep(Object o, String attributeName, ErrorHandler errorHandler, Token token) {
        Object result;
        String arrayName;
        if (o instanceof String) {
            if (o != ERROR_STRING) {
                errorHandler.error(ErrorMessage.NO_CALL_ON_STRING, token, new ModelBuilder("receiver", (Object)o.toString()).build());
            }
            return o;
        }
        boolean arrayAccess = Util.isArrayAccess(attributeName);
        if (arrayAccess && !Util.isValidArrayAccess(attributeName)) {
            errorHandler.error(ErrorMessage.INVALID_ARRAY_SYNTAX, token, new ModelBuilder("arrayExpression", (Object)attributeName).build());
            return ERROR_STRING;
        }
        String rawAttributeName = !arrayAccess ? attributeName : (arrayName = Util.extractArrayName(attributeName));
        if (o instanceof Map) {
            result = this.accessMap((Map)o, rawAttributeName);
        } else {
            List<Object> arrayAsList = Util.arrayAsList(o);
            if (arrayAsList != null && !arrayAccess && rawAttributeName.equalsIgnoreCase("length")) {
                return arrayAsList.size();
            }
            try {
                result = this.getPropertyValue(o, rawAttributeName);
            }
            catch (Exception e) {
                if (o != ERROR_STRING) {
                    errorHandler.error(ErrorMessage.PROPERTY_ACCESS, token, new ModelBuilder("property", (Object)rawAttributeName, "object", o, "exception", (Object)e).build());
                }
                return ERROR_STRING;
            }
        }
        if (arrayAccess) {
            String arrayIndex = Util.extractArrayIndex(attributeName);
            result = this.getIndexFromArray(result, arrayIndex, errorHandler, token);
        }
        return result;
    }

    protected Object getIndexFromArray(Object array, String arrayIndex, ErrorHandler errorHandler, Token token) {
        if (array == null) {
            errorHandler.error(ErrorMessage.NOT_ARRAY, token, new ModelBuilder("array", (Object)"[null]").build());
            return ERROR_STRING;
        }
        List<Object> arrayAsList = Util.arrayAsList(array);
        try {
            if (arrayAsList != null) {
                try {
                    if (arrayIndex.equalsIgnoreCase("last")) {
                        if (arrayAsList.size() > 0) {
                            int index = arrayAsList.size() - 1;
                            return arrayAsList.get(index);
                        }
                        if (array != ERROR_STRING) {
                            errorHandler.error(ErrorMessage.INDEX_OUT_OF_BOUNDS, token, new ModelBuilder("arrayIndex", (Object)arrayIndex, "array", (Object)array.toString()).build());
                        }
                        return ERROR_STRING;
                    }
                    if (arrayIndex.contains(",")) {
                        String[] interval = arrayIndex.split(",");
                        int start = Integer.parseInt(interval[0]);
                        int end = interval.length == 1 ? arrayAsList.size() : start + Integer.parseInt(interval[1]) + 1;
                        ArrayList<Object> returnArray = new ArrayList<Object>();
                        for (int i = start; i < end && i < arrayAsList.size(); ++i) {
                            returnArray.add(arrayAsList.get(i));
                        }
                        return returnArray;
                    }
                    int index = Integer.parseInt(arrayIndex);
                    return arrayAsList.get(index);
                }
                catch (NumberFormatException nfe) {
                    if (array != ERROR_STRING) {
                        errorHandler.error(ErrorMessage.INVALID_INDEX, token, new ModelBuilder("arrayIndex", (Object)arrayIndex, "array", (Object)array.toString()).build());
                    }
                    return ERROR_STRING;
                }
            }
            if (array instanceof String && array != ERROR_STRING) {
                if (arrayIndex.contains(",")) {
                    String[] interval = arrayIndex.split(",");
                    int start = Integer.parseInt(interval[0]);
                    int end = interval.length == 1 ? array.toString().length() : start + Integer.parseInt(interval[1]);
                    return array.toString().substring(start, end);
                }
                int index = Integer.parseInt(arrayIndex);
                return array.toString().substring(index, index + 1);
            }
            if (array != ERROR_STRING) {
                errorHandler.error(ErrorMessage.NOT_ARRAY, token, new ModelBuilder("array", (Object)array.toString()).build());
            }
            return array;
        }
        catch (IndexOutOfBoundsException e) {
            if (array != ERROR_STRING) {
                errorHandler.error(ErrorMessage.INDEX_OUT_OF_BOUNDS, token, new ModelBuilder("arrayIndex", (Object)arrayIndex, "array", (Object)array.toString()).build());
            }
            return ERROR_STRING;
        }
    }

    protected Object accessMap(Map map, String key) {
        Collection<Object> result = key.equals("_entries") ? map.entrySet() : (key.equals("_keys") ? map.keySet() : (key.equals("_values") ? map.values() : map.get(key)));
        if (result == null && this.enableSlowMapAccess && !(map instanceof ScopedMap)) {
            Set entries = map.entrySet();
            for (Map.Entry entry : entries) {
                if (!entry.getKey().toString().equals(key)) continue;
                result = entry.getValue();
                break;
            }
        }
        return result;
    }

    protected Object getPropertyValue(Object o, String propertyName) {
        try {
            Field field;
            Method[] declaredMethods;
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                if (propertyName.equals("key")) {
                    Object result = entry.getKey();
                    return result;
                }
                if (propertyName.equals("value")) {
                    Object result = entry.getValue();
                    return result;
                }
            }
            boolean valueSet = false;
            Object value = null;
            Member member = null;
            Class<?> clazz = o.getClass();
            Map<String, Member> members = this.cache.get(clazz);
            if (members == null) {
                members = new HashMap<String, Member>();
                this.cache.put(clazz, members);
            } else {
                member = members.get(propertyName);
                if (member != null) {
                    if (member.getClass() == Method.class) {
                        return ((Method)member).invoke(o, new Object[0]);
                    }
                    if (member.getClass() == Field.class) {
                        return ((Field)member).get(o);
                    }
                }
            }
            String suffix = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
            for (Method method : declaredMethods = clazz.getMethods()) {
                if (!Modifier.isPublic(method.getModifiers()) || !method.getName().equals("get" + suffix) && !method.getName().equals("is" + suffix) || method.getParameterTypes().length != 0) continue;
                value = method.invoke(o, (Object[])null);
                valueSet = true;
                member = method;
                break;
            }
            if (!valueSet && Modifier.isPublic((field = clazz.getField(propertyName)).getModifiers())) {
                value = field.get(o);
                member = field;
                valueSet = true;
            }
            if (valueSet) {
                members.put(propertyName, member);
            }
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static enum LoopMode {
        DEFAULT,
        LIST;

    }
}

