/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.iso9660.rrip;

import com.github.stephenc.javaisotools.loopfs.iso9660.Util;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.exceptions.InvalidSuspField;
import java.util.ArrayList;
import java.util.List;

class RripSLComponent {
    private int flags = 0;
    private int length = 0;
    private String text = null;

    public RripSLComponent(int flags, int length, String text) {
        this.flags = flags;
        this.length = length;
        this.text = text;
    }

    public boolean isNormalLink() {
        return (this.flags & 0xFFFFFFFE) == 0;
    }

    public boolean linksToCurrentDir() {
        return (this.flags & 0xFFFFFFFE) == 2;
    }

    public boolean linksToParentDir() {
        return (this.flags & 0xFFFFFFFE) == 4;
    }

    public boolean linksToRootDir() {
        return (this.flags & 0xFFFFFFFE) == 8;
    }

    public int getLength() {
        return this.length;
    }

    public String getText() {
        return this.text;
    }

    public static List<RripSLComponent> fromComponentArea(byte[] bytes) throws InvalidSuspField {
        int offset = 0;
        ArrayList<RripSLComponent> comps = new ArrayList<RripSLComponent>();
        byte[] subArray = bytes;
        while (bytes.length - offset >= 2) {
            RripSLComponent comp = RripSLComponent.fromByte(subArray);
            comps.add(comp);
            subArray = Util.getBytes(bytes, offset += comp.length + 2, bytes.length - offset);
        }
        if (bytes.length - offset != 0) {
            throw new InvalidSuspField("SLComponent field has redundant bytes");
        }
        return comps;
    }

    public static RripSLComponent fromByte(byte[] bytes) throws InvalidSuspField {
        int flags = Util.getUInt8(bytes, 1);
        int length = Util.getUInt8(bytes, 2);
        String text = Util.getString(bytes, 3, length);
        return new RripSLComponent(flags, length, text);
    }
}

