/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model.search;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.kiulian.downloader.model.AbstractListVideoDetails;
import com.github.kiulian.downloader.model.Utils;
import com.github.kiulian.downloader.model.search.SearchResultItem;
import com.github.kiulian.downloader.model.search.SearchResultItemType;
import java.util.ArrayList;
import java.util.List;

public class SearchResultVideoDetails
extends AbstractListVideoDetails
implements SearchResultItem {
    private final boolean isMovie;
    private String description;
    private String viewCountText;
    private long viewCount;
    private long startTime;
    private List<String> badges;
    private List<String> richThumbnails;

    public SearchResultVideoDetails(JSONObject jSONObject, boolean bl) {
        super(jSONObject);
        int n;
        Object object;
        this.isMovie = bl;
        if (jSONObject.containsKey("lengthText")) {
            object = jSONObject.getJSONObject("lengthText").getString("simpleText");
            this.lengthSeconds = Utils.parseLengthSeconds((String)object);
        }
        if (bl) {
            this.description = Utils.parseRuns(jSONObject.getJSONObject("descriptionSnippet"));
        } else if (jSONObject.containsKey("detailedMetadataSnippets")) {
            this.description = Utils.parseRuns(jSONObject.getJSONArray("detailedMetadataSnippets").getJSONObject(0).getJSONObject("snippetText"));
        }
        if (jSONObject.containsKey("upcomingEventData")) {
            object = jSONObject.getJSONObject("upcomingEventData").getString("startTime");
            this.startTime = Long.parseLong((String)object);
            this.viewCount = -1L;
        } else if (jSONObject.containsKey("viewCountText")) {
            object = jSONObject.getJSONObject("viewCountText");
            if (((JSONObject)object).containsKey("simpleText")) {
                this.viewCountText = ((JSONObject)object).getString("simpleText");
                this.viewCount = Utils.parseViewCount(this.viewCountText);
            } else if (((JSONObject)object).containsKey("runs")) {
                this.viewCountText = Utils.parseRuns((JSONObject)object);
                this.viewCount = -1L;
            }
        }
        if (jSONObject.containsKey("badges")) {
            object = jSONObject.getJSONArray("badges");
            this.badges = new ArrayList<String>(((JSONArray)object).size());
            for (n = 0; n < ((JSONArray)object).size(); ++n) {
                JSONObject jSONObject2 = ((JSONArray)object).getJSONObject(n);
                if (!jSONObject2.containsKey("metadataBadgeRenderer")) continue;
                this.badges.add(jSONObject2.getJSONObject("metadataBadgeRenderer").getString("label"));
            }
        }
        if (jSONObject.containsKey("richThumbnail")) {
            try {
                object = jSONObject.getJSONObject("richThumbnail").getJSONObject("movingThumbnailRenderer").getJSONObject("movingThumbnailDetails").getJSONArray("thumbnails");
                this.richThumbnails = new ArrayList<String>(((JSONArray)object).size());
                for (n = 0; n < ((JSONArray)object).size(); ++n) {
                    this.richThumbnails.add(((JSONArray)object).getJSONObject(n).getString("url"));
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public SearchResultItemType type() {
        return SearchResultItemType.VIDEO;
    }

    @Override
    public SearchResultVideoDetails asVideo() {
        return this;
    }

    public boolean isMovie() {
        return this.isMovie;
    }

    @Override
    public boolean isLive() {
        return this.viewCount == -1L;
    }

    public String viewCountText() {
        return this.viewCountText;
    }

    public long viewCount() {
        return this.viewCount;
    }

    public long startTime() {
        return this.startTime;
    }

    public List<String> badges() {
        return this.badges;
    }

    public List<String> richThumbnails() {
        return this.richThumbnails;
    }

    public String description() {
        return this.description;
    }
}

