/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.tinymediamanager.jsonrpc.api.AbstractModel;

public final class SystemModel {

    public static interface PropertyName {
        public static final String CANSHUTDOWN = "canshutdown";
        public static final String CANSUSPEND = "cansuspend";
        public static final String CANHIBERNATE = "canhibernate";
        public static final String CANREBOOT = "canreboot";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("canshutdown", "cansuspend", "canhibernate", "canreboot"));
    }

    public static class PropertyValue
    extends AbstractModel {
        public static final String API_TYPE = "System.Property.Value";
        public static final String CANHIBERNATE = "canhibernate";
        public static final String CANREBOOT = "canreboot";
        public static final String CANSHUTDOWN = "canshutdown";
        public static final String CANSUSPEND = "cansuspend";
        public final Boolean canhibernate;
        public final Boolean canreboot;
        public final Boolean canshutdown;
        public final Boolean cansuspend;

        public PropertyValue(Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4) {
            this.canhibernate = bl;
            this.canreboot = bl2;
            this.canshutdown = bl3;
            this.cansuspend = bl4;
        }

        public PropertyValue(JsonNode jsonNode) {
            this.canhibernate = PropertyValue.parseBoolean(jsonNode, CANHIBERNATE);
            this.canreboot = PropertyValue.parseBoolean(jsonNode, CANREBOOT);
            this.canshutdown = PropertyValue.parseBoolean(jsonNode, CANSHUTDOWN);
            this.cansuspend = PropertyValue.parseBoolean(jsonNode, CANSUSPEND);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(CANHIBERNATE, this.canhibernate);
            objectNode.put(CANREBOOT, this.canreboot);
            objectNode.put(CANSHUTDOWN, this.canshutdown);
            objectNode.put(CANSUSPEND, this.cansuspend);
            return objectNode;
        }

        static List<PropertyValue> getSystemModelPropertyValueList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new PropertyValue(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<PropertyValue>(0);
        }
    }
}

