/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.bdjo;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.UnsupportedEncodingException;
import org.tinymediamanager.library.bluray.bdjo.AppCacheInfo;
import org.tinymediamanager.library.bluray.bdjo.ApplicationManagementTable;
import org.tinymediamanager.library.bluray.bdjo.BDJOWriter;
import org.tinymediamanager.library.bluray.bdjo.HexStringIntegerAdapter;
import org.tinymediamanager.library.bluray.bdjo.TableOfAccessiblePlayLists;
import org.tinymediamanager.library.bluray.bdjo.TerminalInfo;
import org.tinymediamanager.library.bluray.bdjo.Version;

@XmlRootElement
@XmlType(propOrder={})
public class BDJO {
    public static final int FILE_MAX = 99999;
    public static final String type = "BDJO";
    public static final String LANGUAGE_CODE_WILDCARD = "*.*";
    public static final String LANGUAGE_CODE_FALLBACK = "%%%";
    public static final String LANGUAGE_CODE_ENGLISH = "eng";
    public static final int NUM_FILEACCESSINFO_BITS = 16;
    public static final int MAX_FILEACCESSINFO_LENGTH = 65536;
    private Version version = Version.V_0200;
    private TerminalInfo terminalInfo;
    private AppCacheInfo appCacheInfo;
    private TableOfAccessiblePlayLists tableOfAccessiblePlayLists;
    private ApplicationManagementTable applicationManagementTable;
    private int keyInterestTable;
    private String fileAccessInfo;

    public static void checkFileName(String string) {
        if (string.length() != 5) {
            throw new IllegalArgumentException("invalid file : " + string);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c)) continue;
            throw new IllegalArgumentException("invalid file : " + string);
        }
    }

    public static void checkLanguage(String string) {
        if (string.length() != 3) {
            throw new IllegalArgumentException("language code length != 3");
        }
    }

    public static int utf8Length(String string) {
        try {
            return string.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return -1;
        }
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public TerminalInfo getTerminalInfo() {
        return this.terminalInfo;
    }

    public void setTerminalInfo(TerminalInfo terminalInfo) {
        this.terminalInfo = terminalInfo;
    }

    public AppCacheInfo getAppCacheInfo() {
        return this.appCacheInfo;
    }

    public void setAppCacheInfo(AppCacheInfo appCacheInfo) {
        this.appCacheInfo = appCacheInfo;
    }

    public TableOfAccessiblePlayLists getTableOfAccessiblePlayLists() {
        return this.tableOfAccessiblePlayLists;
    }

    public void setTableOfAccessiblePlayLists(TableOfAccessiblePlayLists tableOfAccessiblePlayLists) {
        this.tableOfAccessiblePlayLists = tableOfAccessiblePlayLists;
    }

    public ApplicationManagementTable getApplicationManagementTable() {
        return this.applicationManagementTable;
    }

    public void setApplicationManagementTable(ApplicationManagementTable applicationManagementTable) {
        this.applicationManagementTable = applicationManagementTable;
    }

    @XmlJavaTypeAdapter(value=HexStringIntegerAdapter.class)
    public Integer getKeyInterestTable() {
        return this.keyInterestTable;
    }

    public void setKeyInterestTable(Integer n) {
        this.keyInterestTable = n;
    }

    public String getFileAccessInfo() {
        return this.fileAccessInfo;
    }

    public void setFileAccessInfo(String string) {
        int n;
        if (string != null && (n = string.length()) >= 65536) {
            throw new IllegalArgumentException("fileAccessInfo length exceeded : " + n);
        }
        this.fileAccessInfo = string;
    }

    public String toXML() throws JAXBException {
        return BDJOWriter.writeXML(this);
    }
}

