/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.playlist;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class StreamEntry {
    private StreamType streamType;
    private int refToStreamPIDOfMainClip;
    private int refToSubPathId;
    private int refToSubClipEntryId;
    private int refToStreamPIDOfSubClip;

    public void readObject(DataInputStream dataInputStream) throws IOException {
        StreamType streamType;
        dataInputStream.skipBytes(1);
        int n = dataInputStream.readUnsignedByte();
        StreamType[] streamTypeArray = StreamType.values();
        for (int i = 0; i < streamTypeArray.length; ++i) {
            if (streamTypeArray[i].ordinal() != n) continue;
            this.setStreamType(streamTypeArray[i]);
            break;
        }
        if ((streamType = this.getStreamType()) == StreamType.STREAM_FOR_PLAYITEM) {
            this.setRefToStreamPIDOfMainClip(dataInputStream.readUnsignedShort());
            dataInputStream.skipBytes(6);
        } else if (streamType == StreamType.STREAM_FOR_SUBPATH) {
            this.setRefToSubPathId(dataInputStream.readUnsignedByte());
            this.setRefToSubClipEntryId(dataInputStream.readUnsignedByte());
            this.setRefToStreamPIDOfSubClip(dataInputStream.readUnsignedShort());
            dataInputStream.skipBytes(4);
        } else if (streamType == StreamType.STREAM_FOR_IN_MUX_SUBPATH) {
            this.setRefToSubPathId(dataInputStream.readUnsignedByte());
            this.setRefToStreamPIDOfMainClip(dataInputStream.readUnsignedShort());
            dataInputStream.skipBytes(5);
        } else {
            System.out.println("Warning, Unknown StreamEntry type " + streamType);
        }
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        StreamType streamType = this.getStreamType();
        if (streamType == StreamType.STREAM_FOR_PLAYITEM) {
            dataOutputStream.writeByte(9);
            dataOutputStream.writeByte(streamType.ordinal());
            dataOutputStream.writeShort(this.getRefToStreamPIDOfMainClip());
            dataOutputStream.write(new byte[6]);
        } else if (streamType == StreamType.STREAM_FOR_SUBPATH) {
            dataOutputStream.writeByte(9);
            dataOutputStream.writeByte(streamType.ordinal());
            dataOutputStream.writeByte(this.getRefToSubPathId());
            dataOutputStream.writeByte(this.getRefToSubClipEntryId());
            dataOutputStream.writeShort(this.getRefToStreamPIDOfSubClip());
            dataOutputStream.write(new byte[4]);
        } else if (streamType == StreamType.STREAM_FOR_IN_MUX_SUBPATH) {
            dataOutputStream.writeByte(9);
            dataOutputStream.writeByte(streamType.ordinal());
            dataOutputStream.writeByte(this.getRefToSubPathId());
            dataOutputStream.writeShort(this.getRefToStreamPIDOfMainClip());
            dataOutputStream.write(new byte[5]);
        } else {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeByte(streamType.ordinal());
        }
    }

    public StreamType getStreamType() {
        return this.streamType;
    }

    public void setStreamType(StreamType streamType) {
        this.streamType = streamType;
    }

    public int getRefToStreamPIDOfMainClip() {
        return this.refToStreamPIDOfMainClip;
    }

    public void setRefToStreamPIDOfMainClip(int n) {
        this.refToStreamPIDOfMainClip = n;
    }

    public int getRefToSubPathId() {
        return this.refToSubPathId;
    }

    public void setRefToSubPathId(int n) {
        this.refToSubPathId = n;
    }

    public int getRefToSubClipEntryId() {
        return this.refToSubClipEntryId;
    }

    public void setRefToSubClipEntryId(int n) {
        this.refToSubClipEntryId = n;
    }

    public int getRefToStreamPIDOfSubClip() {
        return this.refToStreamPIDOfSubClip;
    }

    public void setRefToStreamPIDOfSubClip(int n) {
        this.refToStreamPIDOfSubClip = n;
    }

    public static enum StreamType {
        RESERVED,
        STREAM_FOR_PLAYITEM,
        STREAM_FOR_SUBPATH,
        STREAM_FOR_IN_MUX_SUBPATH;


        public byte getEncoding() {
            return (byte)this.ordinal();
        }
    }
}

