/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.playlist;

import jakarta.xml.bind.annotation.XmlElement;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.tinymediamanager.library.bluray.playlist.SubPlayItem;

public class SubPath {
    private int id;
    private SubPathType type;
    private boolean isRepeatSubPath;
    private SubPlayItem[] subPlayItems;

    public SubPath() {
    }

    public SubPath(int n) {
        this.id = n;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        int n;
        dataInputStream.skipBytes(5);
        int n2 = dataInputStream.readUnsignedByte();
        SubPathType[] subPathTypeArray = SubPathType.values();
        for (n = 0; n < subPathTypeArray.length; ++n) {
            if (subPathTypeArray[n].ordinal() != n2) continue;
            this.setSubPathType(subPathTypeArray[n]);
            break;
        }
        dataInputStream.skipBytes(1);
        n = dataInputStream.readByte();
        this.setIsRepeatSubPath((n & 1) != 0);
        dataInputStream.skipBytes(1);
        int n3 = dataInputStream.readUnsignedByte();
        SubPlayItem[] subPlayItemArray = new SubPlayItem[n3];
        for (int i = 0; i < subPlayItemArray.length; ++i) {
            subPlayItemArray[i] = new SubPlayItem(i);
            subPlayItemArray[i].readObject(dataInputStream);
        }
        this.setSubPlayItems(subPlayItemArray);
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream2.writeByte(0);
        dataOutputStream2.writeByte(this.getSubPathType().ordinal());
        dataOutputStream2.writeByte(0);
        dataOutputStream2.writeByte(this.getIsRepeatSubPath() ? 1 : 0);
        dataOutputStream2.writeByte(0);
        SubPlayItem[] subPlayItemArray = this.getSubPlayItems();
        dataOutputStream2.writeByte(subPlayItemArray.length);
        for (int i = 0; i < subPlayItemArray.length; ++i) {
            subPlayItemArray[i].writeObject(dataOutputStream2);
        }
        dataOutputStream2.flush();
        dataOutputStream2.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public SubPathType getSubPathType() {
        return this.type;
    }

    public void setSubPathType(SubPathType subPathType) {
        this.type = subPathType;
    }

    public boolean getIsRepeatSubPath() {
        return this.isRepeatSubPath;
    }

    public void setIsRepeatSubPath(boolean bl) {
        this.isRepeatSubPath = bl;
    }

    @XmlElement(name="SubPlayItem")
    public SubPlayItem[] getSubPlayItems() {
        return this.subPlayItems;
    }

    public void setSubPlayItems(SubPlayItem[] subPlayItemArray) {
        this.subPlayItems = subPlayItemArray;
    }

    public static enum SubPathType {
        RESERVED_0,
        RESERVED_1,
        PRIMARY_AUDIO_PRESENTATION,
        INTERACTIVE_GRAPHICS_PRESENTATION,
        TEXT_SUBTITLE_PRESENTATION,
        OUT_OF_MUX_AND_SYNC,
        OUT_OF_MUX_AND_ASYNC,
        IN_MUX_AND_SYNC,
        RESERVED_8;


        public byte getEncoding() {
            return (byte)this.ordinal();
        }
    }
}

