/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.cli;

import java.awt.GraphicsEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.TinyMediaManager;
import org.tinymediamanager.cli.MovieCommand;
import org.tinymediamanager.cli.TvShowCommand;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.http.TmmHttpServer;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.updater.UpdateCheck;
import org.tinymediamanager.updater.UpdaterTask;
import picocli.CommandLine;

@CommandLine.Command(name="tinyMediaManager", mixinStandardHelpOptions=true, usageHelpAutoWidth=true, version={"tinyMediaManager CLI"}, synopsisHeading="%nUsage:%n  ", optionListHeading="%n", commandListHeading="%nCommands:%n", footerHeading="%nExamples:%n", footer={"  tinyMediaManager movie -u -n -r      to find/scrape and rename new movies", "  tinyMediaManager movie -t -s         to download missing trailer/subtitles", "  tinyMediaManager movie -h            to display the help for the movie command", "", "  tinyMediaManager tvshow -u -n -r     to find/scrape and rename new TV shows/episodes", "  tinyMediaManager tvshow -t -s        to download missing trailer/subtitles", "  tinyMediaManager tvshow -h           to display the help for the tvshow command", "", "  tinyMediaManager --update            to download the latest updates for tinyMediaManager"}, subcommands={MovieCommand.class, TvShowCommand.class})
public class TinyMediaManagerCLI
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TinyMediaManagerCLI.class);
    @CommandLine.Option(names={"--update"}, description={"Download the latest updates for tinyMediaManager"})
    boolean update;
    @CommandLine.Option(names={"--start-api"}, description={"Start the API server and keep tinyMediaManager running"})
    boolean startApi;

    public static boolean checkArgs(String ... args) {
        CommandLine cmd = new CommandLine(TinyMediaManagerCLI.class);
        try {
            cmd.parseArgs(args);
        }
        catch (CommandLine.ParameterException e) {
            try {
                cmd.getParameterExceptionHandler().handleParseException(e, args);
                return false;
            }
            catch (Exception e1) {
                LOGGER.warn("could not handle picocli exception - {}", (Object)e1.getMessage());
                return false;
            }
        }
        String fullCommand = String.join((CharSequence)" ", args);
        if (fullCommand.contains("-h")) {
            cmd.execute(args);
            return false;
        }
        return true;
    }

    public static void printHelp() {
        CommandLine cmd = new CommandLine(TinyMediaManagerCLI.class);
        cmd.execute(new String[]{"-h"});
    }

    public static void start(String ... args) {
        CommandLine cmd = new CommandLine(TinyMediaManagerCLI.class);
        cmd.execute(args);
    }

    private TinyMediaManagerCLI() {
    }

    @Override
    public void run() {
        if (this.update) {
            LOGGER.info("Checking for new updates...");
            if (new UpdateCheck().isUpdateAvailable()) {
                LOGGER.info("New update available - downloading...");
                UpdaterTask updaterTask = new UpdaterTask();
                updaterTask.doInBackground();
                if (updaterTask.isDownloadSuccessful()) {
                    LOGGER.info("Update downloaded successful - restart to apply");
                }
            }
        }
        if (this.startApi) {
            if (Settings.getInstance().isEnableHttpServer()) {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    LOGGER.info("received shutdown signal");
                    if (!GraphicsEnvironment.isHeadless()) {
                        MainWindow.getInstance().saveWindowLayout();
                    }
                    TinyMediaManager.shutdown();
                    TinyMediaManager.shutdownLogger();
                }));
                try {
                    TmmHttpServer.getInstance();
                    Thread.sleep(Long.MAX_VALUE);
                }
                catch (InterruptedException e) {
                    System.out.println("stop");
                }
                catch (Exception e) {
                    LOGGER.error("could not start webserver: {}", (Object)e.getMessage());
                }
            } else {
                LOGGER.error("HTTP API is not enabled in the settings!");
            }
        }
    }
}

