/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.apache.commons.io.FilenameUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.MovieRenamerPreviewContainer;
import org.tinymediamanager.core.movie.entities.Movie;

public class MovieRenamerPreview {
    private MovieRenamerPreview() {
        throw new IllegalAccessError();
    }

    public static MovieRenamerPreviewContainer renameMovie(Movie movie) {
        MovieRenamerPreviewContainer container = new MovieRenamerPreviewContainer(movie);
        LinkedHashMap<String, MediaFile> oldFiles = new LinkedHashMap<String, MediaFile>();
        LinkedHashSet<MediaFile> newFiles = new LinkedHashSet<MediaFile>();
        boolean newDestIsMultiMovieDir = movie.isMultiMovieDir();
        String pattern = MovieModuleManager.getInstance().getSettings().getRenamerPathname();
        if (!pattern.isEmpty()) {
            newDestIsMultiMovieDir = !MovieRenamer.isFolderPatternUnique(pattern);
        }
        Movie movieClone = new Movie();
        movieClone.merge(movie);
        movieClone.setDataSource(movie.getDataSource());
        movieClone.setPath(movie.getPath());
        movieClone.setDisc(movie.isDisc());
        movieClone.setStacked(movie.isStacked());
        movieClone.setMultiMovieDir(newDestIsMultiMovieDir);
        movieClone.addToMediaFiles(movie.getMediaFiles());
        if (movieClone.isDisc()) {
            for (MediaFile mf : movieClone.getMediaFiles()) {
                oldFiles.put(mf.getFileAsPath().toString(), new MediaFile(mf));
                MediaFile mediaFile = MovieRenamer.generateFilename(movieClone, mf, "").get(0);
                newFiles.add(mediaFile);
            }
        } else {
            String oldVideoBasename = movieClone.getVideoBasenameWithoutStacking();
            String newVideoBasename = "";
            if (MovieModuleManager.getInstance().getSettings().getRenamerFilename().strip().isEmpty()) {
                newVideoBasename = movieClone.getVideoBasenameWithoutStacking();
            } else {
                MediaFile mediaFile = MovieRenamer.generateFilename(movieClone, movieClone.getMainVideoFile(), newVideoBasename).get(0);
                newVideoBasename = FilenameUtils.getBaseName((String)mediaFile.getFilenameWithoutStacking());
            }
            for (MediaFile mf : movieClone.getMediaFiles(MediaFileType.VIDEO)) {
                oldFiles.put(mf.getFileAsPath().toString(), new MediaFile(mf));
                MediaFile ftr = MovieRenamer.generateFilename(movieClone, mf, newVideoBasename).get(0);
                newFiles.add(ftr);
            }
            for (MediaFile mf : movieClone.getMediaFilesExceptType(MediaFileType.VIDEO)) {
                oldFiles.put(mf.getFileAsPath().toString(), new MediaFile(mf));
                newFiles.addAll(MovieRenamer.generateFilename(movieClone, mf, newVideoBasename, oldVideoBasename));
            }
        }
        Path oldMovieFolder = movieClone.getPathNIO();
        if (pattern.isEmpty()) {
            container.newPath = movieClone.getPathNIO();
        } else {
            try {
                container.newPath = Paths.get(movieClone.getDataSource(), MovieRenamer.createDestinationForFoldername(pattern, movieClone));
            }
            catch (Exception e) {
                container.newPath = movieClone.getPathNIO();
            }
        }
        if (!oldMovieFolder.equals(container.newPath)) {
            container.needsRename = true;
            for (MediaFile mediaFile : oldFiles.values()) {
                mediaFile.replacePathForRenamedFolder(oldMovieFolder, container.newPath);
            }
        }
        for (MediaFile mediaFile : newFiles) {
            if (oldFiles.containsKey(mediaFile.getFileAsPath().toString())) continue;
            container.needsRename = true;
            break;
        }
        for (MediaFile mediaFile : oldFiles.values()) {
            if (newFiles.contains(mediaFile)) continue;
            container.needsRename = true;
            break;
        }
        container.oldMediaFiles.addAll(oldFiles.values());
        container.newMediaFiles.addAll(newFiles);
        return container;
    }
}

