/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.connector;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSetArtworkHelper;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.connector.IMovieSetConnector;
import org.tinymediamanager.core.movie.connector.MovieNfoParser;
import org.tinymediamanager.core.movie.connector.MovieSetConnectors;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.movie.filenaming.IMovieSetFileNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetNfoNaming;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class MovieSetGenericXmlConnector
implements IMovieSetConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetGenericXmlConnector.class);
    protected static final String ORACLE_IS_STANDALONE = "http://www.oracle.com/xml/is-standalone";
    protected static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS = new DecimalFormatSymbols(Locale.US);
    protected final MovieSet movieSet;
    protected final MovieSettings settings;
    protected MovieNfoParser parser = null;
    protected Document document;
    protected Element root;

    protected MovieSetGenericXmlConnector(MovieSet movieSet) {
        this.movieSet = movieSet;
        this.settings = MovieModuleManager.getInstance().getSettings();
    }

    protected abstract void addOwnTags();

    @Override
    public void write(List<MovieSetNfoNaming> nfoNames) {
        if (!this.settings.isWriteCleanNfo()) {
            for (MediaFile mediaFile : this.movieSet.getMediaFiles(MediaFileType.NFO)) {
                try {
                    this.parser = MovieNfoParser.parseNfo(mediaFile.getFileAsPath());
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        for (MediaFile mediaFile : this.movieSet.getMediaFiles(MediaFileType.NFO)) {
            Utils.deleteFileSafely(mediaFile.getFileAsPath());
        }
        ArrayList<MediaFile> newNfos = new ArrayList<MediaFile>(1);
        for (MovieSetNfoNaming nfoNaming : nfoNames) {
            Path nfoPath = this.createNfoPath(this.movieSet, nfoNaming);
            if (nfoPath == null) continue;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                this.document = factory.newDocumentBuilder().newDocument();
                this.document.setXmlStandalone(true);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String dat = formatter.format((Object)new Date());
                this.document.appendChild(this.document.createComment("created on " + dat + " - tinyMediaManager " + Settings.getInstance().getVersion()));
                this.root = this.document.createElement("collection");
                this.document.appendChild(this.root);
                this.addTitle();
                this.addSorttitle();
                this.addPlot();
                this.addThumb();
                this.addFanart();
                this.addIds();
                this.addGenres();
                this.addStudios();
                this.addTags();
                this.addDateAdded();
                this.addLockdata();
                this.addOwnTags();
                this.addUnsupportedTags();
                this.addTinyMediaManagerTags();
                StringWriter out = new StringWriter();
                this.getTransformer().transform(new DOMSource(this.document), new StreamResult(out));
                String xml = ((Object)out).toString().replaceAll("(?<!\r)\n", "\r\n");
                if (!Files.isDirectory(nfoPath.getParent(), new LinkOption[0])) {
                    Files.createDirectory(nfoPath.getParent(), new FileAttribute[0]);
                }
                boolean changed = true;
                try {
                    String xmlOld = Utils.readFileToString(nfoPath).replaceAll("\\<\\!\\-\\-.*\\-\\-\\>", "");
                    String xmlNew = xml.replaceAll("\\<\\!\\-\\-.*\\-\\-\\>", "");
                    if (xmlOld.equals(xmlNew)) {
                        changed = false;
                    }
                }
                catch (Exception xmlOld) {
                    // empty catch block
                }
                if (changed) {
                    Utils.writeStringToFile(nfoPath, xml);
                } else {
                    LOGGER.trace("NFO did not change - do not write it!");
                }
                MediaFile mf = new MediaFile(nfoPath);
                mf.gatherMediaInformation(true);
                newNfos.add(mf);
            }
            catch (Exception e) {
                LOGGER.error("write '" + nfoPath + "'", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movieSet, "message.nfo.writeerror", new String[]{":", e.getLocalizedMessage()}));
            }
        }
        if (!newNfos.isEmpty()) {
            List<MediaFile> list = this.movieSet.getMediaFiles(MediaFileType.NFO);
            for (MediaFile nfo : list) {
                if (!MovieSetConnectors.isValidNFO(nfo.getFileAsPath())) {
                    newNfos.add(nfo);
                    continue;
                }
                if (newNfos.contains(nfo)) continue;
                try {
                    Utils.deleteFileWithBackup(nfo.getFileAsPath(), this.movieSet.getDataSource());
                }
                catch (Exception e) {
                    LOGGER.debug("Could not remove orphaned NFO - '{}'", (Object)e.getMessage());
                }
            }
            this.movieSet.removeAllMediaFiles(MediaFileType.NFO);
            this.movieSet.addToMediaFiles(newNfos);
        }
    }

    private Path createNfoPath(MovieSet movieSet, MovieSetNfoNaming nfoNaming) {
        String dataFolder = this.settings.getMovieSetDataFolder();
        if (StringUtils.isBlank((CharSequence)dataFolder)) {
            return null;
        }
        String movieSetName = MovieSetArtworkHelper.getMovieSetTitleForStorage(movieSet);
        String nfoFilename = nfoNaming.getFilename(movieSetName, "nfo");
        if (StringUtils.isBlank((CharSequence)nfoFilename)) {
            return null;
        }
        if (nfoNaming.getFolderLocation() == IMovieSetFileNaming.Location.KODI_STYLE_FOLDER) {
            return Paths.get(dataFolder, movieSetName, nfoFilename);
        }
        if (nfoNaming.getFolderLocation() == IMovieSetFileNaming.Location.AUTOMATOR_STYLE_FOLDER) {
            return Paths.get(dataFolder, nfoFilename);
        }
        return null;
    }

    protected void addTitle() {
        Element title = this.document.createElement("title");
        title.setTextContent(this.movieSet.getTitle());
        this.root.appendChild(title);
    }

    protected void addSorttitle() {
        Element sorttitle = this.document.createElement("sorttitle");
        sorttitle.setTextContent(this.movieSet.getSortTitle());
        this.root.appendChild(sorttitle);
    }

    protected void addOriginaltitle() {
        Element originaltitle = this.document.createElement("originaltitle");
        originaltitle.setTextContent(this.movieSet.getOriginalTitle());
        this.root.appendChild(originaltitle);
    }

    protected void addRating() {
        String ratingSource;
        Map<String, MediaRating> ratings = this.movieSet.getRatings();
        MediaRating mainMediaRating = null;
        Iterator<Object> iterator = this.settings.getRatingSources().iterator();
        while (iterator.hasNext() && (mainMediaRating = ratings.get(ratingSource = iterator.next())) == null) {
        }
        if (mainMediaRating == null) {
            for (MediaRating r : ratings.values()) {
                if ("user".equals(r.getId())) continue;
                mainMediaRating = r;
            }
        }
        if (mainMediaRating == null) {
            mainMediaRating = MediaMetadata.EMPTY_RATING;
        }
        Float rating10 = mainMediaRating.getMaxValue() > 0 ? Float.valueOf(mainMediaRating.getRating() * 10.0f / (float)mainMediaRating.getMaxValue()) : Float.valueOf(mainMediaRating.getRating());
        Element rating = this.document.createElement("rating");
        rating.setTextContent(String.format(Locale.US, "%.1f", rating10));
        this.root.appendChild(rating);
    }

    protected void addUserrating() {
        MediaRating mediaRating = this.movieSet.getRating("user");
        float rating10 = mediaRating.getMaxValue() > 0 ? mediaRating.getRating() * 10.0f / (float)mediaRating.getMaxValue() : mediaRating.getRating();
        Element UserRating = this.document.createElement("userrating");
        DecimalFormat df = new DecimalFormat("#.#", DECIMAL_FORMAT_SYMBOLS);
        UserRating.setTextContent(df.format(rating10));
        this.root.appendChild(UserRating);
    }

    protected void addVotes() {
        Element votes = this.document.createElement("votes");
        votes.setTextContent(Integer.toString(this.movieSet.getRating().getVotes()));
        this.root.appendChild(votes);
    }

    protected void addPlot() {
        Element plot = this.document.createElement("plot");
        plot.setTextContent(this.movieSet.getPlot());
        this.root.appendChild(plot);
    }

    protected void addThumb() {
        Element thumb = this.document.createElement("thumb");
        thumb.setTextContent(this.movieSet.getArtworkUrl(MediaFileType.POSTER));
        this.root.appendChild(thumb);
    }

    protected void addFanart() {
        Element fanart = this.document.createElement("fanart");
        fanart.setTextContent(this.movieSet.getArtworkUrl(MediaFileType.FANART));
        this.root.appendChild(fanart);
    }

    protected void addIds() {
        String defaultScraper = this.detectDefaultScraper();
        for (Map.Entry<String, Object> entry : this.movieSet.getIds().entrySet()) {
            Element uniqueid = this.document.createElement("uniqueid");
            String key = entry.getKey();
            if ("tmdbSet".equals(key)) {
                key = "tmdb";
            }
            uniqueid.setAttribute("type", key);
            if (defaultScraper.equals(entry.getKey())) {
                uniqueid.setAttribute("default", "true");
            } else {
                uniqueid.setAttribute("default", "false");
            }
            uniqueid.setTextContent(entry.getValue().toString());
            this.root.appendChild(uniqueid);
        }
    }

    protected void addDateAdded() {
        if (!this.settings.isNfoWriteDateAdded()) {
            return;
        }
        Element dateadded = this.document.createElement("dateadded");
        switch (this.settings.getNfoDateAddedField()) {
            case DATE_ADDED: {
                if (this.movieSet.getDateAdded() == null) break;
                dateadded.setTextContent(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.movieSet.getDateAdded()));
                break;
            }
            case FILE_CREATION_DATE: {
                MediaFile mainMediaFile = this.movieSet.getMainFile();
                if (mainMediaFile == null || mainMediaFile.getDateCreated() == null) break;
                dateadded.setTextContent(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mainMediaFile.getDateCreated()));
                break;
            }
            case FILE_LAST_MODIFIED_DATE: {
                MediaFile mainMediaFile = this.movieSet.getMainFile();
                if (mainMediaFile == null || mainMediaFile.getDateLastModified() == null) break;
                dateadded.setTextContent(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mainMediaFile.getDateLastModified()));
            }
        }
        this.root.appendChild(dateadded);
    }

    protected void addLockdata() {
        if (this.settings.isNfoWriteLockdata()) {
            Element lockdata = this.document.createElement("lockdata");
            lockdata.setTextContent("true");
            this.root.appendChild(lockdata);
        }
    }

    protected void addGenres() {
        for (MediaGenres mediaGenre : this.movieSet.getGenres()) {
            Element genre = this.document.createElement("genre");
            genre.setTextContent(mediaGenre.getLocalizedName(this.settings.getNfoLanguage()));
            this.root.appendChild(genre);
        }
    }

    protected void addStudios() {
        List<String> studios = ParserUtils.split(this.movieSet.getProductionCompany());
        for (String s : studios) {
            Element studio = this.document.createElement("studio");
            studio.setTextContent(s);
            this.root.appendChild(studio);
        }
    }

    protected void addTags() {
        for (String t : this.movieSet.getTags()) {
            Element tag = this.document.createElement("tag");
            tag.setTextContent(t);
            this.root.appendChild(tag);
        }
    }

    protected void addUnsupportedTags() {
        if (this.parser != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            for (String unsupportedString : this.parser.unsupportedElements) {
                try {
                    Document unsupported = factory.newDocumentBuilder().parse(new ByteArrayInputStream(unsupportedString.getBytes(StandardCharsets.UTF_8)));
                    this.root.appendChild(this.document.importNode(unsupported.getFirstChild(), true));
                }
                catch (Exception e) {
                    LOGGER.error("import unsupported tags: {}", (Object)e.getMessage());
                }
            }
        }
    }

    protected void addTinyMediaManagerTags() {
        this.root.appendChild(this.document.createComment("tinyMediaManager meta data"));
        this.addUserNote();
    }

    protected void addUserNote() {
        Element userNote = this.document.createElement("user_note");
        userNote.setTextContent(this.movieSet.getNote());
        this.root.appendChild(userNote);
    }

    protected Element getSingleElementByTag(String tag) {
        NodeList nodeList = this.document.getElementsByTagName(tag);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    protected Transformer getTransformer() throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-public", "yes");
        try {
            transformer.setOutputProperty(ORACLE_IS_STANDALONE, "yes");
        }
        catch (Exception exception) {
            // empty catch block
        }
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        return transformer;
    }

    private String detectDefaultScraper() {
        if (this.movieSet.getIds().containsKey("imdb")) {
            return "imdb";
        }
        if (this.movieSet.getIds().containsKey("tmdb")) {
            return "tmdb";
        }
        return this.movieSet.getIds().keySet().stream().findFirst().orElse("");
    }
}

