/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.movie.MovieMediaFileComparator;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSetArtworkHelper;
import org.tinymediamanager.core.movie.MovieSetScraperMetadataConfig;
import org.tinymediamanager.core.movie.connector.MovieSetToEmbyConnector;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public class MovieSet
extends MediaEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSet.class);
    private static final Comparator<Movie> MOVIE_SET_COMPARATOR = new MovieInMovieSetComparator();
    private static final Comparator<MediaFile> MEDIA_FILE_COMPARATOR = new MovieMediaFileComparator();
    @JsonProperty
    private String sortTitle = "";
    @JsonProperty
    private final List<UUID> movieIds = new ArrayList<UUID>(0);
    @JsonProperty
    private final List<MovieSetMovie> dummyMovies = new CopyOnWriteArrayList<MovieSetMovie>();
    private final List<Movie> movies = new CopyOnWriteArrayList<Movie>();
    private String titleSortable = "";

    public MovieSet() {
    }

    public MovieSet(String title) {
        this();
        this.setTitle(title);
        MovieSetArtworkHelper.updateArtwork(this);
    }

    @Override
    protected Comparator<MediaFile> getMediaFileComparator() {
        return MEDIA_FILE_COMPARATOR;
    }

    @Override
    public void initializeAfterLoading() {
        super.initializeAfterLoading();
        this.movieIds.removeIf(Objects::isNull);
        this.dummyMovies.removeIf(Objects::isNull);
        for (UUID uuid : this.movieIds) {
            Movie movie = MovieModuleManager.getInstance().getMovieList().lookupMovie(uuid);
            if (movie == null || movie.getMovieSet() != this) continue;
            this.movies.add(movie);
        }
        try {
            this.movies.sort(MOVIE_SET_COMPARATOR);
        }
        catch (Exception e) {
            LOGGER.debug("could not sort movies - '{}'", (Object)e.getMessage());
        }
        this.movieIds.clear();
        for (Movie movie : this.movies) {
            this.movieIds.add(movie.getDbId());
        }
        for (MovieSetMovie movieSetMovie : this.dummyMovies) {
            movieSetMovie.setMovieSet(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTitle(String newValue) {
        String oldValue = this.title;
        super.setTitle(newValue);
        this.firePropertyChange("titleForUi", oldValue, newValue);
        String oldValueTitleSortable = this.titleSortable;
        this.titleSortable = "";
        this.firePropertyChange("titleSortable", oldValueTitleSortable, this.titleSortable);
        if (!StringUtils.equals((CharSequence)oldValue, (CharSequence)newValue)) {
            List<Movie> list = this.movies;
            synchronized (list) {
                for (Movie movie : this.movies) {
                    movie.movieSetTitleChanged();
                }
            }
        }
    }

    public String getTitleSortable() {
        if (StringUtils.isEmpty((CharSequence)this.titleSortable)) {
            this.titleSortable = Utils.getSortableName(this.getTitle());
        }
        return this.titleSortable;
    }

    public String getSortTitle() {
        return this.sortTitle;
    }

    public void setSortTitle(String newValue) {
        String oldValue = this.sortTitle;
        this.sortTitle = newValue;
        this.firePropertyChange("sortTitle", oldValue, newValue);
    }

    public int getTmdbId() {
        int id;
        try {
            id = (Integer)this.ids.get("tmdbSet");
        }
        catch (Exception e) {
            return 0;
        }
        return id;
    }

    public void setTmdbId(int newValue) {
        int oldValue = this.getTmdbId();
        this.ids.put("tmdbSet", newValue);
        this.firePropertyChange("tmdbId", oldValue, newValue);
    }

    public List<MediaGenres> getGenres() {
        TreeSet<MediaGenres> genres = new TreeSet<MediaGenres>(new MediaGenres.MediaGenresComparator());
        for (Movie movie : this.movies) {
            genres.addAll(movie.getGenres());
        }
        return new ArrayList<MediaGenres>(genres);
    }

    @Override
    public String getProductionCompany() {
        HashSet<String> productionCompanies = new HashSet<String>();
        for (Movie movie : this.movies) {
            List<String> movieProductionCompanies = ParserUtils.split(movie.getProductionCompany());
            productionCompanies.addAll(movieProductionCompanies);
        }
        return String.join((CharSequence)", ", productionCompanies);
    }

    @Override
    public void setProductionCompany(String newValue) {
    }

    @Override
    public void setArtworkUrl(String url, MediaFileType type) {
        super.setArtworkUrl(url, type);
        MovieSetArtworkHelper.downloadArtwork(this, type);
    }

    @Override
    public void deleteMediaFiles(MediaFileType type) {
        this.getMediaFiles(type).forEach(mediaFile -> {
            Utils.deleteFileSafely(mediaFile.getFile());
            this.removeFromMediaFiles((MediaFile)mediaFile);
        });
    }

    public void setArtwork(List<MediaArtwork> artwork, List<MovieSetScraperMetadataConfig> config) {
        MovieSetArtworkHelper.setArtwork(this, artwork, config);
    }

    @Override
    public String getArtworkFilename(MediaFileType type) {
        Path cachedFile;
        String artworkFilename = super.getArtworkFilename(type);
        if (StringUtils.isBlank((CharSequence)artworkFilename) && (cachedFile = ImageCache.getCachedFile(this.getArtworkUrl(type))) != null && Files.exists(cachedFile, new LinkOption[0])) {
            return cachedFile.toAbsolutePath().toString();
        }
        return artworkFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertMovie(Movie movie) {
        if (movie instanceof MovieSetMovie) {
            return;
        }
        List<Movie> list = this.movies;
        synchronized (list) {
            if (this.movies.contains(movie)) {
                return;
            }
            int index = Collections.binarySearch(this.movies, movie, MOVIE_SET_COMPARATOR);
            if (index < 0) {
                this.movies.add(-index - 1, movie);
                this.movieIds.add(-index - 1, movie.getDbId());
            } else {
                this.movies.add(index, movie);
                this.movieIds.add(index, movie.getDbId());
            }
            MovieSetArtworkHelper.updateArtwork(this);
        }
        MovieSetArtworkHelper.writeImagesToMovieFolder(this, Collections.singletonList(movie));
        this.firePropertyChange("addedMovie", null, movie);
        for (MovieSetMovie movieSetMovie : this.dummyMovies) {
            boolean found = false;
            if (movie.getTmdbId() > 0 && movie.getTmdbId() == movieSetMovie.getTmdbId()) {
                found = true;
            }
            if (MediaIdUtil.isValidImdbId(movie.getImdbId()) && movie.getImdbId().equals(movieSetMovie.getImdbId())) {
                found = true;
            }
            if (!found) continue;
            this.firePropertyChange("removedMovie", null, movieSetMovie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMovie(Movie movie, boolean doCleanup) {
        if (doCleanup) {
            MovieSetArtworkHelper.cleanMovieSetArtworkInMovieFolder(movie);
        }
        if (movie.getMovieSet() != null) {
            movie.setMovieSet(null);
            movie.saveToDb();
        }
        List<Movie> list = this.movies;
        synchronized (list) {
            this.movies.remove(movie);
            this.movieIds.remove(movie.getDbId());
            if (doCleanup) {
                MovieSetArtworkHelper.updateArtwork(this);
            }
            this.saveToDb();
        }
        this.firePropertyChange("removedMovie", null, movie);
        for (MovieSetMovie movieSetMovie : this.dummyMovies) {
            boolean found = false;
            if (movie.getTmdbId() > 0 && movie.getTmdbId() == movieSetMovie.getTmdbId()) {
                found = true;
            }
            if (MediaIdUtil.isValidImdbId(movie.getImdbId()) && movie.getImdbId().equals(movieSetMovie.getImdbId())) {
                found = true;
            }
            if (!found) continue;
            this.firePropertyChange("addedMovie", null, movieSetMovie);
        }
    }

    public List<Movie> getMovies() {
        return Collections.unmodifiableList(this.movies);
    }

    public List<Movie> getMoviesForDisplay() {
        ArrayList<Movie> moviesForDisplay = new ArrayList<Movie>(this.getMovies());
        if (MovieModuleManager.getInstance().getSettings().isDisplayMovieSetMissingMovies() && ListUtils.isNotEmpty(this.dummyMovies)) {
            for (MovieSetMovie movieSetMovie : this.dummyMovies) {
                boolean found = false;
                for (Movie movie : this.movies) {
                    if (movie.getTmdbId() > 0 && movie.getTmdbId() == movieSetMovie.getTmdbId()) {
                        found = true;
                        break;
                    }
                    if (!MediaIdUtil.isValidImdbId(movie.getImdbId()) || !movie.getImdbId().equals(movieSetMovie.getImdbId())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                moviesForDisplay.add(movieSetMovie);
            }
            moviesForDisplay.sort(MOVIE_SET_COMPARATOR);
        }
        return moviesForDisplay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllMovies() {
        ArrayList<Movie> oldValue = new ArrayList<Movie>(this.movies);
        List<Movie> list = this.movies;
        synchronized (list) {
            for (Movie movie : this.movies) {
                MovieSetArtworkHelper.cleanMovieSetArtworkInMovieFolder(movie);
                if (movie.getMovieSet() == null) continue;
                movie.setMovieSet(null);
                movie.writeNFO();
                movie.saveToDb();
            }
            this.movies.clear();
            this.movieIds.clear();
            MovieSetArtworkHelper.updateArtwork(this);
            this.saveToDb();
        }
        this.firePropertyChange("removedAllMovies", oldValue, this.movies);
    }

    @Override
    public String toString() {
        return this.getTitle();
    }

    public int getMovieIndex(Movie movie) {
        return this.movies.indexOf(movie);
    }

    public int getMovieIndexWithDummy(Movie movie) {
        return this.getMoviesForDisplay().indexOf(movie);
    }

    public void rewriteAllImages() {
        List<MediaFileType> types = Arrays.asList(MediaFileType.POSTER, MediaFileType.FANART, MediaFileType.BANNER, MediaFileType.LOGO, MediaFileType.CLEARLOGO, MediaFileType.CLEARART);
        for (MediaFileType type : types) {
            MovieSetArtworkHelper.downloadArtwork(this, type);
        }
    }

    public Boolean isWatched() {
        if (this.movies.isEmpty()) {
            return false;
        }
        for (Movie movie : this.movies) {
            if (movie.isWatched()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<MediaFile> getImagesToCache() {
        ArrayList<MediaFile> filesToCache = new ArrayList<MediaFile>();
        List<MediaFileType> types = Arrays.asList(MediaFileType.POSTER, MediaFileType.FANART, MediaFileType.BANNER, MediaFileType.LOGO, MediaFileType.CLEARLOGO, MediaFileType.CLEARART);
        for (MediaFileType type : types) {
            String filename = this.getArtworkFilename(type);
            if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
            filesToCache.add(new MediaFile(Paths.get(filename, new String[0])));
        }
        return filesToCache;
    }

    @Override
    public MediaFile getMainFile() {
        return MediaFile.EMPTY_MEDIAFILE;
    }

    @Override
    public void callbackForGatheredMediainformation(MediaFile mediaFile) {
    }

    @Override
    public synchronized void callbackForWrittenArtwork(MediaArtwork.MediaArtworkType type) {
    }

    @Override
    public void saveToDb() {
        MovieModuleManager.getInstance().getMovieList().persistMovieSet(this);
    }

    public void setMetadata(MediaMetadata metadata, List<MovieSetScraperMetadataConfig> config) {
        if (this.locked) {
            LOGGER.debug("movie set locked, but setMetadata has been called!");
            return;
        }
        if (metadata == null) {
            LOGGER.error("metadata was null");
            return;
        }
        if (metadata.getIds().isEmpty()) {
            LOGGER.warn("wanted to save empty metadata for {}", (Object)this.getTitle());
            return;
        }
        boolean matchFound = false;
        for (Map.Entry<String, Object> entry : metadata.getIds().entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals(this.getId(entry.getKey()))) continue;
            matchFound = true;
            break;
        }
        if (!matchFound) {
            this.ids.clear();
        }
        this.setIds(metadata.getIds());
        if (config.contains(MovieSetScraperMetadataConfig.TITLE)) {
            if (MovieModuleManager.getInstance().getSettings().getCapitalWordsInTitles()) {
                this.setTitle(StrgUtils.capitalize(metadata.getTitle()));
            } else {
                this.setTitle(metadata.getTitle());
            }
        }
        if (config.contains(MovieSetScraperMetadataConfig.PLOT)) {
            this.setPlot(metadata.getPlot());
        }
        this.writeNFO();
        this.saveToDb();
        MovieSetArtworkHelper.cleanupArtwork(this);
    }

    public void writeNFO() {
        if (MovieModuleManager.getInstance().getSettings().getMovieSetNfoFilenames().isEmpty()) {
            LOGGER.debug("Not writing any NFO file, because NFO filename preferences were empty...");
            return;
        }
        switch (MovieModuleManager.getInstance().getSettings().getMovieSetConnector()) {
            default: 
        }
        MovieSetToEmbyConnector connector = new MovieSetToEmbyConnector(this);
        try {
            connector.write(MovieModuleManager.getInstance().getSettings().getMovieSetNfoFilenames());
            this.firePropertyChange("hasNfoFile", false, true);
        }
        catch (Exception e) {
            LOGGER.error("could not write NFO file - '{}'", (Object)e.getMessage());
        }
    }

    public void setDummyMovies(List<MovieSetMovie> dummyMovies) {
        this.dummyMovies.clear();
        dummyMovies.forEach(dummy -> {
            dummy.setMovieSet(this);
            this.dummyMovies.add((MovieSetMovie)dummy);
        });
        this.firePropertyChange("dummyMovies", null, dummyMovies);
    }

    public List<MovieSetMovie> getDummyMovies() {
        return this.dummyMovies;
    }

    @Override
    public Date getReleaseDate() {
        Date firstReleaseDate = null;
        for (Movie movie : this.getMoviesForDisplay()) {
            if (firstReleaseDate == null) {
                firstReleaseDate = movie.getReleaseDate();
                continue;
            }
            if (movie.getReleaseDate() == null || !firstReleaseDate.after(movie.getReleaseDate())) continue;
            firstReleaseDate = movie.getReleaseDate();
        }
        return firstReleaseDate;
    }

    @Override
    public MediaRating getRating() {
        return MediaMetadata.EMPTY_RATING;
    }

    public String getYears() {
        ArrayList years = new ArrayList();
        this.movies.forEach(movie -> years.add(movie.getYear()));
        this.dummyMovies.forEach(dummy -> years.add(dummy.getYear()));
        Collections.sort(years);
        if (!years.isEmpty() && years.size() >= 2) {
            if (((Integer)years.get(0)).equals(years.get(years.size() - 1))) {
                return String.valueOf(years.get(0));
            }
            return years.get(0) + " - " + years.get(years.size() - 1);
        }
        if (years.size() == 1) {
            return String.valueOf(years.get(0));
        }
        return "";
    }

    public Object getValueForMetadata(MovieSetScraperMetadataConfig metadataConfig) {
        return switch (metadataConfig) {
            default -> throw new IncompatibleClassChangeError();
            case MovieSetScraperMetadataConfig.ID -> this.getIds();
            case MovieSetScraperMetadataConfig.TITLE -> this.getTitle();
            case MovieSetScraperMetadataConfig.PLOT -> this.getPlot();
            case MovieSetScraperMetadataConfig.RATING -> this.getRatings();
            case MovieSetScraperMetadataConfig.POSTER -> this.getMediaFiles(MediaFileType.POSTER);
            case MovieSetScraperMetadataConfig.FANART -> this.getMediaFiles(MediaFileType.FANART);
            case MovieSetScraperMetadataConfig.BANNER -> this.getMediaFiles(MediaFileType.BANNER);
            case MovieSetScraperMetadataConfig.CLEARART -> this.getMediaFiles(MediaFileType.CLEARART);
            case MovieSetScraperMetadataConfig.THUMB -> this.getMediaFiles(MediaFileType.THUMB);
            case MovieSetScraperMetadataConfig.LOGO -> this.getMediaFiles(MediaFileType.LOGO);
            case MovieSetScraperMetadataConfig.CLEARLOGO -> this.getMediaFiles(MediaFileType.CLEARLOGO);
            case MovieSetScraperMetadataConfig.DISCART -> this.getMediaFiles(MediaFileType.DISC);
        };
    }

    public static class MovieSetMovie
    extends Movie {
        @Override
        public void writeNFO() {
        }

        @Override
        public void saveToDb() {
        }

        @Override
        protected List<MediaFile> listActorFiles() {
            return Collections.emptyList();
        }

        @Override
        public MediaFile getMainVideoFile() {
            return MediaFile.EMPTY_MEDIAFILE;
        }

        @Override
        public void writeActorImages(boolean overwriteExistingItems) {
        }

        @Override
        public void setMetadata(MediaMetadata metadata, List<MovieScraperMetadataConfig> config, boolean overwriteExistingItems) {
            ArrayList<MovieScraperMetadataConfig> newConfig = new ArrayList<MovieScraperMetadataConfig>(config);
            newConfig.remove(MovieScraperMetadataConfig.COLLECTION);
            super.setMetadata(metadata, newConfig, overwriteExistingItems);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.title.equals(((MovieSetMovie)o).getTitle());
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.title).build();
        }
    }

    private static class MovieInMovieSetComparator
    implements Comparator<Movie> {
        private static final Comparator<Date> DATE_COMPARATOR = Comparator.nullsLast(Date::compareTo);

        private MovieInMovieSetComparator() {
        }

        @Override
        public int compare(Movie o1, Movie o2) {
            int result;
            int year2;
            if (o1 == null || o2 == null) {
                return 0;
            }
            int year1 = o1.getYear();
            if (year1 == 0 && o1.getReleaseDate() != null) {
                year1 = o1.getReleaseDate().toInstant().atZone(ZoneId.of("UTC")).getYear();
            }
            if ((year2 = o2.getYear()) == 0 && o2.getReleaseDate() != null) {
                year2 = o2.getReleaseDate().toInstant().atZone(ZoneId.of("UTC")).getYear();
            }
            if (year1 > 0 && year2 > 0) {
                return year1 - year2;
            }
            if (o1.getReleaseDate() != null && o2.getReleaseDate() != null && (result = DATE_COMPARATOR.compare(o1.getReleaseDate(), o2.getReleaseDate())) != 0) {
                return result;
            }
            return o1.getTitleForUi().compareTo(o2.getTitleForUi());
        }
    }
}

