/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.RenderFormatInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.core.MediaEntityExporter;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;

public class TvShowExporter
extends MediaEntityExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowExporter.class);

    public TvShowExporter(Path pathToTemplate) throws Exception {
        super(pathToTemplate, MediaEntityExporter.TemplateType.TV_SHOW);
    }

    @Override
    public <T extends MediaEntity> void export(List<T> tvShowsToExport, Path exportDir) throws Exception {
        LOGGER.info("preparing tv show export; using {}", (Object)this.properties.getProperty("name"));
        if (this.cancel) {
            return;
        }
        this.engine.registerNamedRenderer((NamedRenderer)new TvShowFilenameRenderer());
        this.engine.registerNamedRenderer((NamedRenderer)new TvShowArtworkCopyRenderer(exportDir));
        this.registerDefaultRenderers();
        if (!Files.exists(exportDir, new LinkOption[0])) {
            Files.createDirectories(exportDir, new FileAttribute[0]);
        }
        Path listExportFile = StringUtils.isNotBlank((CharSequence)this.fileName) ? exportDir.resolve(this.fileName + "." + this.fileExtension) : exportDir.resolve("tvshows." + this.fileExtension);
        String episodeTemplateFile = this.properties.getProperty("episode");
        String episodeTemplate = "";
        if (StringUtils.isNotBlank((CharSequence)episodeTemplateFile)) {
            episodeTemplate = Utils.readFileToString(this.templateDir.resolve(episodeTemplateFile));
        }
        LOGGER.info("generating tv show list");
        Utils.deleteFileSafely(listExportFile);
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("tvShows", new ArrayList<T>(tvShowsToExport));
        String output = this.engine.transform(this.listTemplate, root);
        Utils.writeStringToFile(listExportFile, output);
        LOGGER.info("TvShow list generated: {}", (Object)listExportFile);
        if (StringUtils.isNotBlank((CharSequence)this.detailTemplate)) {
            for (MediaEntity me : tvShowsToExport) {
                if (this.cancel) {
                    return;
                }
                TvShow show = (TvShow)me;
                Path showDir = exportDir.resolve(TvShowExporter.getFilename(show));
                try {
                    Files.createDirectory(showDir, new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException e) {
                    LOGGER.debug("Folder already exists...");
                }
                Path detailsExportFile = showDir.resolve("tvshow." + this.fileExtension);
                root = new HashMap();
                root.put("tvShow", show);
                output = this.engine.transform(this.detailTemplate, root);
                Utils.writeStringToFile(detailsExportFile, output);
                if (!StringUtils.isNotBlank((CharSequence)episodeTemplate)) continue;
                for (TvShowEpisode episode : show.getEpisodes()) {
                    if (this.cancel) {
                        return;
                    }
                    List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO);
                    if (mfs.isEmpty()) continue;
                    Path seasonDir = showDir.resolve(TvShowRenamer.getSeasonFoldername("", episode.getTvShow(), episode));
                    if (!Files.isDirectory(seasonDir, new LinkOption[0])) {
                        Files.createDirectory(seasonDir, new FileAttribute[0]);
                    }
                    String episodeFileName = TvShowExporter.getFilename(episode) + "." + this.fileExtension;
                    Path episodeExportFile = seasonDir.resolve(episodeFileName);
                    root = new HashMap();
                    root.put("episode", episode);
                    output = this.engine.transform(episodeTemplate, root);
                    Utils.writeStringToFile(episodeExportFile, output);
                }
            }
        }
        if (this.cancel) {
            return;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.templateDir);){
            for (Path path : directoryStream) {
                if (Utils.isRegularFile(path)) {
                    if (path.getFileName().toString().endsWith(".jmte") || path.getFileName().toString().endsWith("template.conf")) continue;
                    Files.copy(path, exportDir.resolve(path.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                Utils.copyDirectoryRecursive(path, exportDir.resolve(path.getFileName()));
            }
        }
        catch (IOException ex) {
            LOGGER.error("could not copy resources: ", (Throwable)ex);
        }
    }

    private static String getFilename(MediaEntity entity) {
        if (entity instanceof TvShow) {
            TvShow tvShow = (TvShow)entity;
            return TvShowRenamer.createDestination("${showTitle} (${showYear})", tvShow);
        }
        if (entity instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)entity;
            MediaFile mainVideoFile = episode.getMainVideoFile();
            return FilenameUtils.getBaseName((String)TvShowRenamer.generateEpisodeFilenames("${showTitle} - S${seasonNr2}E${episodeNr2} - ${title}", episode.getTvShow(), mainVideoFile, FilenameUtils.getBaseName((String)mainVideoFile.getFilename())).get(0).getFilename());
        }
        return "";
    }

    private static class TvShowFilenameRenderer
    implements NamedRenderer {
        private TvShowFilenameRenderer() {
        }

        public RenderFormatInfo getFormatInfo() {
            return null;
        }

        public String getName() {
            return "filename";
        }

        public Class<?>[] getSupportedClasses() {
            return new Class[]{TvShow.class};
        }

        public String render(Object o, String pattern, Locale locale, Map<String, Object> model) {
            Map<Object, Object> parameters = new HashMap();
            if (pattern != null) {
                parameters = this.parseParameters(pattern);
            }
            if (o instanceof TvShow) {
                TvShow show = (TvShow)o;
                String filename = TvShowExporter.getFilename(show);
                if (parameters.get("escape") == Boolean.TRUE) {
                    try {
                        filename = URLEncoder.encode(filename, StandardCharsets.UTF_8).replace("+", "%20");
                    }
                    catch (Exception e) {
                        LOGGER.debug("could not encode filename - '{}'", (Object)e.getMessage());
                    }
                }
                return filename;
            }
            return null;
        }

        private Map<String, Object> parseParameters(String parameters) {
            String[] details;
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            block8: for (String detail : details = parameters.split(",")) {
                String key = "";
                String value = "";
                try {
                    String[] d = detail.split("=");
                    key = d[0].strip();
                    value = d[1].strip();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{key, value})) continue;
                switch (key.toLowerCase(Locale.ROOT)) {
                    case "escape": {
                        parameterMap.put(key, Boolean.parseBoolean(value));
                        continue block8;
                    }
                }
            }
            return parameterMap;
        }
    }

    private static class TvShowArtworkCopyRenderer
    extends MediaEntityExporter.ArtworkCopyRenderer {
        public TvShowArtworkCopyRenderer(Path pathToExport) {
            super(pathToExport);
        }

        public Class<?>[] getSupportedClasses() {
            return new Class[]{TvShow.class, TvShowEpisode.class};
        }

        public String render(Object o, String pattern, Locale locale, Map<String, Object> model) {
            if (o instanceof TvShow || o instanceof TvShowEpisode) {
                MediaFile mf;
                MediaEntity entity = (MediaEntity)o;
                Map<Object, Object> parameters = new HashMap();
                if (pattern != null) {
                    parameters = this.parseParameters(pattern);
                }
                if ((mf = entity.getArtworkMap().get(parameters.get("type"))) == null || !mf.isGraphic()) {
                    if (StringUtils.isNotBlank((CharSequence)((String)parameters.get("default")))) {
                        return (String)parameters.get("default");
                    }
                    return "";
                }
                Object filename = TvShowExporter.getFilename(entity) + "-" + mf.getType();
                Path imageDir = StringUtils.isNotBlank((CharSequence)((String)parameters.get("destination"))) ? this.pathToExport.resolve((String)parameters.get("destination")) : this.pathToExport;
                try {
                    Path cachedFile;
                    Path image = mf.getFileAsPath();
                    if (!Files.exists(image, new LinkOption[0]) && (cachedFile = ImageCache.getCachedFile(image)) != null && Files.exists(cachedFile, new LinkOption[0])) {
                        image = cachedFile;
                    }
                    if (!Files.exists(imageDir, new LinkOption[0])) {
                        Files.createDirectory(imageDir, new FileAttribute[0]);
                    }
                    if (parameters.get("thumb") == Boolean.TRUE) {
                        filename = (String)filename + ".thumb." + FilenameUtils.getExtension((String)mf.getFilename());
                        int width = 150;
                        if (parameters.get("width") != null) {
                            width = (Integer)parameters.get("width");
                        }
                        InputStream is = ImageUtils.scaleImage(image, width);
                        Files.copy(is, imageDir.resolve((String)filename), StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        filename = (String)filename + "." + FilenameUtils.getExtension((String)mf.getFilename());
                        Files.copy(image, imageDir.resolve((String)filename), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("could not copy artwork file: ", (Throwable)e);
                    if (StringUtils.isNotBlank((CharSequence)((String)parameters.get("default")))) {
                        return (String)parameters.get("default");
                    }
                    return "";
                }
                if (parameters.get("escape") == Boolean.TRUE) {
                    try {
                        filename = URLEncoder.encode((String)filename, StandardCharsets.UTF_8).replace("+", "%20");
                    }
                    catch (Exception e) {
                        LOGGER.debug("could not encode filename - '{}'", (Object)e.getMessage());
                    }
                }
                return filename;
            }
            return "";
        }
    }
}

