/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.tvshow.TvShowHelpers;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.connector.TvShowSeasonToEmbyConnector;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonNfoNaming;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaArtwork;

public class TvShowSeason
extends MediaEntity
implements Comparable<TvShowSeason> {
    @JsonProperty
    private UUID tvShowDbId = null;
    @JsonProperty
    private final int season;
    private TvShow tvShow = null;
    private final List<TvShowEpisode> episodes = new CopyOnWriteArrayList<TvShowEpisode>();
    private final List<TvShowEpisode> dummyEpisodes = new CopyOnWriteArrayList<TvShowEpisode>();
    private final List<TvShowEpisode> episodesForDisplay = new ArrayList<TvShowEpisode>();
    private PropertyChangeListener listener;

    public TvShowSeason(@JsonProperty(value="season") int season) {
        this.season = season;
        this.init();
    }

    public TvShowSeason(int season, @NotNull TvShow tvShow) {
        this(season);
        this.tvShow = tvShow;
        this.tvShowDbId = tvShow.getDbId();
    }

    public TvShowSeason(TvShowSeason source) {
        super.merge(source);
        this.tvShow = source.tvShow;
        this.tvShowDbId = source.tvShowDbId;
        this.season = source.season;
        this.init();
    }

    private void init() {
        this.listener = evt -> {
            Object patt3905$temp = evt.getSource();
            if (patt3905$temp instanceof TvShowEpisode) {
                TvShowEpisode episode = (TvShowEpisode)patt3905$temp;
                switch (evt.getPropertyName()) {
                    case "mediaFiles": {
                        this.firePropertyChange("mediaFiles", null, evt.getNewValue());
                        break;
                    }
                    case "season": {
                        if (episode.getSeason() == this.season) break;
                        this.removeEpisode(episode);
                        break;
                    }
                    case "firstAired": {
                        this.firePropertyChange("firstAired", null, evt.getNewValue());
                    }
                }
            }
        };
    }

    public int getSeason() {
        return this.season;
    }

    @Override
    public MediaFile getMainFile() {
        return MediaFile.EMPTY_MEDIAFILE;
    }

    @Override
    public String getDataSource() {
        return this.tvShow == null ? "" : this.tvShow.getDataSource();
    }

    @Override
    public Date getReleaseDate() {
        return null;
    }

    @Override
    public boolean isLocked() {
        return this.getTvShow() == null || this.getTvShow().isLocked();
    }

    @Override
    public MediaRating getRating() {
        return MediaMetadata.EMPTY_RATING;
    }

    public void setTvShow(TvShow newValue) {
        TvShow oldValue = this.tvShow;
        this.tvShow = newValue;
        this.tvShowDbId = newValue.getDbId();
        this.firePropertyChange("tvShow", oldValue, newValue);
    }

    public TvShow getTvShow() {
        return this.tvShow;
    }

    public UUID getTvShowDbId() {
        return this.tvShowDbId;
    }

    public void removeAllEpisodes() {
        ArrayList<TvShowEpisode> removedEpisodes = new ArrayList<TvShowEpisode>(this.episodes);
        removedEpisodes.addAll(this.dummyEpisodes);
        this.episodes.clear();
        this.dummyEpisodes.clear();
        this.episodesForDisplay.clear();
        for (TvShowEpisode episode : removedEpisodes) {
            episode.removePropertyChangeListener(this.listener);
            this.firePropertyChange("removedEpisode", null, episode);
            this.firePropertyChange("firstAired", null, this.getFirstAired());
        }
    }

    void removeDummyEpisodes() {
        this.dummyEpisodes.clear();
        this.episodesForDisplay.clear();
    }

    boolean isEmpty() {
        return this.episodes.isEmpty() && this.dummyEpisodes.isEmpty();
    }

    public synchronized void addEpisode(TvShowEpisode episode) {
        if (episode == null) {
            return;
        }
        ArrayList<TvShowEpisode> episodesForDisplayBefore = new ArrayList<TvShowEpisode>();
        if (TvShowModuleManager.getInstance().getSettings().isDisplayMissingEpisodes()) {
            episodesForDisplayBefore.addAll(this.getEpisodesForDisplay());
        }
        if (episode.isDummy()) {
            if (!this.dummyEpisodes.contains(episode)) {
                this.dummyEpisodes.add(episode);
                this.dummyEpisodes.sort(TvShowEpisode::compareTo);
            }
        } else if (!this.episodes.contains(episode)) {
            this.episodes.add(episode);
            this.episodes.sort(TvShowEpisode::compareTo);
        }
        this.episodesForDisplay.clear();
        episode.addPropertyChangeListener(this.listener);
        List<TvShowEpisode> episodesForDisplayNow = this.getEpisodesForDisplay();
        if (episodesForDisplayNow.contains(episode)) {
            if (episodesForDisplayNow.size() == 1) {
                this.firePropertyChange("addedSeason", null, this);
            }
            this.firePropertyChange("addedEpisode", null, episode);
            this.firePropertyChange("firstAired", null, this.getFirstAired());
        }
        if (TvShowModuleManager.getInstance().getSettings().isDisplayMissingEpisodes()) {
            for (TvShowEpisode e : episodesForDisplayBefore) {
                if (episodesForDisplayNow.contains(e)) continue;
                this.firePropertyChange("removedEpisode", null, e);
                this.firePropertyChange("firstAired", null, this.getFirstAired());
            }
        }
    }

    public void removeEpisode(TvShowEpisode episode) {
        if (episode == null) {
            return;
        }
        List<TvShowEpisode> episodesForDisplayBefore = this.getEpisodesForDisplay();
        this.dummyEpisodes.remove(episode);
        this.episodes.remove(episode);
        this.episodesForDisplay.clear();
        episode.removePropertyChangeListener(this.listener);
        if (episodesForDisplayBefore.contains(episode)) {
            this.firePropertyChange("removedEpisode", null, episode);
            this.firePropertyChange("firstAired", null, this.getFirstAired());
        }
        if (TvShowModuleManager.getInstance().getSettings().isDisplayMissingEpisodes()) {
            List<TvShowEpisode> episodesForDisplayNow = this.getEpisodesForDisplay();
            for (TvShowEpisode e : episodesForDisplayNow) {
                if (episodesForDisplayBefore.contains(e)) continue;
                this.firePropertyChange("addedEpisode", null, e);
                this.firePropertyChange("firstAired", null, this.getFirstAired());
            }
        }
        if (this.getEpisodesForDisplay().isEmpty()) {
            this.firePropertyChange("removedSeason", null, this);
        }
    }

    public List<TvShowEpisode> getEpisodes() {
        return Collections.unmodifiableList(this.episodes);
    }

    public Date getFirstAired() {
        Date firstAired = null;
        for (TvShowEpisode episode : this.getEpisodesForDisplay()) {
            if (firstAired == null) {
                firstAired = episode.getFirstAired();
                continue;
            }
            if (episode.getFirstAired() == null || !firstAired.after(episode.getFirstAired())) continue;
            firstAired = episode.getFirstAired();
        }
        return firstAired;
    }

    public boolean isWatched() {
        boolean episodeFound = false;
        boolean watched = true;
        for (TvShowEpisode episode : this.episodes) {
            if (episode.isDummy()) continue;
            episodeFound = true;
            watched = watched && episode.isWatched();
        }
        if (episodeFound) {
            return watched;
        }
        return false;
    }

    public boolean hasEpisodeSubtitles() {
        boolean subtitles = true;
        for (TvShowEpisode episode : this.episodes) {
            if (episode.isDummy() || episode.getHasSubtitles()) continue;
            subtitles = false;
            break;
        }
        return subtitles;
    }

    public Boolean getHasEpisodeImages() {
        TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
        for (TvShowEpisode episode : this.episodes) {
            if (episode.isDummy() || tvShowList.detectMissingArtwork(episode).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Boolean getHasEpisodeMetadata() {
        TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();
        for (TvShowEpisode episode : this.episodes) {
            if (episode.isDummy() || tvShowList.detectMissingMetadata(episode).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isDummy() {
        return this.episodes.isEmpty();
    }

    public synchronized List<TvShowEpisode> getEpisodesForDisplay() {
        if (this.episodesForDisplay.isEmpty()) {
            this.episodesForDisplay.addAll(TvShowHelpers.getEpisodesForDisplay(this.episodes, this.dummyEpisodes));
        }
        return new ArrayList<TvShowEpisode>(this.episodesForDisplay);
    }

    public int getRuntimeOfEpisodes() {
        int runtime = 0;
        for (TvShowEpisode episode : this.episodes) {
            runtime += episode.getRuntime();
        }
        return runtime;
    }

    public int getDummyEpisodeCount() {
        int count = 0;
        for (TvShowEpisode episode : this.getEpisodesForDisplay()) {
            if (!episode.isDummy() || !TvShowHelpers.shouldAddDummyEpisode(episode)) continue;
            ++count;
        }
        return count;
    }

    public long getVideoFilesize() {
        long filesize = 0L;
        for (TvShowEpisode episode : this.episodes) {
            filesize += episode.getVideoFilesize();
        }
        return filesize;
    }

    @Override
    public long getTotalFilesize() {
        long filesize = 0L;
        for (TvShowEpisode episode : this.episodes) {
            filesize += episode.getTotalFilesize();
        }
        return filesize;
    }

    public List<MediaFile> getMediaFilesRecursive() {
        LinkedHashSet<MediaFile> unique = new LinkedHashSet<MediaFile>(super.getMediaFiles());
        for (TvShowEpisode episode : this.episodes) {
            unique.addAll(episode.getMediaFiles());
        }
        return new ArrayList<MediaFile>(unique);
    }

    public List<MediaFile> getMediaFilesRecursive(MediaFileType type) {
        LinkedHashSet<MediaFile> unique = new LinkedHashSet<MediaFile>(super.getMediaFiles(type));
        for (TvShowEpisode episode : this.episodes) {
            unique.addAll(episode.getMediaFiles(type));
        }
        return new ArrayList<MediaFile>(unique);
    }

    @Override
    public boolean isNewlyAdded() {
        for (TvShowEpisode episode : this.episodes) {
            if (!episode.isNewlyAdded()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void saveToDb() {
        TvShowModuleManager.getInstance().getTvShowList().persistSeason(this);
    }

    @Override
    public void callbackForGatheredMediainformation(MediaFile mediaFile) {
    }

    public void writeNfo() {
        List<TvShowSeasonNfoNaming> nfoNamings;
        if (!(this.episodes.isEmpty() && !TvShowModuleManager.getInstance().getSettings().isCreateMissingSeasonItems() || (nfoNamings = TvShowModuleManager.getInstance().getSettings().getSeasonNfoFilenames()).isEmpty())) {
            switch (TvShowModuleManager.getInstance().getSettings().getTvShowConnector()) {
                default: 
            }
            TvShowSeasonToEmbyConnector connector = new TvShowSeasonToEmbyConnector(this);
            connector.write(nfoNamings);
            this.firePropertyChange("hasNfoFile", false, true);
        }
    }

    @Override
    public void callbackForWrittenArtwork(MediaArtwork.MediaArtworkType type) {
    }

    @Override
    protected Comparator<MediaFile> getMediaFileComparator() {
        return null;
    }

    @Override
    public List<MediaFile> getImagesToCache() {
        return this.getMediaFiles().stream().filter(MediaFile::isGraphic).toList();
    }

    public Object getValueForMetadata(TvShowScraperMetadataConfig metadataConfig) {
        return switch (metadataConfig) {
            case TvShowScraperMetadataConfig.TITLE, TvShowScraperMetadataConfig.SEASON_NAMES -> this.getTitle();
            case TvShowScraperMetadataConfig.SEASON_OVERVIEW -> this.getPlot();
            case TvShowScraperMetadataConfig.SEASON_POSTER -> this.getArtworkFilename(MediaFileType.SEASON_POSTER);
            case TvShowScraperMetadataConfig.SEASON_FANART -> this.getArtworkFilename(MediaFileType.SEASON_FANART);
            case TvShowScraperMetadataConfig.SEASON_BANNER -> this.getArtworkFilename(MediaFileType.SEASON_BANNER);
            case TvShowScraperMetadataConfig.SEASON_THUMB -> this.getArtworkFilename(MediaFileType.SEASON_THUMB);
            default -> null;
        };
    }

    @Override
    public String getTitle() {
        if (this.title.isEmpty() && this.tvShow != null) {
            return this.tvShow.getSeasonName(this.season);
        }
        return this.title;
    }

    @Override
    public int compareTo(TvShowSeason o) {
        if (this.getTvShow() != o.getTvShow()) {
            return this.getTvShow().getTitle().compareTo(o.getTvShow().getTitle());
        }
        return Integer.compare(this.getSeason(), o.getSeason());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TvShowSeason that = (TvShowSeason)o;
        return this.season == that.season && Objects.equals(this.tvShow, that.tvShow);
    }

    public int hashCode() {
        return Objects.hash(this.tvShow, this.season);
    }
}

