/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.anidb.AniDbMovieMetadataProvider;
import org.tinymediamanager.scraper.anidb.AniDbTvShowMetadataProvider;
import org.tinymediamanager.scraper.fanarttv.FanartTvMovieArtworkProvider;
import org.tinymediamanager.scraper.fanarttv.FanartTvTvShowArtworkProvider;
import org.tinymediamanager.scraper.ffmpeg.FFmpegMovieArtworkProvider;
import org.tinymediamanager.scraper.ffmpeg.FFmpegTvShowArtworkProvider;
import org.tinymediamanager.scraper.hdtrailersnet.HdTrailersNetMovieTrailerProvider;
import org.tinymediamanager.scraper.imdb.ImdbMovieArtworkProvider;
import org.tinymediamanager.scraper.imdb.ImdbMovieMetadataProvider;
import org.tinymediamanager.scraper.imdb.ImdbMovieTrailerProvider;
import org.tinymediamanager.scraper.imdb.ImdbTvShowArtworkProvider;
import org.tinymediamanager.scraper.imdb.ImdbTvShowMetadataProvider;
import org.tinymediamanager.scraper.imdb.ImdbTvShowTrailerProvider;
import org.tinymediamanager.scraper.interfaces.IKodiMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.interfaces.IMovieArtworkProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieSubtitleProvider;
import org.tinymediamanager.scraper.interfaces.IMovieTrailerProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowSubtitleProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowTrailerProvider;
import org.tinymediamanager.scraper.kodi.KodiMetadataProvider;
import org.tinymediamanager.scraper.moviemeter.MovieMeterMovieMetadataProvider;
import org.tinymediamanager.scraper.mpdbtv.MpdbMovieArtworkMetadataProvider;
import org.tinymediamanager.scraper.mpdbtv.MpdbMovieMetadataProvider;
import org.tinymediamanager.scraper.ofdb.OfdbMovieMetadataProvider;
import org.tinymediamanager.scraper.omdb.OmdbMovieMetadataProvider;
import org.tinymediamanager.scraper.omdb.OmdbTvShowMetadataProvider;
import org.tinymediamanager.scraper.opensubtitles_com.OpenSubtitlesComMovieSubtitleProvider;
import org.tinymediamanager.scraper.opensubtitles_com.OpenSubtitlesComTvShowSubtitleProvider;
import org.tinymediamanager.scraper.spi.IAddonProvider;
import org.tinymediamanager.scraper.thetvdb.TheTvDbMovieArtworkProvider;
import org.tinymediamanager.scraper.thetvdb.TheTvDbMovieMetadataProvider;
import org.tinymediamanager.scraper.thetvdb.TheTvDbTvShowArtworkProvider;
import org.tinymediamanager.scraper.thetvdb.TheTvDbTvShowMetadataProvider;
import org.tinymediamanager.scraper.tmdb.TmdbMovieArtworkProvider;
import org.tinymediamanager.scraper.tmdb.TmdbMovieMetadataProvider;
import org.tinymediamanager.scraper.tmdb.TmdbMovieTrailerProvider;
import org.tinymediamanager.scraper.tmdb.TmdbTvShowArtworkProvider;
import org.tinymediamanager.scraper.tmdb.TmdbTvShowMetadataProvider;
import org.tinymediamanager.scraper.tmdb.TmdbTvShowTrailerProvider;
import org.tinymediamanager.scraper.trakt.TraktMovieMetadataProvider;
import org.tinymediamanager.scraper.trakt.TraktTvShowMetadataProvider;
import org.tinymediamanager.scraper.tvmaze.TvMazeTvShowMetadataProvider;
import org.tinymediamanager.scraper.universal_movie.UniversalMovieMetadataProvider;
import org.tinymediamanager.scraper.universal_tvshow.UniversalTvShowMetadataProvider;
import org.tinymediamanager.scraper.util.ListUtils;

public class MediaProviders {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaProviders.class);
    private static final Map<String, List<IMediaProvider>> MEDIA_PROVIDERS = new LinkedHashMap<String, List<IMediaProvider>>();

    private MediaProviders() {
        throw new IllegalAccessError();
    }

    public static void loadMediaProviders() {
        if (!MEDIA_PROVIDERS.isEmpty()) {
            return;
        }
        LinkedHashSet<Class<? extends IMediaProvider>> addons = new LinkedHashSet<Class<? extends IMediaProvider>>();
        Iterator<IAddonProvider> addonIterator = ServiceLoader.load(IAddonProvider.class).iterator();
        while (addonIterator.hasNext()) {
            try {
                addons.addAll(addonIterator.next().getAddonClasses());
            }
            catch (Error | Exception e) {
                LOGGER.error("Could not load addons - '{}'", (Object)e.getMessage());
            }
        }
        MediaProviders.loadProvider(TmdbMovieMetadataProvider.class);
        MediaProviders.loadProvider(ImdbMovieMetadataProvider.class);
        MediaProviders.loadProvider(OmdbMovieMetadataProvider.class);
        MediaProviders.loadProvider(TraktMovieMetadataProvider.class);
        MediaProviders.loadProvider(MovieMeterMovieMetadataProvider.class);
        MediaProviders.loadProvider(TheTvDbMovieMetadataProvider.class);
        MediaProviders.loadProvider(AniDbMovieMetadataProvider.class);
        MediaProviders.loadProvider(OfdbMovieMetadataProvider.class);
        MediaProviders.loadProvider(MpdbMovieMetadataProvider.class);
        MediaProviders.loadProvider(KodiMetadataProvider.class);
        MediaProviders.loadAddonsForInterface(addons, IMovieMetadataProvider.class);
        MEDIA_PROVIDERS.forEach((key, value) -> {
            for (IMediaProvider mediaProvider : ListUtils.nullSafe(value)) {
                if (!(mediaProvider instanceof IMovieMetadataProvider)) continue;
                UniversalMovieMetadataProvider.addProvider((IMovieMetadataProvider)mediaProvider);
            }
        });
        MediaProviders.loadProvider(UniversalMovieMetadataProvider.class);
        MediaProviders.loadProvider(TmdbMovieArtworkProvider.class);
        MediaProviders.loadProvider(FanartTvMovieArtworkProvider.class);
        MediaProviders.loadProvider(ImdbMovieArtworkProvider.class);
        MediaProviders.loadProvider(MpdbMovieArtworkMetadataProvider.class);
        MediaProviders.loadProvider(FFmpegMovieArtworkProvider.class);
        MediaProviders.loadProvider(TheTvDbMovieArtworkProvider.class);
        MediaProviders.loadAddonsForInterface(addons, IMovieArtworkProvider.class);
        MediaProviders.loadProvider(TmdbMovieTrailerProvider.class);
        MediaProviders.loadProvider(HdTrailersNetMovieTrailerProvider.class);
        MediaProviders.loadProvider(ImdbMovieTrailerProvider.class);
        MediaProviders.loadAddonsForInterface(addons, IMovieTrailerProvider.class);
        MediaProviders.loadProvider(OpenSubtitlesComMovieSubtitleProvider.class);
        MediaProviders.loadAddonsForInterface(addons, IMovieSubtitleProvider.class);
        MediaProviders.loadProvider(TheTvDbTvShowMetadataProvider.class);
        MediaProviders.loadProvider(TmdbTvShowMetadataProvider.class);
        MediaProviders.loadProvider(ImdbTvShowMetadataProvider.class);
        MediaProviders.loadProvider(TraktTvShowMetadataProvider.class);
        MediaProviders.loadProvider(AniDbTvShowMetadataProvider.class);
        MediaProviders.loadProvider(TvMazeTvShowMetadataProvider.class);
        MediaProviders.loadProvider(OmdbTvShowMetadataProvider.class);
        MediaProviders.loadAddonsForInterface(addons, ITvShowMetadataProvider.class);
        List<IMediaProvider> tvdb = MEDIA_PROVIDERS.get("tvdb");
        for (IMediaProvider mediaProvider : ListUtils.nullSafe(tvdb)) {
            if (!(mediaProvider instanceof ITvShowMetadataProvider)) continue;
            UniversalTvShowMetadataProvider.addProvider((ITvShowMetadataProvider)mediaProvider);
        }
        MEDIA_PROVIDERS.forEach((key, value) -> {
            for (IMediaProvider mediaProvider : ListUtils.nullSafe(value)) {
                if (!(mediaProvider instanceof ITvShowMetadataProvider)) continue;
                UniversalTvShowMetadataProvider.addProvider((ITvShowMetadataProvider)mediaProvider);
            }
        });
        MediaProviders.loadProvider(UniversalTvShowMetadataProvider.class);
        MediaProviders.loadProvider(TheTvDbTvShowArtworkProvider.class);
        MediaProviders.loadProvider(FanartTvTvShowArtworkProvider.class);
        MediaProviders.loadProvider(TmdbTvShowArtworkProvider.class);
        MediaProviders.loadProvider(ImdbTvShowArtworkProvider.class);
        MediaProviders.loadProvider(FFmpegTvShowArtworkProvider.class);
        MediaProviders.loadAddonsForInterface(addons, ITvShowArtworkProvider.class);
        MediaProviders.loadProvider(TmdbTvShowTrailerProvider.class);
        MediaProviders.loadProvider(ImdbTvShowTrailerProvider.class);
        MediaProviders.loadAddonsForInterface(addons, ITvShowTrailerProvider.class);
        MediaProviders.loadProvider(OpenSubtitlesComTvShowSubtitleProvider.class);
        MediaProviders.loadAddonsForInterface(addons, ITvShowSubtitleProvider.class);
    }

    private static void loadAddonsForInterface(Collection<Class<? extends IMediaProvider>> addons, Class<? extends IMediaProvider> iface) {
        for (Class<? extends IMediaProvider> addon : addons) {
            if (!iface.isAssignableFrom(addon)) continue;
            try {
                MediaProviders.loadProvider(addon);
            }
            catch (Error | Exception e) {
                LOGGER.error("Could not load addon '{}' - '{}'", (Object)addon.getName(), (Object)e.getMessage());
            }
        }
    }

    private static void loadProvider(Class<? extends IMediaProvider> clazz) {
        try {
            IMediaProvider provider = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (provider.getProviderInfo() != null) {
                List providers = MEDIA_PROVIDERS.computeIfAbsent(provider.getId(), k -> new ArrayList());
                providers.add(provider);
            }
        }
        catch (Exception e) {
            LOGGER.error("could not load media provider {} - {}", (Object)clazz.getName(), (Object)e.getMessage());
        }
    }

    public static <T extends IMediaProvider> List<T> getProvidersForInterface(Class<T> clazz) {
        ArrayList providers = new ArrayList();
        MEDIA_PROVIDERS.forEach((key, value) -> {
            for (IMediaProvider provider : value) {
                if (!clazz.isAssignableFrom(provider.getClass())) continue;
                providers.add(provider);
            }
        });
        return providers;
    }

    public static <T extends IMediaProvider> T getProviderById(String id, Class<T> clazz) {
        IMediaProvider mp;
        block3: {
            IKodiMetadataProvider kodi;
            if (StringUtils.isBlank((CharSequence)id)) {
                return null;
            }
            List<IMediaProvider> providers = MEDIA_PROVIDERS.get(id);
            mp = null;
            for (IMediaProvider mediaProvider : ListUtils.nullSafe(providers)) {
                if (!clazz.isAssignableFrom(mediaProvider.getClass())) continue;
                return (T)mediaProvider;
            }
            if (mp != null) break block3;
            Iterator<IMediaProvider> iterator = MediaProviders.getProvidersForInterface(IKodiMetadataProvider.class).iterator();
            while (iterator.hasNext() && (mp = (kodi = (IKodiMetadataProvider)iterator.next()).getPluginById(id)) == null) {
            }
        }
        return (T)mp;
    }
}

