/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.util.ListUtils;

public class MediaProviderConfigObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaProviderConfigObject.class);
    public static final MediaProviderConfigObject EMPTY_OBJECT = new MediaProviderConfigObject("", ConfigType.TEXT);
    final String key;
    final ConfigType type;
    String keyDescription = "";
    String value = "";
    String defaultValue = "";
    boolean encrypt = false;
    boolean visible = true;
    List<String> possibleValues = new ArrayList<String>();

    public MediaProviderConfigObject(String key, ConfigType type) {
        this.key = key;
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyDescription() {
        return this.keyDescription.isEmpty() ? this.key : this.keyDescription;
    }

    public void setKeyDescription(String keyDescription) {
        this.keyDescription = keyDescription;
    }

    public String getValue() {
        String ret = "";
        switch (this.type) {
            case SELECT: {
                ret = this.getValueAsString();
                break;
            }
            case SELECT_INDEX: {
                Integer i = this.getValueIndex();
                ret = i == null || i < 0 ? "" : String.valueOf(i);
                break;
            }
            case BOOL: {
                return String.valueOf(this.getValueAsBool());
            }
            case INTEGER: {
                return String.valueOf(this.getValueAsInteger());
            }
            default: {
                return this.value;
            }
        }
        return ret;
    }

    public String getValueAsString() {
        if (this.type == ConfigType.SELECT && !this.possibleValues.contains(this.value)) {
            return this.defaultValue;
        }
        return this.value;
    }

    public boolean getValueAsBool() {
        boolean bool = Boolean.FALSE;
        if (this.type != ConfigType.BOOL) {
            return bool;
        }
        bool = this.value.equalsIgnoreCase("true") || this.value.equalsIgnoreCase("false") ? Boolean.parseBoolean(this.value) : Boolean.parseBoolean(this.defaultValue);
        return bool;
    }

    public Integer getValueAsInteger() {
        Integer integer = null;
        if (this.type != ConfigType.INTEGER) {
            return null;
        }
        try {
            integer = Integer.parseInt(this.value);
        }
        catch (Exception e) {
            try {
                integer = Integer.parseInt(this.defaultValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return integer;
    }

    public Integer getValueIndex() {
        if (this.type != ConfigType.SELECT && this.type != ConfigType.SELECT_INDEX) {
            return null;
        }
        Integer ret = this.possibleValues.indexOf(this.value);
        if (ret == -1 && (ret = Integer.valueOf(this.possibleValues.indexOf(this.defaultValue))) == -1) {
            ret = null;
        }
        return ret;
    }

    public void setValue(String value) {
        if (this.type == ConfigType.SELECT && !this.possibleValues.contains(value)) {
            return;
        }
        this.value = StringUtils.strip((String)value);
    }

    public void setValue(boolean value) {
        if (this.type != ConfigType.BOOL) {
            LOGGER.trace("This is not a boolean configuration object - setting keep current value");
        } else {
            this.value = String.valueOf(value);
        }
    }

    public void setValue(Integer value) {
        if (this.type != ConfigType.INTEGER) {
            LOGGER.trace("This is not an Integer configuration object - setting keep current value");
        } else {
            this.value = String.valueOf(value);
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        if (this.type == ConfigType.SELECT && !this.possibleValues.contains(defaultValue)) {
            LOGGER.trace("Will not set defaultValue '{}={}' - since it is not in the list of possible values!", (Object)this.key, (Object)defaultValue);
        } else {
            this.defaultValue = StringUtils.strip((String)defaultValue);
        }
    }

    public List<String> getPossibleValues() {
        return this.possibleValues;
    }

    public void setPossibleValues(List<String> possibleValues) {
        if (ListUtils.isNotEmpty(possibleValues)) {
            this.possibleValues.addAll(possibleValues);
        }
    }

    public void addPossibleValue(String possibleValue) {
        if (!this.possibleValues.contains(possibleValue)) {
            this.possibleValues.add(possibleValue);
        }
    }

    public ConfigType getType() {
        return this.type;
    }

    public boolean isEncrypt() {
        return this.encrypt;
    }

    public void setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public static enum ConfigType {
        TEXT,
        BOOL,
        SELECT,
        SELECT_INDEX,
        INTEGER,
        LABEL,
        MULTI_SELECT;

    }
}

