/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.kodi;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.kodi.AbstractKodiMetadataProvider;
import org.tinymediamanager.scraper.kodi.KodiMovieMetadataProvider;
import org.tinymediamanager.scraper.kodi.KodiScraper;
import org.tinymediamanager.scraper.kodi.KodiTvShowMetadataProvider;
import org.tinymediamanager.scraper.util.StrgUtils;

class KodiUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(KodiUtil.class);
    static final ArrayList<File> commonXmls = KodiUtil.getAllCommonXMLs();
    static final List<AbstractKodiMetadataProvider> scrapers = KodiUtil.getAllScrapers();

    KodiUtil() {
    }

    public static String fixXmlHeader(String xml) {
        String ret = xml;
        Pattern head = Pattern.compile(".*(<\\?xml(.*?)\\?>).*", 32);
        Matcher headm = head.matcher(xml);
        if (headm.matches()) {
            String xmlHeaderOrig = headm.group(1);
            String xmlHeaderNew = headm.group(1);
            Pattern p = Pattern.compile("(\\w+)=[\"']?[\\w.-]+[\"']?");
            Matcher m = p.matcher(xmlHeaderNew);
            while (m.find()) {
                String known;
                switch (known = m.group(1).toLowerCase(Locale.ROOT)) {
                    case "version": 
                    case "encoding": 
                    case "standalone": {
                        break;
                    }
                    default: {
                        xmlHeaderNew = xmlHeaderNew.replace(m.group(), "");
                    }
                }
                xmlHeaderNew = xmlHeaderNew.replaceAll(";", "");
            }
            if (!xmlHeaderNew.equals(xmlHeaderOrig)) {
                xmlHeaderNew = xmlHeaderNew.replaceAll("  ", " ");
                LOGGER.warn("Fixing invalid XML header! " + xmlHeaderOrig + " -> " + xmlHeaderNew);
                ret = ret.replace(xmlHeaderOrig, xmlHeaderNew);
            }
        }
        return ret.strip();
    }

    public static String fixXmlAttributes(String xml) {
        String ret = xml;
        Pattern attr = Pattern.compile("=\"(.*?)\"");
        Matcher m = attr.matcher(xml);
        while (m.find()) {
            String g = m.group(1);
            if (!g.contains("<") && !g.contains(">")) continue;
            LOGGER.warn("Fixing invalid XML entities: {}", (Object)g);
            String fixed = m.group(1).replaceAll("<", "&lt;").replaceAll(">", "&gt;");
            ret = ret.replace(g, fixed);
        }
        return ret;
    }

    public static String fixScripts(String xml) {
        String ret = xml;
        ret = ret.replace("<sc\" \\+ \"ript", "<script");
        ret = ret.replace("</\" \\+ \"script", "</script");
        return ret;
    }

    public static File detectKodiFolder() {
        String[] installFolder;
        String[] appFolder = new String[]{"Kodi", "kodi", "xbmc", "XMBC"};
        for (String i : installFolder = new String[]{System.getenv("ProgramFiles(x86)"), System.getenv("ProgramFiles"), System.getenv("ProgramData"), "/usr/share/", "/usr/lib/", "/Applications/Kodi.app/Contents/Resources", "/Applications/XBMC.app/Contents/Resources"}) {
            if (StringUtils.isEmpty((CharSequence)i)) continue;
            for (String a : appFolder) {
                File path = new File(i, a);
                if (!path.exists()) continue;
                return path;
            }
        }
        return null;
    }

    public static List<File> detectKodiUserFolders() {
        String[] appFolder = new String[]{"Kodi", ".kodi", "kodi", "XMBC", ".xbmc", "xbmc"};
        String[] userFolder = new String[]{System.getenv("APPDATA"), System.getProperty("user.home") + "/Library/Application Support", System.getProperty("user.home")};
        ArrayList<File> userFolders = new ArrayList<File>();
        for (String u : userFolder) {
            if (StringUtils.isEmpty((CharSequence)u)) continue;
            for (String a : appFolder) {
                File path = new File(u, a);
                if (!path.exists()) continue;
                userFolders.add(path);
            }
        }
        return userFolders;
    }

    private static List<KodiScraper> getKodiAddons(IOFileFilter dirFilter, IOFileFilter fileFilter) {
        ArrayList<KodiScraper> scrapers = new ArrayList<KodiScraper>();
        ArrayList foundAddonFiles = new ArrayList();
        LinkedHashMap<String, KodiScraper> tmp = new LinkedHashMap<String, KodiScraper>();
        File addons = new File("./target/test-classes/kodi_scraper");
        if (addons != null && addons.exists()) {
            foundAddonFiles.addAll(FileUtils.listFiles((File)addons, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter));
        } else {
            addons = new File("kodi_scraper");
            if (addons != null && addons.exists()) {
                foundAddonFiles.addAll(FileUtils.listFiles((File)addons, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter));
            }
            for (File userFolder : KodiUtil.detectKodiUserFolders()) {
                addons = new File(userFolder, "addons");
                if (addons == null || !addons.exists()) continue;
                foundAddonFiles.addAll(FileUtils.listFiles((File)addons, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter));
            }
            addons = new File(KodiUtil.detectKodiFolder(), "addons");
            if (addons != null && addons.exists()) {
                foundAddonFiles.addAll(FileUtils.listFiles((File)addons, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter));
            }
        }
        for (File f : foundAddonFiles) {
            KodiScraper x = new KodiScraper(f.getParentFile());
            if (StringUtils.isBlank((CharSequence)x.getProviderInfo().getId()) || "metadata.local".equals(x.getProviderInfo().getId())) continue;
            if (!tmp.containsKey(x.getProviderInfo().getId())) {
                tmp.put(x.getProviderInfo().getId(), x);
                continue;
            }
            KodiScraper old = (KodiScraper)tmp.get(x.getProviderInfo().getId());
            if (StrgUtils.compareVersion(x.getProviderInfo().getVersion(), old.getProviderInfo().getVersion()) > 0) {
                LOGGER.debug("replacing " + x.getProviderInfo().getId() + " v" + old.getProviderInfo().getVersion() + " with v" + x.getProviderInfo().getVersion());
                tmp.remove(x.getProviderInfo().getId());
                tmp.put(x.getProviderInfo().getId(), x);
                continue;
            }
            LOGGER.debug("not adding {} - ID already imported, or version lower", (Object)x.addonFolder.getAbsolutePath());
        }
        scrapers.addAll(tmp.values());
        return scrapers;
    }

    private static List<AbstractKodiMetadataProvider> getAllScrapers() {
        LOGGER.debug("searching for Kodi scrapers");
        IOFileFilter dirFilter = new IOFileFilter(){

            public boolean accept(File arg0, String arg1) {
                return false;
            }

            public boolean accept(File arg0) {
                return arg0.getName().startsWith("metadata") && !arg0.getName().contains("common");
            }
        };
        IOFileFilter fileFilter = new IOFileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().equals("addon.xml");
            }

            public boolean accept(File arg0, String arg1) {
                return false;
            }
        };
        List<KodiScraper> localScrapers = KodiUtil.getKodiAddons(dirFilter, fileFilter);
        if (localScrapers.isEmpty()) {
            LOGGER.debug("Meh - could not find any scrapers...");
        } else {
            for (KodiScraper sc : localScrapers) {
                LOGGER.debug("Found scraper: " + sc.addonFolder + File.separator + sc.scraperXml);
            }
        }
        ArrayList<AbstractKodiMetadataProvider> metadataProviders = new ArrayList<AbstractKodiMetadataProvider>();
        for (KodiScraper scraper : localScrapers) {
            if (scraper.type == null) continue;
            try {
                switch (scraper.type) {
                    case MOVIE: {
                        metadataProviders.add(new KodiMovieMetadataProvider(scraper));
                        break;
                    }
                    case TV_SHOW: {
                        metadataProviders.add(new KodiTvShowMetadataProvider(scraper));
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("could not load scraper " + scraper.getProviderInfo().getId(), (Throwable)e);
            }
        }
        return metadataProviders;
    }

    private static List<KodiScraper> getAllCommon() {
        LOGGER.debug("searching for Kodi commons");
        List<Object> common = new ArrayList();
        IOFileFilter dirFilter = new IOFileFilter(){

            public boolean accept(File arg0, String arg1) {
                return false;
            }

            public boolean accept(File arg0) {
                return arg0.getName().startsWith("metadata") && arg0.getName().contains("common");
            }
        };
        IOFileFilter fileFilter = new IOFileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().equals("addon.xml");
            }

            public boolean accept(File arg0, String arg1) {
                return false;
            }
        };
        common = KodiUtil.getKodiAddons(dirFilter, fileFilter);
        if (common.isEmpty()) {
            LOGGER.debug("Meh - could not find any common folders...");
        }
        return common;
    }

    private static ArrayList<File> getAllCommonXMLs() {
        ArrayList<File> common = new ArrayList<File>();
        IOFileFilter dirFilter = new IOFileFilter(){

            public boolean accept(File arg0, String arg1) {
                return false;
            }

            public boolean accept(File arg0) {
                return arg0.getName().startsWith("metadata") && arg0.getName().contains("common");
            }
        };
        IOFileFilter fileFilter = new IOFileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith("xml") && !pathname.getName().equals("addon.xml");
            }

            public boolean accept(File arg0, String arg1) {
                return false;
            }
        };
        for (KodiScraper sc : KodiUtil.getAllCommon()) {
            Collection files = FileUtils.listFiles((File)sc.getFolder(), (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
            for (File f : files) {
                if (!common.contains(f)) {
                    LOGGER.debug("Found common: " + f);
                    common.add(f);
                    continue;
                }
                LOGGER.debug("Skipped common: " + f);
            }
        }
        if (common.isEmpty()) {
            LOGGER.debug("Meh - could not find any common function...");
        }
        return common;
    }
}

