/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.mdblist;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.bind.DateTypeAdapter;
import java.util.Date;
import okhttp3.HttpUrl;
import okhttp3.Request;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.mdblist.entities.MdbMediaEntity;
import org.tinymediamanager.scraper.mdblist.services.MdbListService;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class MdbListController {
    private static final String API_URL = "https://api.mdblist.com";
    public static final String PARAM_API_KEY = "apikey";
    private Retrofit restAdapter;
    private String apiKey = "";

    MdbListController() {
    }

    private GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder().setLenient();
        builder.registerTypeAdapter(Integer.class, (json, typeOfT, context) -> {
            try {
                return json.getAsInt();
            }
            catch (NumberFormatException e) {
                return 0;
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        return builder;
    }

    protected Retrofit getRestAdapter() {
        if (this.restAdapter == null && !this.apiKey.isBlank()) {
            this.restAdapter = new Retrofit.Builder().baseUrl(API_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.getGsonBuilder().create())).client(TmmHttpClient.newBuilder().addInterceptor(chain -> {
                Request request = chain.request();
                HttpUrl url = request.url().newBuilder().addQueryParameter(PARAM_API_KEY, this.apiKey).build();
                request = request.newBuilder().url(url).build();
                return chain.proceed(request);
            }).build()).build();
        }
        return this.restAdapter;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    private MdbListService getService() {
        return (MdbListService)this.getRestAdapter().create(MdbListService.class);
    }

    private String getMediaTypeForQuery(MediaType mediaType) {
        String mt = "movie";
        if (mediaType == MediaType.TV_SHOW || mediaType == MediaType.TV_EPISODE) {
            mt = "show";
        }
        return mt;
    }

    public Call<MdbMediaEntity> getMediaEntity(String mediaProvider, MediaType mediaType, String mediaId) {
        return this.getService().getMdbMediaEntity(mediaProvider, this.getMediaTypeForQuery(mediaType), mediaId);
    }
}

