/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtil {
    private static Logger log = LoggerFactory.getLogger(NetworkUtil.class);

    public static void main(String[] args) {
        System.out.println("MAC: " + NetworkUtil.getMachineMac());
        System.out.println("HOSTNAME: " + NetworkUtil.getMachineHostname());
        System.out.println("IP: " + NetworkUtil.getMachineIPAddress());
        System.out.println("HOSTNAME ipv6: " + NetworkUtil.getMachineIPv6Hostname());
        System.out.println("IP ipv6: " + NetworkUtil.getMachineIPv6Address());
    }

    public static String getRemoteHostMac(String hostnameOrIP) {
        try {
            InetAddress address = InetAddress.getByName(hostnameOrIP);
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(address);
            return NetworkUtil.obtainMACFromAddress(networkInterface);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to obtain MAC address for address " + hostnameOrIP, (Throwable)e);
            }
            return null;
        }
    }

    public static String getMachineMac() {
        try {
            return NetworkUtil.obtainMACFromAddress(NetworkUtil.getNonLoopbackNetworkInterface());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to obtain MAC address for localhost", (Throwable)e);
            }
            return null;
        }
    }

    public static String getMachineHostname() {
        block3: {
            try {
                NetworkInterface networkInterface = NetworkUtil.getNonLoopbackNetworkInterface();
                Inet4Address address = NetworkUtil.getInet4Address(networkInterface);
                if (address != null) {
                    return address.getCanonicalHostName();
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Failed to obtain MachineHostname", (Throwable)e);
            }
        }
        return null;
    }

    public static String getMachineIPv6Hostname() {
        block3: {
            try {
                NetworkInterface networkInterface = NetworkUtil.getNonLoopbackNetworkInterface();
                Inet6Address address = NetworkUtil.getInet6Address(networkInterface);
                if (address != null) {
                    return address.getCanonicalHostName();
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Failed to obtain IPv6Hostname", (Throwable)e);
            }
        }
        return null;
    }

    public static String getMachineIPAddress() {
        block3: {
            try {
                NetworkInterface networkInterface = NetworkUtil.getNonLoopbackNetworkInterface();
                Inet4Address address = NetworkUtil.getInet4Address(networkInterface);
                if (address != null) {
                    return address.getHostAddress();
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Failed to obtain MachineIPAddress", (Throwable)e);
            }
        }
        return null;
    }

    public static String getMachineIPv6Address() {
        block3: {
            try {
                NetworkInterface networkInterface = NetworkUtil.getNonLoopbackNetworkInterface();
                Inet6Address address = NetworkUtil.getInet6Address(networkInterface);
                if (address != null) {
                    return address.getHostAddress();
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Failed to obtain MachineIPv6Address", (Throwable)e);
            }
        }
        return null;
    }

    private static String obtainMACFromAddress(NetworkInterface networkInterface) throws SocketException {
        if (networkInterface != null) {
            byte[] mac = networkInterface.getHardwareAddress();
            if (mac == null) {
                throw new Error("Failed to obtain mac address from interface: " + networkInterface.getDisplayName());
            }
            StringBuilder stringBuilder = new StringBuilder(17);
            for (int i = 0; i < mac.length; ++i) {
                stringBuilder.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
            }
            return stringBuilder.toString();
        }
        return null;
    }

    private static Inet4Address getInet4Address(NetworkInterface networkInterface) {
        if (networkInterface != null) {
            Enumeration<InetAddress> NICAddresses = networkInterface.getInetAddresses();
            while (NICAddresses.hasMoreElements()) {
                InetAddress address = NICAddresses.nextElement();
                if (!(address instanceof Inet4Address)) continue;
                return (Inet4Address)address;
            }
        }
        return null;
    }

    private static Inet6Address getInet6Address(NetworkInterface networkInterface) {
        if (networkInterface != null) {
            Enumeration<InetAddress> NICAddresses = networkInterface.getInetAddresses();
            while (NICAddresses.hasMoreElements()) {
                InetAddress address = NICAddresses.nextElement();
                if (!(address instanceof Inet6Address)) continue;
                return (Inet6Address)address;
            }
        }
        return null;
    }

    private static NetworkInterface getNonLoopbackNetworkInterface() throws SocketException {
        Enumeration<NetworkInterface> b = NetworkInterface.getNetworkInterfaces();
        while (b.hasMoreElements()) {
            NetworkInterface networkInterface = b.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress address = inetAddresses.nextElement();
                if (address.isLoopbackAddress()) continue;
                return networkInterface;
            }
        }
        return null;
    }
}

