/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.upnp;

import java.beans.PropertyChangeSupport;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.fourthline.cling.support.contentdirectory.AbstractContentDirectoryService;
import org.fourthline.cling.support.contentdirectory.ContentDirectoryErrorCode;
import org.fourthline.cling.support.contentdirectory.ContentDirectoryException;
import org.fourthline.cling.support.contentdirectory.DIDLParser;
import org.fourthline.cling.support.model.BrowseFlag;
import org.fourthline.cling.support.model.BrowseResult;
import org.fourthline.cling.support.model.DIDLContent;
import org.fourthline.cling.support.model.DIDLObject;
import org.fourthline.cling.support.model.SortCriterion;
import org.fourthline.cling.support.model.container.Container;
import org.fourthline.cling.support.model.container.GenreContainer;
import org.fourthline.cling.support.model.container.StorageFolder;
import org.fourthline.cling.support.model.item.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.thirdparty.upnp.Metadata;

public class ContentDirectoryService
extends AbstractContentDirectoryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentDirectoryService.class);

    public ContentDirectoryService() {
    }

    public ContentDirectoryService(List<String> searchCapabilities, List<String> sortCapabilities, PropertyChangeSupport propertyChangeSupport) {
        super(searchCapabilities, sortCapabilities, propertyChangeSupport);
    }

    public ContentDirectoryService(List<String> searchCapabilities, List<String> sortCapabilities) {
        super(searchCapabilities, sortCapabilities);
    }

    public BrowseResult browse(String objectID, BrowseFlag browseFlag, String filter, long firstResult, long maxResults, SortCriterion[] orderby) throws ContentDirectoryException {
        try {
            DIDLObject obj;
            Object um;
            LOGGER.debug("ObjectId: {}", (Object)objectID);
            LOGGER.debug("BrowseFlag: {}", (Object)browseFlag);
            LOGGER.debug("Filter: {}", (Object)filter);
            LOGGER.debug("FirstResult: {}", (Object)firstResult);
            LOGGER.debug("MaxResults: {}", (Object)maxResults);
            LOGGER.debug("OrderBy: {}", (Object)SortCriterion.toString((SortCriterion[])orderby));
            DIDLContent didl = new DIDLContent();
            String[] path = StringUtils.split((String)objectID, (char)'/');
            if (path == null) {
                throw new ContentDirectoryException(ContentDirectoryErrorCode.CANNOT_PROCESS, "path was NULL");
            }
            String request = path[path.length - 1];
            String parent = "";
            if (objectID.contains("/")) {
                parent = objectID.substring(0, objectID.lastIndexOf("/"));
            }
            StorageFolder uRoot = new StorageFolder("0", "-1", "All", "", Integer.valueOf(0), Long.valueOf(0L));
            StorageFolder uMovies = new StorageFolder("1", (Container)uRoot, TmmResourceBundle.getString("tmm.movies"), "", Integer.valueOf(0), Long.valueOf(0L));
            List<Movie> movies = MovieModuleManager.getInstance().getMovieList().getMovies();
            StorageFolder grpTitles = new StorageFolder(uMovies.getId() + "/t", (Container)uMovies, TmmResourceBundle.getString("metatag.title"), "", Integer.valueOf(MovieModuleManager.getInstance().getMovieList().getMovieCount()), Long.valueOf(0L));
            for (Movie movie : movies) {
                org.fourthline.cling.support.model.item.Movie um2 = Metadata.getUpnpMovie(movie, false);
                um2.setId(grpTitles.getId() + "/" + um2.getId());
                um2.setParentID(grpTitles.getId());
                grpTitles.addItem((Item)um2);
            }
            uMovies.addContainer((Container)grpTitles);
            Collection<MediaGenres> mgs = MovieModuleManager.getInstance().getMovieList().getUsedGenres();
            GenreContainer grpGenres = new GenreContainer(uMovies.getId() + "/g", (Container)uMovies, TmmResourceBundle.getString("metatag.genre"), "", Integer.valueOf(mgs.size()));
            for (MediaGenres mg : mgs) {
                GenreContainer gc = new GenreContainer(grpGenres.getId() + "/" + mg.getLocalizedName(), (Container)grpGenres, mg.getLocalizedName(), "", Integer.valueOf(0));
                for (Movie movie : movies) {
                    if (!movie.getGenres().contains(mg)) continue;
                    um = Metadata.getUpnpMovie(movie, false);
                    um.setId(gc.getId() + "/" + um.getId());
                    um.setParentID(gc.getId());
                    gc.addItem((Item)um);
                }
                gc.setChildCount(Integer.valueOf(gc.getContainers().size() + gc.getItems().size()));
                grpGenres.addContainer((Container)gc);
            }
            uMovies.addContainer((Container)grpGenres);
            uMovies.setChildCount(Integer.valueOf(uMovies.getContainers().size() + uMovies.getItems().size()));
            uRoot.addContainer((Container)uMovies);
            StorageFolder uTvShows = new StorageFolder("2", (Container)uRoot, TmmResourceBundle.getString("tmm.tvshows"), "", Integer.valueOf(TvShowModuleManager.getInstance().getTvShowList().getTvShowCount()), Long.valueOf(0L));
            List<TvShow> tmmShows = TvShowModuleManager.getInstance().getTvShowList().getTvShows();
            for (TvShow t : tmmShows) {
                StorageFolder uTvShow = new StorageFolder("2/" + t.getDbId(), (Container)uTvShows, t.getTitle(), "", Integer.valueOf(t.getSeasonCount()), Long.valueOf(0L));
                for (TvShowSeason s : t.getSeasons()) {
                    StorageFolder uSeason = new StorageFolder(uTvShow.getId() + "/" + s.getSeason(), (Container)uTvShow, "Season " + s.getSeason(), "", Integer.valueOf(t.getEpisodeCount()), Long.valueOf(0L));
                    for (TvShowEpisode ep : s.getEpisodes()) {
                        org.fourthline.cling.support.model.item.Movie um3 = Metadata.getUpnpTvShowEpisode(t, ep, false);
                        uSeason.addItem((Item)um3);
                    }
                    uTvShow.addContainer((Container)uSeason);
                }
                uTvShows.addContainer((Container)uTvShow);
            }
            uRoot.addContainer((Container)uTvShows);
            uRoot.setChildCount(Integer.valueOf(uRoot.getContainers().size()));
            if (browseFlag.equals((Object)BrowseFlag.METADATA)) {
                obj = this.findId(objectID, uRoot);
                if (obj instanceof Container) {
                    didl.addContainer((Container)obj);
                } else if (obj instanceof Item) {
                    TvShowEpisode ep;
                    TvShow t;
                    Object item = (Item)obj;
                    if (path[0].equals("1") && this.isUUID(request)) {
                        Movie m = MovieModuleManager.getInstance().getMovieList().lookupMovie(UUID.fromString(request));
                        if (m != null) {
                            um = Metadata.getUpnpMovie(m, true);
                            um.setId(parent + "/" + um.getId());
                            um.setParentID(parent);
                            item = um;
                        }
                    } else if (path[0].equals("2") && path.length == 4 && (t = TvShowModuleManager.getInstance().getTvShowList().lookupTvShow(UUID.fromString(path[1]))) != null && (ep = (TvShowEpisode)t.getEpisode(this.getInt(path[2]), this.getInt(path[3])).stream().findFirst().orElse(null)) != null) {
                        item = Metadata.getUpnpTvShowEpisode(t, ep, true);
                    }
                    didl.addItem(item);
                }
                return this.returnResult(didl, 1L);
            }
            if (browseFlag.equals((Object)BrowseFlag.DIRECT_CHILDREN)) {
                obj = this.findId(objectID, uRoot);
                long total = 0L;
                if (obj instanceof Container) {
                    Container cont = (Container)obj;
                    didl = this.createContentDidl(cont, firstResult, maxResults);
                    total = (long)cont.getContainers().size() + (long)cont.getItems().size();
                }
                return this.returnResult(didl, total);
            }
            throw new ContentDirectoryException(ContentDirectoryErrorCode.NO_SUCH_OBJECT, "BrowseFlag wrong " + browseFlag);
        }
        catch (Exception ex) {
            LOGGER.error("Browse failed", (Throwable)ex);
            throw new ContentDirectoryException(ContentDirectoryErrorCode.CANNOT_PROCESS, ex.toString());
        }
    }

    private DIDLObject findId(String id, StorageFolder folder) {
        StorageFolder ret = folder;
        String[] path = id.split("/");
        Object parent = "";
        for (int i = 0; i < path.length; ++i) {
            String s = path[i];
            ret = this.getTreeObject((String)parent + s, (DIDLObject)ret);
            parent = (String)parent + s + "/";
            if (ret == null) break;
        }
        return ret;
    }

    private DIDLObject getTreeObject(String id, DIDLObject obj) {
        Container ret = null;
        if (id.equalsIgnoreCase(obj.getId())) {
            return obj;
        }
        if (obj instanceof Container) {
            for (Container c : ((Container)obj).getContainers()) {
                if (!c.getId().equalsIgnoreCase(id)) continue;
                ret = c;
                break;
            }
            for (Item i : ((Container)obj).getItems()) {
                if (!i.getId().equalsIgnoreCase(id)) continue;
                ret = i;
                break;
            }
        }
        return ret;
    }

    private boolean isUUID(String uuid) {
        return uuid.length() == 36;
    }

    private DIDLContent createContentDidl(Container cont, long firstResult, long maxResults) {
        DIDLContent didl = new DIDLContent();
        int cnt = 0;
        for (Container c : cont.getContainers()) {
            if (firstResult > 0L) {
                --firstResult;
                continue;
            }
            if (maxResults != 0L && (long)cnt >= maxResults) continue;
            didl.addContainer(c);
            ++cnt;
        }
        for (Item i : cont.getItems()) {
            if (firstResult > 0L) {
                --firstResult;
                continue;
            }
            if (maxResults != 0L && (long)cnt >= maxResults) continue;
            didl.addItem(i);
            ++cnt;
        }
        return didl;
    }

    private BrowseResult returnResult(DIDLContent didl) throws Exception {
        return this.returnResult(didl, didl.getCount());
    }

    private BrowseResult returnResult(DIDLContent didl, long total) throws Exception {
        DIDLParser dip = new DIDLParser();
        String ret = dip.generate(didl);
        LOGGER.trace(ContentDirectoryService.prettyFormat(ret, 2));
        return new BrowseResult(ret, didl.getCount(), total);
    }

    private int getInt(String s) {
        return MetadataUtil.parseInt(s, 0);
    }

    public BrowseResult search(String containerId, String searchCriteria, String filter, long firstResult, long maxResults, SortCriterion[] orderBy) throws ContentDirectoryException {
        return super.search(containerId, searchCriteria, filter, firstResult, maxResults, orderBy);
    }

    public static String prettyFormat(String input, int indent) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Exception e) {
            return "! error parsing xml !";
        }
    }
}

