/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import org.tinymediamanager.ui.components.label.ImageLabel;

public class ColumnLayout
implements LayoutManager2 {
    private static final Dimension MIN_SIZE = new Dimension(1, 1);
    private static final Dimension MAX_SIZE = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);

    @Override
    public void layoutContainer(Container parent) {
        Component[] components = parent.getComponents();
        if (components.length == 0) {
            return;
        }
        int y = 0;
        Dimension maxSize = this.preferredLayoutSize(parent);
        int width = (int)((double)maxSize.width * 0.98);
        for (Component component : components) {
            Dimension preferredSize = component.getPreferredSize();
            if (!component.isVisible()) {
                preferredSize.width = 0;
                preferredSize.height = 0;
            }
            int height = preferredSize.height;
            if (component instanceof ImageLabel) {
                height = (int)(preferredSize.getHeight() * (double)width * 1.0 / preferredSize.getWidth());
            }
            component.setBounds(0, y, width, height);
            y += height;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return MIN_SIZE;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int height;
        Component[] components = parent.getComponents();
        int maxWidth = parent.getWidth();
        int maxHeight = parent.getHeight();
        if (maxWidth == 0 || maxHeight == 0) {
            return MIN_SIZE;
        }
        int width = maxWidth;
        int counter = 0;
        while (true) {
            ++counter;
            height = 0;
            for (Component component : components) {
                Dimension preferredSize = component.getPreferredSize();
                if (!component.isVisible()) continue;
                if (component instanceof ImageLabel) {
                    int proportionalHeight = (int)(preferredSize.getHeight() * (double)width * 1.0 / preferredSize.getWidth());
                    height += proportionalHeight;
                    continue;
                }
                height += preferredSize.height;
            }
            if (width < 1 || height < maxHeight || counter > 10) break;
            width = (int)((double)width * 0.98);
        }
        return new Dimension(width, height);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return MAX_SIZE;
    }
}

