/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.dialogs.TmmOptionDialog;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieDeleteAction
extends TmmAction {
    public MovieDeleteAction() {
        this.putValue("SmallIcon", IconManager.DELETE_FOREVER_RED);
        this.putValue("Name", TmmResourceBundle.getString("movie.delete"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.delete.hint"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        String message = Settings.getInstance().isEnableTrash() ? TmmResourceBundle.getString("movie.delete.desc") : TmmResourceBundle.getString("movie.delete.desc2");
        int answer = TmmOptionDialog.showOptionDialog(MainWindow.getInstance(), TmmResourceBundle.getString("movie.delete"), message);
        if (answer != 0) {
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(() -> MovieModuleManager.getInstance().getMovieList().deleteMovies(selectedMovies));
    }
}

