/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.imdb.ImdbMovieMetadataProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieFetchImdbTop250
extends TmmAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieFetchImdbTop250.class);

    public MovieFetchImdbTop250() {
        this.putValue("SwingLargeIconKey", IconManager.RATING_BLUE);
        this.putValue("SmallIcon", IconManager.RATING_BLUE);
        this.putValue("Name", TmmResourceBundle.getString("movie.fetchtop250"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(TmmResourceBundle.getString("movie.fetchtop250"), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                try {
                    ImdbMovieMetadataProvider mp = new ImdbMovieMetadataProvider();
                    Map<String, Integer> charts = mp.getTop250();
                    int cnt = 0;
                    for (Movie movie : selectedMovies) {
                        String id = movie.getImdbId();
                        if (id.isEmpty()) continue;
                        Integer top = charts.get(id);
                        if (top != null) {
                            ++cnt;
                            movie.setTop250(top);
                            movie.saveToDb();
                            movie.writeNFO();
                            continue;
                        }
                        int current = movie.getTop250();
                        if (current <= 0) continue;
                        movie.setTop250(0);
                        movie.saveToDb();
                        movie.writeNFO();
                    }
                    LOGGER.info("Matched {} Top 250 values from IMDB", (Object)cnt);
                }
                catch (Exception ignored) {
                    LOGGER.warn("Error fetching Top 250: {}", (Object)ignored.getMessage());
                }
            }
        });
    }
}

