/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieChooserDialog;

public class MovieSingleScrapeAction
extends TmmAction {
    public MovieSingleScrapeAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.scrape.selected"));
        this.putValue("SmallIcon", IconManager.SEARCH);
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.scrape.selected"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            return;
        }
        int selectedCount = selectedMovies.size();
        int index = 0;
        do {
            Movie movie = selectedMovies.get(index);
            MovieChooserDialog dialogMovieChooser = new MovieChooserDialog(movie, index, selectedCount);
            dialogMovieChooser.setVisible(true);
            if (!dialogMovieChooser.isContinueQueue()) break;
            if (dialogMovieChooser.isNavigateBack()) {
                --index;
                continue;
            }
            ++index;
        } while (index < selectedCount);
    }
}

