/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.LanguageStyle;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tasks.SubtitleDownloadTask;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.SubtitleSearchAndScrapeOptions;
import org.tinymediamanager.scraper.SubtitleSearchResult;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieSubtitleProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.combobox.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.movies.MovieSubtitleChooserModel;

public class MovieSubtitleChooserDialog
extends TmmDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSubtitleChooserDialog.class);
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();
    private final Movie movieToScrape;
    private final MediaFile fileToScrape;
    private SearchTask activeSearchTask = null;
    private final EventList<MovieSubtitleChooserModel> subtitleEventList;
    private final boolean inQueue;
    private boolean continueQueue = true;
    private TmmTable tableSubs;
    private JComboBox<MediaLanguages> cbLanguage;
    private MediaScraperCheckComboBox cbScraper;
    private JLabel lblProgressAction;
    private JProgressBar progressBar;
    private JButton btnSearch;

    public MovieSubtitleChooserDialog(Movie movie, MediaFile mediaFile, boolean inQueue) {
        super(TmmResourceBundle.getString("moviesubtitlechooser.search"), "movieSubtitleChooser");
        this.movieToScrape = movie;
        this.fileToScrape = mediaFile;
        this.inQueue = inQueue;
        this.subtitleEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(MovieSubtitleChooserModel.class)));
        this.initComponents();
        LinkListener linkListener = new LinkListener();
        this.tableSubs.addMouseListener(linkListener);
        this.tableSubs.addMouseMotionListener(linkListener);
        this.tableSubs.setAutoResizeMode(0);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableSubs, 7);
        ArrayList<MediaScraper> selectedSubtitleScrapers = new ArrayList<MediaScraper>();
        for (MediaScraper subtitleScraper : MovieModuleManager.getInstance().getMovieList().getAvailableSubtitleScrapers()) {
            if (!MovieModuleManager.getInstance().getSettings().getSubtitleScrapers().contains(subtitleScraper.getId())) continue;
            selectedSubtitleScrapers.add(subtitleScraper);
        }
        if (!selectedSubtitleScrapers.isEmpty()) {
            this.cbScraper.setSelectedItems(selectedSubtitleScrapers);
        }
        for (MediaLanguages language : MediaLanguages.valuesSorted()) {
            this.cbLanguage.addItem(language);
            if (language != MovieModuleManager.getInstance().getSettings().getSubtitleScraperLanguage()) continue;
            this.cbLanguage.setSelectedItem((Object)language);
        }
        this.btnSearch.addActionListener(e -> this.searchSubtitle());
        this.cbLanguage.addActionListener(e -> this.searchSubtitle());
        this.searchSubtitle();
    }

    private void initComponents() {
        JPanel panelTitle = new JPanel();
        panelTitle.setLayout((LayoutManager)new MigLayout("", "[grow]", "[]"));
        JLabel lblMovieTitle = new JLabel(this.movieToScrape.getTitle());
        TmmFontHelper.changeFont(lblMovieTitle, 1.33, 1);
        panelTitle.add((Component)lblMovieTitle, "cell 0 0 5 1,growx, wmin 0");
        this.setTopInformationPanel(panelTitle);
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][250lp][][150lp,grow][]", "[][][][][shrink 0][200lp,grow]"));
        TmmLabel lblMediaFileNameT = new TmmLabel(TmmResourceBundle.getString("metatag.filename"));
        panelContent.add((Component)lblMediaFileNameT, "cell 0 0,alignx right");
        JLabel lblMediaFileName = new JLabel(this.fileToScrape.getFile().toString());
        panelContent.add((Component)lblMediaFileName, "cell 1 0 4 1,growx, wmin 0");
        TmmLabel lblRuntimeT = new TmmLabel(TmmResourceBundle.getString("metatag.runtime"));
        panelContent.add((Component)lblRuntimeT, "cell 0 1,alignx right");
        JLabel lblRuntime = new JLabel(this.fileToScrape.getDurationHHMMSS());
        panelContent.add((Component)lblRuntime, "cell 1 1");
        TmmLabel lblImdbIdT = new TmmLabel(TmmResourceBundle.getString("metatag.imdb"));
        panelContent.add((Component)lblImdbIdT, "cell 2 1");
        JLabel lblImdbId = new JLabel(this.movieToScrape.getImdbId());
        panelContent.add((Component)lblImdbId, "cell 3 1");
        TmmLabel lblScraperT = new TmmLabel(TmmResourceBundle.getString("scraper"));
        panelContent.add((Component)lblScraperT, "cell 0 2,alignx right");
        this.cbScraper = new MediaScraperCheckComboBox(this.movieList.getAvailableSubtitleScrapers());
        panelContent.add((Component)this.cbScraper, "cell 1 2,growx");
        this.btnSearch = new JButton(TmmResourceBundle.getString("Button.search"));
        panelContent.add((Component)this.btnSearch, "cell 2 2,alignx left,aligny top");
        TmmLabel lblLanguageT = new TmmLabel(TmmResourceBundle.getString("metatag.language"));
        panelContent.add((Component)lblLanguageT, "cell 0 3,alignx right");
        this.cbLanguage = new JComboBox();
        panelContent.add(this.cbLanguage, "cell 1 3,growx");
        JSeparator separator = new JSeparator();
        panelContent.add((Component)separator, "cell 0 4 5 1,growx");
        JScrollPane scrollPaneSubs = new JScrollPane();
        panelContent.add((Component)scrollPaneSubs, "cell 0 5 5 1,grow");
        this.tableSubs = new TmmTable((TableModel)((Object)new TmmTableModel<MovieSubtitleChooserModel>((EventList<MovieSubtitleChooserModel>)GlazedListsSwing.swingThreadProxyList(this.subtitleEventList), new SubtitleTableFormat())));
        this.tableSubs.setDefaultRenderer(ImageIcon.class, new Renderer());
        this.tableSubs.configureScrollPane(scrollPaneSubs);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout((LayoutManager)new MigLayout("hidemode 3", "[][grow]", "[]"));
        this.progressBar = new JProgressBar();
        infoPanel.add((Component)this.progressBar, "cell 0 0");
        this.lblProgressAction = new JLabel("");
        infoPanel.add((Component)this.lblProgressAction, "cell 1 0, wmin 0");
        this.setBottomInformationPanel(infoPanel);
        if (this.inQueue) {
            JButton btnAbortQueue = new JButton(TmmResourceBundle.getString("Button.abortqueue"));
            btnAbortQueue.setIcon(IconManager.STOP_INV);
            btnAbortQueue.addActionListener(e -> {
                this.continueQueue = false;
                this.setVisible(false);
            });
            this.addButton(btnAbortQueue);
        }
        JButton btnDone = new JButton(TmmResourceBundle.getString("Button.close"));
        btnDone.setIcon(IconManager.APPLY_INV);
        btnDone.addActionListener(e -> this.setVisible(false));
        this.addDefaultButton(btnDone);
    }

    private void searchSubtitle() {
        if (this.activeSearchTask != null && !this.activeSearchTask.isDone()) {
            this.activeSearchTask.cancel();
        }
        ArrayList<MediaScraper> scrapers = new ArrayList<MediaScraper>(this.cbScraper.getSelectedItems());
        this.activeSearchTask = new SearchTask(this.fileToScrape, this.movieToScrape.getIds(), this.movieToScrape.getTitle(), scrapers);
        this.activeSearchTask.execute();
    }

    private void startProgressBar(String description) {
        SwingUtilities.invokeLater(() -> {
            this.lblProgressAction.setText(description);
            this.progressBar.setVisible(true);
            this.progressBar.setIndeterminate(true);
        });
    }

    private void stopProgressBar() {
        SwingUtilities.invokeLater(() -> {
            this.lblProgressAction.setText("");
            this.progressBar.setVisible(false);
            this.progressBar.setIndeterminate(false);
        });
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    private class SearchTask
    extends SwingWorker<Void, Void> {
        private final MediaFile mediaFile;
        private final String searchTerm;
        private final Map<String, Object> ids;
        private final List<SubtitleSearchResult> searchResults;
        private final MediaLanguages language;
        private final List<MediaScraper> scrapers;
        boolean cancel;
        private String message;

        public SearchTask(MediaFile mediaFile, String searchTerm, List<MediaScraper> scrapers) {
            this(mediaFile, Collections.emptyMap(), searchTerm, scrapers);
        }

        public SearchTask(MediaFile mediaFile, Map<String, Object> ids, String searchTerm, List<MediaScraper> scrapers) {
            this.mediaFile = mediaFile;
            this.searchTerm = searchTerm;
            this.ids = ids;
            this.language = (MediaLanguages)((Object)MovieSubtitleChooserDialog.this.cbLanguage.getSelectedItem());
            this.searchResults = new ArrayList<SubtitleSearchResult>();
            this.scrapers = scrapers;
            this.cancel = false;
        }

        @Override
        public Void doInBackground() {
            MovieSubtitleChooserDialog.this.startProgressBar(TmmResourceBundle.getString("chooser.searchingfor") + " " + this.searchTerm);
            for (MediaScraper scraper : this.scrapers) {
                try {
                    IMovieSubtitleProvider subtitleProvider = (IMovieSubtitleProvider)scraper.getMediaProvider();
                    SubtitleSearchAndScrapeOptions options = new SubtitleSearchAndScrapeOptions(MediaType.MOVIE);
                    options.setMediaFile(this.mediaFile);
                    options.setSearchQuery(this.searchTerm);
                    options.setIds(this.ids);
                    options.setLanguage(this.language);
                    this.searchResults.addAll(subtitleProvider.search(options));
                }
                catch (MissingIdException ignored) {
                    LOGGER.debug("missing id for scraper {}", (Object)scraper.getId());
                }
                catch (ScrapeException e) {
                    LOGGER.error("getSubtitles", (Throwable)e);
                    this.message = e.getMessage();
                }
            }
            Collections.sort(this.searchResults);
            Collections.reverse(this.searchResults);
            return null;
        }

        public void cancel() {
            this.cancel = true;
        }

        @Override
        public void done() {
            if (!this.cancel) {
                MovieSubtitleChooserDialog.this.subtitleEventList.clear();
                if (this.searchResults == null || this.searchResults.isEmpty()) {
                    MovieSubtitleChooserDialog.this.subtitleEventList.add((Object)MovieSubtitleChooserModel.EMPTY_RESULT);
                } else {
                    for (SubtitleSearchResult result : this.searchResults) {
                        MovieSubtitleChooserDialog.this.subtitleEventList.add((Object)new MovieSubtitleChooserModel(result, this.language));
                    }
                }
                if (!MovieSubtitleChooserDialog.this.subtitleEventList.isEmpty()) {
                    MovieSubtitleChooserDialog.this.tableSubs.setRowSelectionInterval(0, 0);
                }
                TableColumnResizer.adjustColumnPreferredWidths(MovieSubtitleChooserDialog.this.tableSubs, 15);
            }
            MovieSubtitleChooserDialog.this.stopProgressBar();
            if (!this.cancel && StringUtils.isNotBlank((CharSequence)this.message)) {
                SwingUtilities.invokeLater(() -> {
                    MovieSubtitleChooserDialog.this.lblProgressAction.setVisible(true);
                    MovieSubtitleChooserDialog.this.lblProgressAction.setText(this.message);
                });
            }
        }
    }

    private class LinkListener
    implements MouseListener,
    MouseMotionListener {
        private LinkListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int row = table.rowAtPoint(new Point(e.getX(), e.getY()));
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col == 0) {
                row = table.convertRowIndexToModel(row);
                MovieSubtitleChooserModel model = (MovieSubtitleChooserModel)MovieSubtitleChooserDialog.this.subtitleEventList.get(row);
                try {
                    if (StringUtils.isNotBlank((CharSequence)model.getDownloadUrl())) {
                        String lang = LanguageStyle.getLanguageCodeForStyle(model.getLanguage().name(), MovieModuleManager.getInstance().getSettings().getSubtitleLanguageStyle());
                        if (StringUtils.isBlank((CharSequence)lang)) {
                            lang = model.getLanguage().name();
                        }
                        String filename = FilenameUtils.getBaseName((String)MovieSubtitleChooserDialog.this.fileToScrape.getFilename()) + "." + lang;
                        SubtitleDownloadTask task = new SubtitleDownloadTask(model.getDownloadUrl(), MovieSubtitleChooserDialog.this.movieToScrape.getPathNIO().resolve(filename), MovieSubtitleChooserDialog.this.movieToScrape, lang);
                        MovieSubtitleChooserDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                        MovieSubtitleChooserDialog.this.lblProgressAction.setVisible(true);
                        MovieSubtitleChooserDialog.this.lblProgressAction.setText(TmmResourceBundle.getString("subtitle.downloading"));
                        task.run();
                        MovieSubtitleChooserDialog.this.lblProgressAction.setText(TmmResourceBundle.getString("subtitle.downloaded") + " - " + model.getReleaseName());
                    }
                }
                catch (Exception ex) {
                    MovieSubtitleChooserDialog.this.lblProgressAction.setVisible(true);
                    MovieSubtitleChooserDialog.this.lblProgressAction.setText(TmmResourceBundle.getString("message.scrape.subtitlefaileddownload") + " - " + ex.getLocalizedMessage());
                }
                finally {
                    MovieSubtitleChooserDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col == 0 || col == 1) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0 && col != 1) {
                table.setCursor(new Cursor(0));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JTable table = (JTable)e.getSource();
            int col = table.columnAtPoint(new Point(e.getX(), e.getY()));
            if (col != 0 && col != 1 && table.getCursor().getType() == 12) {
                table.setCursor(new Cursor(0));
            }
            if ((col == 0 || col == 1) && table.getCursor().getType() == 0) {
                table.setCursor(new Cursor(12));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
        }
    }

    private static class SubtitleTableFormat
    extends TmmTableFormat<MovieSubtitleChooserModel> {
        public SubtitleTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, "", "icon", model -> IconManager.DOWNLOAD, ImageIcon.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.title"), "title", MovieSubtitleChooserModel::getName, String.class);
            col.setCellTooltip(MovieSubtitleChooserModel::getName);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.releasename"), "releasename", MovieSubtitleChooserModel::getReleaseName, String.class);
            col.setCellTooltip(MovieSubtitleChooserModel::getReleaseName);
            this.addColumn(col);
        }
    }

    private static class Renderer
    extends DefaultTableCellRenderer {
        private final JLabel downloadLabel = new JLabel(TmmResourceBundle.getString("Button.download"), IconManager.DOWNLOAD, 0);

        Renderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == IconManager.DOWNLOAD) {
                return this.downloadLabel;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

