/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieAspectRatioFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    private static final String RATIO_1_33 = "4:3 (1.33:1)";
    private static final String RATIO_1_37 = "11:8 (1.37:1)";
    private static final String RATIO_1_43 = "IMAX (1.43:1)";
    private static final String RATIO_1_56 = "14:9 (1.56:1)";
    private static final String RATIO_1_66 = "5:3 (1.66:1)";
    private static final String RATIO_1_78 = "16:9 (1.78:1)";
    private static final String RATIO_1_85 = "Widescreen (1.85:1)";
    private static final String RATIO_1_90 = "Digital IMAX (1.90:1)";
    private static final String RATIO_2_00 = "18:9 (2.00:1)";
    private static final String RATIO_2_20 = "70mm (2.20:1)";
    private static final String RATIO_2_35 = "Anamorphic (2.35:1)";
    private static final String RATIO_2_40 = "Anamorphic widescreen (2.39:1 & 12:5)";
    private static final String RATIO_2_55 = "CinemaScope 55 (2.55:1)";
    private static final String RATIO_2_76 = "Ultra Panavision 70 (2.76:1)";
    private final String others;

    public MovieAspectRatioFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).startsWith(s2.toLowerCase(Locale.ROOT)));
        this.others = TmmResourceBundle.getString("filter.others");
        this.setValues(RATIO_1_33, RATIO_1_37, RATIO_1_43, RATIO_1_56, RATIO_1_66, RATIO_1_78, RATIO_1_85, RATIO_1_90, RATIO_2_00, RATIO_2_20, RATIO_2_35, RATIO_2_40, RATIO_2_55, RATIO_2_76, this.others);
    }

    @Override
    public String getId() {
        return "movieAspectRatio";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedValues = this.checkComboBox.getSelectedItems();
        MediaFile mf = movie.getMainVideoFile();
        if (mf == null) {
            return false;
        }
        float aspectRatio = mf.getAspectRatio().floatValue();
        for (String ratios : selectedValues) {
            if (!(aspectRatio == 1.33f ? ratios.equals(RATIO_1_33) : (aspectRatio == 1.37f ? ratios.equals(RATIO_1_37) : (aspectRatio == 1.43f ? ratios.equals(RATIO_1_43) : (aspectRatio == 1.56f ? ratios.equals(RATIO_1_56) : (aspectRatio == 1.66f ? ratios.equals(RATIO_1_66) : (aspectRatio == 1.78f ? ratios.equals(RATIO_1_78) : (aspectRatio == 1.85f ? ratios.equals(RATIO_1_85) : (aspectRatio == 1.9f ? ratios.equals(RATIO_1_90) : (aspectRatio == 2.0f ? ratios.equals(RATIO_2_00) : (aspectRatio == 2.2f ? ratios.equals(RATIO_2_20) : (aspectRatio == 2.35f ? ratios.equals(RATIO_2_35) : (aspectRatio == 2.39f || aspectRatio == 2.4f ? ratios.equals(RATIO_2_40) : (aspectRatio == 2.55f ? ratios.equals(RATIO_2_55) : (aspectRatio == 2.76f ? ratios.equals(RATIO_2_76) : ratios.equals(this.others)))))))))))))))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.aspect"));
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

