/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.components.treetable.TmmTreeTable;

public class MovieSetSelectionModel
extends AbstractModelObject {
    public static final String SELECTED_MOVIE_SET = "selectedMovieSet";
    private final MovieSet initalMovieSet;
    private final PropertyChangeListener propertyChangeListener;
    private MovieSet selectedMovieSet;
    private TmmTreeTable treeTable;

    public MovieSetSelectionModel() {
        this.selectedMovieSet = this.initalMovieSet = new MovieSet("");
        this.propertyChangeListener = evt -> {
            if (evt.getSource() == this.selectedMovieSet) {
                this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        };
    }

    public void setTreeTable(TmmTreeTable treeTable) {
        this.treeTable = treeTable;
    }

    public void setSelectedMovieSet(MovieSet movieSet) {
        MovieSet oldValue = this.selectedMovieSet;
        this.selectedMovieSet = movieSet != null ? movieSet : this.initalMovieSet;
        if (oldValue != null) {
            oldValue.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.selectedMovieSet != null) {
            this.selectedMovieSet.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.firePropertyChange(SELECTED_MOVIE_SET, oldValue, this.selectedMovieSet);
    }

    public MovieSet getSelectedMovieSet() {
        return this.selectedMovieSet;
    }

    public List<MovieSet> getSelectedMovieSets() {
        ArrayList<MovieSet> selectedMovieSets = new ArrayList<MovieSet>();
        for (Object obj : this.getSelectedObjects()) {
            if (!(obj instanceof MovieSet)) continue;
            selectedMovieSets.add((MovieSet)obj);
        }
        return selectedMovieSets;
    }

    public List<Movie> getSelectedMovies() {
        return this.getSelectedMovies(false);
    }

    public List<Movie> getSelectedMovies(boolean withLocked) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>();
        for (Object obj : this.getSelectedObjects()) {
            if (!(obj instanceof Movie)) continue;
            Movie movie = (Movie)obj;
            if (withLocked) {
                selectedMovies.add(movie);
                continue;
            }
            if (movie.isLocked()) continue;
            selectedMovies.add(movie);
        }
        return selectedMovies;
    }

    public List<Movie> getSelectedMoviesRecursive() {
        LinkedHashSet<Movie> selectedMovies = new LinkedHashSet<Movie>();
        for (Object obj : this.getSelectedObjects()) {
            if (obj instanceof MovieSet) {
                selectedMovies.addAll(((MovieSet)obj).getMovies());
                continue;
            }
            if (obj instanceof MovieSet.MovieSetMovie || !(obj instanceof Movie)) continue;
            selectedMovies.add((Movie)obj);
        }
        return new ArrayList<Movie>(selectedMovies);
    }

    public List<Object> getSelectedObjects() {
        int[] rows;
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        for (int row : rows = this.treeTable.getSelectedRows()) {
            DefaultMutableTreeNode node = this.treeTable.getTreeNode(row);
            if (node == null) continue;
            Object userObject = node.getUserObject();
            if (userObject instanceof MovieSet) {
                selectedObjects.add(userObject);
                continue;
            }
            if (!(userObject instanceof Movie)) continue;
            selectedObjects.add(userObject);
        }
        return selectedObjects;
    }
}

