/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.dialogs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSetArtworkHelper;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.ui.ArtworkDragAndDropListener;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.components.button.FlatButton;
import org.tinymediamanager.ui.components.label.ImageLabel;
import org.tinymediamanager.ui.components.label.LinkLabel;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.tabbedpane.TmmTabbedPane;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.textfield.TmmObligatoryTextArea;
import org.tinymediamanager.ui.components.textfield.TmmRoundTextArea;
import org.tinymediamanager.ui.dialogs.AbstractEditorDialog;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;

public class MovieSetEditorDialog
extends AbstractEditorDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetEditorDialog.class);
    private static final String ORIGINAL_IMAGE_SIZE = "originalImageSize";
    private static final String SPACER = "        ";
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();
    private final JTabbedPane tabbedPane = new TmmTabbedPane();
    private final MovieSet movieSetToEdit;
    private final List<Movie> moviesInSet = ObservableCollections.observableList(new ArrayList());
    private final List<Movie> removedMovies = new ArrayList<Movie>();
    private final List<MediaScraper> artworkScrapers = new ArrayList<MediaScraper>();
    private JTextArea tfName;
    private JTextArea tfSorttitle;
    private TmmTable tableMovies;
    private ImageLabel lblPoster;
    private ImageLabel lblFanart;
    private JTextArea taPlot;
    private JTextField tfTmdbId;
    private ImageLabel lblClearlogo;
    private ImageLabel lblBanner;
    private ImageLabel lblClearart;
    private ImageLabel lblDisc;
    private ImageLabel lblThumb;
    private JTextField tfPoster;
    private JTextField tfFanart;
    private JTextField tfClearLogo;
    private JTextField tfBanner;
    private JTextField tfClearArt;
    private JTextField tfThumb;
    private JTextField tfDisc;
    private JTextArea taNote;

    public MovieSetEditorDialog(MovieSet movieSet, int queueIndex, int queueSize, int selectedTab) {
        super(TmmResourceBundle.getString("movieset.edit") + (String)(queueSize > 1 ? " " + (queueIndex + 1) + "/" + queueSize : ""), "movieSetEditor", movieSet);
        this.setMinimumSize(new Dimension(800, 600));
        this.movieSetToEdit = movieSet;
        this.artworkScrapers.addAll(this.movieList.getDefaultArtworkScrapers());
        this.queueIndex = queueIndex;
        this.queueSize = queueSize;
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        JPanel panelContent = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.details"), panelContent);
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][400lp,grow][150lp:200lp,grow 50]", "[][][][100lp:25%:25%,grow][50lp:50lp:100lp,grow 50][20lp:n][pref!][][50lp:20%:30%,grow]"));
        TmmLabel lblName = new TmmLabel(TmmResourceBundle.getString("movieset.title"));
        panelContent.add((Component)lblName, "cell 0 0,alignx trailing");
        this.tfName = new TmmObligatoryTextArea();
        panelContent.add((Component)this.tfName, "cell 1 0,growx,aligny top, wmin 0");
        this.lblPoster = new ImageLabel();
        this.lblPoster.setCursor(Cursor.getPredefinedCursor(12));
        this.lblPoster.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, MovieSetEditorDialog.this.extractIds(), MediaArtwork.MediaArtworkType.POSTER, MovieSetEditorDialog.this.artworkScrapers, MovieSetEditorDialog.this.lblPoster, MediaType.MOVIE_SET);
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                MovieSetEditorDialog.this.updateArtworkUrl(MovieSetEditorDialog.this.lblPoster, MovieSetEditorDialog.this.tfPoster);
            }
        });
        panelContent.add((Component)new TmmLabel(TmmResourceBundle.getString("mediafiletype.poster")), "cell 2 0");
        LinkLabel lblPosterSize = new LinkLabel();
        panelContent.add((Component)lblPosterSize, "cell 2 0");
        FlatButton btnDeletePoster = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeletePoster.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeletePoster.addActionListener(e -> {
            this.lblPoster.clearImage();
            this.tfPoster.setText("");
        });
        btnDeletePoster.setFocusable(false);
        panelContent.add((Component)btnDeletePoster, "cell 2 0");
        TmmLabel lblSorttitleT = new TmmLabel(TmmResourceBundle.getString("metatag.sorttitle"));
        panelContent.add((Component)lblSorttitleT, "cell 0 1,alignx trailing");
        this.tfSorttitle = new TmmRoundTextArea();
        panelContent.add((Component)this.tfSorttitle, "cell 1 1,growx,aligny top");
        panelContent.add((Component)this.lblPoster, "cell 2 1 1 6,grow");
        this.lblPoster.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblPosterSize, this.lblPoster, btnDeletePoster, MediaFileType.POSTER));
        TmmLabel lblTmdbid = new TmmLabel(TmmResourceBundle.getString("metatag.tmdb"));
        panelContent.add((Component)lblTmdbid, "cell 0 2,alignx trailing");
        this.tfTmdbId = new JTextField();
        panelContent.add((Component)this.tfTmdbId, "flowx,cell 1 2,aligny center");
        this.tfTmdbId.setColumns(10);
        TmmLabel lblOverview = new TmmLabel(TmmResourceBundle.getString("metatag.plot"));
        panelContent.add((Component)lblOverview, "cell 0 3,alignx trailing,aligny top");
        JScrollPane scrollPaneOverview = new JScrollPane();
        panelContent.add((Component)scrollPaneOverview, "cell 1 3,wmin 0,grow");
        this.taPlot = new JTextArea();
        this.taPlot.setLineWrap(true);
        this.taPlot.setWrapStyleWord(true);
        this.taPlot.setForeground(UIManager.getColor("TextField.foreground"));
        scrollPaneOverview.setViewportView(this.taPlot);
        TmmLabel lblNoteT = new TmmLabel(TmmResourceBundle.getString("metatag.note"));
        panelContent.add((Component)lblNoteT, "cell 0 4,alignx trailing,aligny top");
        JScrollPane scrollPane = new JScrollPane();
        panelContent.add((Component)scrollPane, "cell 1 4,wmin 0,grow");
        this.taNote = new JTextArea();
        this.taNote.setLineWrap(true);
        this.taNote.setWrapStyleWord(true);
        this.taNote.setForeground(UIManager.getColor("TextField.foreground"));
        scrollPane.setViewportView(this.taNote);
        TmmLabel lblMovies = new TmmLabel(TmmResourceBundle.getString("tmm.movies"));
        panelContent.add((Component)lblMovies, "flowy,cell 0 6,alignx trailing,aligny top");
        JScrollPane scrollPaneMovies = new JScrollPane();
        panelContent.add((Component)scrollPaneMovies, "cell 1 6 1 3,grow");
        this.tableMovies = new TmmTable();
        scrollPaneMovies.setViewportView(this.tableMovies);
        this.lblFanart = new ImageLabel();
        this.lblFanart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblFanart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, MovieSetEditorDialog.this.extractIds(), MediaArtwork.MediaArtworkType.BACKGROUND, MovieSetEditorDialog.this.artworkScrapers, MovieSetEditorDialog.this.lblFanart, MediaType.MOVIE_SET);
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                MovieSetEditorDialog.this.updateArtworkUrl(MovieSetEditorDialog.this.lblFanart, MovieSetEditorDialog.this.tfFanart);
            }
        });
        panelContent.add((Component)new TmmLabel(TmmResourceBundle.getString("mediafiletype.fanart")), "cell 2 7");
        LinkLabel lblFanartSize = new LinkLabel();
        panelContent.add((Component)lblFanartSize, "cell 2 7");
        FlatButton btnDeleteFanart = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteFanart.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteFanart.addActionListener(e -> {
            this.lblFanart.clearImage();
            this.tfFanart.setText("");
        });
        panelContent.add((Component)btnDeleteFanart, "cell 2 7");
        panelContent.add((Component)this.lblFanart, "cell 2 8,grow");
        this.lblFanart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblFanartSize, this.lblFanart, btnDeleteFanart, MediaFileType.FANART));
        JButton btnRemoveMovie = new JButton("");
        btnRemoveMovie.setAction(new RemoveMovieAction());
        panelContent.add((Component)btnRemoveMovie, "cell 0 6,alignx right,aligny top");
        JPanel artworkPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.extraartwork"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new MigLayout("", "[200lp:50%,grow][20lp:n][200lp:50%,grow]", "[][100lp:30%:30%,grow][20lp:n][][100lp:30%:30%,grow][20lp:n][][100lp:30%:30%,grow]"));
        TmmLabel lblClearlogoT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.clearlogo"));
        artworkPanel.add((Component)lblClearlogoT, "cell 0 0");
        LinkLabel lblClearlogoSize = new LinkLabel();
        artworkPanel.add((Component)lblClearlogoSize, "cell 0 0");
        FlatButton btnDeleteClearLogo = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteClearLogo.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteClearLogo.addActionListener(e -> {
            this.lblClearlogo.clearImage();
            this.tfClearLogo.setText("");
        });
        artworkPanel.add((Component)btnDeleteClearLogo, "cell 0 0");
        this.lblClearlogo = new ImageLabel();
        this.lblClearlogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, MovieSetEditorDialog.this.extractIds(), MediaArtwork.MediaArtworkType.CLEARLOGO, MovieSetEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieSetEditorDialog.this.lblClearlogo, MediaType.MOVIE_SET);
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                MovieSetEditorDialog.this.updateArtworkUrl(MovieSetEditorDialog.this.lblClearlogo, MovieSetEditorDialog.this.tfClearLogo);
            }
        });
        this.lblClearlogo.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblClearlogo, "cell 0 1,grow");
        this.lblClearlogo.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblClearlogoSize, this.lblClearlogo, btnDeleteClearLogo, MediaFileType.CLEARLOGO));
        TmmLabel lblBannerT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT, "cell 0 3");
        LinkLabel lblBannerSize = new LinkLabel();
        artworkPanel.add((Component)lblBannerSize, "cell 0 3");
        FlatButton btnDeleteBanner = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteBanner.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteBanner.addActionListener(e -> {
            this.lblBanner.clearImage();
            this.tfBanner.setText("");
        });
        artworkPanel.add((Component)btnDeleteBanner, "cell 0 3");
        this.lblBanner = new ImageLabel();
        this.lblBanner.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, MovieSetEditorDialog.this.extractIds(), MediaArtwork.MediaArtworkType.BANNER, MovieSetEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieSetEditorDialog.this.lblBanner, MediaType.MOVIE_SET);
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                MovieSetEditorDialog.this.updateArtworkUrl(MovieSetEditorDialog.this.lblBanner, MovieSetEditorDialog.this.tfBanner);
            }
        });
        this.lblBanner.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblBanner, "cell 0 4 3 1,grow");
        this.lblBanner.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblBannerSize, this.lblBanner, btnDeleteBanner, MediaFileType.BANNER));
        TmmLabel lblClearartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.clearart"));
        artworkPanel.add((Component)lblClearartT, "cell 2 0");
        LinkLabel lblClearartSize = new LinkLabel();
        artworkPanel.add((Component)lblClearartSize, "cell 2 0");
        FlatButton btnDeleteClearart = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteClearart.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteClearart.addActionListener(e -> {
            this.lblClearart.clearImage();
            this.tfClearArt.setText("");
        });
        artworkPanel.add((Component)btnDeleteClearart, "cell 2 0");
        this.lblClearart = new ImageLabel();
        this.lblClearart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, MovieSetEditorDialog.this.extractIds(), MediaArtwork.MediaArtworkType.CLEARART, MovieSetEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieSetEditorDialog.this.lblClearart, MediaType.MOVIE_SET);
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                MovieSetEditorDialog.this.updateArtworkUrl(MovieSetEditorDialog.this.lblClearart, MovieSetEditorDialog.this.tfClearArt);
            }
        });
        this.lblClearart.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblClearart, "cell 2 1,grow");
        this.lblClearart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblClearartSize, this.lblClearart, btnDeleteClearart, MediaFileType.CLEARART));
        TmmLabel lblThumbT = new TmmLabel("Thumb");
        artworkPanel.add((Component)lblThumbT, "cell 0 6");
        LinkLabel lblThumbSize = new LinkLabel();
        artworkPanel.add((Component)lblThumbSize, "cell 0 6");
        FlatButton btnDeleteThumb = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteThumb.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteThumb.addActionListener(e -> {
            this.lblThumb.clearImage();
            this.tfThumb.setText("");
        });
        artworkPanel.add((Component)btnDeleteThumb, "cell 0 6");
        this.lblThumb = new ImageLabel();
        this.lblThumb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, MovieSetEditorDialog.this.extractIds(), MediaArtwork.MediaArtworkType.THUMB, MovieSetEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieSetEditorDialog.this.lblThumb, MediaType.MOVIE_SET);
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                MovieSetEditorDialog.this.updateArtworkUrl(MovieSetEditorDialog.this.lblThumb, MovieSetEditorDialog.this.tfThumb);
            }
        });
        this.lblThumb.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblThumb, "cell 0 7,grow");
        this.lblThumb.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblThumbSize, this.lblThumb, btnDeleteThumb, MediaFileType.THUMB));
        TmmLabel lblDiscT = new TmmLabel("Disc");
        artworkPanel.add((Component)lblDiscT, "cell 2 6");
        LinkLabel lblDiscSize = new LinkLabel();
        artworkPanel.add((Component)lblDiscSize, "cell 2 6");
        FlatButton btnDeleteDisc = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteDisc.setToolTipText(TmmResourceBundle.getString("Button.deleteartwork.desc"));
        btnDeleteDisc.addActionListener(e -> {
            this.lblDisc.clearImage();
            this.tfDisc.setText("");
        });
        artworkPanel.add((Component)btnDeleteDisc, "cell 2 6");
        this.lblDisc = new ImageLabel();
        this.lblDisc.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, MovieSetEditorDialog.this.extractIds(), MediaArtwork.MediaArtworkType.DISC, MovieSetEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieSetEditorDialog.this.lblDisc, MediaType.MOVIE_SET);
                dialog.setLocationRelativeTo(MainWindow.getInstance());
                dialog.setVisible(true);
                MovieSetEditorDialog.this.updateArtworkUrl(MovieSetEditorDialog.this.lblDisc, MovieSetEditorDialog.this.tfDisc);
            }
        });
        this.lblDisc.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblDisc, "cell 2 7,grow");
        this.lblDisc.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblDiscSize, this.lblDisc, btnDeleteDisc, MediaFileType.DISC));
        JPanel artworkAndTrailerPanel = new JPanel();
        this.tabbedPane.addTab(TmmResourceBundle.getString("edit.artwork"), null, artworkAndTrailerPanel, null);
        artworkAndTrailerPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][][][][]"));
        TmmLabel lblPosterT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.poster"));
        artworkAndTrailerPanel.add((Component)lblPosterT, "cell 0 0,alignx right");
        this.tfPoster = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfPoster, "cell 1 0,growx");
        TmmLabel lblFanartT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.fanart"));
        artworkAndTrailerPanel.add((Component)lblFanartT, "cell 0 1,alignx right");
        this.tfFanart = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfFanart, "cell 1 1,growx");
        TmmLabel lblClearLogoT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.clearlogo"));
        artworkAndTrailerPanel.add((Component)lblClearLogoT, "cell 0 2,alignx right");
        this.tfClearLogo = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfClearLogo, "cell 1 2,growx");
        lblBannerT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.banner"));
        artworkAndTrailerPanel.add((Component)lblBannerT, "cell 0 3,alignx right");
        this.tfBanner = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfBanner, "cell 1 3,growx");
        TmmLabel lblClearArtT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.clearart"));
        artworkAndTrailerPanel.add((Component)lblClearArtT, "cell 0 4,alignx right");
        this.tfClearArt = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfClearArt, "cell 1 4,growx");
        lblThumbT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.thumb"));
        artworkAndTrailerPanel.add((Component)lblThumbT, "cell 0 5,alignx right");
        this.tfThumb = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfThumb, "cell 1 5,growx");
        lblDiscT = new TmmLabel(TmmResourceBundle.getString("mediafiletype.disc"));
        artworkAndTrailerPanel.add((Component)lblDiscT, "cell 0 6,alignx trailing");
        this.tfDisc = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfDisc, "cell 1 6,growx");
        if (queueSize > 1) {
            JButton btnAbort = new JButton(new AbstractEditorDialog.AbortQueueAction(this, TmmResourceBundle.getString("Button.abortqueue")));
            this.addButton(btnAbort);
            if (queueIndex > 0) {
                JButton backButton = new JButton(new AbstractEditorDialog.NavigateBackAction(this));
                this.addButton(backButton);
            }
        }
        JButton btnCancel = new JButton(new CancelAction());
        this.addButton(btnCancel);
        JButton btnOk = new JButton(new OkAction());
        this.getRootPane().registerKeyboardAction(new OkAction(), KeyStroke.getKeyStroke(83, 128), 2);
        this.getRootPane().registerKeyboardAction(new OkAction(), KeyStroke.getKeyStroke(10, 128), 2);
        if (SystemUtils.IS_OS_MAC) {
            this.getRootPane().registerKeyboardAction(new OkAction(), KeyStroke.getKeyStroke(10, 256), 2);
        }
        this.addDefaultButton(btnOk);
        this.tfName.setText(this.movieSetToEdit.getTitle());
        this.tfSorttitle.setText(this.movieSetToEdit.getSortTitle());
        this.tfTmdbId.setText(String.valueOf(this.movieSetToEdit.getTmdbId()));
        this.taPlot.setText(this.movieSetToEdit.getPlot());
        this.taNote.setText(this.movieSetToEdit.getNote());
        this.moviesInSet.addAll(this.movieSetToEdit.getMovies());
        this.setArtworkPath(MediaFileType.POSTER, this.lblPoster);
        this.setArtworkPath(MediaFileType.FANART, this.lblFanart);
        this.setArtworkPath(MediaFileType.BANNER, this.lblBanner);
        this.setArtworkPath(MediaFileType.CLEARLOGO, this.lblClearlogo);
        this.setArtworkPath(MediaFileType.CLEARART, this.lblClearart);
        this.setArtworkPath(MediaFileType.THUMB, this.lblThumb);
        this.setArtworkPath(MediaFileType.DISC, this.lblDisc);
        this.tfPoster.setText(this.movieSetToEdit.getArtworkUrl(MediaFileType.POSTER));
        this.tfFanart.setText(this.movieSetToEdit.getArtworkUrl(MediaFileType.FANART));
        this.tfClearLogo.setText(this.movieSetToEdit.getArtworkUrl(MediaFileType.CLEARLOGO));
        this.tfClearArt.setText(this.movieSetToEdit.getArtworkUrl(MediaFileType.CLEARART));
        this.tfThumb.setText(this.movieSetToEdit.getArtworkUrl(MediaFileType.THUMB));
        this.tfDisc.setText(this.movieSetToEdit.getArtworkUrl(MediaFileType.DISC));
        this.tfBanner.setText(this.movieSetToEdit.getArtworkUrl(MediaFileType.BANNER));
        this.initDataBindings();
        this.tableMovies.getTableHeader().getColumnModel().getColumn(0).setHeaderValue(TmmResourceBundle.getString("metatag.name"));
        int width = (int)((float)this.tableMovies.getFontMetrics(this.tableMovies.getFont()).stringWidth("2000") * 1.3f + 10.0f);
        int titleWidth = this.tableMovies.getFontMetrics(this.tableMovies.getFont()).stringWidth(TmmResourceBundle.getString("metatag.year"));
        if (titleWidth > width) {
            width = titleWidth;
        }
        this.tableMovies.getTableHeader().getColumnModel().getColumn(1).setPreferredWidth(width);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(1).setMinWidth(width);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(1).setMaxWidth((int)((float)width * 1.1f));
        this.tableMovies.getTableHeader().getColumnModel().getColumn(1).setResizable(false);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(1).setHeaderValue(TmmResourceBundle.getString("metatag.year"));
        this.tableMovies.getTableHeader().getColumnModel().getColumn(2).setPreferredWidth(70);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(2).setMinWidth(70);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(2).setMaxWidth(85);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(2).setResizable(false);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(2).setHeaderValue(TmmResourceBundle.getString("metatag.watched"));
        this.tabbedPane.setSelectedIndex(selectedTab);
        this.registerDropTarget(this.lblPoster, this.tfPoster);
        this.registerDropTarget(this.lblFanart, this.tfFanart);
        this.registerDropTarget(this.lblBanner, this.tfBanner);
        this.registerDropTarget(this.lblClearart, this.tfClearArt);
        this.registerDropTarget(this.lblClearlogo, this.tfClearLogo);
        this.registerDropTarget(this.lblThumb, this.tfThumb);
        this.registerDropTarget(this.lblDisc, this.tfDisc);
    }

    public int getSelectedTab() {
        return this.tabbedPane.getSelectedIndex();
    }

    private Map<String, Object> extractIds() {
        HashMap<String, Object> ids = new HashMap<String, Object>(this.movieSetToEdit.getIds());
        try {
            ids.put("tmdbSet", Integer.parseInt(this.tfTmdbId.getText()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ids;
    }

    private void registerDropTarget(final ImageLabel imageLabel, final JTextField textField) {
        new DropTarget(imageLabel, new ArtworkDragAndDropListener(imageLabel){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                super.drop(dtde);
                MovieSetEditorDialog.this.updateArtworkUrl(imageLabel, textField);
            }
        });
    }

    private void updateArtworkUrl(ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isNotBlank((CharSequence)imageLabel.getImageUrl())) {
            textField.setText(imageLabel.getImageUrl());
        }
    }

    private void setArtworkPath(MediaFileType type, ImageLabel imageLabel) {
        if (StringUtils.isNotBlank((CharSequence)this.movieSetToEdit.getArtworkFilename(type))) {
            imageLabel.setImagePath(this.movieSetToEdit.getArtworkFilename(type));
        } else {
            imageLabel.setImageUrl(this.movieSetToEdit.getArtworkUrl(type));
        }
    }

    private void processArtwork(MediaFileType type, ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{imageLabel.getImagePath(), imageLabel.getImageUrl()}) && StringUtils.isNotBlank((CharSequence)this.movieSetToEdit.getArtworkFilename(type))) {
            this.movieSetToEdit.deleteMediaFiles(type);
        }
        if (StringUtils.isNotEmpty((CharSequence)textField.getText()) && !textField.getText().equals(this.movieSetToEdit.getArtworkUrl(type))) {
            this.movieSetToEdit.setArtworkUrl(textField.getText(), type);
        } else if (StringUtils.isEmpty((CharSequence)textField.getText())) {
            this.movieSetToEdit.removeArtworkUrl(type);
        }
    }

    protected void initDataBindings() {
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.moviesInSet, (JTable)this.tableMovies);
        BeanProperty movieBeanProperty = BeanProperty.create((String)"title");
        jTableBinding.addColumnBinding((Property)movieBeanProperty).setEditable(false);
        BeanProperty movieBeanProperty_1 = BeanProperty.create((String)"year");
        jTableBinding.addColumnBinding((Property)movieBeanProperty_1).setEditable(false);
        BeanProperty movieBeanProperty_2 = BeanProperty.create((String)"watched");
        jTableBinding.addColumnBinding((Property)movieBeanProperty_2).setEditable(false).setColumnClass(Boolean.class);
        jTableBinding.setEditable(false);
        jTableBinding.bind();
        this.bindingGroup = new BindingGroup();
        this.bindingGroup.addBinding((Binding)jTableBinding);
    }

    private class RemoveMovieAction
    extends AbstractAction {
        RemoveMovieAction() {
            this.putValue("SwingLargeIconKey", IconManager.REMOVE_INV);
            this.putValue("ShortDescription", TmmResourceBundle.getString("movieset.movie.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MovieSetEditorDialog.this.moviesInSet.isEmpty()) {
                return;
            }
            int row = MovieSetEditorDialog.this.tableMovies.getSelectedRow();
            if (row > -1) {
                Movie movie = MovieSetEditorDialog.this.moviesInSet.get(row);
                MovieSetEditorDialog.this.moviesInSet.remove(row);
                MovieSetEditorDialog.this.removedMovies.add(movie);
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.cancel"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("edit.discard"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
            this.putValue("SwingLargeIconKey", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieSetEditorDialog.this.setVisible(false);
        }
    }

    private class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.save"));
            this.putValue("ShortDescription", TmmResourceBundle.getString("Button.save"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StringUtils.isBlank((CharSequence)MovieSetEditorDialog.this.tfName.getText())) {
                MovieSetEditorDialog.this.tfName.requestFocusInWindow();
                return;
            }
            MovieSetEditorDialog.this.commitChanges();
            MovieSetEditorDialog.this.movieSetToEdit.setTitle(MovieSetEditorDialog.this.tfName.getText());
            MovieSetEditorDialog.this.movieSetToEdit.setSortTitle(MovieSetEditorDialog.this.tfSorttitle.getText());
            MovieSetEditorDialog.this.movieSetToEdit.setPlot(MovieSetEditorDialog.this.taPlot.getText());
            MovieSetEditorDialog.this.movieSetToEdit.setNote(MovieSetEditorDialog.this.taNote.getText());
            MovieSetEditorDialog.this.processArtwork(MediaFileType.POSTER, MovieSetEditorDialog.this.lblPoster, MovieSetEditorDialog.this.tfPoster);
            MovieSetEditorDialog.this.processArtwork(MediaFileType.FANART, MovieSetEditorDialog.this.lblFanart, MovieSetEditorDialog.this.tfFanart);
            MovieSetEditorDialog.this.processArtwork(MediaFileType.CLEARLOGO, MovieSetEditorDialog.this.lblClearlogo, MovieSetEditorDialog.this.tfClearLogo);
            MovieSetEditorDialog.this.processArtwork(MediaFileType.BANNER, MovieSetEditorDialog.this.lblBanner, MovieSetEditorDialog.this.tfBanner);
            MovieSetEditorDialog.this.processArtwork(MediaFileType.CLEARART, MovieSetEditorDialog.this.lblClearart, MovieSetEditorDialog.this.tfClearArt);
            MovieSetEditorDialog.this.processArtwork(MediaFileType.THUMB, MovieSetEditorDialog.this.lblThumb, MovieSetEditorDialog.this.tfThumb);
            MovieSetEditorDialog.this.processArtwork(MediaFileType.DISC, MovieSetEditorDialog.this.lblDisc, MovieSetEditorDialog.this.tfDisc);
            for (int i = MovieSetEditorDialog.this.movieSetToEdit.getMovies().size() - 1; i >= 0; --i) {
                Movie movie = MovieSetEditorDialog.this.movieSetToEdit.getMovies().get(i);
                if (MovieSetEditorDialog.this.moviesInSet.contains(movie)) continue;
                movie.setMovieSet(null);
                movie.writeNFO();
                movie.saveToDb();
                MovieSetEditorDialog.this.movieSetToEdit.removeMovie(movie, true);
            }
            for (Movie movie : MovieSetEditorDialog.this.moviesInSet) {
                movie.saveToDb();
            }
            for (Movie movie : MovieSetEditorDialog.this.removedMovies) {
                movie.removeFromMovieSet();
                movie.saveToDb();
                movie.writeNFO();
                MovieSetEditorDialog.this.movieSetToEdit.removeMovie(movie, true);
            }
            for (Movie movie : MovieSetEditorDialog.this.moviesInSet) {
                movie.writeNFO();
            }
            int tmdbId = 0;
            try {
                tmdbId = Integer.parseInt(MovieSetEditorDialog.this.tfTmdbId.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            MovieSetEditorDialog.this.movieSetToEdit.setTmdbId(tmdbId);
            MovieSetEditorDialog.this.movieSetToEdit.writeNFO();
            MovieSetEditorDialog.this.movieSetToEdit.saveToDb();
            MovieSetArtworkHelper.cleanupArtwork(MovieSetEditorDialog.this.movieSetToEdit);
            MovieSetEditorDialog.this.setVisible(false);
        }
    }
}

