/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.formdev.flatlaf.ui.FlatTabbedPaneUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class TmmTabbedPaneUI
extends FlatTabbedPaneUI {
    protected static final int BORDER_RADIUS = 15;
    protected Color contentBackgroundColor;

    public static ComponentUI createUI(JComponent c) {
        return new TmmTabbedPaneUI();
    }

    protected void installDefaults() {
        Font defaultFont = UIManager.getFont("defaultFont");
        if (defaultFont != null) {
            this.tabPane.setFont(null);
            UIManager.put("TabbedPane.font", this.scale(defaultFont, 1.1667).deriveFont(1));
        }
        super.installDefaults();
        this.contentBackgroundColor = UIManager.getColor("TabbedPane.contentBackgroundColor");
    }

    protected void paintTabSelection(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        Graphics2D g2D = (Graphics2D)g.create();
        try {
            FlatUIUtils.setRenderingHints((Graphics)g);
            Insets insets = this.tabPane.getInsets();
            int x = insets.left;
            int y = insets.top;
            int w = this.tabPane.getWidth() - insets.right - insets.left;
            int h = this.tabPane.getHeight() - insets.top - insets.bottom;
            g2D.setColor(this.contentAreaColor);
            g2D.fillRect(x, y, w, h);
            if (this.contentBackgroundColor != null) {
                g2D.setColor(this.contentBackgroundColor);
                if (this.drawFullWidth()) {
                    x = 0;
                    y = 0;
                } else {
                    Insets contentInsets = this.getContentBorderInsets(tabPlacement);
                    x = insets.left + contentInsets.left;
                    y = 0;
                    w = w - contentInsets.left - contentInsets.right;
                }
                if (this.drawRoundEdge()) {
                    g2D.fillRoundRect(x, y, w, h, 15, 15);
                } else {
                    g2D.fillRect(x, y, w, h);
                }
            }
            if (selectedIndex >= 0) {
                Rectangle tabRect = this.getTabBounds(this.tabPane, selectedIndex);
                Insets tabInsets = this.getTabInsets(tabPlacement, selectedIndex);
                if (tabRect.width > tabInsets.left + tabInsets.right) {
                    g2D.setColor(this.selectedBackground);
                    int[] xPoints = new int[]{tabRect.x + (tabRect.width / 2 + 10), tabRect.x + (tabRect.width / 2 - 10), tabRect.x + tabRect.width / 2};
                    int[] yPoints = new int[]{tabRect.y + tabRect.height, tabRect.y + tabRect.height, tabRect.y + tabRect.height + 10};
                    g2D.fillPolygon(xPoints, yPoints, xPoints.length);
                }
            }
        }
        finally {
            g2D.dispose();
        }
    }

    protected Font scale(Font font, double factor) {
        int newSize = Math.round((float)((double)font.getSize() * factor));
        return font.deriveFont((float)newSize);
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    protected Insets getContentBorderInsets(int tabPlacement) {
        Insets insets = new Insets(this.contentBorderInsets.top, this.contentBorderInsets.left, this.contentBorderInsets.bottom, this.contentBorderInsets.right);
        if (Boolean.FALSE.equals(this.tabPane.getClientProperty("rightBorder"))) {
            insets.right = 0;
        }
        if ("half".equals(this.tabPane.getClientProperty("rightBorder"))) {
            insets.right = this.contentBorderInsets.right / 2;
        }
        if (Boolean.FALSE.equals(this.tabPane.getClientProperty("leftBorder"))) {
            insets.left = 0;
        }
        if ("half".equals(this.tabPane.getClientProperty("leftBorder"))) {
            insets.left = this.contentBorderInsets.left / 2;
        }
        insets.bottom = this.drawRoundEdge() ? 10 : 0;
        return insets;
    }

    private boolean drawRoundEdge() {
        Object clientProperty = this.tabPane.getClientProperty("roundEdge");
        if (clientProperty == null) {
            return true;
        }
        return Boolean.parseBoolean(clientProperty.toString());
    }

    private boolean drawFullWidth() {
        Object clientProperty = this.tabPane.getClientProperty("fullWidth");
        if (clientProperty == null) {
            return false;
        }
        return Boolean.parseBoolean(clientProperty.toString());
    }

    protected Insets getTabAreaInsets(int tabPlacement) {
        Insets insets = new Insets(this.tabAreaInsets.top, this.tabAreaInsets.left, this.tabAreaInsets.bottom, this.tabAreaInsets.right);
        if (Boolean.FALSE.equals(this.tabPane.getClientProperty("rightBorder"))) {
            insets.right = 0;
        }
        if (Boolean.FALSE.equals(this.tabPane.getClientProperty("leftBorder"))) {
            insets.left = 0;
        }
        return insets;
    }

    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        Rectangle clipRect = g.getClipBounds();
        if (clipRect.y < this.maxTabHeight) {
            g.setColor(this.tabPane.getBackground());
            g.fillRect(0, -1, this.tabPane.getWidth(), this.maxTabHeight + 1);
        }
        super.paintTabArea(g, tabPlacement, selectedIndex);
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Rectangle clipRect = g.getClipBounds();
        if (clipRect.y < this.maxTabHeight) {
            g.setColor(this.tabPane.getBackground());
            g.fillRect(0, -1, this.tabPane.getWidth(), this.maxTabHeight + 1);
        }
    }
}

