/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tasks.QueueTask;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowHelpers;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowThemeDownloadTask;
import org.tinymediamanager.core.tvshow.tasks.TvShowTrailerDownloadTask;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.TrailerSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowTrailerProvider;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.StrgUtils;

public class TvShowChooserModel
extends AbstractModelObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowChooserModel.class);
    public static final TvShowChooserModel emptyResult = new TvShowChooserModel();
    private final TvShow tvShow;
    private final MediaScraper mediaScraper;
    private final List<MediaScraper> artworkScrapers;
    private final List<MediaScraper> trailerScrapers;
    private MediaLanguages language = null;
    private MediaSearchResult result = null;
    private MediaMetadata metadata = null;
    private float score = 0.0f;
    private String title = "";
    private String originalTitle = "";
    private String overview = "";
    private int year = 0;
    private String id = "";
    private String combinedName = "";
    private String posterUrl = "";
    private List<MediaEpisodeGroup> episodeGroups = new ArrayList<MediaEpisodeGroup>();
    private MediaEpisodeGroup episodeGroup = null;
    private List<MediaMetadata> episodeList = new ArrayList<MediaMetadata>();
    private boolean scraped = false;
    private QueueTask queueTask;

    public TvShowChooserModel(TvShow tvShow, MediaScraper mediaScraper, List<MediaScraper> artworkScrapers, List<MediaScraper> trailerScrapers, MediaSearchResult result, MediaLanguages language) {
        this.tvShow = tvShow;
        this.mediaScraper = mediaScraper;
        this.artworkScrapers = artworkScrapers;
        this.result = result;
        this.language = language;
        this.trailerScrapers = trailerScrapers;
        this.setTitle(result.getTitle());
        this.setOriginalTitle(result.getOriginalTitle());
        this.setYear(result.getYear());
        Object obj = result.getId();
        if (obj != null) {
            this.setId(obj.toString());
        }
        this.setCombinedName();
        this.score = result.getScore();
    }

    private TvShowChooserModel() {
        this.setTitle(TmmResourceBundle.getString("chooser.nothingfound"));
        this.tvShow = null;
        this.mediaScraper = null;
        this.artworkScrapers = null;
        this.trailerScrapers = null;
        this.combinedName = this.title;
    }

    public float getScore() {
        return this.score;
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = StrgUtils.getNonNullString(title);
        this.firePropertyChange("title", oldValue, this.title);
    }

    public void setOriginalTitle(String originalTitle) {
        String oldValue = this.originalTitle;
        this.originalTitle = StrgUtils.getNonNullString(originalTitle);
        this.firePropertyChange("originalTitle", oldValue, this.originalTitle);
    }

    public void setOverview(String overview) {
        String oldValue = this.overview;
        this.overview = StrgUtils.getNonNullString(overview);
        this.firePropertyChange("overview", oldValue, this.overview);
    }

    public String getTitle() {
        return this.title;
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public String getOverview() {
        return this.overview;
    }

    public String getPosterUrl() {
        return this.posterUrl;
    }

    public void setPosterUrl(String newValue) {
        String oldValue = this.posterUrl;
        this.posterUrl = StrgUtils.getNonNullString(newValue);
        this.firePropertyChange("posterUrl", oldValue, newValue);
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        int oldValue = this.year;
        this.year = year;
        this.firePropertyChange("year", oldValue, this.year);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        String oldValue = this.id;
        this.id = id;
        this.firePropertyChange("id", oldValue, this.id);
    }

    public void setCombinedName() {
        String oldValue = this.combinedName;
        this.combinedName = this.getYear() > 0 ? this.getTitle() + " (" + this.getYear() + ")" : this.getTitle();
        this.firePropertyChange("combinedName", oldValue, this.combinedName);
    }

    public String getCombinedName() {
        return this.combinedName;
    }

    public MediaScraper getMediaScraper() {
        return this.mediaScraper;
    }

    public List<MediaScraper> getArtworkScrapers() {
        return this.artworkScrapers;
    }

    public void addTask(TmmTask task) {
        if (this.queueTask == null) {
            this.queueTask = new QueueTask(TmmResourceBundle.getString("tvshow.scrape.metadata"));
        }
        this.queueTask.addTask(task);
    }

    public void startTasks() {
        if (this.queueTask != null) {
            TmmTaskManager.getInstance().addUnnamedTask(this.queueTask);
            this.queueTask = null;
        }
    }

    public void startTrailerScrapeTask(boolean overwrite) {
        this.addTask(new TrailerScrapeTask(this.tvShow, overwrite));
    }

    public void startThemeDownloadTask(boolean overwrite) {
        this.addTask(new TvShowThemeDownloadTask(Collections.singletonList(this.tvShow), overwrite));
    }

    public void scrapeMetaData() {
        try {
            this.setPosterUrl(this.result.getPosterUrl());
            TvShowSearchAndScrapeOptions options = new TvShowSearchAndScrapeOptions();
            options.setSearchResult(this.result);
            options.setLanguage(this.language);
            options.setCertificationCountry(TvShowModuleManager.getInstance().getSettings().getCertificationCountry());
            options.setReleaseDateCountry(TvShowModuleManager.getInstance().getSettings().getReleaseDateCountry());
            options.setIds(this.result.getIds());
            LOGGER.info("=====================================================");
            LOGGER.info("Scrape tvShow metadata with scraper: {}", (Object)this.mediaScraper.getMediaProvider().getProviderInfo().getId());
            LOGGER.info("{}", (Object)options);
            LOGGER.info("=====================================================");
            this.metadata = ((ITvShowMetadataProvider)this.mediaScraper.getMediaProvider()).getMetadata(options);
            this.episodeList = ((ITvShowMetadataProvider)this.mediaScraper.getMediaProvider()).getEpisodeList(options);
            MediaIdUtil.injectMissingIds(this.metadata.getIds(), MediaType.TV_SHOW);
            this.episodeGroups.addAll(this.metadata.getEpisodeGroups());
            Collections.sort(this.episodeGroups);
            if (this.episodeGroups.size() > 1) {
                MediaEpisodeGroup detectedEpisodeGroup = TvShowHelpers.findBestMatchingEpisodeGroup(this.tvShow, this.episodeGroups, this.episodeList);
                this.episodeGroup = detectedEpisodeGroup != null ? detectedEpisodeGroup : this.episodeGroups.get(0);
            } else if (this.episodeGroups.size() == 1) {
                this.episodeGroup = this.episodeGroups.get(0);
            }
            this.setOverview(this.metadata.getPlot());
            if (StringUtils.isBlank((CharSequence)this.posterUrl) && !this.metadata.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).isEmpty()) {
                this.setPosterUrl(this.metadata.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).get(0).getPreviewUrl());
            }
            this.setScraped(true);
        }
        catch (MissingIdException e) {
            LOGGER.warn("missing id for scrape");
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "TvShowChooser", "scraper.error.missingid"));
        }
        catch (NothingFoundException ignored) {
            LOGGER.debug("nothing found");
        }
        catch (ScrapeException e) {
            LOGGER.error("getMetadata", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowChooser", "message.scrape.metadatatvshowfailed", new String[]{":", e.getLocalizedMessage()}));
        }
        catch (Exception e) {
            LOGGER.error("unforeseen error: ", (Throwable)e);
        }
    }

    public List<TvShowEpisode> getEpisodesForDisplay() {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>();
        if (!this.scraped) {
            return episodes;
        }
        TvShowSearchAndScrapeOptions options = new TvShowSearchAndScrapeOptions();
        options.setLanguage(this.language);
        options.setCertificationCountry(TvShowModuleManager.getInstance().getSettings().getCertificationCountry());
        options.setReleaseDateCountry(TvShowModuleManager.getInstance().getSettings().getReleaseDateCountry());
        for (Map.Entry<String, Object> entry : this.metadata.getIds().entrySet()) {
            options.setId(entry.getKey(), entry.getValue().toString());
        }
        try {
            List<MediaMetadata> mediaEpisodes = ((ITvShowMetadataProvider)this.mediaScraper.getMediaProvider()).getEpisodeList(options);
            for (MediaMetadata me : mediaEpisodes) {
                TvShowEpisode ep = new TvShowEpisode();
                ep.setEpisodeNumbers(me.getEpisodeNumbers());
                ep.setFirstAired(me.getReleaseDate());
                ep.setTitle(me.getTitle());
                ep.setOriginalTitle(me.getOriginalTitle());
                ep.setPlot(me.getPlot());
                ep.setActors(me.getCastMembers(Person.Type.ACTOR));
                ep.setDirectors(me.getCastMembers(Person.Type.DIRECTOR));
                ep.setWriters(me.getCastMembers(Person.Type.WRITER));
                episodes.add(ep);
            }
        }
        catch (MissingIdException e) {
            LOGGER.warn("missing id for scrape");
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "TvShowChooser", "scraper.error.missingid"));
        }
        catch (ScrapeException e) {
            LOGGER.error("getEpisodeList", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowChooser", "message.scrape.episodelistfailed", new String[]{":", e.getLocalizedMessage()}));
        }
        return episodes;
    }

    public MediaMetadata getMetadata() {
        return this.metadata;
    }

    private void setScraped(boolean newValue) {
        boolean oldValue = this.scraped;
        this.scraped = newValue;
        this.firePropertyChange("scraped", oldValue, newValue);
    }

    public boolean isScraped() {
        return this.scraped;
    }

    public MediaLanguages getLanguage() {
        return this.language;
    }

    public List<MediaEpisodeGroup> getEpisodeGroups() {
        return this.episodeGroups;
    }

    public MediaEpisodeGroup getEpisodeGroup() {
        return this.episodeGroup;
    }

    public void setEpisodeGroup(MediaEpisodeGroup newValue) {
        MediaEpisodeGroup oldValue = this.episodeGroup;
        this.episodeGroup = newValue;
        this.firePropertyChange("episodeGroup", oldValue, newValue);
    }

    public List<MediaMetadata> getEpisodeList() {
        return this.episodeList;
    }

    public void startArtworkScrapeTask(List<TvShowScraperMetadataConfig> config, boolean overwrite) {
        this.addTask(new ArtworkScrapeTask(this.tvShow, config, overwrite));
    }

    public List<MediaArtwork> getArtwork() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
        ArtworkSearchAndScrapeOptions options = new ArtworkSearchAndScrapeOptions(MediaType.TV_SHOW);
        options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
        options.setMetadata(this.metadata);
        options.setIds(this.metadata.getIds());
        options.setLanguage(TvShowModuleManager.getInstance().getSettings().getDefaultImageScraperLanguage());
        options.setFanartSize(TvShowModuleManager.getInstance().getSettings().getImageFanartSize());
        options.setPosterSize(TvShowModuleManager.getInstance().getSettings().getImagePosterSize());
        options.setThumbSize(TvShowModuleManager.getInstance().getSettings().getImageThumbSize());
        for (Map.Entry<String, Object> entry : this.tvShow.getIds().entrySet()) {
            options.setId(entry.getKey(), entry.getValue().toString());
        }
        this.artworkScrapers.parallelStream().forEach(artworkScraper -> {
            ITvShowArtworkProvider artworkProvider = (ITvShowArtworkProvider)artworkScraper.getMediaProvider();
            try {
                lock.writeLock().lock();
                artwork.addAll(artworkProvider.getArtwork(options));
            }
            catch (MissingIdException e) {
                LOGGER.debug("no id found for scraper {}", (Object)artworkScraper.getMediaProvider().getProviderInfo().getId());
            }
            catch (NothingFoundException e) {
                LOGGER.debug("did not find artwork for '{}'", (Object)this.tvShow.getTitle());
            }
            catch (ScrapeException e) {
                LOGGER.error("getArtwork", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.tvShow, "message.scrape.tvshowartworkfailed", new String[]{":", e.getLocalizedMessage()}));
            }
            finally {
                lock.writeLock().unlock();
            }
        });
        if (StringUtils.isNotBlank((CharSequence)this.getPosterUrl())) {
            MediaArtwork ma = new MediaArtwork(this.result.getProviderId(), MediaArtwork.MediaArtworkType.POSTER);
            ma.setOriginalUrl(this.getPosterUrl());
            ma.setPreviewUrl(this.getPosterUrl());
            ma.addImageSize(0, 0, this.getPosterUrl(), 0);
            artwork.add(ma);
        }
        return artwork;
    }

    private class TrailerScrapeTask
    extends TmmTask {
        private final TvShow tvShowtoScrape;
        private final boolean overwrite;

        public TrailerScrapeTask(TvShow tvShow, boolean overwrite) {
            super(TmmResourceBundle.getString("message.scrape.trailer") + " " + tvShow.getTitle(), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
            this.tvShowtoScrape = tvShow;
            this.overwrite = overwrite;
        }

        @Override
        protected void doInBackground() {
            if (!TvShowChooserModel.this.scraped) {
                return;
            }
            if (!this.overwrite && !this.tvShowtoScrape.getTrailer().isEmpty()) {
                return;
            }
            ArrayList<MediaTrailer> trailer = new ArrayList<MediaTrailer>();
            TrailerSearchAndScrapeOptions options = new TrailerSearchAndScrapeOptions(MediaType.TV_SHOW);
            options.setMetadata(TvShowChooserModel.this.metadata);
            options.setIds(TvShowChooserModel.this.metadata.getIds());
            options.setLanguage(TvShowChooserModel.this.language);
            for (MediaScraper trailerScraper : TvShowChooserModel.this.trailerScrapers) {
                try {
                    ITvShowTrailerProvider trailerProvider = (ITvShowTrailerProvider)trailerScraper.getMediaProvider();
                    trailer.addAll(trailerProvider.getTrailers(options));
                }
                catch (MissingIdException ignored) {
                    LOGGER.debug("no id found for scraper {}", (Object)trailerScraper.getMediaProvider().getProviderInfo().getId());
                }
                catch (ScrapeException e) {
                    LOGGER.error("getTrailers {}", (Object)e.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowChooser", "message.scrape.trailerfailed", new String[]{":", e.getLocalizedMessage()}));
                }
            }
            this.tvShowtoScrape.setTrailers(trailer);
            this.tvShowtoScrape.saveToDb();
            this.tvShowtoScrape.writeNFO();
            if (TvShowModuleManager.getInstance().getSettings().isUseTrailerPreference() && TvShowModuleManager.getInstance().getSettings().isAutomaticTrailerDownload() && TvShowChooserModel.this.tvShow.getMediaFiles(MediaFileType.TRAILER).isEmpty() && !TvShowChooserModel.this.tvShow.getTrailer().isEmpty()) {
                TmmTaskManager.getInstance().addDownloadTask(new TvShowTrailerDownloadTask(TvShowChooserModel.this.tvShow));
            }
        }
    }

    private class ArtworkScrapeTask
    extends TmmTask {
        private final TvShow tvShowToScrape;
        private final List<TvShowScraperMetadataConfig> config;
        private final boolean overwrite;

        public ArtworkScrapeTask(TvShow tvShow, List<TvShowScraperMetadataConfig> config, boolean overwrite) {
            super(TmmResourceBundle.getString("message.scrape.artwork") + " " + tvShow.getTitle(), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
            this.tvShowToScrape = tvShow;
            this.config = config;
            this.overwrite = overwrite;
        }

        @Override
        protected void doInBackground() {
            if (!TvShowChooserModel.this.scraped) {
                return;
            }
            List<MediaArtwork> artwork = TvShowChooserModel.this.getArtwork();
            this.tvShowToScrape.setArtwork(artwork, this.config, this.overwrite);
        }
    }
}

