/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.ui.panels.AbstractModalInputPanel;

public class TvShowEpisodeNumberEditorPanel
extends AbstractModalInputPanel {
    private final JComboBox<MediaEpisodeGroup> cbEpisodeGroup;
    private final JSpinner spEpisode;
    private final JSpinner spSeason;
    private MediaEpisodeNumber episodeNumber;

    public TvShowEpisodeNumberEditorPanel(MediaEpisodeNumber episodeNumber, List<MediaEpisodeGroup> episodeGroupsInTvShow) {
        ArrayList<MediaEpisodeGroup> episodeGroups = new ArrayList<MediaEpisodeGroup>(episodeGroupsInTvShow);
        if (this.isEpisodeGroupMissing(MediaEpisodeGroup.EpisodeGroupType.AIRED, episodeGroupsInTvShow)) {
            episodeGroups.add(0, MediaEpisodeGroup.DEFAULT_AIRED);
        }
        if (this.isEpisodeGroupMissing(MediaEpisodeGroup.EpisodeGroupType.ABSOLUTE, episodeGroupsInTvShow)) {
            episodeGroups.add(0, MediaEpisodeGroup.DEFAULT_ABSOLUTE);
        }
        if (this.isEpisodeGroupMissing(MediaEpisodeGroup.EpisodeGroupType.DVD, episodeGroupsInTvShow)) {
            episodeGroups.add(0, MediaEpisodeGroup.DEFAULT_DVD);
        }
        if (this.isEpisodeGroupMissing(MediaEpisodeGroup.EpisodeGroupType.DISPLAY, episodeGroupsInTvShow)) {
            episodeGroups.add(0, MediaEpisodeGroup.DEFAULT_DISPLAY);
        }
        this.setLayout((LayoutManager)new MigLayout("", "[][]", "[][][]"));
        JLabel episodeGroupT = new JLabel(TmmResourceBundle.getString("metatag.episode.group"));
        this.add((Component)episodeGroupT, "cell 0 0,alignx trailing");
        this.cbEpisodeGroup = new JComboBox<MediaEpisodeGroup>((MediaEpisodeGroup[])episodeGroups.toArray(MediaEpisodeGroup[]::new));
        this.add(this.cbEpisodeGroup, "cell 1 0,growx");
        JLabel seasonT = new JLabel(TmmResourceBundle.getString("metatag.season"));
        this.add((Component)seasonT, "cell 0 1,alignx trailing");
        this.spSeason = new JSpinner();
        this.spSeason.setModel(new SpinnerNumberModel(-1, -1, Integer.MAX_VALUE, 1));
        this.add((Component)this.spSeason, "cell 1 1,growx");
        JLabel episodeT = new JLabel(TmmResourceBundle.getString("metatag.episode"));
        this.add((Component)episodeT, "cell 0 2,alignx trailing");
        this.spEpisode = new JSpinner();
        this.spEpisode.setModel(new SpinnerNumberModel(-1, -1, Integer.MAX_VALUE, 1));
        this.add((Component)this.spEpisode, "cell 1 2,growx");
        this.cbEpisodeGroup.setSelectedItem(episodeNumber.episodeGroup());
        this.spSeason.setValue(episodeNumber.season());
        this.spEpisode.setValue(episodeNumber.episode());
        SwingUtilities.invokeLater(this.cbEpisodeGroup::requestFocus);
    }

    private boolean isEpisodeGroupMissing(MediaEpisodeGroup.EpisodeGroupType episodeGroupType, List<MediaEpisodeGroup> episodeGroupsInTvShow) {
        for (MediaEpisodeGroup episodeGroup : episodeGroupsInTvShow) {
            if (!episodeGroup.getEpisodeGroupType().equals((Object)episodeGroupType)) continue;
            return false;
        }
        return true;
    }

    public MediaEpisodeNumber getEpisodeNumber() {
        return this.episodeNumber;
    }

    @Override
    protected void onClose() {
        Object object = this.cbEpisodeGroup.getSelectedItem();
        if (object instanceof MediaEpisodeGroup) {
            MediaEpisodeGroup episodeGroup = (MediaEpisodeGroup)object;
            this.episodeNumber = new MediaEpisodeNumber(episodeGroup, (Integer)this.spSeason.getValue(), (Integer)this.spEpisode.getValue());
        }
        this.setVisible(false);
    }
}

