/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableCellRenderer;
import org.tinymediamanager.ui.tvshows.TvShowTreeDataProvider;

public class TvShowTreeCellRenderer
extends TmmTreeTableCellRenderer {
    private Color colorDummy;

    @Override
    public void updateUI() {
        super.updateUI();
        this.colorDummy = UIManager.getColor("Component.linkColor");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TvShowEpisode episode;
        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof TvShowTreeDataProvider.TvShowTreeNode) {
            TvShow tvShow = (TvShow)((TvShowTreeDataProvider.TvShowTreeNode)value).getUserObject();
            if (tvShow.isLocked()) {
                this.setIcon(IconManager.LOCK_BLUE);
            } else {
                this.setIcon(null);
            }
        }
        if (value instanceof TvShowTreeDataProvider.TvShowSeasonTreeNode) {
            TvShowSeason season = (TvShowSeason)((TvShowTreeDataProvider.TvShowSeasonTreeNode)value).getUserObject();
            if (season.isDummy()) {
                renderer.setForeground(this.colorDummy);
            }
        } else if (value instanceof TvShowTreeDataProvider.TvShowEpisodeTreeNode && (episode = (TvShowEpisode)((TvShowTreeDataProvider.TvShowEpisodeTreeNode)value).getUserObject()).isDummy()) {
            renderer.setForeground(this.colorDummy);
        }
        return renderer;
    }

    @Override
    public String getToolTipText() {
        if (!TvShowModuleManager.getInstance().getSettings().isShowTvShowTableTooltips()) {
            return null;
        }
        return super.getToolTipText();
    }
}

