/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowChangeToAbsoluteAction
extends TmmAction {
    public TvShowChangeToAbsoluteAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.changetoabs.title"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.changetoabs.title"));
        this.putValue("SmallIcon", IconManager.ABSOLUTE);
        this.putValue("SwingLargeIconKey", IconManager.ABSOLUTE);
    }

    @Override
    protected void processAction(ActionEvent e) {
        TvShowSelectionModel.SelectedObjects selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        if (selectedObjects.isLockedFound()) {
            TvShowSelectionModel.showLockedInformation();
        }
        if (selectedObjects.isEmpty()) {
            return;
        }
        int decision = JOptionPane.showConfirmDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tvshow.changetoabs.message"), TmmResourceBundle.getString("tvshow.changetoabs.title"), 0);
        if (decision == 0) {
            for (TvShowEpisode episode : selectedObjects.getEpisodesRecursive()) {
                int ep = episode.getEpisode(MediaEpisodeGroup.EpisodeGroupType.AIRED);
                int s = episode.getSeason(MediaEpisodeGroup.EpisodeGroupType.AIRED);
                if (s < 0) {
                    s = 0;
                }
                int abs = s * 100 + ep;
                episode.setEpisode(new MediaEpisodeNumber(MediaEpisodeGroup.DEFAULT_ABSOLUTE, 1, abs));
                episode.saveToDb();
            }
            for (TvShow show : selectedObjects.getTvShows()) {
                if (!show.getEpisodeGroups().contains(MediaEpisodeGroup.DEFAULT_ABSOLUTE)) {
                    show.addEpisodeGroup(MediaEpisodeGroup.DEFAULT_ABSOLUTE);
                }
                show.setEpisodeGroup(MediaEpisodeGroup.DEFAULT_ABSOLUTE);
                show.saveToDb();
            }
        }
    }
}

