/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.tasks.TvShowScrapeTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowScrapeMetadataDialog;

public class TvShowSelectedScrapeAction
extends TmmAction {
    public TvShowSelectedScrapeAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshow.scrape.selected.force"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshow.scrape.selected.force.desc"));
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
        this.putValue("SmallIcon", IconManager.SEARCH);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShowsRecursive();
        if (selectedTvShows.isEmpty()) {
            return;
        }
        TvShowScrapeMetadataDialog dialog = TvShowScrapeMetadataDialog.createScrapeDialog(TmmResourceBundle.getString("tvshow.scrape.selected.force"));
        dialog.setLocationRelativeTo(MainWindow.getInstance());
        dialog.setVisible(true);
        if (!dialog.shouldStartScrape()) {
            return;
        }
        TvShowSearchAndScrapeOptions options = dialog.getTvShowSearchAndScrapeOptions();
        List<TvShowScraperMetadataConfig> tvShowScraperMetadataConfig = dialog.getTvShowScraperMetadataConfig();
        List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig = dialog.getTvShowEpisodeScraperMetadataConfig();
        boolean overwrite = dialog.getOverwriteExistingItems();
        TvShowScrapeTask scrapeTask = new TvShowScrapeTask(new TvShowScrapeTask.TvShowScrapeParams(selectedTvShows, options, tvShowScraperMetadataConfig, episodeScraperMetadataConfig).setOverwriteExistingItems(overwrite));
        TmmTaskManager.getInstance().addMainTask(scrapeTask);
    }
}

