/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowMediaSourceFilter
extends AbstractCheckComboBoxTvShowUIFilter<MediaSource> {
    public TvShowMediaSourceFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toString().toLowerCase(Locale.ROOT).startsWith(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallMediaSources();
        MediaSource.addListener(evt -> SwingUtilities.invokeLater(this::buildAndInstallMediaSources));
    }

    @Override
    public String getId() {
        return "tvShowMediaSource";
    }

    @Override
    public boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        for (TvShowEpisode episode : episodes) {
            if (!(invert ^ selectedItems.contains(episode.getMediaSource()))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.source"));
    }

    private void buildAndInstallMediaSources() {
        ArrayList<MediaSource> mediaSources = new ArrayList<MediaSource>();
        for (MediaSource mediaSource : MediaSource.values()) {
            if (!StringUtils.isNotBlank((CharSequence)mediaSource.toString())) continue;
            mediaSources.add(mediaSource);
        }
        this.setValues(mediaSources);
    }

    @Override
    protected String parseTypeToString(MediaSource type) throws Exception {
        return type.name();
    }

    @Override
    protected MediaSource parseStringToType(String string) throws Exception {
        return MediaSource.getMediaSource(string);
    }
}

