/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowYearFilter
extends AbstractCheckComboBoxTvShowUIFilter<Integer> {
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();

    public TvShowYearFilter() {
        this.checkComboBox.enableFilter((s, s2) -> String.valueOf(s).startsWith(s2.toLowerCase(Locale.ROOT)));
        this.buildYearArray();
        this.tvShowList.addPropertyChangeListener("year", evt -> SwingUtilities.invokeLater(this::buildYearArray));
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.year"));
    }

    @Override
    public String getId() {
        return "tvShowYear";
    }

    @Override
    protected String parseTypeToString(Integer type) throws Exception {
        return type.toString();
    }

    @Override
    protected Integer parseStringToType(String string) throws Exception {
        return Integer.parseInt(string);
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        return invert ^ selectedItems.contains(tvShow.getYear());
    }

    private void buildYearArray() {
        HashSet yearSet = new HashSet();
        this.tvShowList.getTvShows().forEach(tvShow -> yearSet.add(tvShow.getYear()));
        ArrayList years = new ArrayList(ListUtils.asSortedList(yearSet));
        Collections.sort(years);
        this.setValues(years);
    }
}

