/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.filenaming.TvShowExtraFanartNaming;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;

class TvShowImageExtraPanel
extends JPanel {
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private final ItemListener checkBoxListener = e -> this.checkChanges();
    private JCheckBox cbActorImages;
    private JSpinner spDownloadCountExtrafanart;
    private JCheckBox chckbxEnableExtrafanart;
    private JCheckBox chckbxExtraFanart1;
    private JCheckBox chckbxExtraFanart2;
    private JCheckBox chckbxExtraFanart3;

    TvShowImageExtraPanel() {
        this.initComponents();
        this.initDataBindings();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.chckbxExtraFanart1);
        buttonGroup.add(this.chckbxExtraFanart2);
        buttonGroup.add(this.chckbxExtraFanart3);
        this.settings.addPropertyChangeListener(evt -> {
            if ("preset".equals(evt.getPropertyName())) {
                this.buildCheckBoxes();
            }
        });
        this.buildCheckBoxes();
    }

    private void buildCheckBoxes() {
        this.clearSelection(this.chckbxExtraFanart1, this.chckbxExtraFanart2, this.chckbxExtraFanart3);
        for (TvShowExtraFanartNaming fanart : this.settings.getExtraFanartFilenames()) {
            switch (fanart) {
                case EXTRAFANART: {
                    this.chckbxExtraFanart1.setSelected(true);
                    break;
                }
                case FOLDER_EXTRAFANART: {
                    this.chckbxExtraFanart2.setSelected(true);
                    break;
                }
                case EXTRABACKDROP: {
                    this.chckbxExtraFanart3.setSelected(true);
                }
            }
        }
        this.chckbxExtraFanart1.addItemListener(this.checkBoxListener);
        this.chckbxExtraFanart2.addItemListener(this.checkBoxListener);
        this.chckbxExtraFanart3.addItemListener(this.checkBoxListener);
    }

    private void clearSelection(JCheckBox ... checkBoxes) {
        for (JCheckBox checkBox : checkBoxes) {
            checkBox.removeItemListener(this.checkBoxListener);
            checkBox.setSelected(false);
        }
    }

    private void checkChanges() {
        this.settings.clearExtraFanartFilenames();
        if (this.chckbxExtraFanart1.isSelected()) {
            this.settings.addExtraFanartFilename(TvShowExtraFanartNaming.EXTRAFANART);
        }
        if (this.chckbxExtraFanart2.isSelected()) {
            this.settings.addExtraFanartFilename(TvShowExtraFanartNaming.FOLDER_EXTRAFANART);
        }
        if (this.chckbxExtraFanart3.isSelected()) {
            this.settings.addExtraFanartFilename(TvShowExtraFanartNaming.EXTRABACKDROP);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[600lp,grow]", "[]"));
        JPanel panelOptions = new JPanel();
        panelOptions.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][grow][10lp!][][15lp!][]"));
        TmmLabel lblOptionsT = new TmmLabel(TmmResourceBundle.getString("Settings.extraartwork"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelOptions, lblOptionsT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#advanced-options-1"));
        this.add((Component)collapsiblePanel, "cell 0 0,growx,wmin 0");
        this.chckbxEnableExtrafanart = new JCheckBox(TmmResourceBundle.getString("Settings.enable.extrafanart"));
        panelOptions.add((Component)this.chckbxEnableExtrafanart, "cell 1 0 2 1");
        JPanel panel = new JPanel();
        panelOptions.add((Component)panel, "cell 2 1,growx");
        panel.setLayout((LayoutManager)new MigLayout("insets 0", "[][20lp!][]", "[][]"));
        this.chckbxExtraFanart1 = new JCheckBox("fanartX." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panel.add((Component)this.chckbxExtraFanart1, "cell 0 0");
        this.chckbxExtraFanart2 = new JCheckBox("extrafanart/fanartX." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panel.add((Component)this.chckbxExtraFanart2, "cell 2 0");
        this.chckbxExtraFanart3 = new JCheckBox("backdropX." + TmmResourceBundle.getString("Settings.artwork.extension"));
        panel.add((Component)this.chckbxExtraFanart3, "cell 0 1");
        JLabel lblDownloadCount = new JLabel(TmmResourceBundle.getString("Settings.amount.autodownload"));
        panelOptions.add((Component)lblDownloadCount, "cell 2 3");
        this.spDownloadCountExtrafanart = new JSpinner();
        this.spDownloadCountExtrafanart.setMinimumSize(new Dimension(60, 20));
        panelOptions.add((Component)this.spDownloadCountExtrafanart, "cell 2 3");
        this.cbActorImages = new JCheckBox(TmmResourceBundle.getString("Settings.actor.download"));
        panelOptions.add((Component)this.cbActorImages, "cell 1 5 2 1");
    }

    protected void initDataBindings() {
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"writeActorImages");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.cbActorImages, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSettingsBeanProperty_1 = BeanProperty.create((String)"imageExtraFanartCount");
        BeanProperty jSpinnerBeanProperty_1 = BeanProperty.create((String)"value");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_1, (Object)this.spDownloadCountExtrafanart, (Property)jSpinnerBeanProperty_1);
        autoBinding_3.bind();
        BeanProperty tvShowSettingsBeanProperty_2 = BeanProperty.create((String)"imageExtraFanart");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_2, (Object)this.chckbxEnableExtrafanart, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty jSpinnerBeanProperty = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chckbxEnableExtrafanart, (Property)jCheckBoxBeanProperty, (Object)this.spDownloadCountExtrafanart, (Property)jSpinnerBeanProperty);
        autoBinding_2.bind();
        BeanProperty jCheckBoxBeanProperty_2 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxEnableExtrafanart, (Property)jCheckBoxBeanProperty, (Object)this.chckbxExtraFanart1, (Property)jCheckBoxBeanProperty_2);
        autoBinding_9.bind();
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxEnableExtrafanart, (Property)jCheckBoxBeanProperty, (Object)this.chckbxExtraFanart2, (Property)jCheckBoxBeanProperty_2);
        autoBinding_10.bind();
    }
}

