/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.data;

import com.ubnt.data.B;
import com.ubnt.data.FirewallGroupType;
import com.ubnt.data.FirewallRule;
import com.ubnt.data.ReferClasses;
import com.ubnt.data.Sanitizable;
import com.ubnt.data.X;
import com.ubnt.model.api.systemlog.admin.activity.changes.AdminChangeKey;
import com.ubnt.model.api.systemlog.admin.activity.changes.AdminChangeSection;
import com.ubnt.repository.Q;
import com.ubnt.service.systemlog.admin.activity.changes.private;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class FirewallGroup
extends X
implements Sanitizable,
Q,
com.ubnt.service.systemlog.admin.activity.changes.X {
    public static final String \u00d5\u00d8\u00d6000 = "firewallgroup";
    @ReferClasses
    public static final List<Class<?>> superdoObject = Collections.emptyList();
    public static final String interfacefloatObject = "unifi_controller_addresses";
    public static final String \u00d4\u00d6\u00d6000 = "unifi_controller_ports-tcp";
    public static final String \u00f4\u00d8\u00d6000 = "unifi_controller_ports-udp";
    public static final String \u00f4\u00d6\u00d6000 = "unifi_talk_addresses";
    public static final String classfloatObject = "unifi_talk_ports";
    public static final String \u00d4\u00f5\u00d6000 = "guest_network";
    public static final String \u00d5\u00f4\u00d6000 = "corporate_network";
    public static final String \u00f5\u00f4\u00d6000 = "_corporate_network";
    public static final String \u00f5\u00d8\u00d6000 = "local_network";
    public static final String \u00f6\u00d6\u00d6000 = "remote_user_vpn_network";
    public static final String \u00f5\u00d6\u00d6000 = "remote_site_vpn_network";
    public static final String \u00f6\u00d8\u00d6000 = "remote_client_vpn_network";
    public static final String O\u00d6\u00d6000 = "LTE_failover_network";
    public static final String intdoObject = "wanmagic_addressv4";
    public static final String \u00f5\u00f5\u00d6000 = "local_networkv6";
    public static final String publicforObject = "guest_networkv6";
    public static final String O\u00f5\u00d6000 = "corporate_networkv6";
    public static final String o\u00d8\u00d6000 = "LTE_failover_networkv6";
    public static final String ObjectforObject = "ssl_inspection_subnets";
    public static final String \u00d5\u00f5\u00d6000 = "ssl_inspection_v6_subnets";
    public static final String classdoObject = "ssl_non_guest_subnets";
    public static final String \u00f6\u00d5\u00d6000 = "ssl_non_guest_v6_subnets";
    public static final String \u00f4\u00d5\u00d6000 = "ssl_guest_subnets";
    public static final String intfloatObject = "ssl_guest_v6_subnets";
    public static final String o\u00f4\u00d6000 = "guest_pre_allow";
    public static final String \u00d6\u00d6\u00d6000 = "guest_restricted";
    public static final String dofloatObject = "guest_allow_dns_servers";
    public static final String \u00d2\u00d6\u00d6000 = "authorized_guests";
    public static final String voidforObject = "guest_portal_address";
    public static final String floatforObject = "guest_portal_ports";
    public static final String \u00d2\u00d8\u00d6000 = "guest_portal_redirector_ports";
    public static final String \u00f4\u00f4\u00d6000 = "captive_portal_subnets";
    public static final String \u00f4\u00f5\u00d6000 = "ipsec_ports";
    public static final String \u00d2\u00f5\u00d6000 = "l2tp_port";
    public static final String o\u00d6\u00d6000 = "openvpn_tcp_ports";
    public static final String O\u00d8\u00d6000 = "openvpn_udp_ports";
    public static final String \u00d6\u00d8\u00d6000 = "wireguard_ports";
    public static final String \u00d4\u00d8\u00d6000 = "unifi_console_https_port";
    public static final String O\u00f4\u00d6000 = "ipsec_remote_subnets";
    public static final String \u00f5\u00d5\u00d6000 = "isolated_subnets";
    public static final String \u00d5\u00d6\u00d6000 = "isolated_subnetsv6";
    public static final String o\u00f5\u00d6000 = "skip_nat_subnets";
    public static final String dodoObject = "mdns_addresses_name";
    public static final String \u00f6\u00f5\u00d6000 = "mdns_ports_name";
    public static final String[] \u00d4\u00f4\u00d6000 = new String[]{"guest_pre_allow", "guest_restricted", "guest_allow_dns_servers", "authorized_guests", "guest_portal_address", "unifi_controller_addresses"};
    public static final String[] \u00d6\u00f5\u00d6000 = new String[]{"guest_portal_ports", "guest_portal_redirector_ports", "unifi_controller_ports-tcp", "unifi_controller_ports-udp"};
    public static final String \u00f6\u00f4\u00d6000 = "group_members";
    public static final String \u00d2\u00f4\u00d6000 = "group_type";
    public static B \u00d6\u00f4\u00d6000 = B.\u00f4\u00f4\u00f6000(FirewallGroup.class.getSimpleName());

    public static String name() {
        return \u00d5\u00d8\u00d6000;
    }

    @Override
    public String getCollectionName() {
        return FirewallGroup.name();
    }

    @Override
    public AdminChangeSection getSection() {
        return AdminChangeSection.FIREWALL_GROUP;
    }

    @Override
    public AdminChangeKey getChangeKey() {
        return AdminChangeKey.SECURITY;
    }

    @Override
    public Optional<private> getDepiction() {
        return private.\u00d400000("name", this.getName());
    }

    public static int mask() {
        return \u00d6\u00d40000 | \u00d2\u00d30000;
    }

    @Override
    public void sanitize(X x2) {
        \u00d6\u00f4\u00d6000.\u00d8\u00f4\u00f6000(x2);
    }

    public static String getOverlappingPortMember(List<String> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string : list) {
            int n2;
            X x2 = FirewallRule.parsePortOptions(string);
            if (x2 == null) continue;
            if (x2.containsField("port_numbered")) {
                n2 = x2.getInt("port_numbered");
                if (arrayList.contains(n2)) {
                    return string;
                }
                arrayList.add(n2);
            }
            if (!x2.containsField("port_range_start") || !x2.containsField("port_range_end")) continue;
            n2 = x2.getInt("port_range_start");
            int n3 = x2.getInt("port_range_end");
            for (int i2 = n2; i2 <= n3; ++i2) {
                if (arrayList.contains(i2)) {
                    return string;
                }
                arrayList.add(i2);
            }
        }
        return "";
    }

    public FirewallGroup setGroupType(FirewallGroupType firewallGroupType) {
        this.put(\u00d2\u00f4\u00d6000, (Object)firewallGroupType.toString());
        return this;
    }

    public boolean isIpv4AddressGroup() {
        return StringUtils.equals((CharSequence)this.getString(\u00d2\u00f4\u00d6000), (CharSequence)FirewallGroupType.\u00d200000.toString());
    }

    public boolean isIpv6AddressGroup() {
        return StringUtils.equals((CharSequence)this.getString(\u00d2\u00f4\u00d6000), (CharSequence)FirewallGroupType.o00000.toString());
    }

    public boolean isPortGroup() {
        return StringUtils.equals((CharSequence)this.getString(\u00d2\u00f4\u00d6000), (CharSequence)FirewallGroupType.\u00d500000.toString());
    }

    public boolean containsPort(String string) {
        return this.isPortGroup() && this.getStringList(\u00f6\u00f4\u00d6000).contains(string);
    }

    @Override
    public String getId() {
        return this.getString("_id");
    }

    public FirewallGroup setId(String string) {
        this.put("_id", (Object)string);
        return this;
    }

    public String getName() {
        return this.getString("name");
    }

    public FirewallGroup setName(String string) {
        this.put("name", (Object)string);
        return this;
    }

    public List<String> getMembers() {
        return this.getStringList(\u00f6\u00f4\u00d6000);
    }
}

