/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.googlecode.ipv6.IPv6Address;
import com.googlecode.ipv6.IPv6AddressRange;
import com.googlecode.ipv6.IPv6Network;
import com.ubnt.ace.P;
import com.ubnt.ace.view.O0OO;
import com.ubnt.data.B;
import com.ubnt.data.DhcpOption;
import com.ubnt.data.DpiGroup;
import com.ubnt.data.HasSettingPreference;
import com.ubnt.data.Ipv6RaPriority;
import com.ubnt.data.NetworkConfDefaults;
import com.ubnt.data.RadiusProfile;
import com.ubnt.data.ReferClasses;
import com.ubnt.data.Sanitizable;
import com.ubnt.data.Setting;
import com.ubnt.data.SettingPreference;
import com.ubnt.data.UserGroup;
import com.ubnt.data.X;
import com.ubnt.model.N.B.new;
import com.ubnt.model.N.B.o0OO;
import com.ubnt.model.N.B.oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO;
import com.ubnt.model.N.B.ooOO;
import com.ubnt.model.N.oOOO.A;
import com.ubnt.model.N.oOOO.OoOO;
import com.ubnt.model.api.global.config.network.EnabledFor;
import com.ubnt.model.api.network.configuration.NetworkGatewayDeviceType;
import com.ubnt.model.api.network.configuration.NetworkPurpose;
import com.ubnt.model.api.network.configuration.OpenVpnConfigurationStatus;
import com.ubnt.model.api.network.configuration.VpnNetworkProtocol;
import com.ubnt.model.api.network.configuration.WanDnsPreference;
import com.ubnt.model.api.systemlog.admin.activity.changes.AdminChangeKey;
import com.ubnt.model.api.systemlog.admin.activity.changes.AdminChangeSection;
import com.ubnt.model.api.uid.UidVpnType;
import com.ubnt.model.api.wan.Ipv6WanDelegationType;
import com.ubnt.model.api.wan.WanLoadBalanceType;
import com.ubnt.model.api.wan.WanNetworkGroup;
import com.ubnt.model.api.wan.WanType;
import com.ubnt.model.api.wan.WanTypeV6;
import com.ubnt.net.return.OooO;
import com.ubnt.repository.Q;
import com.ubnt.service.config.ubios.G.C;
import com.ubnt.service.referencename.D;
import com.ubnt.service.system.kA;
import com.ubnt.service.systemlog.admin.activity.changes.N;
import com.ubnt.service.systemlog.admin.activity.changes.O;
import com.ubnt.service.systemlog.admin.activity.changes.OOOo;
import com.ubnt.service.systemlog.admin.activity.changes.private;
import com.ubnt.service.vpn.String.super;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.SubnetUtils;
import org.slf4j.Logger;

public class NetworkConf
extends X
implements HasSettingPreference,
Sanitizable,
Q,
com.ubnt.service.systemlog.admin.activity.changes.X,
O,
com.ubnt.service.network.C {
    private static final Logger \u00f4\u00d3O000 = kA.donew;
    public static final String \u00d5\u00f60000 = "networkconf";
    public static final int intint = 4094;
    public static final String \u00f6\u00d2O000 = "-";
    private static final Set<String> \u00d6\u00f60000 = Set.of("ether_lighting_raw_color_hex", "ether_lighting_rounded_color_index", "ipv6_enabled", "openvpn_id", "openvpn_configuration_status", "purpose", "wireguard_id", "routing_table_id");
    private static final Map<String, D> \u00f4\u00d2O000 = Map.of("dpigroup_id", D.\u00f6o0000, "firewall_zone_id", D.oo0000, "radiusprofile_id", D.Stringnew, "usergroup_id", D.String, "remote_site_id", D.private, "wan_sla", D.\u00d800000);
    private static final Set<String> \u00f6OO000 = Set.of("openvpn_configuration", "wireguard_client_configuration_file", "sdwan_remote_site_id");
    private static final Map<String, String> \u00d5\u00d2O000 = Map.ofEntries(Map.entry("nat_outbound_ip_addresses", "wan_network_group"), Map.entry("wan_dhcp_options", "optionNumber"));
    @ReferClasses
    public static final List<Class<?>> \u00f6oO000 = ImmutableList.of(UserGroup.class, DpiGroup.class, RadiusProfile.class, DhcpOption.class);
    public static final String \u00f5\u00f80000 = "LAN";
    public static final String \u00d4\u00d2O000 = "ROUTE";
    public static final String \u00f5\u00d2O000 = "WAN_LTE_FAILOVER";
    public static final String o0O000 = "WAN_5G";
    public static final String \u00f5\u00f50000 = "WAN";
    static final String \u00d2oO000 = "MC_LAG_INTER_CHASSIS_ROUTE";
    public static final Set<String> voidnull = Set.of("ROUTE", "WAN_5G");
    public static final int \u00d4oO000 = 1;
    public static final String dofloat = "INTERNAL";
    public static final String \u00d5\u00f50000 = "LAN";
    public static final String \u00d2\u00f50000 = "LAN2";
    public static final String o\u00f50000 = "LAN3";
    public static final String floatreturn = "LAN4";
    public static final String o\u00d4O000 = "LAN5";
    public static final String O\u00d4O000 = "LAN6";
    public static final String interfacefloat = "LAN7";
    public static final String \u00f6\u00d3O000 = "LAN8";
    public static final String[] \u00d4\u00f50000 = new String[]{"LAN", "LAN2", "LAN3", "LAN4", "LAN5", "LAN6", "LAN7", "LAN8"};
    @Deprecated
    public static final String \u00d4\u00f60000 = WanNetworkGroup.WAN.toString();
    @Deprecated
    public static final String \u00f4OO000 = WanNetworkGroup.WAN2.toString();
    @Deprecated
    public static final String \u00d5OO000 = WanNetworkGroup.LTE_FAILOVER.toString();
    public static final String interfacevoid = "any";
    public static final String O\u00f60000 = "localdomain";
    public static final String \u00d6OO000 = "routing";
    @Deprecated
    public static final String superint = NetworkPurpose.VLAN_ONLY.toString();
    @Deprecated
    public static final String \u00f60O000 = NetworkPurpose.CORPORATE.toString();
    @Deprecated
    public static final String \u00d2\u00f60000 = NetworkPurpose.GUEST.toString();
    @Deprecated
    public static final String publicreturn = NetworkPurpose.WAN.toString();
    @Deprecated
    public static final String \u00d4\u00d3O000 = NetworkPurpose.REMOTE_USER_VPN.toString();
    @Deprecated
    public static final String \u00f5OO000 = NetworkPurpose.SITE_VPN.toString();
    @Deprecated
    public static final String O\u00d2O000 = NetworkPurpose.VPN_CLIENT.toString();
    public static final Set<String> \u00d6\u00d3O000 = ImmutableSet.of((Object)\u00f60O000, (Object)\u00d2\u00f60000);
    public static final int \u00f4oO000 = 86400;
    public static final int \u00d4OO000 = 86400;
    public static final int \u00f4\u00f50000 = 14400;
    public static final int classvoid = 1280;
    public static final int \u00d2\u00d3O000 = 1476;
    public static final int o\u00d2O000 = 4;
    public static final int o\u00f60000 = 3;
    @Deprecated
    public static final String o\u00f80000 = new.if.toString();
    @Deprecated
    public static final String \u00d6\u00f50000 = new.\u00f800000.toString();
    @Deprecated
    public static final String intvoid = new.\u00f500000.toString();
    @Deprecated
    public static final String \u00f5oO000 = new.\u00d3O0000.toString();
    @Deprecated
    public static final String interfaceint = new.\u00d300000.toString();
    @Deprecated
    public static final String \u00f6\u00f50000 = new.\u00d400000.toString();
    public static final String Objectif = "dhcpd_user_option_";
    public static final String dovoid = "dhcpd_user_option_%s";
    public static final String \u00d2OO000 = "Default";
    public static final String floatif = "192.168.1.1/24";
    public static final String \u00d5oO000 = "10.255.252.0/30";
    public static final String \u00f5\u00f60000 = "10.255.253.1/24";
    public static final String publicnull = "0.0.0.0/24";
    public static final int doint = 254;
    public static final String publicif = "10.255.254.0/24";
    public static final String voidif = "100.127.125.128";
    public static final String OOO000 = "100.127.125.129";
    public static final String ooO000 = "255.255.255.254";
    public static final String o\u00d3O000 = "tun900";
    public static final String supervoid = "gre1";
    public static final String intfloat = "lo";
    public static final String \u00d6oO000 = "wwan";
    public static final String floatnull = "wwan0";
    public static final String classint = "Inter-VLAN routing";
    public static final String[] \u00d20O000 = new String[]{"ip_subnet", "dhcpd_enabled", "dhcpd_start", "dhcpd_stop", "dhcpd_tftp_server", "dhcpd_wpad_url", "dhcpd_time_offset", "dhcpd_time_offset_enabled", "dhcpd_unifi_controller", "dhcpd_boot_filename", "dhcpd_boot_server", "dhcpd_boot_enabled", "dhcpd_ntp_enabled", "dhcpd_ntp_1", "dhcpd_ntp_2", "dhcpd_wins_enabled", "dhcpd_wins_1", "dhcpd_wins_2", "dhcpd_leasetime", "dhcpd_dns_enabled", "dhcpd_dns_1", "dhcpd_dns_2", "dhcpd_dns_3", "dhcpd_dns_4", "dhcpd_gateway", "dhcpd_gateway_enabled"};
    public static final int \u00f50O000 = 1;
    public static final int \u00f4\u00f80000 = 4012;
    public static final int \u00d6\u00f80000 = 4013;
    public static final int \u00d5\u00f80000 = 4014;
    public static final int \u00d4\u00f80000 = 4015;
    public static final int O\u00f80000 = 4016;
    public static final int \u00f6\u00f60000 = 4017;
    public static final int \u00f4\u00f60000 = 4018;
    public static final int Objectnull = 4040;
    public static final int \u00f40O000 = 4050;
    public static final int \u00d2\u00f80000 = 1;
    public static final int oOO000 = 2;
    public static final int O0O000 = 31536000;
    public static final int O\u00f50000 = 500000;
    public static final int \u00f6\u00f80000 = 3;
    public static final int \u00d40O000 = 86400;
    public static final int \u00d2\u00d2O000 = -86400;
    public static final int \u00d5\u00d3O000 = 1194;
    public static final int \u00d6\u00d2O000 = 127;
    private static final int superfloat = 1000000;
    private static final int OoO000 = 300000;
    private static final double \u00f5\u00d3O000 = 0.8;
    public static final int classfloat = 4500;
    public static final int O\u00d3O000 = 500;
    public static B \u00d50O000 = B.\u00f4\u00f4\u00f6000(NetworkConf.class.getSimpleName());
    public static final NetworkConf \u00d60O000 = (NetworkConf)new NetworkConf().makeImmutable();

    public static String name() {
        return \u00d5\u00f60000;
    }

    @Override
    public String getCollectionName() {
        return NetworkConf.name();
    }

    @Override
    public AdminChangeSection getSection() {
        return switch (this.getNetworkPurpose()) {
            case NetworkPurpose.CORPORATE, NetworkPurpose.GUEST -> AdminChangeSection.NETWORK_LOCAL;
            case NetworkPurpose.REMOTE_USER_VPN -> AdminChangeSection.NETWORK_VPN_SERVER;
            case NetworkPurpose.SITE_VPN -> AdminChangeSection.NETWORK_SITE_VPN;
            case NetworkPurpose.VPN_CLIENT -> AdminChangeSection.NETWORK_VPN_CLIENT;
            case NetworkPurpose.VLAN_ONLY -> AdminChangeSection.NETWORK_VLAN_ONLY;
            case NetworkPurpose.WAN, NetworkPurpose.WAN_MAGIC -> AdminChangeSection.NETWORK_WAN;
            default -> AdminChangeSection.NETWORK;
        };
    }

    @Override
    public AdminChangeKey getChangeKey() {
        return switch (this.getNetworkPurpose()) {
            case NetworkPurpose.REMOTE_USER_VPN, NetworkPurpose.SITE_VPN, NetworkPurpose.VPN_CLIENT -> AdminChangeKey.VPN;
            case NetworkPurpose.WAN, NetworkPurpose.WAN_MAGIC -> AdminChangeKey.INTERNET;
            default -> AdminChangeKey.NETWORK;
        };
    }

    @Override
    public Optional<private> getDepiction() {
        return private.\u00d400000("name", this.getName());
    }

    @Override
    public OOOo getChangeLogRule(N n2) {
        if (this.isRemoteUserOpenVpnServer() && n2.\u00d300000() != O0OO.\u00d600000) {
            return OOOo.new;
        }
        return OOOo.Object().super(\u00d6\u00f60000).publicsuper(Set.of("enabled")).\u00f400000(\u00f4\u00d2O000).\u00d6O0000(\u00f6OO000).\u00d4o0000(\u00d5\u00d2O000).supernew(this.\u00f4\u00d60000()).class();
    }

    private Map<String, Object> \u00f4\u00d60000() {
        return ImmutableMap.builder().putAll(this.O\u00d60000()).put((Object)"enabled", (Object)true).build();
    }

    private Map<String, Object> O\u00d60000() {
        if (this.isLocalSiteNetwork()) {
            return ImmutableMap.builder().putAll((Map)((Object)NetworkConfDefaults.localNetworkAutoSettings(this.isVlanEnabled()))).put((Object)"setting_preference", (Object)SettingPreference.\u00d300000.toString()).put((Object)"gateway_type", (Object)NetworkGatewayDeviceType.DEFAULT.toString()).build();
        }
        if (this.isLteWanFailoverNetwork()) {
            return NetworkConfDefaults.lteWanAutoSettings();
        }
        if (this.isWanNetwork()) {
            return ImmutableMap.builder().putAll((Map)((Object)NetworkConfDefaults.wanAutoSettings())).put((Object)"wan_pppoe_username_enabled", (Object)true).put((Object)"wan_pppoe_password_enabled", (Object)true).build();
        }
        return Map.of();
    }

    public static int mask() {
        return \u00d6\u00d40000 | \u00d2\u00d30000 | \u00d5\u00d20000;
    }

    @Override
    public synchronized NetworkConf append(String string, Object object) {
        super.append(string, object);
        return this;
    }

    public boolean isUidTrafficRulesEnabled() {
        return this.is("uid_traffic_rules_enabled", false);
    }

    public boolean isUidVpnMasqueradeEnabled() {
        return this.is("uid_vpn_masquerade_enabled", false);
    }

    public Optional<String> getSdWanRemoteSiteId() {
        return this.getOptionalString("sdwan_remote_site_id");
    }

    public NetworkConf setSdWanRemoteSiteId(String string) {
        return this.append("sdwan_remote_site_id", string);
    }

    public Optional<String> getSdWanHubSpokeConnectionId() {
        return this.getOptionalString("sdwan_hub_spoke_connection_id");
    }

    public NetworkConf setSdWanHubSpokeConnectionId(String string) {
        return this.append("sdwan_hub_spoke_connection_id", string);
    }

    public Optional<WanNetworkGroup> getSdWanHubSpokeLocalWanId() {
        return P.\u00d500000(WanNetworkGroup.class, this.getString("sdwan_hub_spoke_local_wan_id"));
    }

    public NetworkConf setSdWanHubSpokeLocalWanId(WanNetworkGroup wanNetworkGroup) {
        return this.append("sdwan_hub_spoke_local_wan_id", wanNetworkGroup.toString());
    }

    public NetworkConf setUidVpnMasqueradeEnabled(boolean bl) {
        return this.append("uid_vpn_masquerade_enabled", bl);
    }

    public NetworkConf setUidTrafficRulesEnabled(boolean bl) {
        return this.append("uid_traffic_rules_enabled", bl);
    }

    public List<String> getUidTrafficRulesAllowedIpAndHostnames() {
        return this.getStringList("uid_traffic_rules_allowed_ips_and_hostnames");
    }

    public NetworkConf setUidTrafficRulesAllowedIpsAndHostnames(List<String> list) {
        return this.append("uid_traffic_rules_allowed_ips_and_hostnames", list);
    }

    public Optional<String> getUidWorkspaceUrl() {
        return Optional.ofNullable(this.getString("uid_workspace_url"));
    }

    public NetworkConf setUidWorkspaceUrl(String string) {
        return this.append("uid_workspace_url", string);
    }

    public Optional<String> getUidPolicyName() {
        return Optional.ofNullable(this.getString("uid_policy_name"));
    }

    public NetworkConf setUidPolicyName(String string) {
        return this.append("uid_policy_name", string);
    }

    public NetworkConf setUidPolicyEnabled(boolean bl) {
        return this.append("uid_policy_enabled", bl);
    }

    public boolean isUidPolicyEnabled() {
        return this.is("uid_policy_enabled", false);
    }

    public List<String> getUidVpnCustomRouting() {
        return this.getStringList("uid_vpn_custom_routing");
    }

    public NetworkConf setUidVpnCustomRouting(List<String> list) {
        return this.append("uid_vpn_custom_routing", list);
    }

    public Optional<String> getUidVpnDefaultDnsSuffix() {
        return Optional.ofNullable(this.getString("uid_vpn_default_dns_suffix"));
    }

    public NetworkConf setUidVpnDefaultDnsSuffix(String string) {
        return this.append("uid_vpn_default_dns_suffix", string);
    }

    public boolean isUidVpnSyncPublicIp() {
        return this.is("uid_vpn_sync_public_ip", false);
    }

    public NetworkConf setUidVpnSyncPublicIp(boolean bl) {
        return this.append("uid_vpn_sync_public_ip", bl);
    }

    public Optional<Integer> getUidVpnMaxConnectionTime() {
        return this.getOptionalInt("uid_vpn_max_connection_time_seconds");
    }

    public NetworkConf setUidVpnMaxConnectionTime(Integer n2) {
        return this.append("uid_vpn_max_connection_time_seconds", n2);
    }

    public Optional<String> getFirewallZoneId() {
        return Optional.ofNullable(this.getString("firewall_zone_id"));
    }

    public NetworkConf setFirewallZoneId(String string) {
        return this.append("firewall_zone_id", string);
    }

    public Optional<String> getOptionalWanSla() {
        return Optional.ofNullable(this.getWanSla());
    }

    @Nullable
    public String getWanSla() {
        return this.getString("wan_sla");
    }

    public NetworkConf setWanSla(String string) {
        return this.append("wan_sla", string);
    }

    public Optional<Integer> getRoutingTableIdOptional() {
        return this.getOptionalInt("routing_table_id");
    }

    public int getRoutingTableId() {
        return this.getInt("routing_table_id");
    }

    public boolean hasRoutingTableId() {
        return this.getRoutingTableIdOptional().isPresent();
    }

    public NetworkConf setRoutingTableId(Integer n2) {
        return this.append("routing_table_id", n2);
    }

    public NetworkConf removeRoutingTableId() {
        this.remove("routing_table_id");
        return this;
    }

    @Override
    public synchronized NetworkConf mergeFrom(X x2) {
        super.mergeFrom(x2);
        return this;
    }

    @Override
    public void sanitize(X x2) {
        String string2 = x2.getString("purpose");
        if ((\u00f60O000.equals(string2) || \u00d2\u00f60000.equals(string2)) && !x2.containsField("networkgroup")) {
            x2.put("networkgroup", (Object)"LAN");
        }
        String[] stringArray = x2.keySet().stream().filter(string -> string.startsWith(Objectif)).collect(Collectors.toSet()).toArray(new String[0]);
        X x3 = new X();
        x3.copyAttrsIfPresent(x2, stringArray);
        x2.removeFields(stringArray);
        boolean bl = false;
        if (x2.getInt("vlan") == 4040) {
            x2.removeFields("vlan");
            bl = true;
        }
        \u00d50O000.\u00d8\u00f4\u00f6000(x2);
        x2.mergeFrom(x3);
        if (bl) {
            x2.put("vlan", (Object)4040);
        }
    }

    public static NetworkConf createLocalAreaNetworkBaseConfForSite(String string) {
        NetworkConf networkConf = new NetworkConf();
        networkConf.mergeFrom(NetworkConfDefaults.localNetworkBaseAutoSettings(false));
        return networkConf.setSiteId(string).setAutoScaleNetworkEnabled(true).setNoDelete(true).setHiddenId("LAN").setIpSubnet(floatif).setName(\u00d2OO000).setDhcpdStart(NetworkConf.getDefaultDHCPStartIP(floatif)).setDhcpdStop(NetworkConf.getDefaultDHCPStopIP(floatif)).setVlanEnabled(false);
    }

    public static NetworkConf createInterVlanRoutingNetworkConfForSite(String string) {
        return new NetworkConf().setSiteId(string).setName(classint).setPurpose(NetworkPurpose.CORPORATE).setDomainName(\u00d6OO000).setVlanEnabled(true).setVlan(4040).setIpSubnet(\u00f5\u00f60000).setNoDelete(true).setHiddenId(\u00d4\u00d2O000).setNetworkGroup("LAN").setIpV6InterfaceType(A.\u00d600000).setNat(true).setDhcpdEnabled(false).setDhcpdV6Enabled(false).setIpV6RaEnabled(false).setLteLanEnabled(true);
    }

    public static NetworkConf createVlanForMclagInterChassisLink() {
        return new NetworkConf().setPurpose(NetworkPurpose.CORPORATE).setVlanEnabled(true).setVlan(4050).setIpSubnet(\u00d5oO000).setHiddenId(\u00d2oO000).setNetworkGroup("LAN");
    }

    public static NetworkConf createLteFailoverWanNetworkConf(String string) {
        return new NetworkConf().setHiddenId(\u00f5\u00d2O000).setSettingPreference(SettingPreference.\u00d300000).setWanNetworkGroup(\u00d5OO000).setPurpose(NetworkPurpose.WAN).setName("LTE Failover WAN").setSiteId(string).setWanType(WanType.STATIC.toString()).setReportWanEvent(true).setWanLoadBalanceType(WanLoadBalanceType.FAILOVER_ONLY).setWanIp(OOO000).setWanGateway(voidif).setWanNetmask(ooO000).setWanFailOverPriority(WanNetworkGroup.LTE_FAILOVER.index());
    }

    public static NetworkConf createDefaultWan5gNetwork(String string, WanNetworkGroup wanNetworkGroup) {
        return new NetworkConf().mergeFrom(NetworkConfDefaults.wanAutoSettings()).setNoDelete(true).setWanNetworkGroup(wanNetworkGroup).setName(wanNetworkGroup.defaultDisplayName()).setSiteId(string).setWanLoadBalanceType(WanLoadBalanceType.FAILOVER_ONLY).setWanFailOverPriority(wanNetworkGroup.index()).setWan5gNetwork().setInterfaceName(floatnull);
    }

    public static NetworkConf createWanNetworkConfFromConfigNetworkWan(X x2, String string, WanNetworkGroup wanNetworkGroup) {
        return NetworkConf.createWanNetworkConfFromConfigNetworkWan(x2, string, wanNetworkGroup, false, wanNetworkGroup.index());
    }

    public static NetworkConf createWanNetworkConfFromConfigNetworkWan(X x2, String string, WanNetworkGroup wanNetworkGroup, int n2) {
        return NetworkConf.createWanNetworkConfFromConfigNetworkWan(x2, string, wanNetworkGroup, false, n2);
    }

    public static NetworkConf createWanNetworkConfFromConfigNetworkWan(X x2, String string, WanNetworkGroup wanNetworkGroup, boolean bl, int n2) {
        String string2;
        List<X> list;
        String[] stringArray;
        NetworkConf networkConf = new NetworkConf();
        if (bl || WanNetworkGroup.WAN == wanNetworkGroup) {
            networkConf.put("attr_no_delete", (Object)true);
        }
        if (WanNetworkGroup.WAN == wanNetworkGroup) {
            networkConf.put("attr_hidden_id", (Object)\u00f5\u00f50000);
        }
        networkConf.mergeFrom(NetworkConfDefaults.wanAutoSettings());
        networkConf.setSiteId(string);
        networkConf.setWanNetworkGroup(wanNetworkGroup);
        networkConf.setPurpose(NetworkPurpose.WAN);
        networkConf.setName(wanNetworkGroup.defaultDisplayName());
        networkConf.setWanFailOverPriority(n2);
        for (String string3 : stringArray = new String[]{"type", "ip", "netmask", "gateway", "username", "dns1", "dns2", "dns3", "dns4", "load_balance_type", "type_v6", "ipv6", "gateway_v6", "dslite_remote_host"}) {
            String string4 = x2.getString(string3);
            if (!StringUtils.isNotEmpty((CharSequence)string4)) continue;
            networkConf.put("wan_" + string3, (Object)string4);
        }
        for (String string3 : stringArray = new String[]{"vlan", "smartq_up_rate", "smartq_down_rate", "dhcpv6_pd_size", "load_balance_weight", "prefixlen", "egress_qos"}) {
            if (!x2.containsField(string3)) continue;
            int n3 = x2.getInt(string3);
            networkConf.put("wan_" + string3, (Object)n3);
        }
        for (String string3 : stringArray = new String[]{"vlan_enabled", "smartq_enabled"}) {
            if (!x2.containsField(string3)) continue;
            networkConf.put("wan_" + string3, (Object)x2.is(string3, false));
        }
        String string5 = x2.getString("x_password");
        if (StringUtils.isNotEmpty((CharSequence)string5)) {
            networkConf.put("x_wan_password", (Object)string5);
        }
        if (!(list = x2.getList("dhcp_options")).isEmpty()) {
            networkConf.put("wan_dhcp_options", list);
        }
        if (StringUtils.isNotEmpty((CharSequence)(string2 = x2.getString("mac_override")))) {
            networkConf.setMacOverride(string2);
            networkConf.setMacOverrideEnabled(true);
        }
        networkConf.setWanLoadBalanceType(wanNetworkGroup == WanNetworkGroup.WAN ? WanLoadBalanceType.WEIGHTED : WanLoadBalanceType.FAILOVER_ONLY);
        networkConf.setWanDnsPreference(networkConf.O\u00d80000() ? WanDnsPreference.MANUAL : WanDnsPreference.AUTO);
        networkConf.setSettingPreference(networkConf.matchesAutoWanSettings() ? SettingPreference.\u00d300000 : SettingPreference.super);
        if (wanNetworkGroup == WanNetworkGroup.WAN) {
            networkConf.setWanLoadBalanceWeight(99);
        }
        networkConf.setWanDsLiteRemoteHostAuto(x2.is("wan_dslite_remote_host_auto", false));
        return networkConf;
    }

    public boolean matchesAutoWanSettings() {
        NetworkConf networkConf = this.isLteWanFailoverNetwork() ? NetworkConfDefaults.lteWanAutoSettings() : NetworkConfDefaults.wanAutoSettings();
        NetworkConf networkConf2 = new NetworkConf();
        networkConf2.mergeFrom(networkConf);
        networkConf2.mergeFrom(this);
        networkConf2.retainFields((String[])networkConf.keySet().stream().toArray(String[]::new));
        return networkConf.equals(networkConf2);
    }

    public String getNetworkGroup() {
        if (this.isLocalSiteNetwork()) {
            return this.getString("networkgroup");
        }
        if (this.isWanNetwork()) {
            return this.getWanNetworkGroup().map(WanNetworkGroup::toString).orElse(null);
        }
        return "unknown";
    }

    public NetworkConf setNetworkGroup(String string) {
        this.put("networkgroup", (Object)string);
        return this;
    }

    public boolean hasWan1NetworkGroup() {
        return this.getWanNetworkGroup().map(wanNetworkGroup -> WanNetworkGroup.WAN == wanNetworkGroup).orElse(false);
    }

    public boolean hasWan2NetworkGroup() {
        return this.getWanNetworkGroup().map(wanNetworkGroup -> WanNetworkGroup.WAN2 == wanNetworkGroup).orElse(false);
    }

    public boolean isWanNetworkGroup() {
        return this.getWanNetworkGroup().filter(WanNetworkGroup.WAN_NETWORK_GROUPS::contains).isPresent();
    }

    public Optional<WanNetworkGroup> getWanNetworkGroup() {
        return WanNetworkGroup.ofStringValueOptional(this.getString("wan_networkgroup"));
    }

    public NetworkConf setWanNetworkGroup(WanNetworkGroup wanNetworkGroup) {
        this.put("wan_networkgroup", (Object)wanNetworkGroup.toString());
        return this;
    }

    public boolean isIpsecSeparateIkeV2Networks() {
        return this.is("ipsec_separate_ikev2_networks", false);
    }

    public NetworkConf setIpsecSeparateIkeV2Networks(boolean bl) {
        return this.append("ipsec_separate_ikev2_networks", bl);
    }

    @Deprecated
    public NetworkConf setWanNetworkGroup(String string) {
        this.put("wan_networkgroup", (Object)string);
        return this;
    }

    public boolean isWanLoadBalanceFailoverOnly() {
        return this.getWanLoadBalanceType().map(wanLoadBalanceType -> WanLoadBalanceType.FAILOVER_ONLY == wanLoadBalanceType).orElse(false);
    }

    public boolean isWanLoadBalanceWeighted() {
        return this.getWanLoadBalanceType().map(wanLoadBalanceType -> WanLoadBalanceType.WEIGHTED == wanLoadBalanceType).orElse(false);
    }

    public Optional<WanLoadBalanceType> getWanLoadBalanceType() {
        return this.getOptionalString("wan_load_balance_type").flatMap(WanLoadBalanceType::ofStringValue);
    }

    public NetworkConf setWanLoadBalanceType(WanLoadBalanceType wanLoadBalanceType) {
        this.put("wan_load_balance_type", (Object)wanLoadBalanceType.toString());
        return this;
    }

    public Optional<Integer> getWanLoadBalanceWeight() {
        return this.getOptionalInt("wan_load_balance_weight");
    }

    public NetworkConf setWanLoadBalanceWeight(int n2) {
        this.put("wan_load_balance_weight", (Object)n2);
        return this;
    }

    public Optional<Integer> getWanFailOverPriority() {
        return this.getOptionalInt("wan_failover_priority");
    }

    public NetworkConf setWanFailOverPriority(int n2) {
        this.put("wan_failover_priority", (Object)n2);
        return this;
    }

    @Deprecated
    public String getPurpose() {
        return this.getString("purpose");
    }

    public NetworkPurpose getNetworkPurpose() {
        return this.getOptionalEnum("purpose", NetworkPurpose.class).orElse(null);
    }

    public boolean hasNetworkPurpose(NetworkPurpose networkPurpose) {
        return networkPurpose != null && networkPurpose.toString().equals(this.getString("purpose"));
    }

    public boolean isDefaultLocalAreaNetwork() {
        return "LAN".equals(this.getNetworkGroup()) && "LAN".equals(this.getHiddenId().orElse(null));
    }

    public Optional<String> getMacOverride() {
        return Optional.ofNullable(this.getString("mac_override"));
    }

    public NetworkConf setMacOverride(String string) {
        this.put("mac_override", (Object)string);
        return this;
    }

    public boolean isMacOverrideEnabled() {
        return this.is("mac_override_enabled", false);
    }

    public NetworkConf setMacOverrideEnabled(boolean bl) {
        this.put("mac_override_enabled", (Object)bl);
        return this;
    }

    public int getMaskbits() {
        return OooO.o\u00d20000(this.getIpSubnet());
    }

    public int getPrefixLength() {
        if (this.isIpv6StandardPrefixLengthInterfaceType()) {
            return 64;
        }
        String string = this.getString("ipv6_subnet");
        String string2 = this.getString("type_v6", "none");
        if (StringUtils.equals((CharSequence)string2, (CharSequence)"track")) {
            return 64;
        }
        if (!com.ubnt.ace.o0OO.\u00d500000(string)) {
            return 0;
        }
        String[] stringArray = this.getString("ipv6_subnet").split("/");
        int n2 = Integer.parseInt(stringArray[1]);
        return n2;
    }

    public String getIpv4() {
        String string = this.getString("ip_subnet");
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        String[] stringArray = string.split("/");
        return stringArray[0];
    }

    public String getIpv6() {
        String string = this.getString("ipv6_subnet");
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        String[] stringArray = string.split("/");
        return stringArray[0];
    }

    public int getLocalPort() {
        return this.getInt("local_port");
    }

    public NetworkConf setLocalPort(int n2) {
        this.put("local_port", (Object)n2);
        return this;
    }

    public Optional<Integer> getUidPublicGatewayPort() {
        return this.getOptionalInt("uid_public_gateway_port");
    }

    public NetworkConf setUidPublicGatewayPort(int n2) {
        return this.append("uid_public_gateway_port", n2);
    }

    public NetworkConf setIpSubnet(String string) {
        this.put("ip_subnet", (Object)string);
        return this;
    }

    public String getIpSubnet() {
        return this.getString("ip_subnet", floatif);
    }

    public String getIpSubnetOrNull() {
        return this.getString("ip_subnet");
    }

    public String getSubnet() {
        return this.\u00f8\u00d50000(this.getSubnetInfo());
    }

    public SubnetUtils.SubnetInfo getSubnetInfo() {
        SubnetUtils subnetUtils = new SubnetUtils(this.getString("ip_subnet", floatif));
        return subnetUtils.getInfo();
    }

    public Optional<String> getIpV6Subnet() {
        return Optional.ofNullable(this.getString("ipv6_subnet"));
    }

    public NetworkConf setIpV6Subnet(String string) {
        this.put("ipv6_subnet", (Object)string);
        return this;
    }

    public String getSubnetv6() {
        String string = this.getString("ipv6_subnet");
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        IPv6Network iPv6Network = IPv6Network.fromString((String)string);
        String string2 = iPv6Network.getFirst().toString();
        String string3 = Integer.toString(iPv6Network.getNetmask().asPrefixLength());
        return string2 + "/" + string3;
    }

    public String getGatewayDeviceMac() {
        return this.getString("gateway_device", "");
    }

    public NetworkConf setGatewayDeviceMac(String string) {
        this.put("gateway_device", (Object)string);
        return this;
    }

    public boolean containsIp(String string) {
        String string2 = this.getString("ip_subnet");
        if (StringUtils.isBlank((CharSequence)string2)) {
            return false;
        }
        SubnetUtils subnetUtils = new SubnetUtils(string2);
        SubnetUtils.SubnetInfo subnetInfo = subnetUtils.getInfo();
        try {
            return subnetInfo.isInRange(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean containsIpv6(String string) {
        String string2 = this.getString("ipv6_subnet");
        if (!com.ubnt.ace.o0OO.\u00d500000(string2)) {
            return false;
        }
        IPv6Network iPv6Network = IPv6Network.fromString((String)string2);
        IPv6AddressRange iPv6AddressRange = IPv6AddressRange.fromFirstAndLast((IPv6Address)iPv6Network.getFirst(), (IPv6Address)iPv6Network.getLast());
        try {
            return iPv6AddressRange.contains(IPv6Address.fromString((String)string));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean containsIpOrIpv6(String string) {
        return this.containsIp(string) || this.containsIpv6(string);
    }

    public static String getDefaultDHCPStartIP(SubnetUtils.SubnetInfo subnetInfo) {
        int n2 = Integer.bitCount(subnetInfo.asInteger(subnetInfo.getNetmask()));
        int n3 = n2 < 25 ? (25 - n2) * 5 : 1;
        int n4 = subnetInfo.asInteger(subnetInfo.getLowAddress());
        int n5 = n4 + n3;
        int[] nArray = new int[4];
        for (int i2 = 3; i2 >= 0; --i2) {
            int n6 = i2;
            nArray[n6] = nArray[n6] | n5 >>> 8 * (3 - i2) & 0xFF;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            stringBuilder.append(nArray[i3]);
            if (i3 == nArray.length - 1) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    public static String getDefaultDHCPStartIP(String string) {
        SubnetUtils subnetUtils = new SubnetUtils(string);
        subnetUtils.setInclusiveHostCount(false);
        SubnetUtils.SubnetInfo subnetInfo = subnetUtils.getInfo();
        return NetworkConf.getDefaultDHCPStartIP(subnetInfo);
    }

    public static String getDefaultDHCPStopIP(String string) {
        SubnetUtils subnetUtils = new SubnetUtils(string);
        subnetUtils.setInclusiveHostCount(false);
        return subnetUtils.getInfo().getHighAddress();
    }

    public Optional<VpnNetworkProtocol> getVpnProtocol() {
        return P.\u00d500000(VpnNetworkProtocol.class, this.getString("vpn_protocol"));
    }

    public NetworkConf setVpnProtocol(VpnNetworkProtocol vpnNetworkProtocol) {
        this.put("vpn_protocol", (Object)vpnNetworkProtocol.toString());
        return this;
    }

    public NetworkConf setPurpose(@NotNull NetworkPurpose networkPurpose) {
        this.put("purpose", (Object)networkPurpose.toString());
        return this;
    }

    public boolean isLocalSiteNetwork() {
        return this.isCorpNetwork() || this.isGuestNetwork();
    }

    public boolean isCorpNetwork() {
        return this.hasNetworkPurpose(NetworkPurpose.CORPORATE);
    }

    public boolean isGuestNetwork() {
        return this.hasNetworkPurpose(NetworkPurpose.GUEST);
    }

    public boolean isLoopback() {
        return intfloat.equals(this.getInterfaceName());
    }

    public String getGatewayDeviceType() {
        return this.getString("gateway_type", NetworkGatewayDeviceType.DEFAULT.toString());
    }

    public boolean isLayer3Network() {
        return this.isLocalSiteNetwork() && NetworkGatewayDeviceType.SWITCH.toString().equals(this.getGatewayDeviceType());
    }

    public boolean isInterVlanRoutingNetwork() {
        return this.getHiddenId().map(string -> StringUtils.equals((CharSequence)string, (CharSequence)\u00d4\u00d2O000)).orElse(false);
    }

    public NetworkConf setLayer3Network(boolean bl) {
        NetworkGatewayDeviceType networkGatewayDeviceType = bl ? NetworkGatewayDeviceType.SWITCH : NetworkGatewayDeviceType.DEFAULT;
        this.put("gateway_type", (Object)networkGatewayDeviceType.toString());
        return this;
    }

    public boolean isSiteToSiteVpnNetwork() {
        return this.hasNetworkPurpose(NetworkPurpose.SITE_VPN);
    }

    public boolean isSiteToSiteVpnWithTrafficRoutesSupport() {
        return this.isSiteOpenVpnNetwork() || this.isSiteIpsecVpnNetwork() && this.isIpsecDynamicRouting() || this.isSdWanTunnelNetwork();
    }

    public boolean isSiteAutoVpnNetwork() {
        return this.isSiteToSiteVpnNetwork() && new.if.equals((Object)this.getVpnType().orElse(new.if));
    }

    public boolean isSiteManualVpnNetwork() {
        return this.isSiteToSiteVpnNetwork() && !new.if.equals((Object)this.getVpnType().orElse(new.if));
    }

    public boolean isSiteIpsecVpnNetwork() {
        return this.isSiteToSiteVpnNetwork() && this.hasVpnType(new.\u00f800000);
    }

    public boolean isPolicyBasedIpsecVpn() {
        return this.isSiteIpsecVpnNetwork() && !this.isIpsecDynamicRouting();
    }

    public boolean isSdWanHubSpokeTunnelNetwork() {
        return this.isSiteToSiteVpnNetwork() && this.hasVpnType(new.\u00d800000);
    }

    public boolean isSdWanMeshTunnelNetwork() {
        return this.isSiteToSiteVpnNetwork() && this.hasVpnType(new.return);
    }

    public boolean isSdWanTunnelNetwork() {
        return this.isSiteToSiteVpnNetwork() && (this.isSdWanMeshTunnelNetwork() || this.isSdWanHubSpokeTunnelNetwork());
    }

    public boolean isSiteOpenVpnNetwork() {
        return this.isSiteToSiteVpnNetwork() && this.hasVpnType(new.\u00f500000);
    }

    public boolean isVpnClientNetwork() {
        return this.hasNetworkPurpose(NetworkPurpose.VPN_CLIENT);
    }

    public boolean isPptpClientNetwork() {
        return this.isVpnClientNetwork() && this.hasVpnType(new.\u00d3O0000);
    }

    public boolean isOpenVpnClientNetwork() {
        return this.isVpnClientNetwork() && this.hasVpnType(new.\u00d4O0000);
    }

    public boolean isAnyOpenVpn() {
        return this.isOpenVpnServer() || this.isOpenVpnClientNetwork() || this.isSiteOpenVpnNetwork();
    }

    public boolean isRemoteUserWireguardVpnServer() {
        return this.isRemoteUserVpnNetwork() && this.hasVpnType(new.new);
    }

    public boolean isWireguardClient() {
        return this.isVpnClientNetwork() && this.hasVpnType(new.OO0000);
    }

    public boolean isWireguardClientOrServer() {
        return this.isWireguardVpnServer() || this.isWireguardClient();
    }

    public boolean isRemoteUserVpnNetwork() {
        return this.hasNetworkPurpose(NetworkPurpose.REMOTE_USER_VPN);
    }

    public boolean isRemoteUserL2tpVpnNetwork() {
        return this.isRemoteUserVpnNetwork() && this.hasVpnType(new.\u00d400000);
    }

    public boolean isRemoteUserPptpVpnNetwork() {
        return this.isRemoteUserVpnNetwork() && this.hasVpnType(new.\u00d300000);
    }

    public boolean isAnyVpn() {
        return this.getVpnType().isPresent();
    }

    public boolean useRadiusProfile() {
        return this.isRemoteUserPptpVpnNetwork() || this.isRemoteUserL2tpVpnNetwork() || this.isRemoteUserOpenVpnServer();
    }

    public boolean isRequireMsChapV2() {
        return this.is("require_mschapv2", false);
    }

    public NetworkConf setRequireMsChapV2(Object object) {
        this.put("require_mschapv2", object);
        return this;
    }

    public boolean isRemoteUserOpenVpnServer() {
        return \u00d4\u00d3O000.equals(this.getString("purpose")) && new.\u00f400000.toString().equals(this.getString("vpn_type"));
    }

    public boolean isUidVpnServer() {
        return this.hasNetworkPurpose(NetworkPurpose.REMOTE_USER_VPN) && this.hasVpnType(new.\u00d5O0000);
    }

    public boolean isUidOpenVpnServer() {
        return this.isUidVpnServer() && this.getUidVpnType().map(uidVpnType -> uidVpnType == UidVpnType.OPENVPN).orElse(true) != false;
    }

    public boolean isUidWireguardVpnServer() {
        return this.isUidVpnServer() && this.getUidVpnType().map(uidVpnType -> uidVpnType == UidVpnType.WIREGUARD).orElse(false) != false;
    }

    public boolean isWireguardVpnServer() {
        return this.isRemoteUserWireguardVpnServer() || this.isUidWireguardVpnServer();
    }

    public boolean isOpenVpnServer() {
        return this.isRemoteUserOpenVpnServer() || this.isUidOpenVpnServer();
    }

    public boolean hasPrivateIpv4Address() {
        String string = this.getIpv4();
        return StringUtils.isNotEmpty((CharSequence)string) && OooO.\u00d6\u00d20000(string);
    }

    public NetworkConf setVpnType(new new_) {
        this.put("vpn_type", (Object)new_.toString());
        return this;
    }

    public boolean isCustomInterfaceMtuEnabled() {
        return this.is("interface_mtu_enabled", false);
    }

    public NetworkConf setInterfaceMtuEnabled(boolean bl) {
        return this.append("interface_mtu_enabled", bl);
    }

    public Optional<Integer> getInterfaceMtu() {
        return this.getOptionalInt("interface_mtu");
    }

    public NetworkConf setInterfaceMtu(Integer n2) {
        return this.append("interface_mtu", n2);
    }

    public Optional<String> getIpsecKeyExchange() {
        return Optional.ofNullable(this.getString("ipsec_key_exchange"));
    }

    @Deprecated
    public Optional<oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO> getIpsecEncryption() {
        return P.\u00d500000(oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.class, this.getString("ipsec_encryption"));
    }

    @Deprecated
    public NetworkConf setIpsecEncryption(oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO2) {
        return this.append("ipsec_encryption", oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO2.toString());
    }

    public Optional<oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO> getIpsecIkeEncryption() {
        return P.\u00d500000(oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.class, this.getString("ipsec_ike_encryption"));
    }

    public NetworkConf setIpsecIkeEncryption(oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO2) {
        return this.append("ipsec_ike_encryption", oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO2.toString());
    }

    @Deprecated
    public Optional<o0OO> getIpsecHash() {
        return P.\u00d500000(o0OO.class, this.getString("ipsec_hash"));
    }

    @Deprecated
    public NetworkConf setIpsecHash(o0OO o0OO2) {
        return this.append("ipsec_hash", (Object)o0OO2);
    }

    public Optional<o0OO> getIpsecIkeHash() {
        return P.\u00d500000(o0OO.class, this.getString("ipsec_ike_hash"));
    }

    public NetworkConf setIpsecIkeHash(o0OO o0OO2) {
        return this.append("ipsec_ike_hash", o0OO2.toString());
    }

    public Optional<Integer> getIpsecIkeLifetime() {
        return this.getOptionalInt("ipsec_ike_lifetime");
    }

    public NetworkConf setIpsecIkeLifetime(int n2) {
        return this.append("ipsec_ike_lifetime", n2);
    }

    public Optional<String> getIpsecPreSharedKey() {
        return this.getOptionalString("x_ipsec_pre_shared_key").filter(StringUtils::isNotEmpty);
    }

    public Optional<Integer> getIpsecEspDhGroup() {
        return this.getOptionalInt("ipsec_esp_dh_group");
    }

    public NetworkConf setIpsecEspDhGroup(int n2) {
        return this.append("ipsec_esp_dh_group", n2);
    }

    public Optional<oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO> getIpsecEspEncryption() {
        return P.\u00d500000(oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.class, this.getString("ipsec_esp_encryption"));
    }

    public NetworkConf setIpsecEspEncryption(oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO2) {
        return this.append("ipsec_esp_encryption", oOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO2.toString());
    }

    public Optional<o0OO> getIpsecEspHash() {
        return P.\u00d500000(o0OO.class, this.getString("ipsec_esp_hash"));
    }

    public NetworkConf setIpsecEspHash(o0OO o0OO2) {
        return this.append("ipsec_esp_hash", o0OO2.toString());
    }

    public Optional<Integer> getIpsecEspLifetime() {
        return this.getOptionalInt("ipsec_esp_lifetime");
    }

    public NetworkConf setIpsecEspLifetime(int n2) {
        return this.append("ipsec_esp_lifetime", n2);
    }

    public Optional<Integer> getIpsecIkeDhGroup() {
        return this.getOptionalInt("ipsec_ike_dh_group");
    }

    public NetworkConf setIpsecIkeDhGroup(int n2) {
        return this.append("ipsec_ike_dh_group", n2);
    }

    public NetworkConf setIpsecPreSharedKey(String string) {
        this.put("x_ipsec_pre_shared_key", (Object)string);
        return this;
    }

    public NetworkConf setIpsecKeyExchange(String string) {
        this.put("ipsec_key_exchange", (Object)string);
        return this;
    }

    public boolean isIpsecLocalIdentifierEnabled() {
        return this.is("ipsec_local_identifier_enabled", false);
    }

    public NetworkConf setIpsecLocalIdentifierEnabled(boolean bl) {
        return this.append("ipsec_local_identifier_enabled", bl);
    }

    public Optional<String> getIpsecLocalIdentifier() {
        return Optional.ofNullable(this.getString("ipsec_local_identifier"));
    }

    public NetworkConf setIpsecLocalIdentifier(String string) {
        return this.append("ipsec_local_identifier", string);
    }

    public boolean isIpsecPerfectForwardSecrecy() {
        return this.is("ipsec_pfs", false);
    }

    public NetworkConf setIpsecPerfectForwardSecrecy(boolean bl) {
        return this.append("ipsec_pfs", bl);
    }

    public boolean isIpsecRemoteIdentifierEnabled() {
        return this.is("ipsec_remote_identifier_enabled", false);
    }

    public NetworkConf setIpsecRemoteIdentifierEnabled(boolean bl) {
        return this.append("ipsec_remote_identifier_enabled", bl);
    }

    public Optional<String> getIpsecRemoteIdentifier() {
        return Optional.ofNullable(this.getString("ipsec_remote_identifier"));
    }

    public NetworkConf setIpsecRemoteIdentifier(String string) {
        return this.append("ipsec_remote_identifier", string);
    }

    public boolean isIpsecTunnelIpEnabled() {
        return this.is("ipsec_tunnel_ip_enabled", false);
    }

    public NetworkConf setIpsecTunnelIpEnabled(boolean bl) {
        return this.append("ipsec_tunnel_ip_enabled", bl);
    }

    public Optional<String> getIpsecTunnelIp() {
        return this.getOptionalString("ipsec_tunnel_ip");
    }

    public NetworkConf setIpsecTunnelIp(String string) {
        return this.append("ipsec_tunnel_ip", string);
    }

    public List<String> getRemoteVpnSubnets() {
        return this.getStringList("remote_vpn_subnets");
    }

    public NetworkConf setRemoteVpnSubnets(List<String> list) {
        this.put("remote_vpn_subnets", list);
        return this;
    }

    public boolean isRemoteVpnDynamicSubnetsEnabled() {
        return this.is("remote_vpn_dynamic_subnets_enabled", false);
    }

    public NetworkConf setRemoteVpnDynamicSubnetsEnabled(boolean bl) {
        return this.append("remote_vpn_dynamic_subnets_enabled", bl);
    }

    public boolean isVlanEnabled() {
        return this.is("vlan_enabled", false);
    }

    public NetworkConf setVlanEnabled(boolean bl) {
        this.put("vlan_enabled", (Object)bl);
        return this;
    }

    public boolean isVlanOnlyNetwork() {
        return superint.equals(this.getString("purpose"));
    }

    public boolean isWanNetwork() {
        return publicreturn.equals(this.getString("purpose"));
    }

    public boolean isRouteNetwork() {
        return \u00d4\u00d2O000.equals(this.getString("attr_hidden_id"));
    }

    public boolean isLteWanFailoverNetwork() {
        return publicreturn.equals(this.getString("purpose")) && \u00f5\u00d2O000.equals(this.getString("attr_hidden_id"));
    }

    public boolean isDsLiteNetwork() {
        return this.getWanType().flatMap(WanType::of).filter(wanType -> WanType.DSLITE == wanType).isPresent();
    }

    public boolean isLteLanEnabled() {
        return this.is("lte_lan_enabled", false);
    }

    public NetworkConf setLteLanEnabled(boolean bl) {
        this.put("lte_lan_enabled", (Object)bl);
        return this;
    }

    public boolean couldBeNativeNetwork() {
        return this.isLocalSiteLayer2Network() && !this.isInterVlanRoutingNetwork();
    }

    public boolean isLocalSiteLayer2Network() {
        return this.isLocalSiteNetwork() || this.isVlanOnlyNetwork();
    }

    public boolean isDefaultLocalSiteLayer2Network() {
        return this.isLocalSiteNetwork() && "LAN".equals(this.getString("attr_hidden_id"));
    }

    public boolean inNetworkGroup(String string) {
        return StringUtils.equals((CharSequence)this.getNetworkGroup(), (CharSequence)string);
    }

    public static int getNetworkGroupInternalVlan(String string) {
        if (string.equals("LAN")) {
            return 1;
        }
        if (string.equals(\u00d2\u00f50000)) {
            return 4012;
        }
        if (string.equals(o\u00f50000)) {
            return 4013;
        }
        if (string.equals(floatreturn)) {
            return 4014;
        }
        if (string.equals(o\u00d4O000)) {
            return 4015;
        }
        if (string.equals(O\u00d4O000)) {
            return 4016;
        }
        if (string.equals(interfacefloat)) {
            return 4017;
        }
        if (string.equals(\u00f6\u00d3O000)) {
            return 4018;
        }
        return 1;
    }

    public NetworkConf setVlan(int n2) {
        this.put("vlan", (Object)n2);
        return this;
    }

    public int getVlan() {
        int n2 = this.getInt("vlan", 1);
        if (this.isVlanEnabled() && n2 > 1 && n2 < 4094) {
            return n2;
        }
        String string = this.getString("networkgroup", "unknown");
        return NetworkConf.getNetworkGroupInternalVlan(string);
    }

    public NetworkConf toConfigNetworkWan() {
        NetworkConf networkConf = new NetworkConf();
        for (String string : this.keySet()) {
            if (string.startsWith("wan_")) {
                networkConf.put(string.substring(4), this.get(string, null));
                continue;
            }
            networkConf.put(string, this.get(string, null));
        }
        String string = networkConf.getString("x_wan_password");
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            networkConf.put("x_password", (Object)string);
        }
        if (networkConf.containsField("dhcpv6_pd_size")) {
            networkConf.put("dhcpv6_pd_size", (Object)networkConf.getInt("dhcpv6_pd_size"));
        }
        if (this.isLteWanFailoverNetwork()) {
            networkConf.put("type", (Object)"lte-failover");
        }
        return networkConf;
    }

    public int getPriority() {
        int n2 = this.getInt("priority", -1);
        return n2;
    }

    public NetworkConf setLanTunnelIpAddress(String string) {
        if (this.isLanTunnelWanNetwork() && com.ubnt.ace.o0OO.\u00f5\u00f40000(string)) {
            this.put("ip_subnet", (Object)(string + "/30"));
        }
        return this;
    }

    public String getLTETunnelAddrCidr() {
        if (!this.isLanTunnelWanNetwork()) {
            return null;
        }
        return OooO.private(this.getString("wan_ip"), this.getString("wan_netmask"));
    }

    public static boolean isIpsecInUse(List<NetworkConf> list) {
        for (NetworkConf networkConf : list) {
            if (!networkConf.isSiteAutoVpnNetwork() && !networkConf.isSiteIpsecVpnNetwork() && !networkConf.isRemoteUserL2tpVpnNetwork()) continue;
            return true;
        }
        return false;
    }

    public void populateSmartQueueFromProviderCapabilities(Setting setting) {
        if (this.containsField("wan_smartq_enabled")) {
            \u00f4\u00d3O000.warn("Not populating smart queues for network (name={}) since setting has been touched.", (Object)this.getString("name"));
            return;
        }
        if (!setting.containsField("upload") || !setting.containsField("download")) {
            \u00f4\u00d3O000.warn("Not populating smart queues for network (name={}) since provider capabilities is missing upload or download field: {}", (Object)this.getString("name"), (Object)setting);
            return;
        }
        int n2 = Math.min(1000000, setting.getInt("upload"));
        int n3 = Math.min(1000000, setting.getInt("download"));
        if (n2 > 300000 || n3 > 300000) {
            \u00f4\u00d3O000.warn("Not populating smart queues for network (name={}) since upload ({}) or download ({}) rate is too high", new Object[]{this.getString("name"), n2, n3});
            return;
        }
        this.put("wan_smartq_enabled", (Object)true);
        this.put("wan_smartq_up_rate", (Object)this.getInt("wan_smartq_up_rate", (int)Math.ceil((double)n2 * 0.8)));
        this.put("wan_smartq_down_rate", (Object)this.getInt("wan_smartq_down_rate", (int)Math.ceil((double)n3 * 0.8)));
        \u00f4\u00d3O000.warn("Auto populating smart queues for network (name={}, upload rate={}, download rate={})", new Object[]{this.getString("name"), this.getInt("wan_smartq_up_rate"), this.getInt("wan_smartq_down_rate")});
    }

    public String getName() {
        return this.getString("name", "");
    }

    public NetworkConf setName(String string) {
        this.put("name", (Object)string);
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.is("enabled", true);
    }

    public NetworkConf setEnabled(boolean bl) {
        this.put("enabled", (Object)bl);
        return this;
    }

    public Optional<SettingPreference> getSettingPreference() {
        return P.\u00d500000(SettingPreference.class, this.getString("setting_preference"));
    }

    public Optional<SettingPreference> getIpv6SettingPreference() {
        return P.\u00d500000(SettingPreference.class, this.getString("ipv6_setting_preference"));
    }

    public NetworkConf setIpv6SettingPreference(SettingPreference settingPreference) {
        this.put("ipv6_setting_preference", (Object)settingPreference.getValue());
        return this;
    }

    public NetworkConf setSettingPreference(SettingPreference settingPreference) {
        this.put("setting_preference", (Object)settingPreference.getValue());
        return this;
    }

    @Override
    public boolean hasAutoSettingPreference() {
        return this.getSettingPreference().orElse(SettingPreference.super) == SettingPreference.\u00d300000;
    }

    @Override
    public boolean hasManualSettingPreference() {
        return this.getSettingPreference().orElse(SettingPreference.super) == SettingPreference.super;
    }

    public boolean hasIpv6AutoSettingPreference() {
        return this.getIpv6SettingPreference().orElse(SettingPreference.super) == SettingPreference.\u00d300000;
    }

    public boolean hasIpv6ManualSettingPreference() {
        return this.getIpv6SettingPreference().orElse(SettingPreference.super) == SettingPreference.super;
    }

    public List<String> getRemoteSubnets() {
        if (this.isSiteAutoVpnNetwork()) {
            return this.getRemoteSiteSubnets();
        }
        if (this.isSiteManualVpnNetwork() || this.isVpnClientNetwork() || this.isSdWanMeshTunnelNetwork()) {
            return this.getRemoteVpnSubnets();
        }
        return Collections.emptyList();
    }

    public List<String> getRemoteSiteSubnets() {
        return this.getStringList("remote_site_subnets");
    }

    public NetworkConf setRemoteSiteSubnets(List<String> list) {
        return this.append("remote_site_subnets", list);
    }

    public boolean isAutoScaleNetworkEnabled() {
        return this.is("auto_scale_enabled", false);
    }

    public NetworkConf setAutoScaleNetworkEnabled(boolean bl) {
        this.put("auto_scale_enabled", (Object)bl);
        return this;
    }

    @Override
    public String getId() {
        return this.getString("_id");
    }

    public NetworkConf setId(String string) {
        this.put("_id", (Object)string);
        return this;
    }

    public Optional<String> getHiddenId() {
        return Optional.ofNullable(this.getString("attr_hidden_id"));
    }

    public NetworkConf setHiddenId(String string) {
        this.put("attr_hidden_id", (Object)string);
        return this;
    }

    public NetworkConf setNoDelete(boolean bl) {
        this.put("attr_no_delete", (Object)bl);
        return this;
    }

    public NetworkConf setNoEdit(boolean bl) {
        this.put("attr_no_edit", (Object)bl);
        return this;
    }

    public boolean isNoDeletable() {
        return this.is("attr_no_delete", false);
    }

    public String getSiteId() {
        return this.getString("site_id");
    }

    public NetworkConf setSiteId(String string) {
        this.put("site_id", (Object)string);
        return this;
    }

    public Optional<String> getInterfaceNameOptional() {
        return this.getOptionalString("ifname");
    }

    public String getInterfaceName() {
        return this.getString("ifname");
    }

    public NetworkConf setInterfaceName(String string) {
        this.put("ifname", (Object)string);
        return this;
    }

    public List<X> getWanDhcpOptions() {
        return this.getList("wan_dhcp_options", Collections.emptyList());
    }

    public NetworkConf setWanDhcpOptions(List<X> list) {
        this.put("wan_dhcp_options", list);
        return this;
    }

    public Optional<String> getWanIp() {
        return Optional.ofNullable(this.getString("wan_ip"));
    }

    public NetworkConf setWanIp(String string) {
        this.put("wan_ip", (Object)string);
        return this;
    }

    public List<String> getWanIpAliases() {
        return this.getStringList("wan_ip_aliases");
    }

    public NetworkConf setWanIpAliases(List<String> list) {
        this.put("wan_ip_aliases", list);
        return this;
    }

    public boolean supportsWanIpAliases() {
        return this.getWanType().map(string -> StringUtils.equalsAny((CharSequence)string, (CharSequence[])new CharSequence[]{WanType.STATIC.toString(), WanType.PPPOE.toString()})).orElse(false);
    }

    public boolean supportsOspf() {
        return this.isLocalSiteNetwork() || this.isWanNetwork() && this.isStaticWan() || this.isOpenVpnServer() || this.isOpenVpnClientNetwork() || this.isWireguardClientOrServer() || this.isSiteIpsecVpnNetwork() && this.isIpsecTunnelIpEnabled();
    }

    public Optional<String> getWanGateway() {
        return Optional.ofNullable(this.getString("wan_gateway"));
    }

    public NetworkConf setWanGateway(String string) {
        this.put("wan_gateway", (Object)string);
        return this;
    }

    public Optional<String> getWanNetmask() {
        return this.getOptionalString("wan_netmask");
    }

    public NetworkConf setWanNetmask(String string) {
        this.put("wan_netmask", (Object)string);
        return this;
    }

    public com.ubnt.model.K.A getWanProviderCapabilities() {
        return com.ubnt.model.K.A.\u00d500000(this.getX("wan_provider_capabilities", X.superObject));
    }

    public NetworkConf setWanProviderCapabilities(com.ubnt.model.K.A a2) {
        this.put("wan_provider_capabilities", (Object)a2.\u00d200000());
        return this;
    }

    public List<X> getLegacyNatOutboundIpAddresses() {
        return this.getList("nat_outbound_ip_addresses");
    }

    public List<com.ubnt.model.K.ooOO> getNatOutboundIpAddresses() {
        return this.getLegacyNatOutboundIpAddresses().stream().map(com.ubnt.model.K.ooOO::if).toList();
    }

    public NetworkConf setNatOutboundIpAddresses(List<com.ubnt.model.K.ooOO> list) {
        List list2 = list.stream().map(com.ubnt.model.K.ooOO::\u00f400000).collect(Collectors.toList());
        this.put("nat_outbound_ip_addresses", list2);
        return this;
    }

    public Optional<String> getWanType() {
        return Optional.ofNullable(this.getString("wan_type"));
    }

    public Optional<WanType> getWanTypeOptional() {
        return this.getWanType().flatMap(WanType::of);
    }

    public NetworkConf setWanType(String string) {
        this.put("wan_type", (Object)string);
        return this;
    }

    public NetworkConf setWanType(WanType wanType) {
        this.put("wan_type", (Object)wanType.toString());
        return this;
    }

    public boolean hasWanType(WanType wanType) {
        return this.getWanType().filter(string -> string.equals(wanType.toString())).isPresent();
    }

    public boolean isWanTypeV6(WanTypeV6 wanTypeV6) {
        return this.getWanTypeV6().filter(string -> string.equals(wanTypeV6.toString())).isPresent();
    }

    public boolean isIpv6WanDelegationType(Ipv6WanDelegationType ipv6WanDelegationType) {
        return this.getIpv6WanDelegationTypeOptional().filter(ipv6WanDelegationType2 -> ipv6WanDelegationType2 == ipv6WanDelegationType).isPresent();
    }

    public boolean isStaticWan() {
        return this.getWanType().map(string -> StringUtils.equals((CharSequence)string, (CharSequence)WanType.STATIC.toString())).orElse(false);
    }

    public Optional<String> getWanTypeV6() {
        return Optional.ofNullable(this.getString("wan_type_v6"));
    }

    public Optional<WanTypeV6> getWanTypeV6Optional() {
        return this.getWanTypeV6().flatMap(WanTypeV6::ofStringValueOptional);
    }

    public NetworkConf setWanTypeV6(WanTypeV6 wanTypeV6) {
        this.put("wan_type_v6", (Object)wanTypeV6);
        return this;
    }

    private Optional<String> \u00d6\u00d50000() {
        return Optional.ofNullable(this.getString("ipv6_wan_delegation_type"));
    }

    public Optional<Ipv6WanDelegationType> getIpv6WanDelegationTypeOptional() {
        return this.\u00d6\u00d50000().flatMap(Ipv6WanDelegationType::ofStringValueOptional);
    }

    public NetworkConf setIpv6WanDelegationType(Ipv6WanDelegationType ipv6WanDelegationType) {
        this.put("ipv6_wan_delegation_type", (Object)ipv6WanDelegationType);
        return this;
    }

    public Optional<String> getSingleNetworkLan() {
        return Optional.ofNullable(this.getString("single_network_lan"));
    }

    public Optional<String> getWanDsLiteRemoteHost() {
        return Optional.ofNullable(this.getString("wan_dslite_remote_host"));
    }

    public boolean getWanDsLiteRemoteHostAuto() {
        return this.is("wan_dslite_remote_host_auto", false);
    }

    public NetworkConf setWanDsLiteRemoteHost(String string) {
        this.put("wan_dslite_remote_host", (Object)string);
        return this;
    }

    public NetworkConf setWanDsLiteRemoteHostAuto(boolean bl) {
        this.put("wan_dslite_remote_host_auto", (Object)bl);
        return this;
    }

    public Optional<String> getIpsecInterface() {
        return Optional.ofNullable(this.getString("ipsec_interface"));
    }

    public NetworkConf setIpsecInterface(String string) {
        this.put("ipsec_interface", (Object)string);
        return this;
    }

    public boolean isIpsecDynamicRouting() {
        return this.is("ipsec_dynamic_routing", false);
    }

    public NetworkConf setIpsecDynamicRouting(boolean bl) {
        this.put("ipsec_dynamic_routing", (Object)bl);
        return this;
    }

    public Optional<String> getIpsecLocalIp() {
        return Optional.ofNullable(this.getString("ipsec_local_ip"));
    }

    public NetworkConf setIpsecLocalIp(String string) {
        this.put("ipsec_local_ip", (Object)string);
        return this;
    }

    @Deprecated
    public boolean isVpnType(new new_) {
        return this.hasVpnType(new_);
    }

    public Optional<String> getIpsecPeerIp() {
        return this.getOptionalString("ipsec_peer_ip");
    }

    public NetworkConf setIpsecPeerIp(String string) {
        this.put("ipsec_peer_ip", (Object)string);
        return this;
    }

    public Optional<new> getVpnType() {
        return this.getOptionalEnum("vpn_type", new.class);
    }

    public boolean hasVpnType(new new_) {
        return new_.equals(this.getVpnType().orElse(null));
    }

    public Optional<UidVpnType> getUidVpnType() {
        return P.\u00d500000(UidVpnType.class, this.getString("uid_vpn_type"));
    }

    public NetworkConf setUidVpnType(UidVpnType uidVpnType) {
        return this.append("uid_vpn_type", uidVpnType.toString());
    }

    public NetworkConf setVpnType(String string) {
        this.put("vpn_type", (Object)string);
        return this;
    }

    public Optional<String> getRadiusProfileId() {
        return Optional.ofNullable(this.getString("radiusprofile_id"));
    }

    public NetworkConf setRadiusProfileId(String string) {
        this.put("radiusprofile_id", (Object)string);
        return this;
    }

    public Optional<String> getL2tpInterface() {
        return Optional.ofNullable(this.getString("l2tp_interface"));
    }

    public NetworkConf setL2tpInterface(String string) {
        this.put("l2tp_interface", (Object)string);
        return this;
    }

    public Optional<String> getL2tpLocalWanIp() {
        return Optional.ofNullable(this.getString("l2tp_local_wan_ip"));
    }

    public NetworkConf setL2tpLocalWanIp(String string) {
        this.put("l2tp_local_wan_ip", (Object)string);
        return this;
    }

    public Optional<String> getDomainName() {
        return Optional.ofNullable(this.getString("domain_name"));
    }

    public String getDomainNameWithDefault() {
        return this.getDomainName().orElse(this.isVlanEnabled() ? "" : O\u00f60000);
    }

    public NetworkConf setDomainName(String string) {
        this.put("domain_name", (Object)string);
        return this;
    }

    public boolean isReportWanEvent() {
        return this.is("report_wan_event", false);
    }

    public NetworkConf setReportWanEvent(boolean bl) {
        this.put("report_wan_event", (Object)bl);
        return this;
    }

    public boolean isWanVlanEnabled() {
        return this.is("wan_vlan_enabled", false);
    }

    public NetworkConf setWanVlanEnabled(boolean bl) {
        this.put("wan_vlan_enabled", (Object)bl);
        return this;
    }

    public Optional<Integer> getWanVlan() {
        return Optional.ofNullable(this.getIntOrNull("wan_vlan"));
    }

    public NetworkConf setWanVlan(int n2) {
        this.put("wan_vlan", (Object)n2);
        return this;
    }

    public boolean isWanSmartqEnabled() {
        return this.is("wan_smartq_enabled", false);
    }

    public NetworkConf setWanSmartqEnabled(boolean bl) {
        this.put("wan_smartq_enabled", (Object)bl);
        return this;
    }

    public Optional<Integer> getWanSmartqDownRate() {
        return this.getOptionalInt("wan_smartq_down_rate");
    }

    public NetworkConf setWanSmartqDownRate(int n2) {
        this.put("wan_smartq_down_rate", (Object)n2);
        return this;
    }

    public Optional<Integer> getWanSmartqUpRate() {
        return this.getOptionalInt("wan_smartq_up_rate");
    }

    public NetworkConf setWanSmartqUpRate(int n2) {
        this.put("wan_smartq_up_rate", (Object)n2);
        return this;
    }

    public Optional<WanDnsPreference> getWanDnsPreference() {
        return P.\u00d500000(WanDnsPreference.class, this.getString("wan_dns_preference"));
    }

    public boolean hasAutoDnsPreference() {
        return this.getWanDnsPreference().orElse(WanDnsPreference.MANUAL) == WanDnsPreference.AUTO;
    }

    public boolean hasManualDnsPreference() {
        return this.getWanDnsPreference().orElse(WanDnsPreference.MANUAL) == WanDnsPreference.MANUAL;
    }

    public NetworkConf setWanDnsPreference(WanDnsPreference wanDnsPreference) {
        this.put("wan_dns_preference", (Object)wanDnsPreference.toString());
        return this;
    }

    public Optional<String> getWanDns1() {
        return Optional.ofNullable(this.getString("wan_dns1"));
    }

    public NetworkConf setWanDns1(String string) {
        this.put("wan_dns1", (Object)string);
        return this;
    }

    public Optional<String> getWanDns2() {
        return Optional.ofNullable(this.getString("wan_dns2"));
    }

    public NetworkConf setWanDns2(String string) {
        this.put("wan_dns2", (Object)string);
        return this;
    }

    public NetworkConf setDhcpdIp(int n2, String string) {
        this.put("dhcpd_ip_" + n2, (Object)string);
        return this;
    }

    public NetworkConf setDhcpdMac(int n2, String string) {
        this.put("dhcpd_mac_" + n2, (Object)string);
        return this;
    }

    public Optional<String> getDhcpdDns1() {
        return this.getOptionalString("dhcpd_dns_1");
    }

    public NetworkConf setDhcpdDns1(String string) {
        this.put("dhcpd_dns_1", (Object)string);
        return this;
    }

    public Optional<String> getDhcpdDns2() {
        return this.getOptionalString("dhcpd_dns_2");
    }

    public NetworkConf setDhcpdDns2(String string) {
        this.put("dhcpd_dns_2", (Object)string);
        return this;
    }

    public Optional<String> getDhcpdDns3() {
        return this.getOptionalString("dhcpd_dns_3");
    }

    public NetworkConf setDhcpdDns3(String string) {
        this.put("dhcpd_dns_3", (Object)string);
        return this;
    }

    public Optional<String> getDhcpdDns4() {
        return this.getOptionalString("dhcpd_dns_4");
    }

    public NetworkConf setDhcpdDns4(String string) {
        this.put("dhcpd_dns_4", (Object)string);
        return this;
    }

    public boolean isOpenvpnStrictClientCommonName() {
        return this.is("openvpn_strict_client_common_name", false);
    }

    public NetworkConf setOpenvpnStrictClientCommonName(boolean bl) {
        this.put("openvpn_strict_client_common_name", (Object)bl);
        return this;
    }

    public boolean isDhcpdDnsEnabled() {
        return this.is("dhcpd_dns_enabled", false);
    }

    public NetworkConf setDhcpdDnsEnabled(boolean bl) {
        this.put("dhcpd_dns_enabled", (Object)bl);
        return this;
    }

    public boolean isIgmpSnooping() {
        return this.is("igmp_snooping", false);
    }

    public NetworkConf setIgmpSnooping(boolean bl) {
        this.put("igmp_snooping", (Object)bl);
        return this;
    }

    public boolean isFloodUnknownMulticastEnabled() {
        return this.is("igmp_flood_unknown_multicast", false);
    }

    public NetworkConf setFloodUnknownMulticastEnabled(boolean bl) {
        this.put("igmp_flood_unknown_multicast", (Object)bl);
        return this;
    }

    public NetworkConf setIgmpFastLeaveEnabled(boolean bl) {
        this.put("igmp_fastleave", (Object)bl);
        return this;
    }

    public List<X> getIgmpQuerierSwitches() {
        return this.getList("igmp_querier_switches", Collections.emptyList());
    }

    public NetworkConf setIgmpQuerierSwitches(List<X> list) {
        this.put("igmp_querier_switches", list);
        return this;
    }

    public EnabledFor getIgmpProxyEnabledFor() {
        return P.\u00d500000(EnabledFor.class, this.getString("igmp_proxy_for")).orElse(EnabledFor.NONE);
    }

    public NetworkConf setIgmpProxyEnabledFor(EnabledFor enabledFor) {
        this.append("igmp_proxy_for", enabledFor.toString());
        return this;
    }

    public List<String> getIgmpProxyDownstreamNetworkIds() {
        return this.getStringList("igmp_proxy_downstream_networkconf_ids");
    }

    public NetworkConf setIgmpProxyDownstreamNetworkIds(List<String> list) {
        this.put("igmp_proxy_downstream_networkconf_ids", list);
        return this;
    }

    public boolean isIgmpProxyUpstream() {
        return this.is("igmp_proxy_upstream", false);
    }

    public NetworkConf setIgmpProxyUpstream(boolean bl) {
        this.put("igmp_proxy_upstream", (Object)bl);
        return this;
    }

    public Optional<SubnetUtils.SubnetInfo> getIpSubnetInfo() {
        return this.getOptionalString("ip_subnet").flatMap(OooO::nullnew);
    }

    public boolean isDhcpdEnabled() {
        return this.is("dhcpd_enabled", false);
    }

    public NetworkConf setDhcpdEnabled(boolean bl) {
        this.put("dhcpd_enabled", (Object)bl);
        return this;
    }

    public boolean isDhcpRelayEnabled() {
        return this.is("dhcp_relay_enabled", false);
    }

    public NetworkConf setDhcpRelayEnabled(boolean bl) {
        this.put("dhcp_relay_enabled", (Object)bl);
        return this;
    }

    public boolean isDhcpGuardEnabled() {
        return this.is("dhcpguard_enabled", false);
    }

    public NetworkConf setDhcpGuardEnabled(boolean bl) {
        this.put("dhcpguard_enabled", (Object)bl);
        return this;
    }

    public int getDhcpdLeasetime() {
        return this.getInt("dhcpd_leasetime", 86400);
    }

    public NetworkConf setDhcpdLeasetime(int n2) {
        this.put("dhcpd_leasetime", (Object)n2);
        return this;
    }

    public Optional<String> getDhcpdStart() {
        return Optional.ofNullable(this.getString("dhcpd_start"));
    }

    public NetworkConf setDhcpdStart(String string) {
        this.put("dhcpd_start", (Object)string);
        return this;
    }

    public Optional<String> getDhcpdStop() {
        return Optional.ofNullable(this.getString("dhcpd_stop"));
    }

    public List<String> getDhcpdDnsPrefixedList() {
        return this.getPrefixedList("dhcpd_dns").stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    public NetworkConf setDhcpdStop(String string) {
        this.put("dhcpd_stop", (Object)string);
        return this;
    }

    public boolean isDhcpdV6Enabled() {
        return this.is("dhcpdv6_enabled", false);
    }

    public NetworkConf setDhcpdV6Enabled(boolean bl) {
        this.put("dhcpdv6_enabled", (Object)bl);
        return this;
    }

    public NetworkConf setDhcpdv6Start(String string) {
        this.put("dhcpdv6_start", (Object)string);
        return this;
    }

    public String getDhcpdv6Start() {
        return this.getString("dhcpdv6_start", "::2");
    }

    public NetworkConf setDhcpdv6Stop(String string) {
        this.put("dhcpdv6_stop", (Object)string);
        return this;
    }

    public String getDhcpdv6Stop() {
        return this.getString("dhcpdv6_stop", "::7d1");
    }

    private String \u00f8\u00d50000(SubnetUtils.SubnetInfo subnetInfo) {
        return String.format("%s/%d", subnetInfo.getNetworkAddress(), Integer.bitCount(subnetInfo.asInteger(subnetInfo.getNetmask())));
    }

    public boolean isInternetAccessEnabled() {
        return this.is("internet_access_enabled", true);
    }

    public NetworkConf setInternetAccessEnabled(boolean bl) {
        this.put("internet_access_enabled", (Object)bl);
        return this;
    }

    public boolean isNetworkIsolationEnabled() {
        return this.is("network_isolation_enabled", false);
    }

    public NetworkConf setNetworkIsolationEnabled(boolean bl) {
        this.put("network_isolation_enabled", (Object)bl);
        return this;
    }

    public boolean isNat() {
        return this.is("is_nat", true);
    }

    public NetworkConf setNat(boolean bl) {
        this.put("is_nat", (Object)bl);
        return this;
    }

    public boolean isWanV6Enabled() {
        return this.getWanTypeV6().map(string -> !string.equals(WanTypeV6.DISABLED.toString())).orElse(false);
    }

    public boolean isIpv6RaEnabled() {
        return this.is("ipv6_ra_enabled", true);
    }

    public NetworkConf setIpV6RaEnabled(boolean bl) {
        this.put("ipv6_ra_enabled", (Object)bl);
        return this;
    }

    public NetworkConf setIpV6InterfaceType(A a2) {
        this.put("ipv6_interface_type", (Object)a2.toString());
        return this;
    }

    public A getIpV6InterfaceType() {
        return A.super(this.getString("ipv6_interface_type"));
    }

    public boolean isIpV6PdNetwork() {
        return A.\u00d500000 == this.getIpV6InterfaceType();
    }

    public boolean isDpiEnabled() {
        return this.is("dpi_enabled", false);
    }

    public NetworkConf setDpiEnabled(boolean bl) {
        this.put("dpi_enabled", (Object)bl);
        return this;
    }

    public Optional<String> getDpiGroupId() {
        return this.getOptionalString("dpigroup_id");
    }

    public NetworkConf setDpiGroupId(String string) {
        this.put("dpigroup_id", (Object)string);
        return this;
    }

    public boolean isExposedToSiteVpn() {
        return this.is("exposed_to_site_vpn", false);
    }

    public NetworkConf setExposedToSiteVpn(boolean bl) {
        this.put("exposed_to_site_vpn", (Object)bl);
        return this;
    }

    private boolean O\u00d80000() {
        return this.getWanDns1().isPresent() || this.getWanDns2().isPresent();
    }

    public boolean isMulticastDnsEnabled() {
        return this.is("mdns_enabled", false);
    }

    public NetworkConf setMulticastDnsEnabled(boolean bl) {
        this.put("mdns_enabled", (Object)bl);
        return this;
    }

    public NetworkConf setRouteDistance(int n2) {
        this.put("route_distance", (Object)n2);
        return this;
    }

    public Optional<Integer> getRouteDistance() {
        return this.getOptionalInt("route_distance");
    }

    public boolean isL2tpAllowWeakCiphers() {
        return this.getBoolean("l2tp_allow_weak_ciphers", false);
    }

    public NetworkConf setL2tpAllowWeakCiphers(boolean bl) {
        this.put("l2tp_allow_weak_ciphers", (Object)bl);
        return this;
    }

    public boolean isDhcpdBootEnabled() {
        return this.is("dhcpd_boot_enabled", false);
    }

    public NetworkConf setDhcpdBootEnabled(boolean bl) {
        this.put("dhcpd_boot_enabled", (Object)bl);
        return this;
    }

    public boolean isDhcpdGatewayEnabled() {
        return this.is("dhcpd_gateway_enabled", false);
    }

    public NetworkConf setDhcpdGatewayEnabled(boolean bl) {
        this.put("dhcpd_gateway_enabled", (Object)bl);
        return this;
    }

    public boolean isDhcpdNtpEnabled() {
        return this.is("dhcpd_ntp_enabled", false);
    }

    public NetworkConf setDhcpNtpEnabled(boolean bl) {
        this.put("dhcpd_ntp_enabled", (Object)bl);
        return this;
    }

    public String getDhcpdTftpServer() {
        return this.getString("dhcpd_tftp_server");
    }

    public NetworkConf setDhcpdTftpServer(String string) {
        this.put("dhcpd_tftp_server", (Object)string);
        return this;
    }

    public boolean isDhcpdTimeOffsetEnabled() {
        return this.is("dhcpd_time_offset_enabled", false);
    }

    public NetworkConf setDhcpdTimeOffsetEnabled(boolean bl) {
        this.put("dhcpd_time_offset_enabled", (Object)bl);
        return this;
    }

    public String getDhcpdUnifiController() {
        return this.getString("dhcpd_unifi_controller");
    }

    public NetworkConf setDhcpdUnifiController(String string) {
        this.put("dhcpd_unifi_controller", (Object)string);
        return this;
    }

    public boolean isDhcpdWinsEnabled() {
        return this.is("dhcpd_wins_enabled", false);
    }

    public NetworkConf setDhcpdWinsEnabled(boolean bl) {
        this.put("dhcpd_wins_enabled", (Object)bl);
        return this;
    }

    public String getDhcpdWpadUrl() {
        return this.getString("dhcpd_wpad_url");
    }

    public NetworkConf setDhcpdWpadUrl(String string) {
        this.put("dhcpd_wpad_url", (Object)string);
        return this;
    }

    public NetworkConf setDhcpdConflictChecking(boolean bl) {
        this.put("dhcpd_conflict_checking", (Object)bl);
        return this;
    }

    public boolean isDhcpdConflictCheckingEnabled() {
        return this.is("dhcpd_conflict_checking", true);
    }

    public boolean isDhcpdV6DnsAuto() {
        return this.is("dhcpdv6_dns_auto", true);
    }

    public NetworkConf setDhcpdV6DnsAuto(boolean bl) {
        this.put("dhcpdv6_dns_auto", (Object)bl);
        return this;
    }

    public int getDhcpdV6Leasetime() {
        return this.getInt("dhcpdv6_leasetime", 86400);
    }

    public NetworkConf setDhcpdV6Leasetime(int n2) {
        this.put("dhcpdv6_leasetime", (Object)n2);
        return this;
    }

    public String getIpv6PdInterface() {
        return this.getString("ipv6_pd_interface", "");
    }

    public NetworkConf setIpv6PdInterface(String string) {
        this.put("ipv6_pd_interface", (Object)string);
        return this;
    }

    public String getIpv6SingleNetworkInterface() {
        return this.getString("ipv6_single_network_interface", "");
    }

    public NetworkConf setIpv6SingleNetworkInterface(String string) {
        this.put("ipv6_single_network_interface", (Object)string);
        return this;
    }

    public String getIpv6PdStart() {
        return this.getString("ipv6_pd_start", "::2");
    }

    public NetworkConf setIpv6PdStart(String string) {
        this.put("ipv6_pd_start", (Object)string);
        return this;
    }

    public String getIpv6PdStop() {
        return this.getString("ipv6_pd_stop", "::7d1");
    }

    public NetworkConf setIpv6PdStop(String string) {
        this.put("ipv6_pd_stop", (Object)string);
        return this;
    }

    public String getIpv6RaPreferredLifetime() {
        return this.getString("ipv6_ra_preferred_lifetime", NetworkConfDefaults.\u00f4O0000);
    }

    public NetworkConf setIpv6RaPreferredLifetime(int n2) {
        this.put("ipv6_ra_preferred_lifetime", (Object)n2);
        return this;
    }

    public Ipv6RaPriority getIpv6RaPriority() {
        return Ipv6RaPriority.ofStringValue(this.getString("ipv6_ra_priority")).orElse(NetworkConfDefaults.o00000);
    }

    public NetworkConf setIpv6RaPriority(Ipv6RaPriority ipv6RaPriority) {
        this.put("ipv6_ra_priority", (Object)ipv6RaPriority.toString());
        return this;
    }

    public boolean isUpnpLanEnabled() {
        return this.is("upnp_lan_enabled", false);
    }

    public NetworkConf setUpnpLanEnabled(boolean bl) {
        this.put("upnp_lan_enabled", (Object)bl);
        return this;
    }

    public String getDhcpGateway() {
        return this.getString("dhcpd_gateway");
    }

    public NetworkConf setDhcpGateway(String string) {
        return this.append("dhcpd_gateway", string);
    }

    public Optional<String> getOpenVpnLocalAddress() {
        return Optional.ofNullable(this.getString("openvpn_local_address"));
    }

    public NetworkConf setOpenVpnLocalAddress(String string) {
        return this.append("openvpn_local_address", string);
    }

    public Optional<String> getOpenVpnRemoteHost() {
        return Optional.ofNullable(this.getString("openvpn_remote_host"));
    }

    public NetworkConf setOpenVpnRemoteHost(String string) {
        return this.append("openvpn_remote_host", string);
    }

    public Optional<String> getOpenVpnRemoteAddress() {
        return Optional.ofNullable(this.getString("openvpn_remote_address"));
    }

    public NetworkConf setOpenVpnRemoteAddress(String string) {
        this.put("openvpn_remote_address", (Object)string);
        return this;
    }

    public Optional<Integer> getOpenVpnTlsRenegotiationTimeout() {
        return this.getOptionalInt("openvpn_tls_renegotiation_timeout");
    }

    public NetworkConf setOpenVpnTlsRenegotiationTimeout(Integer n2) {
        this.put("openvpn_tls_renegotiation_timeout", (Object)n2);
        return this;
    }

    public Optional<String> getOpenVpnConfiguration() {
        return Optional.ofNullable(this.getString("openvpn_configuration"));
    }

    public Optional<String> getOpenVpnConfigurationFilename() {
        return Optional.ofNullable(this.getString("openvpn_configuration_filename"));
    }

    public NetworkConf setOpenVpnConfiguration(String string) {
        return this.append("openvpn_configuration", string);
    }

    public NetworkConf setOpenVpnConfigurationFilename(String string) {
        return this.append("openvpn_configuration_filename", string);
    }

    public Optional<OpenVpnConfigurationStatus> getOpenVpnConfigurationStatus() {
        return P.\u00d500000(OpenVpnConfigurationStatus.class, this.getString("openvpn_configuration_status"));
    }

    public NetworkConf setOpenVpnConfigurationStatus(OpenVpnConfigurationStatus openVpnConfigurationStatus) {
        return this.append("openvpn_configuration_status", openVpnConfigurationStatus.toString());
    }

    public Optional<String> getOpenVpnUsername() {
        return Optional.ofNullable(this.getString("openvpn_username"));
    }

    public NetworkConf setOpenVpnUsername(String string) {
        return this.append("openvpn_username", string);
    }

    public Optional<String> getOpenVpnPassword() {
        return Optional.ofNullable(this.getString("x_openvpn_password"));
    }

    public NetworkConf setOpenVpnPassword(String string) {
        return this.append("x_openvpn_password", string);
    }

    public Optional<Integer> getOpenVpnId() {
        return this.getOptionalInt("openvpn_id");
    }

    public Optional<super> getOpenVpnEncryptionCipher() {
        return this.getOptionalEnum("openvpn_encryption_cipher", super.class);
    }

    public NetworkConf setOpenVpnEncryptionCipher(super super_) {
        return this.append("openvpn_encryption_cipher", super_.toString());
    }

    public boolean isVpnClientConfigurationRemoteIpOverrideEnabled() {
        return this.is("vpn_client_configuration_remote_ip_override_enabled", false);
    }

    public NetworkConf setVpnClientConfigurationRemoteIpOverrideEnabled(boolean bl) {
        return this.append("vpn_client_configuration_remote_ip_override_enabled", bl);
    }

    public Optional<String> getVpnClientConfigurationRemoteIpOverride() {
        return Optional.ofNullable(this.getString("vpn_client_configuration_remote_ip_override")).filter(StringUtils::isNotBlank);
    }

    public NetworkConf setVpnClientConfigurationRemoteIpOverride(String string) {
        return this.append("vpn_client_configuration_remote_ip_override", string);
    }

    public NetworkConf setOpenVpnId(int n2) {
        return this.append("openvpn_id", n2);
    }

    public Optional<ooOO> getWireguardClientMode() {
        return P.\u00d500000(ooOO.class, this.getString("wireguard_client_mode"));
    }

    public Optional<String> getWireguardClientConfigurationFile() {
        return Optional.ofNullable(this.getString("wireguard_client_configuration_file"));
    }

    public NetworkConf setWireguardClientConfigurationFile(String string) {
        return this.append("wireguard_client_configuration_file", string);
    }

    public Optional<String> getWireguardClientPeerPublicKey() {
        return Optional.ofNullable(this.getString("wireguard_client_peer_public_key"));
    }

    public NetworkConf setWireguardClientPeerPublicKey(String string) {
        return this.append("wireguard_client_peer_public_key", string);
    }

    public Optional<String> getWireguardClientPeerIp() {
        return Optional.ofNullable(this.getString("wireguard_client_peer_ip"));
    }

    public NetworkConf setWireguardClientPeerIp(String string) {
        return this.append("wireguard_client_peer_ip", string);
    }

    public Optional<Integer> getWireguardClientPeerPort() {
        return Optional.ofNullable(this.getIntOrNull("wireguard_client_peer_port"));
    }

    public NetworkConf setWireguardClientPeerPort(Integer n2) {
        return this.append("wireguard_client_peer_port", n2);
    }

    public Optional<String> getWireguardClientPreSharedKey() {
        return Optional.ofNullable(this.getString("wireguard_client_preshared_key"));
    }

    public NetworkConf setWireguardClientPresharedKey(String string) {
        return this.append("wireguard_client_preshared_key", string);
    }

    public boolean isWireguardClientPreSharedKeyEnabled() {
        return this.is("wireguard_client_preshared_key_enabled", false);
    }

    public NetworkConf setWireguardClientPresharedKeyEnabled(boolean bl) {
        return this.append("wireguard_client_preshared_key_enabled", bl);
    }

    public NetworkConf setWireguardClientMode(ooOO ooOO2) {
        return this.append("wireguard_client_mode", ooOO2.toString());
    }

    public Optional<String> getWireguardPrivateKey() {
        return this.getOptionalString("x_wireguard_private_key").filter(StringUtils::isNotEmpty);
    }

    public NetworkConf setWireguardPrivateKey(String string) {
        return this.append("x_wireguard_private_key", string);
    }

    public Optional<Integer> getWireguardId() {
        return this.getOptionalInt("wireguard_id");
    }

    public NetworkConf setWireguardId(int n2) {
        return this.append("wireguard_id", n2);
    }

    public Optional<String> getWireguardInterface() {
        return Optional.ofNullable(this.getString("wireguard_interface"));
    }

    public NetworkConf setWireguardInterface(String string) {
        return this.append("wireguard_interface", string);
    }

    public Optional<String> getWireguardLocalWanIp() {
        return Optional.ofNullable(this.getString("wireguard_local_wan_ip"));
    }

    public NetworkConf setWireguardLocalWanIp(String string) {
        return this.append("wireguard_local_wan_ip", string);
    }

    public boolean isSmartSubnetDetected() {
        return this.getOptionalBoolean("is_smart_subnet_detected").orElse(false);
    }

    public NetworkConf setSmartSubnetDetected(boolean bl) {
        this.put("is_smart_subnet_detected", (Object)bl);
        return this;
    }

    public Optional<String> getVrrpPrimaryGatewaySubnetIp() {
        return this.getOptionalString("vrrp_ip_subnet_gw1");
    }

    public Optional<String> getVrrpSecondaryGatewaySubnetIp() {
        return this.getOptionalString("vrrp_ip_subnet_gw2");
    }

    public Optional<Integer> getVrrpVrid() {
        return this.getOptionalInt("vrrp_vrid");
    }

    public boolean isEqualToLocalNetworkAutoSettings() {
        NetworkConf networkConf = NetworkConfDefaults.localNetworkAutoSettings(this.isVlanEnabled());
        return (this.getFirewallZoneId().isPresent() || StringUtils.equals((CharSequence)this.getPurpose(), (CharSequence)networkConf.getPurpose())) && this.isDhcpdEnabled() == networkConf.isDhcpdEnabled() && this.isDhcpdV6Enabled() == networkConf.isDhcpdV6Enabled() && this.isDhcpGuardEnabled() == networkConf.isDhcpGuardEnabled() && StringUtils.equals((CharSequence)this.getDomainNameWithDefault(), (CharSequence)networkConf.getDomainNameWithDefault()) && this.isIgmpSnooping() == networkConf.isIgmpSnooping() && this.getIpV6InterfaceType().equals((Object)networkConf.getIpV6InterfaceType()) && this.isNat() == networkConf.isNat() && this.isIpv6RaEnabled() == networkConf.isIpv6RaEnabled() && this.isMulticastDnsEnabled() == networkConf.isMulticastDnsEnabled();
    }

    public Optional<Integer> getWanEgressQos() {
        return this.getOptionalInt("wan_egress_qos");
    }

    public NetworkConf setWanEgressQos(int n2) {
        this.put("wan_egress_qos", (Object)n2);
        return this;
    }

    public Optional<String> getOpenVpnAuthKey() {
        return Optional.ofNullable(this.getString("x_auth_key")).filter(StringUtils::isNotEmpty);
    }

    public NetworkConf setOpenVpnAuthKey(String string) {
        return this.append("x_auth_key", string);
    }

    public Optional<String> getOpenVpnAuthorityCertificate() {
        return Optional.ofNullable(this.getString("x_ca_crt")).filter(StringUtils::isNotEmpty);
    }

    public NetworkConf setOpenVpnAuthorityCertificate(String string) {
        return this.append("x_ca_crt", string);
    }

    public Optional<String> getOpenVpnAuthorityKey() {
        return Optional.ofNullable(this.getString("x_ca_key")).filter(StringUtils::isNotEmpty);
    }

    public NetworkConf setOpenVpnAuthorityKey(String string) {
        return this.append("x_ca_key", string);
    }

    public Optional<String> getOpenVpnInterface() {
        return Optional.ofNullable(this.getString("openvpn_interface"));
    }

    public NetworkConf setOpenVpnInterface(WanNetworkGroup wanNetworkGroup) {
        return this.append("openvpn_interface", wanNetworkGroup.toString().toLowerCase());
    }

    public Optional<String> getOpenVpnLocalWanIp() {
        return Optional.ofNullable(this.getString("openvpn_local_wan_ip"));
    }

    public NetworkConf setOpenVpnLocalWanIp(String string) {
        this.put("openvpn_local_wan_ip", (Object)string);
        return this;
    }

    public Optional<String> getOpenVpnServerCertificate() {
        return Optional.ofNullable(this.getString("x_server_crt")).filter(StringUtils::isNotEmpty);
    }

    public NetworkConf setOpenVpnServerCertificate(String string) {
        return this.append("x_server_crt", string);
    }

    public Optional<String> getOpenVpnServerKey() {
        return Optional.ofNullable(this.getString("x_server_key")).filter(StringUtils::isNotEmpty);
    }

    public NetworkConf setOpenVpnServerKey(String string) {
        return this.append("x_server_key", string);
    }

    public Optional<String> getOpenVpnDhKey() {
        return Optional.ofNullable(this.getString("x_dh_key")).filter(StringUtils::isNotEmpty);
    }

    public NetworkConf setOpenVpnDhKey(String string) {
        return this.append("x_dh_key", string);
    }

    public Optional<String> getOpenVpnSharedClientCertificate() {
        return Optional.ofNullable(this.getString("x_shared_client_crt")).filter(StringUtils::isNotEmpty);
    }

    public NetworkConf setOpenVpnSharedClientCertificate(String string) {
        return this.append("x_shared_client_crt", string);
    }

    public Optional<String> getOpenVpnSharedClientKey() {
        return Optional.ofNullable(this.getString("x_shared_client_key")).filter(StringUtils::isNotEmpty);
    }

    public NetworkConf setOpenVpnSharedClientKey(String string) {
        return this.append("x_shared_client_key", string);
    }

    public boolean hasRequiredOpenVpnServerCertificatesAndKeys() {
        return this.getOpenVpnAuthorityCertificate().isPresent() && this.getOpenVpnServerCertificate().isPresent() && this.getOpenVpnAuthKey().isPresent() && this.getOpenVpnDhKey().isPresent();
    }

    public Optional<Integer> getWanDhcpCos() {
        return Optional.of(this.getInt("wan_dhcp_cos", -1)).filter(n2 -> n2 >= 0);
    }

    public boolean isIpv6Enabled() {
        return this.is("ipv6_enabled", true);
    }

    public NetworkConf setIpv6Enabled(boolean bl) {
        this.put("ipv6_enabled", (Object)bl);
        return this;
    }

    public NetworkConf setClientAddressAssignment(OoOO ooOO2) {
        this.put("ipv6_client_address_assignment", (Object)ooOO2.toString());
        return this;
    }

    public OoOO getClientAddressAssignment() {
        return OoOO.\u00d200000(this.getString("ipv6_client_address_assignment"));
    }

    public NetworkConf setDhcpv6dDns(int n2, String string) {
        this.put("dhcpdv6_dns_" + n2, (Object)string);
        return this;
    }

    public boolean isAllowSlaacEnabled() {
        return this.is("dhcpdv6_allow_slaac", true);
    }

    public NetworkConf setDhcpdv6AllowSlaac(boolean bl) {
        this.put("dhcpdv6_allow_slaac", (Object)bl);
        return this;
    }

    public boolean isIpv6DefaultPrefixLength() {
        return this.getPrefixLength() == 64;
    }

    public boolean isIpv6StaticInterfaceType() {
        return this.getIpV6InterfaceType() == A.\u00d200000;
    }

    public boolean isDhcpv6AddressAssignment() {
        return this.getClientAddressAssignment() == OoOO.new;
    }

    public boolean isIpv6AutoPreference() {
        return this.getIpv6SettingPreference().filter(settingPreference -> settingPreference == SettingPreference.\u00d300000).isPresent();
    }

    public NetworkConf setIPv6PdPrefixId(int n2) {
        this.put("ipv6_pd_prefixid", (Object)n2);
        return this;
    }

    public Optional<Integer> getIPv6PdPrefixId() {
        return Optional.of(this.getInt("ipv6_pd_prefixid", -1)).filter(n2 -> n2 >= 0);
    }

    public NetworkConf setIPv6PdAutoPrefixIdEnabled(boolean bl) {
        this.put("ipv6_pd_auto_prefixid_enabled", (Object)bl);
        return this;
    }

    public boolean isIPv6PdAutoPrefixIdEnabled() {
        return this.is("ipv6_pd_auto_prefixid_enabled", true);
    }

    public boolean isIPv6PdPrefixIdAutoCalculated() {
        return this.isIPv6PdAutoPrefixIdEnabled() || this.getIPv6PdPrefixId().isEmpty();
    }

    public boolean isDhcpv6Configured() {
        return this.isIpv6StaticInterfaceType() && (this.isDhcpdV6Enabled() || this.getClientAddressAssignment() == OoOO.new);
    }

    public NetworkConf setDhcpv6PdSize(int n2) {
        this.put("wan_dhcpv6_pd_size", (Object)n2);
        return this;
    }

    public int getWanDhcpv6PdSize() {
        return this.getInt("wan_dhcpv6_pd_size", 64);
    }

    public NetworkConf setWanIpv6(String string) {
        this.put("wan_ipv6", (Object)string);
        return this;
    }

    public NetworkConf setWanGatewayIpv6(String string) {
        this.put("wan_gateway_v6", (Object)string);
        return this;
    }

    public boolean isWanIpV6PdNetwork() {
        return this.isWanTypeV6(WanTypeV6.DHCPV6) || this.isWanTypeV6(WanTypeV6.SLAAC) && this.isIpv6WanDelegationType(Ipv6WanDelegationType.PD);
    }

    public NetworkConf setWanIpv6Dns1(String string) {
        this.put("wan_ipv6_dns1", (Object)string);
        return this;
    }

    public Optional<String> getWanIpv6Dns1() {
        return Optional.ofNullable(this.getString("wan_ipv6_dns1"));
    }

    public NetworkConf setWanIpv6Dns2(String string) {
        this.put("wan_ipv6_dns2", (Object)string);
        return this;
    }

    public Optional<String> getWanIpv6Dns2() {
        return Optional.ofNullable(this.getString("wan_ipv6_dns2"));
    }

    public NetworkConf setWanIpv6DnsPreference(WanDnsPreference wanDnsPreference) {
        this.put("wan_ipv6_dns_preference", (Object)wanDnsPreference);
        return this;
    }

    public Optional<WanDnsPreference> getWanIpv6DnsPreference() {
        return P.\u00d500000(WanDnsPreference.class, this.getString("wan_ipv6_dns_preference"));
    }

    public boolean hasAutoIpv6DnsPreference() {
        return this.getWanIpv6DnsPreference().orElse(WanDnsPreference.AUTO) == WanDnsPreference.AUTO;
    }

    public NetworkConf setRemoteSiteId(String string) {
        this.append("remote_site_id", string);
        return this;
    }

    public Optional<String> getRemoteSiteId() {
        return this.getOptionalString("remote_site_id");
    }

    public boolean isIgmpFastleaveEnabled() {
        return this.is("igmp_fastleave", false);
    }

    public int getIgmpMaxResponseTime() {
        return this.getInt("igmp_maxresponse", 10);
    }

    public int getIgmpMcrtrExpireTime() {
        return this.getInt("igmp_mcrtrexpiretime", 180);
    }

    public int getIgmpGroupMembershipInterval() {
        return this.getInt("igmp_groupmembership", 260);
    }

    public boolean isIgmpReportSuppressionEnabled() {
        return this.is("igmp_supression", false);
    }

    public boolean isWanPppoeUsernameEnabled() {
        return this.is("wan_pppoe_username_enabled", true);
    }

    public NetworkConf setWanPppoeUsernameEnabled(boolean bl) {
        this.append("wan_pppoe_username_enabled", bl);
        return this;
    }

    public boolean isWanPppoePasswordEnabled() {
        return this.is("wan_pppoe_password_enabled", true);
    }

    public NetworkConf setWanPppoePasswordEnabled(boolean bl) {
        this.append("wan_pppoe_password_enabled", bl);
        return this;
    }

    public Optional<String> getWanPppoeUsername() {
        return this.getOptionalString("wan_username");
    }

    public NetworkConf setWanPppoeUsername(String string) {
        this.append("wan_username", string);
        return this;
    }

    public Optional<String> getWanPppoePassword() {
        return this.getOptionalString("x_wan_password");
    }

    public NetworkConf setWanPppoePassword(String string) {
        this.append("x_wan_password", string);
        return this;
    }

    public boolean isIpv6StandardPrefixLengthInterfaceType() {
        return C.\u00d300000(this.getIpV6InterfaceType());
    }

    public boolean isIpv6SlaacClientAddressAssignment() {
        return this.getClientAddressAssignment() == OoOO.\u00d400000;
    }

    public boolean isIPv6SingleNetwork() {
        return A.o00000 == this.getIpV6InterfaceType();
    }

    public boolean isWanFailoverFirstPriority() {
        return this.getWanFailOverPriority().map(n2 -> n2 == 1).orElse(false);
    }

    public boolean isWanNetworkAndNotLteFailover() {
        return this.isWanNetwork() && !this.isLteWanFailoverNetwork();
    }

    public boolean isWan5gNetwork() {
        return this.getHiddenId().filter(string -> StringUtils.equals((CharSequence)o0O000, (CharSequence)string)).isPresent();
    }

    public boolean isWanMagicEnabled() {
        return this.is("wan_magic_enabled", false);
    }

    public NetworkConf setWanMagicEnabled(boolean bl) {
        this.append("wan_magic_enabled", bl);
        return this;
    }

    public NetworkConf setWan5gNetwork() {
        this.setHiddenId(o0O000);
        return this;
    }

    public boolean isWanMagicNetwork() {
        return this.getNetworkPurpose() == NetworkPurpose.WAN_MAGIC;
    }

    public NetworkConf setLanTunnelWanDevice(String string) {
        this.put("lan_tunnel_wan_device", (Object)string);
        return this;
    }

    public Optional<String> getLanTunnelWanDevice() {
        return this.getOptionalString("lan_tunnel_wan_device");
    }

    public boolean isLanTunnelWanNetwork() {
        return this.isLteWanFailoverNetwork() || this.isWan5gNetwork() && this.getLanTunnelWanDevice().isPresent();
    }
}

