/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.device;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.data.DeviceType;
import com.ubnt.model.api.SearchTag;
import com.ubnt.model.api.device.ClientDeviceDto;
import com.ubnt.model.api.device.DeviceIconInfoDto;
import com.ubnt.model.api.device.UnifiDeviceDto;
import com.ubnt.model.for.J;
import com.ubnt.model.for.new.Object;
import com.ubnt.model.for.supersuper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.immutables.value.Generated;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Generated(from="ClientDeviceDto", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableClientDeviceDto
extends ClientDeviceDto {
    @Nullable
    private final String id;
    private final String mac;
    private final boolean isDefault;
    private final String name;
    private final String modelShortname;
    @Nullable
    private final String ipAddress;
    @Nullable
    private final Integer experience;
    @Nullable
    private final String version;
    @Nullable
    private final String displayableVersion;
    @Nullable
    private final Double usageBytes;
    @Nullable
    private final Long downloadSpeedBytesPerSecond;
    @Nullable
    private final Long uploadSpeedBytesPerSecond;
    @Nullable
    private final Long uptimeSeconds;
    private final J productLine;
    @Nullable
    private final Long lastSeenTimestampSeconds;
    @Nullable
    private final String connectionNetworkId;
    @Nullable
    private final String connectionNetworkName;
    @Nullable
    private final Long ipv4ActiveLeaseExpirationTimestampSeconds;
    @Nullable
    private final String lastConnectionNetworkId;
    @Nullable
    private final String lastConnectionNetworkName;
    @Nullable
    private final String stackingGroupId;
    @Nullable
    private final DeviceType type;
    private final List<List<Integer>> iconResolutions;
    private final String iconFilename;
    private final List<DeviceIconInfoDto> icons;
    private final int state;
    private final boolean isWired;
    @Nullable
    private final Integer wiredSpeedMegabitsPerSecond;
    @Nullable
    private final supersuper firmwareStatus;
    @Nullable
    private final String essid;
    @Nullable
    private final Integer rateImbalance;
    private final String uplinkMac;
    @Nullable
    private final Object uplinkRadioBand;
    private final boolean viewInApplication;
    private final Set<SearchTag> tags;

    private ImmutableClientDeviceDto(Builder builder) {
        this.id = builder.id;
        this.mac = builder.mac;
        this.isDefault = builder.isDefault;
        this.name = builder.name;
        this.modelShortname = builder.modelShortname;
        this.ipAddress = builder.ipAddress;
        this.experience = builder.experience;
        this.version = builder.version;
        this.displayableVersion = builder.displayableVersion;
        this.usageBytes = builder.usageBytes;
        this.downloadSpeedBytesPerSecond = builder.downloadSpeedBytesPerSecond;
        this.uploadSpeedBytesPerSecond = builder.uploadSpeedBytesPerSecond;
        this.uptimeSeconds = builder.uptimeSeconds;
        this.productLine = builder.productLine;
        this.lastSeenTimestampSeconds = builder.lastSeenTimestampSeconds;
        this.connectionNetworkId = builder.connectionNetworkId;
        this.connectionNetworkName = builder.connectionNetworkName;
        this.ipv4ActiveLeaseExpirationTimestampSeconds = builder.ipv4ActiveLeaseExpirationTimestampSeconds;
        this.lastConnectionNetworkId = builder.lastConnectionNetworkId;
        this.lastConnectionNetworkName = builder.lastConnectionNetworkName;
        this.stackingGroupId = builder.stackingGroupId;
        this.type = builder.type;
        this.iconResolutions = ImmutableClientDeviceDto.\u00f8\u00f50000(true, builder.iconResolutions);
        this.iconFilename = builder.iconFilename;
        this.icons = ImmutableClientDeviceDto.\u00f8\u00f50000(true, builder.icons);
        this.state = builder.state;
        this.isWired = builder.isWired;
        this.wiredSpeedMegabitsPerSecond = builder.wiredSpeedMegabitsPerSecond;
        this.firmwareStatus = builder.firmwareStatus;
        this.essid = builder.essid;
        this.rateImbalance = builder.rateImbalance;
        this.uplinkMac = builder.uplinkMac;
        this.uplinkRadioBand = builder.uplinkRadioBand;
        this.viewInApplication = builder.viewInApplication;
        this.tags = ImmutableClientDeviceDto.\u00f6\u00f50000(builder.tags);
    }

    @Override
    @JsonProperty(value="_id")
    @Schema(name="Object Id")
    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="mac")
    @Schema(name="MAC address")
    public String mac() {
        return this.mac;
    }

    @Override
    @JsonProperty(value="default")
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    @JsonProperty(value="name")
    @Schema(name="Device name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="model")
    @Schema(name="Device model shortname")
    public String modelShortname() {
        return this.modelShortname;
    }

    @Override
    @JsonProperty(value="ip")
    @Schema(name="IP address")
    public Optional<String> ipAddress() {
        return Optional.ofNullable(this.ipAddress);
    }

    @Override
    @JsonProperty(value="satisfaction")
    @Schema(name="Experience", example="99")
    public Optional<Integer> experience() {
        return Optional.ofNullable(this.experience);
    }

    @Override
    @JsonProperty(value="version")
    @Schema(name="Firmware version")
    public Optional<String> version() {
        return Optional.ofNullable(this.version);
    }

    @Override
    @JsonProperty(value="displayable_version")
    @Schema(name="Firmware version in user friendly form")
    public Optional<String> displayableVersion() {
        return Optional.ofNullable(this.displayableVersion);
    }

    @Override
    @JsonProperty(value="usage_bytes")
    @Schema(name="24h usage in bytes per second")
    public Optional<Double> usageBytes() {
        return Optional.ofNullable(this.usageBytes);
    }

    @Override
    @JsonProperty(value="download_speed_bytes_per_second")
    @Schema(name="Download speed in bytes per second", example="1024")
    public Optional<Long> downloadSpeedBytesPerSecond() {
        return Optional.ofNullable(this.downloadSpeedBytesPerSecond);
    }

    @Override
    @JsonProperty(value="upload_speed_bytes_per_second")
    @Schema(name="Upload speed in bytes", example="512")
    public Optional<Long> uploadSpeedBytesPerSecond() {
        return Optional.ofNullable(this.uploadSpeedBytesPerSecond);
    }

    @Override
    @JsonProperty(value="uptime")
    @Schema(name="Uptime in seconds", example="120")
    public Optional<Long> uptimeSeconds() {
        return Optional.ofNullable(this.uptimeSeconds);
    }

    @Override
    @JsonProperty(value="product_line")
    @Schema(name="Controller that could manage this device")
    public J productLine() {
        return this.productLine;
    }

    @Override
    @JsonProperty(value="last_seen")
    @Schema(description="Information about when the device was seen for the last time in unix timestamp in seconds")
    public Optional<Long> lastSeenTimestampSeconds() {
        return Optional.ofNullable(this.lastSeenTimestampSeconds);
    }

    @Override
    @JsonProperty(value="connection_network_id")
    @Schema(name="Network id where the device is connected to")
    public Optional<String> connectionNetworkId() {
        return Optional.ofNullable(this.connectionNetworkId);
    }

    @Override
    @JsonProperty(value="connection_network_name")
    @Schema(name="Network name where the device is connected to")
    public Optional<String> connectionNetworkName() {
        return Optional.ofNullable(this.connectionNetworkName);
    }

    @Override
    @JsonProperty(value="ipv4_lease_expiration_timestamp_seconds")
    @Schema(name="Device ip v4 lease expiration timestamp in seconds")
    public Optional<Long> ipv4ActiveLeaseExpirationTimestampSeconds() {
        return Optional.ofNullable(this.ipv4ActiveLeaseExpirationTimestampSeconds);
    }

    @Override
    @JsonProperty(value="last_connection_network_id")
    public Optional<String> lastConnectionNetworkId() {
        return Optional.ofNullable(this.lastConnectionNetworkId);
    }

    @Override
    @JsonProperty(value="last_connection_network_name")
    public Optional<String> lastConnectionNetworkName() {
        return Optional.ofNullable(this.lastConnectionNetworkName);
    }

    @Override
    @JsonProperty(value="stacking_group_id")
    @Schema(name="Stacking group that the device belongs to")
    public Optional<String> stackingGroupId() {
        return Optional.ofNullable(this.stackingGroupId);
    }

    @Override
    @JsonProperty(value="type")
    public Optional<DeviceType> type() {
        return Optional.ofNullable(this.type);
    }

    @Override
    @JsonProperty(value="icon_resolutions")
    public List<List<Integer>> iconResolutions() {
        return this.iconResolutions;
    }

    @Override
    @JsonProperty(value="icon_filename")
    public String iconFilename() {
        return this.iconFilename;
    }

    @Override
    @JsonProperty(value="icons")
    public List<DeviceIconInfoDto> icons() {
        return this.icons;
    }

    @Override
    @JsonProperty(value="state")
    public int state() {
        return this.state;
    }

    @Override
    @JsonProperty(value="is_wired")
    public boolean isWired() {
        return this.isWired;
    }

    @Override
    @JsonProperty(value="wired_speed_megabits_per_second")
    public Optional<Integer> wiredSpeedMegabitsPerSecond() {
        return Optional.ofNullable(this.wiredSpeedMegabitsPerSecond);
    }

    @Override
    @JsonProperty(value="firmware_status")
    public Optional<supersuper> firmwareStatus() {
        return Optional.ofNullable(this.firmwareStatus);
    }

    @Override
    @JsonProperty(value="essid")
    public Optional<String> essid() {
        return Optional.ofNullable(this.essid);
    }

    @Override
    @JsonProperty(value="rate_imbalance")
    @Schema(description="Imbalance in percent between rate of the client and its uplink. Possible values [-100;100]. 0 indicates perfect balance, negative values - higher client rate. Since 7.3.26", example="-40")
    public Optional<Integer> rateImbalance() {
        return Optional.ofNullable(this.rateImbalance);
    }

    @Override
    @JsonProperty(value="uplink_mac")
    public String uplinkMac() {
        return this.uplinkMac;
    }

    @Override
    @JsonProperty(value="uplink_radio_band")
    public Optional<Object> uplinkRadioBand() {
        return Optional.ofNullable(this.uplinkRadioBand);
    }

    @Override
    @JsonProperty(value="view_in_application")
    public boolean viewInApplication() {
        return this.viewInApplication;
    }

    @Override
    @JsonProperty(value="tags")
    public Set<SearchTag> tags() {
        return this.tags;
    }

    public boolean equals(@Nullable java.lang.Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableClientDeviceDto && this.o\u00f60000(0, (ImmutableClientDeviceDto)object);
    }

    private boolean o\u00f60000(int n2, ImmutableClientDeviceDto immutableClientDeviceDto) {
        return Objects.equals(this.id, immutableClientDeviceDto.id) && Objects.equals(this.mac, immutableClientDeviceDto.mac) && this.isDefault == immutableClientDeviceDto.isDefault && Objects.equals(this.name, immutableClientDeviceDto.name) && Objects.equals(this.modelShortname, immutableClientDeviceDto.modelShortname) && Objects.equals(this.ipAddress, immutableClientDeviceDto.ipAddress) && Objects.equals(this.experience, immutableClientDeviceDto.experience) && Objects.equals(this.version, immutableClientDeviceDto.version) && Objects.equals(this.displayableVersion, immutableClientDeviceDto.displayableVersion) && Objects.equals(this.usageBytes, immutableClientDeviceDto.usageBytes) && Objects.equals(this.downloadSpeedBytesPerSecond, immutableClientDeviceDto.downloadSpeedBytesPerSecond) && Objects.equals(this.uploadSpeedBytesPerSecond, immutableClientDeviceDto.uploadSpeedBytesPerSecond) && Objects.equals(this.uptimeSeconds, immutableClientDeviceDto.uptimeSeconds) && Objects.equals((java.lang.Object)this.productLine, (java.lang.Object)immutableClientDeviceDto.productLine) && Objects.equals(this.lastSeenTimestampSeconds, immutableClientDeviceDto.lastSeenTimestampSeconds) && Objects.equals(this.connectionNetworkId, immutableClientDeviceDto.connectionNetworkId) && Objects.equals(this.connectionNetworkName, immutableClientDeviceDto.connectionNetworkName) && Objects.equals(this.ipv4ActiveLeaseExpirationTimestampSeconds, immutableClientDeviceDto.ipv4ActiveLeaseExpirationTimestampSeconds) && Objects.equals(this.lastConnectionNetworkId, immutableClientDeviceDto.lastConnectionNetworkId) && Objects.equals(this.lastConnectionNetworkName, immutableClientDeviceDto.lastConnectionNetworkName) && Objects.equals(this.stackingGroupId, immutableClientDeviceDto.stackingGroupId) && Objects.equals((java.lang.Object)this.type, (java.lang.Object)immutableClientDeviceDto.type) && this.iconResolutions.equals(immutableClientDeviceDto.iconResolutions) && Objects.equals(this.iconFilename, immutableClientDeviceDto.iconFilename) && this.icons.equals(immutableClientDeviceDto.icons) && this.state == immutableClientDeviceDto.state && this.isWired == immutableClientDeviceDto.isWired && Objects.equals(this.wiredSpeedMegabitsPerSecond, immutableClientDeviceDto.wiredSpeedMegabitsPerSecond) && Objects.equals((java.lang.Object)this.firmwareStatus, (java.lang.Object)immutableClientDeviceDto.firmwareStatus) && Objects.equals(this.essid, immutableClientDeviceDto.essid) && Objects.equals(this.rateImbalance, immutableClientDeviceDto.rateImbalance) && Objects.equals(this.uplinkMac, immutableClientDeviceDto.uplinkMac) && Objects.equals(this.uplinkRadioBand, immutableClientDeviceDto.uplinkRadioBand) && this.viewInApplication == immutableClientDeviceDto.viewInApplication && this.tags.equals(immutableClientDeviceDto.tags);
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + Objects.hashCode(this.id);
        n2 += (n2 << 5) + Objects.hashCode(this.mac);
        n2 += (n2 << 5) + Boolean.hashCode(this.isDefault);
        n2 += (n2 << 5) + Objects.hashCode(this.name);
        n2 += (n2 << 5) + Objects.hashCode(this.modelShortname);
        n2 += (n2 << 5) + Objects.hashCode(this.ipAddress);
        n2 += (n2 << 5) + Objects.hashCode(this.experience);
        n2 += (n2 << 5) + Objects.hashCode(this.version);
        n2 += (n2 << 5) + Objects.hashCode(this.displayableVersion);
        n2 += (n2 << 5) + Objects.hashCode(this.usageBytes);
        n2 += (n2 << 5) + Objects.hashCode(this.downloadSpeedBytesPerSecond);
        n2 += (n2 << 5) + Objects.hashCode(this.uploadSpeedBytesPerSecond);
        n2 += (n2 << 5) + Objects.hashCode(this.uptimeSeconds);
        n2 += (n2 << 5) + Objects.hashCode((java.lang.Object)this.productLine);
        n2 += (n2 << 5) + Objects.hashCode(this.lastSeenTimestampSeconds);
        n2 += (n2 << 5) + Objects.hashCode(this.connectionNetworkId);
        n2 += (n2 << 5) + Objects.hashCode(this.connectionNetworkName);
        n2 += (n2 << 5) + Objects.hashCode(this.ipv4ActiveLeaseExpirationTimestampSeconds);
        n2 += (n2 << 5) + Objects.hashCode(this.lastConnectionNetworkId);
        n2 += (n2 << 5) + Objects.hashCode(this.lastConnectionNetworkName);
        n2 += (n2 << 5) + Objects.hashCode(this.stackingGroupId);
        n2 += (n2 << 5) + Objects.hashCode((java.lang.Object)this.type);
        n2 += (n2 << 5) + this.iconResolutions.hashCode();
        n2 += (n2 << 5) + Objects.hashCode(this.iconFilename);
        n2 += (n2 << 5) + this.icons.hashCode();
        n2 += (n2 << 5) + this.state;
        n2 += (n2 << 5) + Boolean.hashCode(this.isWired);
        n2 += (n2 << 5) + Objects.hashCode(this.wiredSpeedMegabitsPerSecond);
        n2 += (n2 << 5) + Objects.hashCode((java.lang.Object)this.firmwareStatus);
        n2 += (n2 << 5) + Objects.hashCode(this.essid);
        n2 += (n2 << 5) + Objects.hashCode(this.rateImbalance);
        n2 += (n2 << 5) + Objects.hashCode(this.uplinkMac);
        n2 += (n2 << 5) + Objects.hashCode(this.uplinkRadioBand);
        n2 += (n2 << 5) + Boolean.hashCode(this.viewInApplication);
        n2 += (n2 << 5) + this.tags.hashCode();
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ClientDeviceDto{");
        if (this.id != null) {
            stringBuilder.append("id=").append(this.id);
        }
        if (this.mac != null) {
            if (stringBuilder.length() > 16) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("mac=").append(this.mac);
        }
        if (stringBuilder.length() > 16) {
            stringBuilder.append(", ");
        }
        stringBuilder.append("isDefault=").append(this.isDefault);
        if (this.name != null) {
            stringBuilder.append(", ");
            stringBuilder.append("name=").append(this.name);
        }
        if (this.modelShortname != null) {
            stringBuilder.append(", ");
            stringBuilder.append("modelShortname=").append(this.modelShortname);
        }
        if (this.ipAddress != null) {
            stringBuilder.append(", ");
            stringBuilder.append("ipAddress=").append(this.ipAddress);
        }
        if (this.experience != null) {
            stringBuilder.append(", ");
            stringBuilder.append("experience=").append(this.experience);
        }
        if (this.version != null) {
            stringBuilder.append(", ");
            stringBuilder.append("version=").append(this.version);
        }
        if (this.displayableVersion != null) {
            stringBuilder.append(", ");
            stringBuilder.append("displayableVersion=").append(this.displayableVersion);
        }
        if (this.usageBytes != null) {
            stringBuilder.append(", ");
            stringBuilder.append("usageBytes=").append(this.usageBytes);
        }
        if (this.downloadSpeedBytesPerSecond != null) {
            stringBuilder.append(", ");
            stringBuilder.append("downloadSpeedBytesPerSecond=").append(this.downloadSpeedBytesPerSecond);
        }
        if (this.uploadSpeedBytesPerSecond != null) {
            stringBuilder.append(", ");
            stringBuilder.append("uploadSpeedBytesPerSecond=").append(this.uploadSpeedBytesPerSecond);
        }
        if (this.uptimeSeconds != null) {
            stringBuilder.append(", ");
            stringBuilder.append("uptimeSeconds=").append(this.uptimeSeconds);
        }
        if (this.productLine != null) {
            stringBuilder.append(", ");
            stringBuilder.append("productLine=").append((java.lang.Object)this.productLine);
        }
        if (this.lastSeenTimestampSeconds != null) {
            stringBuilder.append(", ");
            stringBuilder.append("lastSeenTimestampSeconds=").append(this.lastSeenTimestampSeconds);
        }
        if (this.connectionNetworkId != null) {
            stringBuilder.append(", ");
            stringBuilder.append("connectionNetworkId=").append(this.connectionNetworkId);
        }
        if (this.connectionNetworkName != null) {
            stringBuilder.append(", ");
            stringBuilder.append("connectionNetworkName=").append(this.connectionNetworkName);
        }
        if (this.ipv4ActiveLeaseExpirationTimestampSeconds != null) {
            stringBuilder.append(", ");
            stringBuilder.append("ipv4ActiveLeaseExpirationTimestampSeconds=").append(this.ipv4ActiveLeaseExpirationTimestampSeconds);
        }
        if (this.lastConnectionNetworkId != null) {
            stringBuilder.append(", ");
            stringBuilder.append("lastConnectionNetworkId=").append(this.lastConnectionNetworkId);
        }
        if (this.lastConnectionNetworkName != null) {
            stringBuilder.append(", ");
            stringBuilder.append("lastConnectionNetworkName=").append(this.lastConnectionNetworkName);
        }
        if (this.stackingGroupId != null) {
            stringBuilder.append(", ");
            stringBuilder.append("stackingGroupId=").append(this.stackingGroupId);
        }
        if (this.type != null) {
            stringBuilder.append(", ");
            stringBuilder.append("type=").append((java.lang.Object)this.type);
        }
        stringBuilder.append(", ");
        stringBuilder.append("iconResolutions=").append(this.iconResolutions);
        if (this.iconFilename != null) {
            stringBuilder.append(", ");
            stringBuilder.append("iconFilename=").append(this.iconFilename);
        }
        stringBuilder.append(", ");
        stringBuilder.append("icons=").append(this.icons);
        stringBuilder.append(", ");
        stringBuilder.append("state=").append(this.state);
        stringBuilder.append(", ");
        stringBuilder.append("isWired=").append(this.isWired);
        if (this.wiredSpeedMegabitsPerSecond != null) {
            stringBuilder.append(", ");
            stringBuilder.append("wiredSpeedMegabitsPerSecond=").append(this.wiredSpeedMegabitsPerSecond);
        }
        if (this.firmwareStatus != null) {
            stringBuilder.append(", ");
            stringBuilder.append("firmwareStatus=").append((java.lang.Object)this.firmwareStatus);
        }
        if (this.essid != null) {
            stringBuilder.append(", ");
            stringBuilder.append("essid=").append(this.essid);
        }
        if (this.rateImbalance != null) {
            stringBuilder.append(", ");
            stringBuilder.append("rateImbalance=").append(this.rateImbalance);
        }
        if (this.uplinkMac != null) {
            stringBuilder.append(", ");
            stringBuilder.append("uplinkMac=").append(this.uplinkMac);
        }
        if (this.uplinkRadioBand != null) {
            stringBuilder.append(", ");
            stringBuilder.append("uplinkRadioBand=").append(this.uplinkRadioBand);
        }
        stringBuilder.append(", ");
        stringBuilder.append("viewInApplication=").append(this.viewInApplication);
        stringBuilder.append(", ");
        stringBuilder.append("tags=").append(this.tags);
        return stringBuilder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableClientDeviceDto \u00d2\u00f60000(_o _o2) {
        Builder builder = ImmutableClientDeviceDto.builder();
        if (_o2.\u00d4\u00f60000 != null) {
            builder.id(_o2.\u00d4\u00f60000);
        }
        if (_o2.\u00d6\u00f60000 != null) {
            builder.mac(_o2.\u00d6\u00f60000);
        }
        if (_o2.intreturn) {
            builder.isDefault(_o2.\u00d3\u00f80000);
        }
        if (_o2.\u00d3\u00f50000 != null) {
            builder.name(_o2.\u00d3\u00f50000);
        }
        if (_o2.\u00f8\u00f60000 != null) {
            builder.modelShortname(_o2.\u00f8\u00f60000);
        }
        if (_o2.\u00f8\u00f40000 != null) {
            builder.ipAddress(_o2.\u00f8\u00f40000);
        }
        if (_o2.voidvoid != null) {
            builder.experience(_o2.voidvoid);
        }
        if (_o2.supernull != null) {
            builder.version(_o2.supernull);
        }
        if (_o2.\u00d6\u00f80000 != null) {
            builder.displayableVersion(_o2.\u00d6\u00f80000);
        }
        if (_o2.\u00d2\u00f50000 != null) {
            builder.usageBytes(_o2.\u00d2\u00f50000);
        }
        if (_o2.\u00d8\u00f60000 != null) {
            builder.downloadSpeedBytesPerSecond(_o2.\u00d8\u00f60000);
        }
        if (_o2.\u00f4\u00f50000 != null) {
            builder.uploadSpeedBytesPerSecond(_o2.\u00f4\u00f50000);
        }
        if (_o2.\u00d8\u00f50000 != null) {
            builder.uptimeSeconds(_o2.\u00d8\u00f50000);
        }
        if (_o2.\u00f6\u00f50000 != null) {
            builder.productLine(_o2.\u00f6\u00f50000);
        }
        if (_o2.\u00f8\u00f50000 != null) {
            builder.lastSeenTimestampSeconds(_o2.\u00f8\u00f50000);
        }
        if (_o2.interfacereturn != null) {
            builder.connectionNetworkId(_o2.interfacereturn);
        }
        if (_o2.\u00d2\u00f80000 != null) {
            builder.connectionNetworkName(_o2.\u00d2\u00f80000);
        }
        if (_o2.\u00f6\u00f40000 != null) {
            builder.ipv4ActiveLeaseExpirationTimestampSeconds(_o2.\u00f6\u00f40000);
        }
        if (_o2.Objectvoid != null) {
            builder.lastConnectionNetworkId(_o2.Objectvoid);
        }
        if (_o2.\u00d6\u00f50000 != null) {
            builder.lastConnectionNetworkName(_o2.\u00d6\u00f50000);
        }
        if (_o2.O\u00f60000 != null) {
            builder.stackingGroupId(_o2.O\u00f60000);
        }
        if (_o2.intnull != null) {
            builder.type(_o2.intnull);
        }
        if (_o2.\u00d8\u00f40000 != null) {
            builder.addAllIconResolutions(_o2.\u00d8\u00f40000);
        }
        if (_o2.\u00f6\u00f60000 != null) {
            builder.iconFilename(_o2.\u00f6\u00f60000);
        }
        if (_o2.classnull != null) {
            builder.addAllIcons(_o2.classnull);
        }
        if (_o2.\u00f4\u00f60000) {
            builder.state(_o2.\u00f4\u00f80000);
        }
        if (_o2.publicvoid) {
            builder.isWired(_o2.floatvoid);
        }
        if (_o2.\u00f4\u00f40000 != null) {
            builder.wiredSpeedMegabitsPerSecond(_o2.\u00f4\u00f40000);
        }
        if (_o2.\u00d4\u00f50000 != null) {
            builder.firmwareStatus(_o2.\u00d4\u00f50000);
        }
        if (_o2.\u00d4\u00f80000 != null) {
            builder.essid(_o2.\u00d4\u00f80000);
        }
        if (_o2.O\u00f80000 != null) {
            builder.rateImbalance(_o2.O\u00f80000);
        }
        if (_o2.doreturn != null) {
            builder.uplinkMac(_o2.doreturn);
        }
        if (_o2.O\u00f50000 != null) {
            builder.uplinkRadioBand(_o2.O\u00f50000);
        }
        if (_o2.\u00d8\u00f80000) {
            builder.viewInApplication(_o2.\u00d3\u00f60000);
        }
        if (_o2.\u00d2\u00f60000 != null) {
            builder.addAllTags(_o2.\u00d2\u00f60000);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> returnvoid(Iterable<? extends T> iterable, boolean bl, boolean bl2) {
        ArrayList<T> arrayList;
        if (iterable instanceof Collection) {
            int n2 = ((Collection)iterable).size();
            if (n2 == 0) {
                return Collections.emptyList();
            }
            arrayList = new ArrayList(n2);
        } else {
            arrayList = new ArrayList<T>();
        }
        for (T t2 : iterable) {
            if (bl2 && t2 == null) continue;
            if (bl) {
                Objects.requireNonNull(t2, "element");
            }
            arrayList.add(t2);
        }
        return arrayList;
    }

    private static <T> List<T> \u00f8\u00f50000(boolean bl, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (bl) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T extends Enum<T>> Set<T> \u00f6\u00f50000(Iterable<T> iterable) {
        if (iterable instanceof EnumSet) {
            return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet)iterable));
        }
        List<T> list = ImmutableClientDeviceDto.returnvoid(iterable, true, false);
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton((Enum)list.get(0));
            }
        }
        return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }

    @Generated(from="ClientDeviceDto", generator="Immutables")
    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String mac;
        private boolean isDefault;
        @Nullable
        private String name;
        @Nullable
        private String modelShortname;
        @Nullable
        private String ipAddress;
        @Nullable
        private Integer experience;
        @Nullable
        private String version;
        @Nullable
        private String displayableVersion;
        @Nullable
        private Double usageBytes;
        @Nullable
        private Long downloadSpeedBytesPerSecond;
        @Nullable
        private Long uploadSpeedBytesPerSecond;
        @Nullable
        private Long uptimeSeconds;
        @Nullable
        private J productLine;
        @Nullable
        private Long lastSeenTimestampSeconds;
        @Nullable
        private String connectionNetworkId;
        @Nullable
        private String connectionNetworkName;
        @Nullable
        private Long ipv4ActiveLeaseExpirationTimestampSeconds;
        @Nullable
        private String lastConnectionNetworkId;
        @Nullable
        private String lastConnectionNetworkName;
        @Nullable
        private String stackingGroupId;
        @Nullable
        private DeviceType type;
        private List<List<Integer>> iconResolutions = new ArrayList<List<Integer>>();
        @Nullable
        private String iconFilename;
        private List<DeviceIconInfoDto> icons = new ArrayList<DeviceIconInfoDto>();
        private int state;
        private boolean isWired;
        @Nullable
        private Integer wiredSpeedMegabitsPerSecond;
        @Nullable
        private supersuper firmwareStatus;
        @Nullable
        private String essid;
        @Nullable
        private Integer rateImbalance;
        @Nullable
        private String uplinkMac;
        @Nullable
        private Object uplinkRadioBand;
        private boolean viewInApplication;
        private EnumSet<SearchTag> tags = EnumSet.noneOf(SearchTag.class);

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(UnifiDeviceDto unifiDeviceDto) {
            Objects.requireNonNull(unifiDeviceDto, "instance");
            this.o00000((short)0, unifiDeviceDto);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ClientDeviceDto clientDeviceDto) {
            Objects.requireNonNull(clientDeviceDto, "instance");
            this.o00000((short)0, clientDeviceDto);
            return this;
        }

        private void o00000(short s2, java.lang.Object object) {
            java.lang.Object object2;
            Optional<java.lang.Object> optional;
            Optional<java.lang.Object> optional2;
            java.lang.Object object3;
            Optional<java.lang.Object> optional3;
            Optional<java.lang.Object> optional4;
            Optional<java.lang.Object> optional5;
            java.lang.Object object4;
            UnifiDeviceDto unifiDeviceDto;
            if (object instanceof UnifiDeviceDto) {
                Optional<String> optional6;
                Optional<String> optional7;
                String string;
                Optional<String> optional8;
                Optional<String> optional9;
                J j2;
                String string2;
                Optional<String> optional10;
                Optional<Long> optional11;
                Optional<Long> optional12;
                unifiDeviceDto = (UnifiDeviceDto)object;
                object4 = unifiDeviceDto.downloadSpeedBytesPerSecond();
                if (((Optional)object4).isPresent()) {
                    this.downloadSpeedBytesPerSecond((Optional<Long>)object4);
                }
                if ((optional5 = unifiDeviceDto.lastConnectionNetworkId()).isPresent()) {
                    this.lastConnectionNetworkId(optional5);
                }
                if ((optional4 = unifiDeviceDto.lastSeenTimestampSeconds()).isPresent()) {
                    this.lastSeenTimestampSeconds(optional4);
                }
                if ((optional3 = unifiDeviceDto.lastConnectionNetworkName()).isPresent()) {
                    this.lastConnectionNetworkName(optional3);
                }
                if ((object3 = unifiDeviceDto.modelShortname()) != null) {
                    this.modelShortname((String)object3);
                }
                if ((optional2 = unifiDeviceDto.ipAddress()).isPresent()) {
                    this.ipAddress(optional2);
                }
                if ((optional = unifiDeviceDto.ipv4ActiveLeaseExpirationTimestampSeconds()).isPresent()) {
                    this.ipv4ActiveLeaseExpirationTimestampSeconds(optional);
                }
                if (((Optional)(object2 = unifiDeviceDto.experience())).isPresent()) {
                    this.experience((Optional<Integer>)object2);
                }
                if ((optional12 = unifiDeviceDto.uploadSpeedBytesPerSecond()).isPresent()) {
                    this.uploadSpeedBytesPerSecond(optional12);
                }
                if ((optional11 = unifiDeviceDto.uptimeSeconds()).isPresent()) {
                    this.uptimeSeconds(optional11);
                }
                if ((optional10 = unifiDeviceDto.version()).isPresent()) {
                    this.version(optional10);
                }
                if ((string2 = unifiDeviceDto.mac()) != null) {
                    this.mac(string2);
                }
                if ((j2 = unifiDeviceDto.productLine()) != null) {
                    this.productLine(j2);
                }
                this.isDefault(unifiDeviceDto.isDefault());
                Optional<String> optional13 = unifiDeviceDto.connectionNetworkName();
                if (optional13.isPresent()) {
                    this.connectionNetworkName(optional13);
                }
                if ((optional9 = unifiDeviceDto.connectionNetworkId()).isPresent()) {
                    this.connectionNetworkId(optional9);
                }
                if ((optional8 = unifiDeviceDto.stackingGroupId()).isPresent()) {
                    this.stackingGroupId(optional8);
                }
                if ((string = unifiDeviceDto.name()) != null) {
                    this.name(string);
                }
                if ((optional7 = unifiDeviceDto.id()).isPresent()) {
                    this.id(optional7);
                }
                this.state(unifiDeviceDto.state());
                Optional<Double> optional14 = unifiDeviceDto.usageBytes();
                if (optional14.isPresent()) {
                    this.usageBytes(optional14);
                }
                if ((optional6 = unifiDeviceDto.displayableVersion()).isPresent()) {
                    this.displayableVersion(optional6);
                }
            }
            if (object instanceof ClientDeviceDto) {
                unifiDeviceDto = (ClientDeviceDto)object;
                object4 = ((ClientDeviceDto)unifiDeviceDto).uplinkMac();
                if (object4 != null) {
                    this.uplinkMac((String)object4);
                }
                if ((optional5 = ((ClientDeviceDto)unifiDeviceDto).uplinkRadioBand()).isPresent()) {
                    this.uplinkRadioBand(optional5);
                }
                if ((optional4 = ((ClientDeviceDto)unifiDeviceDto).essid()).isPresent()) {
                    this.essid(optional4);
                }
                if ((optional3 = ((ClientDeviceDto)unifiDeviceDto).type()).isPresent()) {
                    this.type(optional3);
                }
                this.addAllIcons(((ClientDeviceDto)unifiDeviceDto).icons());
                this.viewInApplication(((ClientDeviceDto)unifiDeviceDto).viewInApplication());
                this.addAllTags(((ClientDeviceDto)unifiDeviceDto).tags());
                this.addAllIconResolutions(((ClientDeviceDto)unifiDeviceDto).iconResolutions());
                object3 = ((ClientDeviceDto)unifiDeviceDto).wiredSpeedMegabitsPerSecond();
                if (((Optional)object3).isPresent()) {
                    this.wiredSpeedMegabitsPerSecond((Optional<Integer>)object3);
                }
                this.isWired(((ClientDeviceDto)unifiDeviceDto).isWired());
                optional2 = ((ClientDeviceDto)unifiDeviceDto).rateImbalance();
                if (optional2.isPresent()) {
                    this.rateImbalance(optional2);
                }
                if ((optional = ((ClientDeviceDto)unifiDeviceDto).firmwareStatus()).isPresent()) {
                    this.firmwareStatus(optional);
                }
                if ((object2 = ((ClientDeviceDto)unifiDeviceDto).iconFilename()) != null) {
                    this.iconFilename((String)object2);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder id(@Nullable String string) {
            this.id = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(Optional<String> optional) {
            this.id = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mac(String string) {
            this.mac = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isDefault(boolean bl) {
            this.isDefault = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String string) {
            this.name = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder modelShortname(String string) {
            this.modelShortname = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ipAddress(@Nullable String string) {
            this.ipAddress = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ipAddress(Optional<String> optional) {
            this.ipAddress = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder experience(@Nullable Integer n2) {
            this.experience = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder experience(Optional<Integer> optional) {
            this.experience = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(@Nullable String string) {
            this.version = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(Optional<String> optional) {
            this.version = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder displayableVersion(@Nullable String string) {
            this.displayableVersion = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder displayableVersion(Optional<String> optional) {
            this.displayableVersion = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder usageBytes(@Nullable Double d2) {
            this.usageBytes = d2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder usageBytes(Optional<Double> optional) {
            this.usageBytes = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder downloadSpeedBytesPerSecond(@Nullable Long l2) {
            this.downloadSpeedBytesPerSecond = l2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder downloadSpeedBytesPerSecond(Optional<Long> optional) {
            this.downloadSpeedBytesPerSecond = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uploadSpeedBytesPerSecond(@Nullable Long l2) {
            this.uploadSpeedBytesPerSecond = l2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uploadSpeedBytesPerSecond(Optional<Long> optional) {
            this.uploadSpeedBytesPerSecond = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uptimeSeconds(@Nullable Long l2) {
            this.uptimeSeconds = l2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uptimeSeconds(Optional<Long> optional) {
            this.uptimeSeconds = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder productLine(J j2) {
            this.productLine = j2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastSeenTimestampSeconds(@Nullable Long l2) {
            this.lastSeenTimestampSeconds = l2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastSeenTimestampSeconds(Optional<Long> optional) {
            this.lastSeenTimestampSeconds = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder connectionNetworkId(@Nullable String string) {
            this.connectionNetworkId = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder connectionNetworkId(Optional<String> optional) {
            this.connectionNetworkId = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder connectionNetworkName(@Nullable String string) {
            this.connectionNetworkName = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder connectionNetworkName(Optional<String> optional) {
            this.connectionNetworkName = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ipv4ActiveLeaseExpirationTimestampSeconds(@Nullable Long l2) {
            this.ipv4ActiveLeaseExpirationTimestampSeconds = l2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ipv4ActiveLeaseExpirationTimestampSeconds(Optional<Long> optional) {
            this.ipv4ActiveLeaseExpirationTimestampSeconds = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastConnectionNetworkId(@Nullable String string) {
            this.lastConnectionNetworkId = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastConnectionNetworkId(Optional<String> optional) {
            this.lastConnectionNetworkId = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastConnectionNetworkName(@Nullable String string) {
            this.lastConnectionNetworkName = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastConnectionNetworkName(Optional<String> optional) {
            this.lastConnectionNetworkName = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder stackingGroupId(@Nullable String string) {
            this.stackingGroupId = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder stackingGroupId(Optional<String> optional) {
            this.stackingGroupId = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(@Nullable DeviceType deviceType) {
            this.type = deviceType;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(Optional<? extends DeviceType> optional) {
            this.type = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addIconResolutions(@Nullable List<Integer> list) {
            this.iconResolutions.add(list);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addIconResolutions(List<Integer> ... listArray) {
            for (List<Integer> list : listArray) {
                this.iconResolutions.add(list);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder iconResolutions(Iterable<? extends List<Integer>> iterable) {
            this.iconResolutions.clear();
            return this.addAllIconResolutions(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllIconResolutions(Iterable<? extends List<Integer>> iterable) {
            for (List<Integer> list : iterable) {
                this.iconResolutions.add(list);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder iconFilename(String string) {
            this.iconFilename = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addIcons(@Nullable DeviceIconInfoDto deviceIconInfoDto) {
            this.icons.add(deviceIconInfoDto);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addIcons(DeviceIconInfoDto ... deviceIconInfoDtoArray) {
            for (DeviceIconInfoDto deviceIconInfoDto : deviceIconInfoDtoArray) {
                this.icons.add(deviceIconInfoDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder icons(Iterable<? extends DeviceIconInfoDto> iterable) {
            this.icons.clear();
            return this.addAllIcons(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllIcons(Iterable<? extends DeviceIconInfoDto> iterable) {
            for (DeviceIconInfoDto deviceIconInfoDto : iterable) {
                this.icons.add(deviceIconInfoDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder state(int n2) {
            this.state = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isWired(boolean bl) {
            this.isWired = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder wiredSpeedMegabitsPerSecond(@Nullable Integer n2) {
            this.wiredSpeedMegabitsPerSecond = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder wiredSpeedMegabitsPerSecond(Optional<Integer> optional) {
            this.wiredSpeedMegabitsPerSecond = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder firmwareStatus(@Nullable supersuper supersuper2) {
            this.firmwareStatus = supersuper2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder firmwareStatus(Optional<? extends supersuper> optional) {
            this.firmwareStatus = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder essid(@Nullable String string) {
            this.essid = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder essid(Optional<String> optional) {
            this.essid = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rateImbalance(@Nullable Integer n2) {
            this.rateImbalance = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rateImbalance(Optional<Integer> optional) {
            this.rateImbalance = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uplinkMac(String string) {
            this.uplinkMac = string;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uplinkRadioBand(@Nullable Object object) {
            this.uplinkRadioBand = object;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uplinkRadioBand(Optional<? extends Object> optional) {
            this.uplinkRadioBand = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder viewInApplication(boolean bl) {
            this.viewInApplication = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(@Nullable SearchTag searchTag) {
            this.tags.add(searchTag);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTags(SearchTag ... searchTagArray) {
            for (SearchTag searchTag : searchTagArray) {
                this.tags.add(searchTag);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tags(Iterable<SearchTag> iterable) {
            this.tags.clear();
            return this.addAllTags(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTags(Iterable<SearchTag> iterable) {
            for (SearchTag searchTag : iterable) {
                this.tags.add(searchTag);
            }
            return this;
        }

        public ImmutableClientDeviceDto build() {
            return new ImmutableClientDeviceDto(this);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ClientDeviceDto", generator="Immutables")
    static final class _o
    extends ClientDeviceDto {
        @Nullable
        Optional<String> \u00d4\u00f60000 = Optional.empty();
        @Nullable
        String \u00d6\u00f60000;
        boolean \u00d3\u00f80000;
        boolean intreturn;
        @Nullable
        String \u00d3\u00f50000;
        @Nullable
        String \u00f8\u00f60000;
        @Nullable
        Optional<String> \u00f8\u00f40000 = Optional.empty();
        @Nullable
        Optional<Integer> voidvoid = Optional.empty();
        @Nullable
        Optional<String> supernull = Optional.empty();
        @Nullable
        Optional<String> \u00d6\u00f80000 = Optional.empty();
        @Nullable
        Optional<Double> \u00d2\u00f50000 = Optional.empty();
        @Nullable
        Optional<Long> \u00d8\u00f60000 = Optional.empty();
        @Nullable
        Optional<Long> \u00f4\u00f50000 = Optional.empty();
        @Nullable
        Optional<Long> \u00d8\u00f50000 = Optional.empty();
        @Nullable
        J \u00f6\u00f50000;
        @Nullable
        Optional<Long> \u00f8\u00f50000 = Optional.empty();
        @Nullable
        Optional<String> interfacereturn = Optional.empty();
        @Nullable
        Optional<String> \u00d2\u00f80000 = Optional.empty();
        @Nullable
        Optional<Long> \u00f6\u00f40000 = Optional.empty();
        @Nullable
        Optional<String> Objectvoid = Optional.empty();
        @Nullable
        Optional<String> \u00d6\u00f50000 = Optional.empty();
        @Nullable
        Optional<String> O\u00f60000 = Optional.empty();
        @Nullable
        Optional<DeviceType> intnull = Optional.empty();
        @Nullable
        List<List<Integer>> \u00d8\u00f40000 = Collections.emptyList();
        @Nullable
        String \u00f6\u00f60000;
        @Nullable
        List<DeviceIconInfoDto> classnull = Collections.emptyList();
        int \u00f4\u00f80000;
        boolean \u00f4\u00f60000;
        boolean floatvoid;
        boolean publicvoid;
        @Nullable
        Optional<Integer> \u00f4\u00f40000 = Optional.empty();
        @Nullable
        Optional<supersuper> \u00d4\u00f50000 = Optional.empty();
        @Nullable
        Optional<String> \u00d4\u00f80000 = Optional.empty();
        @Nullable
        Optional<Integer> O\u00f80000 = Optional.empty();
        @Nullable
        String doreturn;
        @Nullable
        Optional<Object> O\u00f50000 = Optional.empty();
        boolean \u00d3\u00f60000;
        boolean \u00d8\u00f80000;
        @Nullable
        Set<SearchTag> \u00d2\u00f60000 = Collections.emptySet();

        _o() {
        }

        @JsonProperty(value="_id")
        @Schema(name="Object Id")
        public void \u00d2\u00f50000(Optional<String> optional) {
            this.\u00d4\u00f60000 = optional;
        }

        @JsonProperty(value="mac")
        @Schema(name="MAC address")
        public void o\u00f40000(String string) {
            this.\u00d6\u00f60000 = string;
        }

        @JsonProperty(value="default")
        public void Stringreturn(boolean bl) {
            this.\u00d3\u00f80000 = bl;
            this.intreturn = true;
        }

        @JsonProperty(value="name")
        @Schema(name="Device name")
        public void ifclass(String string) {
            this.\u00d3\u00f50000 = string;
        }

        @JsonProperty(value="model")
        @Schema(name="Device model shortname")
        public void privatereturn(String string) {
            this.\u00f8\u00f60000 = string;
        }

        @JsonProperty(value="ip")
        @Schema(name="IP address")
        public void \u00f5\u00f50000(Optional<String> optional) {
            this.\u00f8\u00f40000 = optional;
        }

        @JsonProperty(value="satisfaction")
        @Schema(name="Experience", example="99")
        public void \u00f5\u00f40000(Optional<Integer> optional) {
            this.voidvoid = optional;
        }

        @JsonProperty(value="version")
        @Schema(name="Firmware version")
        public void \u00d5\u00f50000(Optional<String> optional) {
            this.supernull = optional;
        }

        @JsonProperty(value="displayable_version")
        @Schema(name="Firmware version in user friendly form")
        public void \u00f6\u00f40000(Optional<String> optional) {
            this.\u00d6\u00f80000 = optional;
        }

        @JsonProperty(value="usage_bytes")
        @Schema(name="24h usage in bytes per second")
        public void \u00d2\u00d80000(Optional<Double> optional) {
            this.\u00d2\u00f50000 = optional;
        }

        @JsonProperty(value="download_speed_bytes_per_second")
        @Schema(name="Download speed in bytes per second", example="1024")
        public void \u00d8\u00f50000(Optional<Long> optional) {
            this.\u00d8\u00f60000 = optional;
        }

        @JsonProperty(value="upload_speed_bytes_per_second")
        @Schema(name="Upload speed in bytes", example="512")
        public void \u00d8\u00d80000(Optional<Long> optional) {
            this.\u00f4\u00f50000 = optional;
        }

        @JsonProperty(value="uptime")
        @Schema(name="Uptime in seconds", example="120")
        public void \u00d3\u00f40000(Optional<Long> optional) {
            this.\u00d8\u00f50000 = optional;
        }

        @JsonProperty(value="product_line")
        @Schema(name="Controller that could manage this device")
        public void \u00f8\u00d60000(J j2) {
            this.\u00f6\u00f50000 = j2;
        }

        @JsonProperty(value="last_seen")
        @Schema(description="Information about when the device was seen for the last time in unix timestamp in seconds")
        public void nullreturn(Optional<Long> optional) {
            this.\u00f8\u00f50000 = optional;
        }

        @JsonProperty(value="connection_network_id")
        @Schema(name="Network id where the device is connected to")
        public void \u00d6\u00f50000(Optional<String> optional) {
            this.interfacereturn = optional;
        }

        @JsonProperty(value="connection_network_name")
        @Schema(name="Network name where the device is connected to")
        public void o\u00d80000(Optional<String> optional) {
            this.\u00d2\u00f80000 = optional;
        }

        @JsonProperty(value="ipv4_lease_expiration_timestamp_seconds")
        @Schema(name="Device ip v4 lease expiration timestamp in seconds")
        public void \u00d5\u00d80000(Optional<Long> optional) {
            this.\u00f6\u00f40000 = optional;
        }

        @JsonProperty(value="last_connection_network_id")
        public void \u00f5\u00d80000(Optional<String> optional) {
            this.Objectvoid = optional;
        }

        @JsonProperty(value="last_connection_network_name")
        public void \u00f8\u00f40000(Optional<String> optional) {
            this.\u00d6\u00f50000 = optional;
        }

        @JsonProperty(value="stacking_group_id")
        @Schema(name="Stacking group that the device belongs to")
        public void returnclass(Optional<String> optional) {
            this.O\u00f60000 = optional;
        }

        @JsonProperty(value="type")
        public void \u00d2\u00f40000(Optional<DeviceType> optional) {
            this.intnull = optional;
        }

        @JsonProperty(value="icon_resolutions")
        public void whileclass(List<List<Integer>> list) {
            this.\u00d8\u00f40000 = list;
        }

        @JsonProperty(value="icon_filename")
        public void \u00d6\u00d80000(String string) {
            this.\u00f6\u00f60000 = string;
        }

        @JsonProperty(value="icons")
        public void \u00d6\u00f40000(List<DeviceIconInfoDto> list) {
            this.classnull = list;
        }

        @JsonProperty(value="state")
        public void \u00d5\u00f40000(int n2) {
            this.\u00f4\u00f80000 = n2;
            this.\u00f4\u00f60000 = true;
        }

        @JsonProperty(value="is_wired")
        public void newvoid(boolean bl) {
            this.floatvoid = bl;
            this.publicvoid = true;
        }

        @JsonProperty(value="wired_speed_megabits_per_second")
        public void \u00d3\u00f50000(Optional<Integer> optional) {
            this.\u00f4\u00f40000 = optional;
        }

        @JsonProperty(value="firmware_status")
        public void forreturn(Optional<supersuper> optional) {
            this.\u00d4\u00f50000 = optional;
        }

        @JsonProperty(value="essid")
        public void \u00f8\u00d80000(Optional<String> optional) {
            this.\u00d4\u00f80000 = optional;
        }

        @JsonProperty(value="rate_imbalance")
        @Schema(description="Imbalance in percent between rate of the client and its uplink. Possible values [-100;100]. 0 indicates perfect balance, negative values - higher client rate. Since 7.3.26", example="-40")
        public void \u00f6\u00d80000(Optional<Integer> optional) {
            this.O\u00f80000 = optional;
        }

        @JsonProperty(value="uplink_mac")
        public void o\u00f50000(String string) {
            this.doreturn = string;
        }

        @JsonProperty(value="uplink_radio_band")
        public void \u00d3\u00d80000(Optional<Object> optional) {
            this.O\u00f50000 = optional;
        }

        @JsonProperty(value="view_in_application")
        public void thisreturn(boolean bl) {
            this.\u00d3\u00f60000 = bl;
            this.\u00d8\u00f80000 = true;
        }

        @JsonProperty(value="tags")
        public void \u00d8\u00f40000(Set<SearchTag> set) {
            this.\u00d2\u00f60000 = set;
        }

        @Override
        public Optional<String> id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String mac() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDefault() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String modelShortname() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> ipAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> experience() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> version() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> displayableVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Double> usageBytes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> downloadSpeedBytesPerSecond() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> uploadSpeedBytesPerSecond() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> uptimeSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public J productLine() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> lastSeenTimestampSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> connectionNetworkId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> connectionNetworkName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> ipv4ActiveLeaseExpirationTimestampSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> lastConnectionNetworkId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> lastConnectionNetworkName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> stackingGroupId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<DeviceType> type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<List<Integer>> iconResolutions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String iconFilename() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<DeviceIconInfoDto> icons() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int state() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isWired() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> wiredSpeedMegabitsPerSecond() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<supersuper> firmwareStatus() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> essid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> rateImbalance() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String uplinkMac() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Object> uplinkRadioBand() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean viewInApplication() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<SearchTag> tags() {
            throw new UnsupportedOperationException();
        }
    }
}

