/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.firewall.policy;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.class.F;
import com.ubnt.model.M.B;
import com.ubnt.model.api.firewall.policy.ImmutableFirewallPolicyScheduleDto;
import com.ubnt.net.v2.validation.constraints.Time24Hours;
import com.ubnt.service.firewall.policy.FirewallPolicyScheduleDocumentPart;
import com.ubnt.service.firewall.policy.ooOO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=ImmutableFirewallPolicyScheduleDto.Builder.class)
@Value.Immutable
@F
public interface FirewallPolicyScheduleDto {
    @JsonProperty(value="mode")
    @NotNull
    public ooOO mode();

    @JsonProperty(value="repeat_on_days")
    @Schema(description="Repeat on on days. Applicable to: EVERY_WEEK, CUSTOM", example="[\"sun\"]")
    public List<B> repeatOnDays();

    @JsonProperty(value="time_all_day")
    @Schema(description="Rule will be running for all day. Time range start/end are ignored. Applicable to: EVERY_WEEK, CUSTOM")
    public boolean allDay();

    @JsonProperty(value="time_range_start")
    @Schema(description="Start time in 24 hours format. Applicable to: EVERY_DAY, EVERY_WEEK, ONE_TIME_ONLY, CUSTOM", example="11:30")
    public Optional<@Time24Hours String> timeRangeStart();

    @JsonProperty(value="time_range_end")
    @Schema(description="End time in 24 hours format. It accepts 24:00 as end of the day. Applicable to: EVERY_DAY, EVERY_WEEK, ONE_TIME_ONLY, CUSTOM", example="21:15")
    public Optional<@Time24Hours(accept2400=true) String> timeRangeEnd();

    @JsonProperty(value="date")
    @Schema(description="Start date. Applicable to: ONE_TIME_ONLY", example="2021-07-13")
    public Optional<LocalDate> date();

    @JsonProperty(value="date_start")
    @Schema(name="Start date. Applicable to: CUSTOM", example="2021-07-13")
    public Optional<LocalDate> dateStart();

    @JsonProperty(value="date_end")
    @Schema(name="End date. Applicable to: CUSTOM", example="2021-08-14")
    public Optional<LocalDate> dateEnd();

    default public FirewallPolicyScheduleDocumentPart toDocument() {
        return FirewallPolicyScheduleDocumentPart.builder().\u00d300000(this.mode()).null(this.repeatOnDays()).\u00d800000(this.allDay()).\u00d500000(this.timeRangeStart().orElse(null)).\u00f600000(this.timeRangeEnd().orElse(null)).\u00d600000(this.date().orElse(null)).o00000(this.dateStart().orElse(null)).\u00d200000(this.dateEnd().orElse(null)).for();
    }

    public static FirewallPolicyScheduleDto fromDocument(FirewallPolicyScheduleDocumentPart firewallPolicyScheduleDocumentPart) {
        return ImmutableFirewallPolicyScheduleDto.builder().mode(firewallPolicyScheduleDocumentPart.getMode()).repeatOnDays(firewallPolicyScheduleDocumentPart.getRepeatOnDays()).allDay(firewallPolicyScheduleDocumentPart.isAllDay()).timeRangeStart(firewallPolicyScheduleDocumentPart.getTimeRangeStart()).timeRangeEnd(firewallPolicyScheduleDocumentPart.getTimeRangeEnd()).date(firewallPolicyScheduleDocumentPart.getDate()).dateStart(firewallPolicyScheduleDocumentPart.getDateStart()).dateEnd(firewallPolicyScheduleDocumentPart.getDateEnd()).build();
    }

    public static FirewallPolicyScheduleDto always() {
        return ImmutableFirewallPolicyScheduleDto.builder().mode(ooOO.\u00d500000).build();
    }

    public static ImmutableFirewallPolicyScheduleDto.Builder builder() {
        return ImmutableFirewallPolicyScheduleDto.builder();
    }
}

