/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.ospf;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.model.api.ospf.OspfAuthenticationType;
import com.ubnt.model.api.ospf.OspfInterfaceDto;
import com.ubnt.model.api.ospf.OspfMd5AuthKeyDto;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Schema(name="OSPF Interface")
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Generated(from="OspfInterfaceDto", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableOspfInterfaceDto
implements OspfInterfaceDto {
    private final String networkId;
    private final int cost;
    private final OspfAuthenticationType authenticationType;
    @Nullable
    private final String plainTextAuthenticationKey;
    @Nullable
    private final List<OspfMd5AuthKeyDto> md5AuthenticationKeys;
    private final boolean passiveInterface;
    private final int priority;
    @Nullable
    private final Integer helloInterval;
    @Nullable
    private final Integer deadInterval;

    private ImmutableOspfInterfaceDto(Builder builder) {
        this.networkId = builder.networkId;
        this.cost = builder.cost;
        this.authenticationType = builder.authenticationType;
        this.plainTextAuthenticationKey = builder.plainTextAuthenticationKey;
        this.md5AuthenticationKeys = builder.md5AuthenticationKeys;
        this.passiveInterface = builder.passiveInterface;
        this.priority = builder.priority;
        this.helloInterval = builder.helloInterval;
        this.deadInterval = builder.deadInterval;
    }

    @Override
    @JsonProperty(value="network_id")
    @NotEmpty
    public String networkId() {
        return this.networkId;
    }

    @Override
    @JsonProperty(value="cost")
    @Min(value=1L)
    @Max(value=65535L)
    public @Min(value=1L) @Max(value=65535L) int cost() {
        return this.cost;
    }

    @Override
    @JsonProperty(value="authentication_type")
    @NotNull
    public OspfAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    @Override
    @JsonProperty(value="plain_text_authentication_key")
    public Optional<String> plainTextAuthenticationKey() {
        return Optional.ofNullable(this.plainTextAuthenticationKey);
    }

    @Override
    @JsonProperty(value="md5_authentication_keys")
    public Optional<List<OspfMd5AuthKeyDto>> md5AuthenticationKeys() {
        return Optional.ofNullable(this.md5AuthenticationKeys);
    }

    @Override
    @JsonProperty(value="passive_interface")
    public boolean passiveInterface() {
        return this.passiveInterface;
    }

    @Override
    @JsonProperty(value="priority")
    @Min(value=1L)
    public @Min(value=1L) int priority() {
        return this.priority;
    }

    @Override
    @JsonProperty(value="hello_interval")
    public Optional<Integer> helloInterval() {
        return Optional.ofNullable(this.helloInterval);
    }

    @Override
    @JsonProperty(value="dead_interval")
    public Optional<Integer> deadInterval() {
        return Optional.ofNullable(this.deadInterval);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableOspfInterfaceDto && this.\u00d200000(0, (ImmutableOspfInterfaceDto)object);
    }

    private boolean \u00d200000(int n2, ImmutableOspfInterfaceDto immutableOspfInterfaceDto) {
        return Objects.equals(this.networkId, immutableOspfInterfaceDto.networkId) && this.cost == immutableOspfInterfaceDto.cost && Objects.equals((Object)this.authenticationType, (Object)immutableOspfInterfaceDto.authenticationType) && Objects.equals(this.plainTextAuthenticationKey, immutableOspfInterfaceDto.plainTextAuthenticationKey) && Objects.equals(this.md5AuthenticationKeys, immutableOspfInterfaceDto.md5AuthenticationKeys) && this.passiveInterface == immutableOspfInterfaceDto.passiveInterface && this.priority == immutableOspfInterfaceDto.priority && Objects.equals(this.helloInterval, immutableOspfInterfaceDto.helloInterval) && Objects.equals(this.deadInterval, immutableOspfInterfaceDto.deadInterval);
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + Objects.hashCode(this.networkId);
        n2 += (n2 << 5) + this.cost;
        n2 += (n2 << 5) + Objects.hashCode((Object)this.authenticationType);
        n2 += (n2 << 5) + Objects.hashCode(this.plainTextAuthenticationKey);
        n2 += (n2 << 5) + Objects.hashCode(this.md5AuthenticationKeys);
        n2 += (n2 << 5) + Boolean.hashCode(this.passiveInterface);
        n2 += (n2 << 5) + this.priority;
        n2 += (n2 << 5) + Objects.hashCode(this.helloInterval);
        n2 += (n2 << 5) + Objects.hashCode(this.deadInterval);
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("OspfInterfaceDto{");
        if (this.networkId != null) {
            stringBuilder.append("networkId=").append(this.networkId);
        }
        if (stringBuilder.length() > 17) {
            stringBuilder.append(", ");
        }
        stringBuilder.append("cost=").append(this.cost);
        if (this.authenticationType != null) {
            stringBuilder.append(", ");
            stringBuilder.append("authenticationType=").append((Object)this.authenticationType);
        }
        if (this.plainTextAuthenticationKey != null) {
            stringBuilder.append(", ");
            stringBuilder.append("plainTextAuthenticationKey=").append(this.plainTextAuthenticationKey);
        }
        if (this.md5AuthenticationKeys != null) {
            stringBuilder.append(", ");
            stringBuilder.append("md5AuthenticationKeys=").append(this.md5AuthenticationKeys);
        }
        stringBuilder.append(", ");
        stringBuilder.append("passiveInterface=").append(this.passiveInterface);
        stringBuilder.append(", ");
        stringBuilder.append("priority=").append(this.priority);
        if (this.helloInterval != null) {
            stringBuilder.append(", ");
            stringBuilder.append("helloInterval=").append(this.helloInterval);
        }
        if (this.deadInterval != null) {
            stringBuilder.append(", ");
            stringBuilder.append("deadInterval=").append(this.deadInterval);
        }
        return stringBuilder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOspfInterfaceDto \u00d300000(_o _o2) {
        Builder builder = ImmutableOspfInterfaceDto.builder();
        if (_o2.float != null) {
            builder.networkId(_o2.float);
        }
        if (_o2.\u00d400000) {
            builder.cost(_o2.o00000);
        }
        if (_o2.\u00f400000 != null) {
            builder.authenticationType(_o2.\u00f400000);
        }
        if (_o2.\u00f500000 != null) {
            builder.plainTextAuthenticationKey(_o2.\u00f500000);
        }
        if (_o2.\u00f600000 != null) {
            builder.md5AuthenticationKeys(_o2.\u00f600000);
        }
        if (_o2.Object) {
            builder.passiveInterface(_o2.\u00d200000);
        }
        if (_o2.\u00d600000) {
            builder.priority(_o2.void);
        }
        if (_o2.\u00d500000 != null) {
            builder.helloInterval(_o2.\u00d500000);
        }
        if (_o2.OO0000 != null) {
            builder.deadInterval(_o2.OO0000);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OspfInterfaceDto", generator="Immutables")
    public static final class Builder {
        @Nullable
        private String networkId;
        private int cost;
        @Nullable
        private OspfAuthenticationType authenticationType;
        @Nullable
        private String plainTextAuthenticationKey;
        @Nullable
        private List<OspfMd5AuthKeyDto> md5AuthenticationKeys;
        private boolean passiveInterface;
        private int priority;
        @Nullable
        private Integer helloInterval;
        @Nullable
        private Integer deadInterval;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OspfInterfaceDto ospfInterfaceDto) {
            Optional<Integer> optional;
            Optional<List<OspfMd5AuthKeyDto>> optional2;
            Optional<String> optional3;
            Objects.requireNonNull(ospfInterfaceDto, "instance");
            String string = ospfInterfaceDto.networkId();
            if (string != null) {
                this.networkId(string);
            }
            this.cost(ospfInterfaceDto.cost());
            OspfAuthenticationType ospfAuthenticationType = ospfInterfaceDto.authenticationType();
            if (ospfAuthenticationType != null) {
                this.authenticationType(ospfAuthenticationType);
            }
            if ((optional3 = ospfInterfaceDto.plainTextAuthenticationKey()).isPresent()) {
                this.plainTextAuthenticationKey(optional3);
            }
            if ((optional2 = ospfInterfaceDto.md5AuthenticationKeys()).isPresent()) {
                this.md5AuthenticationKeys(optional2);
            }
            this.passiveInterface(ospfInterfaceDto.passiveInterface());
            this.priority(ospfInterfaceDto.priority());
            Optional<Integer> optional4 = ospfInterfaceDto.helloInterval();
            if (optional4.isPresent()) {
                this.helloInterval(optional4);
            }
            if ((optional = ospfInterfaceDto.deadInterval()).isPresent()) {
                this.deadInterval(optional);
            }
            return this;
        }

        @JsonProperty(value="network_id")
        @CanIgnoreReturnValue
        public final Builder networkId(String string) {
            this.networkId = string;
            return this;
        }

        @JsonProperty(value="cost")
        @CanIgnoreReturnValue
        public final Builder cost(int n2) {
            this.cost = n2;
            return this;
        }

        @JsonProperty(value="authentication_type")
        @CanIgnoreReturnValue
        public final Builder authenticationType(OspfAuthenticationType ospfAuthenticationType) {
            this.authenticationType = ospfAuthenticationType;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder plainTextAuthenticationKey(@Nullable String string) {
            this.plainTextAuthenticationKey = string;
            return this;
        }

        @JsonProperty(value="plain_text_authentication_key")
        @CanIgnoreReturnValue
        public final Builder plainTextAuthenticationKey(Optional<String> optional) {
            this.plainTextAuthenticationKey = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder md5AuthenticationKeys(@Nullable List<OspfMd5AuthKeyDto> list) {
            this.md5AuthenticationKeys = list;
            return this;
        }

        @JsonProperty(value="md5_authentication_keys")
        @CanIgnoreReturnValue
        public final Builder md5AuthenticationKeys(Optional<? extends List<OspfMd5AuthKeyDto>> optional) {
            this.md5AuthenticationKeys = optional.orElse(null);
            return this;
        }

        @JsonProperty(value="passive_interface")
        @CanIgnoreReturnValue
        public final Builder passiveInterface(boolean bl) {
            this.passiveInterface = bl;
            return this;
        }

        @JsonProperty(value="priority")
        @CanIgnoreReturnValue
        public final Builder priority(int n2) {
            this.priority = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder helloInterval(@Nullable Integer n2) {
            this.helloInterval = n2;
            return this;
        }

        @JsonProperty(value="hello_interval")
        @CanIgnoreReturnValue
        public final Builder helloInterval(Optional<Integer> optional) {
            this.helloInterval = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deadInterval(@Nullable Integer n2) {
            this.deadInterval = n2;
            return this;
        }

        @JsonProperty(value="dead_interval")
        @CanIgnoreReturnValue
        public final Builder deadInterval(Optional<Integer> optional) {
            this.deadInterval = optional.orElse(null);
            return this;
        }

        public ImmutableOspfInterfaceDto build() {
            return new ImmutableOspfInterfaceDto(this);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="OspfInterfaceDto", generator="Immutables")
    static final class _o
    implements OspfInterfaceDto {
        @Nullable
        String float;
        int o00000;
        boolean \u00d400000;
        @Nullable
        OspfAuthenticationType \u00f400000;
        @Nullable
        Optional<String> \u00f500000 = Optional.empty();
        @Nullable
        Optional<List<OspfMd5AuthKeyDto>> \u00f600000 = Optional.empty();
        boolean \u00d200000;
        boolean Object;
        int void;
        boolean \u00d600000;
        @Nullable
        Optional<Integer> \u00d500000 = Optional.empty();
        @Nullable
        Optional<Integer> OO0000 = Optional.empty();

        _o() {
        }

        @JsonProperty(value="network_id")
        @NotEmpty
        public void OO0000(String string) {
            this.float = string;
        }

        @JsonProperty(value="cost")
        @Min(value=1L)
        @Max(value=65535L)
        public void class(int n2) {
            this.o00000 = n2;
            this.\u00d400000 = true;
        }

        @JsonProperty(value="authentication_type")
        @NotNull
        public void \u00d800000(OspfAuthenticationType ospfAuthenticationType) {
            this.\u00f400000 = ospfAuthenticationType;
        }

        @JsonProperty(value="plain_text_authentication_key")
        public void \u00f800000(Optional<String> optional) {
            this.\u00f500000 = optional;
        }

        @JsonProperty(value="md5_authentication_keys")
        public void \u00f400000(Optional<List<OspfMd5AuthKeyDto>> optional) {
            this.\u00f600000 = optional;
        }

        @JsonProperty(value="passive_interface")
        public void \u00d400000(boolean bl) {
            this.\u00d200000 = bl;
            this.Object = true;
        }

        @JsonProperty(value="priority")
        @Min(value=1L)
        public void int(int n2) {
            this.void = n2;
            this.\u00d600000 = true;
        }

        @JsonProperty(value="hello_interval")
        public void \u00d600000(Optional<Integer> optional) {
            this.\u00d500000 = optional;
        }

        @JsonProperty(value="dead_interval")
        public void \u00f600000(Optional<Integer> optional) {
            this.OO0000 = optional;
        }

        @Override
        public String networkId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int cost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OspfAuthenticationType authenticationType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> plainTextAuthenticationKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<OspfMd5AuthKeyDto>> md5AuthenticationKeys() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean passiveInterface() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int priority() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> helloInterval() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> deadInterval() {
            throw new UnsupportedOperationException();
        }
    }
}

