/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.wlan;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.data.X;
import com.ubnt.model.M.B;
import com.ubnt.model.null.F;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Schema(name="WLAN schedule configuration entry", description="Supports duration in minutes")
public class WlanScheduleConfigurationEntry {
    @JsonProperty(value="start_days_of_week")
    @Schema(required=true)
    @NotEmpty
    private List<B> startDaysOfWeek;
    @JsonProperty(value="start_hour")
    @Schema(required=true, example="1")
    @Min(value=0L)
    @Max(value=23L)
    @NotNull
    private @Min(value=0L) @Max(value=23L) @NotNull Integer startHour;
    @JsonProperty(value="start_minute")
    @Schema(required=true, example="1")
    @Min(value=0L)
    @Max(value=59L)
    @NotNull
    private @Min(value=0L) @Max(value=59L) @NotNull Integer startMinute;
    @JsonProperty(value="duration_minutes")
    @Schema(required=true, example="1")
    @Min(value=1L)
    @NotNull
    private @Min(value=1L) @NotNull int durationMinutes;
    @JsonProperty(value="name")
    private String name;

    public List<B> getStartDaysOfWeek() {
        return this.startDaysOfWeek;
    }

    public WlanScheduleConfigurationEntry setStartDaysOfWeek(List<B> list) {
        this.startDaysOfWeek = list;
        return this;
    }

    public Integer getStartHour() {
        return Optional.ofNullable(this.startHour).orElse(0);
    }

    public WlanScheduleConfigurationEntry setStartHour(@Nullable Integer n2) {
        this.startHour = n2;
        return this;
    }

    public Integer getStartMinute() {
        return Optional.ofNullable(this.startMinute).orElse(0);
    }

    public WlanScheduleConfigurationEntry setStartMinute(@Nullable Integer n2) {
        this.startMinute = n2;
        return this;
    }

    public Integer getDurationMinutes() {
        return this.durationMinutes;
    }

    public WlanScheduleConfigurationEntry setDurationMinutes(int n2) {
        this.durationMinutes = n2;
        return this;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public WlanScheduleConfigurationEntry setName(String string) {
        this.name = string;
        return this;
    }

    public static WlanScheduleConfigurationEntry fromLegacy(X x2) {
        return WlanScheduleConfigurationEntry.super().if(x2);
    }

    public X toLegacy() {
        return WlanScheduleConfigurationEntry.super().\u00f500000(this);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("startDaysOfWeek", this.startDaysOfWeek).append("startHour", (Object)this.startHour).append("startMinute", (Object)this.startMinute).append("durationMinutes", this.durationMinutes).append("name", (Object)this.name).toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        WlanScheduleConfigurationEntry wlanScheduleConfigurationEntry = (WlanScheduleConfigurationEntry)object;
        return this.durationMinutes == wlanScheduleConfigurationEntry.durationMinutes && this.startDaysOfWeek.equals(wlanScheduleConfigurationEntry.startDaysOfWeek) && Objects.equals(this.startHour, wlanScheduleConfigurationEntry.startHour) && Objects.equals(this.startMinute, wlanScheduleConfigurationEntry.startMinute) && Objects.equals(this.name, wlanScheduleConfigurationEntry.name);
    }

    public int hashCode() {
        return Objects.hash(this.startDaysOfWeek, this.startHour, this.startMinute, this.durationMinutes, this.name);
    }

    private static F<WlanScheduleConfigurationEntry, X> super() {
        return F.new(WlanScheduleConfigurationEntry.class, X.class).for("start_days_of_week", WlanScheduleConfigurationEntry::getStartDaysOfWeek, WlanScheduleConfigurationEntry::setStartDaysOfWeek, B.class).null("start_hour", WlanScheduleConfigurationEntry::getStartHour, WlanScheduleConfigurationEntry::setStartHour).null("start_minute", WlanScheduleConfigurationEntry::getStartMinute, WlanScheduleConfigurationEntry::setStartMinute).null("duration_minutes", WlanScheduleConfigurationEntry::getDurationMinutes, WlanScheduleConfigurationEntry::setDurationMinutes).\u00d2O0000("name", WlanScheduleConfigurationEntry::getName, WlanScheduleConfigurationEntry::setName).\u00f600000();
    }
}

