/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2;

import com.ubnt.data.Site;
import com.ubnt.model.api.feature.FeatureDescriptionDto;
import com.ubnt.model.api.feature.FeatureVerificationResponse;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowPrivilege;
import com.ubnt.net.v2.config.security.annotation.AllowUCoreLocal;
import com.ubnt.service.features.N;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Tag(name="Features")
public class FeaturesController {
    private final N super;

    public FeaturesController(N n2) {
        this.super = n2;
    }

    @AllowPrivilege(value={"admin", "readonly", "hotspot"})
    @GetMapping(value={"/api/features"})
    @Operation(summary="List application features")
    @AllowUCoreLocal
    public List<String> listFeatures() {
        return this.super.\u00d500000();
    }

    @AllowPrivilege(value={"admin", "readonly", "hotspot"})
    @GetMapping(value={"/api/features/{featureName}/exists"})
    @Operation(summary="Verify existence of specific feature")
    @AllowUCoreLocal
    public FeatureVerificationResponse featureExists(@PathVariable(value="featureName") @Parameter(required=true, schema=@Schema(allowableValues={"ALL_UNIFI_DEVICES_PAGE, RADIUS_BATCH_USERS, RADIUS_PROFILES, UID_RADIUS, UID_RADIUS_GROUP_POLICY, UID_VPN, UID_VPN_ALLOW_WAN_LOCAL, UID_VPN_OVERRIDE_DNS, UID_VPN_STRICT_CLIENT_COMMON_NAME, UID_VPN_SUPPORT_UDP, UID_WIFI, UID_WIFI_IOT, UID_WIFI_RADIUS_GROUP_POLICY, LIVE_DEVICE_UPDATES"}), example="LIVE_DEVICE_UPDATES") String string) {
        return FeatureVerificationResponse.of(this.super.\u00f400000(string));
    }

    @GetMapping(value={"/api/site/{siteName}/features"})
    @Operation(summary="List site features")
    @AllowUCoreLocal
    public List<String> listSiteFeatures(@PathVariable(value="siteName") Site site, @RequestParam(value="includeSystemFeatures", defaultValue="false") boolean bl) {
        List<String> list = this.super.return(site.getId());
        if (bl) {
            list.addAll(this.super.\u00d500000());
        }
        return list;
    }

    @GetMapping(value={"/api/site/{siteName}/described-features"})
    @Operation(summary="List site features with description")
    @AllowUCoreLocal
    public List<FeatureDescriptionDto> listSiteFeaturesWithDescription(@PathVariable(value="siteName") Site site, @RequestParam(value="includeSystemFeatures", defaultValue="false") boolean bl) {
        return Stream.concat(this.super.\u00f500000(site.getId()).stream(), bl ? this.super.OO0000().stream() : Stream.empty()).map(FeatureDescriptionDto::of).collect(Collectors.toList());
    }

    @GetMapping(value={"/api/site/{siteName}/features/{featureName}/exists"})
    @Operation(summary="Verify existence of specific site feature")
    @AllowUCoreLocal
    public FeatureVerificationResponse siteFeatureExists(@PathVariable(value="siteName") Site site, @PathVariable(value="featureName") @Parameter(required=true, schema=@Schema(allowableValues={"WIFI_CONFIG_CREATED"}, example="WIFI_CONFIG_CREATED")) String string) {
        return FeatureVerificationResponse.of(this.super.if(site.getId(), string));
    }
}

