/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.config.ubios.ospf;

import com.ubnt.data.NetworkConf;
import com.ubnt.model.api.ospf.OspfAuthenticationType;
import com.ubnt.net.return.OooO;
import com.ubnt.service.ospf.OspfRouterDocument;
import com.ubnt.service.system.kA;
import com.ubnt.udapi.O;
import com.ubnt.udapi.for.C.G;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class do {
    private static final Logger o00000 = kA.\u00d2o0000;

    public List<G> class(OspfRouterDocument ospfRouterDocument, List<NetworkConf> list) {
        return ospfRouterDocument.getAreas().stream().map(ospfAreaDocumentPart -> G.\u00d2\u00d2\u00d5000().\u00d200000(ospfAreaDocumentPart.getAreaId()).o00000(ospfAreaDocumentPart.getAreaType()).\u00d400000(OspfAuthenticationType.OFF).Object(ospfAreaDocumentPart.getNetworkIds().stream().flatMap(string -> this.\u00d300000((String)string, list).stream()).flatMap(this::int).toList()).\u00f500000()).filter(g2 -> !g2.\u00d3\u00d2\u00d5000().isEmpty()).toList();
    }

    private Optional<NetworkConf> \u00d300000(String string, List<NetworkConf> list) {
        return list.stream().filter(networkConf -> StringUtils.equals((CharSequence)string, (CharSequence)networkConf.getId())).findAny().or(() -> {
            o00000.warn("Missing network '{}' assigned to an OSPF Area", (Object)string);
            return Optional.empty();
        });
    }

    private Stream<O> int(NetworkConf networkConf) {
        if (networkConf.isLocalSiteNetwork() || networkConf.isOpenVpnServer() || networkConf.isWireguardClientOrServer()) {
            return Stream.of(O.\u00d300000(networkConf.getSubnet()));
        }
        if (networkConf.isWanNetwork() && networkConf.isStaticWan()) {
            return Stream.concat(do.\u00f400000(networkConf).stream(), networkConf.getWanIpAliases().stream()).flatMap(this::\u00f600000).distinct().map(O::\u00d300000);
        }
        if (networkConf.isOpenVpnClientNetwork()) {
            return Optional.ofNullable(networkConf.getIpSubnetOrNull()).map(O::\u00d300000).or(() -> {
                o00000.warn("OpenVPN Client '{}' configured to be used in OSPF Area, but IP is missing. OpenVPN Client Client needs to establish successful connection first", (Object)networkConf.getId());
                return Optional.empty();
            }).stream();
        }
        if (this.\u00d200000(networkConf)) {
            return networkConf.getIpsecTunnelIp().map(OooO::\u00d200000).map(O::\u00d300000).or(() -> {
                o00000.warn("IPSec Site to Site VPN '{}' configured to be used in OSPF Area, but Tunnel IP is missing", (Object)networkConf.getId());
                return Optional.empty();
            }).stream();
        }
        o00000.warn("Cannot build OSPF Area for network '{}', purpose: '{}'", (Object)networkConf.getId(), (Object)networkConf.getNetworkPurpose());
        return Stream.empty();
    }

    private static Optional<String> \u00f400000(NetworkConf networkConf) {
        return networkConf.getWanIp().flatMap(string -> {
            String string2 = networkConf.getWanNetmask().orElse("255.255.255.0");
            return OooO.\u00d3O0000(string, string2);
        }).or(() -> {
            o00000.warn("Cannot build OSPF Area for WAN network: '{}', ip: '{}', netmask: '{}'", new Object[]{networkConf.getId(), networkConf.getWanIp().orElse(null), networkConf.getWanNetmask().orElse(null)});
            return Optional.empty();
        });
    }

    private boolean \u00d200000(NetworkConf networkConf) {
        return networkConf.isSiteIpsecVpnNetwork() && networkConf.isIpsecDynamicRouting() && networkConf.isIpsecTunnelIpEnabled() && networkConf.isRemoteVpnDynamicSubnetsEnabled();
    }

    private Stream<String> \u00f600000(String string) {
        try {
            return Stream.of(OooO.\u00d200000(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            o00000.warn("Cannot build OSPF area for subnet '{}'", (Object)string);
            return Stream.empty();
        }
    }
}

