/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ForgeEntityTypeTagsProvider
extends EntityTypeTagsProvider {
    public ForgeEntityTypeTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "forge", existingFileHelper);
    }

    public void addTags(HolderLookup.Provider lookupProvider) {
        this.tag(Tags.EntityTypes.BOSSES).add((Object[])new EntityType[]{EntityType.ENDER_DRAGON, EntityType.WITHER}).addOptionalTag(ForgeEntityTypeTagsProvider.forgeTagKey("bosses"));
        this.tag(Tags.EntityTypes.MINECARTS).add((Object[])new EntityType[]{EntityType.MINECART, EntityType.CHEST_MINECART, EntityType.FURNACE_MINECART, EntityType.HOPPER_MINECART, EntityType.SPAWNER_MINECART, EntityType.TNT_MINECART, EntityType.COMMAND_BLOCK_MINECART});
        this.tag(Tags.EntityTypes.BOATS).add((Object[])new EntityType[]{EntityType.ACACIA_BOAT, EntityType.ACACIA_CHEST_BOAT, EntityType.BIRCH_BOAT, EntityType.BIRCH_CHEST_BOAT, EntityType.CHERRY_BOAT, EntityType.CHERRY_CHEST_BOAT, EntityType.DARK_OAK_BOAT, EntityType.DARK_OAK_CHEST_BOAT, EntityType.JUNGLE_BOAT, EntityType.JUNGLE_CHEST_BOAT, EntityType.MANGROVE_BOAT, EntityType.MANGROVE_CHEST_BOAT, EntityType.OAK_BOAT, EntityType.OAK_CHEST_BOAT, EntityType.PALE_OAK_BOAT, EntityType.PALE_OAK_CHEST_BOAT, EntityType.SPRUCE_BOAT, EntityType.SPRUCE_CHEST_BOAT});
        this.tag(Tags.EntityTypes.CAPTURING_NOT_SUPPORTED);
        this.tag(Tags.EntityTypes.TELEPORTING_NOT_SUPPORTED);
        this.tag(ForgeEntityTypeTagsProvider.forgeTagKey("bosses")).add((Object[])new EntityType[]{EntityType.ENDER_DRAGON, EntityType.WITHER});
    }

    private static TagKey<EntityType<?>> forgeTagKey(String path) {
        return EntityTypeTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)path));
    }

    public String getName() {
        return "Forge EntityType Tags";
    }
}

