/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
class ObjectHolderRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<Consumer<Predicate<ResourceLocation>>> objectHolders = new HashSet<Consumer<Predicate<ResourceLocation>>>();

    ObjectHolderRegistry() {
    }

    static synchronized void addHandler(Consumer<Predicate<ResourceLocation>> ref) {
        objectHolders.add(ref);
    }

    static synchronized boolean removeHandler(Consumer<Predicate<ResourceLocation>> ref) {
        return objectHolders.remove(ref);
    }

    static void applyObjectHolders() {
        try {
            LOGGER.debug(ForgeRegistry.REGISTRIES, "Applying holder lookups");
            ObjectHolderRegistry.applyObjectHolders(key -> true);
            LOGGER.debug(ForgeRegistry.REGISTRIES, "Holder lookups applied");
        }
        catch (RuntimeException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    static void applyObjectHolders(Predicate<ResourceLocation> filter) {
        RuntimeException aggregate = new RuntimeException("Failed to apply some object holders, see suppressed exceptions for details");
        for (Consumer<Predicate<ResourceLocation>> objectHolder : objectHolders) {
            try {
                objectHolder.accept(filter);
            }
            catch (Exception e) {
                aggregate.addSuppressed(e);
            }
        }
        if (aggregate.getSuppressed().length > 0) {
            throw aggregate;
        }
    }
}

