/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformer;

import java.util.Objects;
import java.util.Set;
import net.minecraftforge.accesstransformer.AccessTransformer;
import net.minecraftforge.accesstransformer.Target;
import net.minecraftforge.accesstransformer.TargetType;
import org.objectweb.asm.tree.MethodNode;

public class MethodTarget
extends Target<MethodNode> {
    private final String targetName;

    public MethodTarget(String className, String methodName, String desc) {
        super(className);
        this.targetName = methodName + desc;
    }

    @Override
    public TargetType getType() {
        return TargetType.METHOD;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.targetName;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MethodTarget)) {
            return false;
        }
        MethodTarget o = (MethodTarget)obj;
        return super.equals(obj) && Objects.equals(this.targetName, o.targetName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getClassName(), this.getType(), this.targetName});
    }

    @Override
    public String targetName() {
        return this.targetName;
    }

    @Override
    public void apply(MethodNode node, AccessTransformer.Modifier targetAccess, AccessTransformer.FinalState targetFinalState, Set<String> privateChanged) {
        boolean wasPrivate = (node.access & 2) == 2;
        node.access = targetAccess.mergeWith(node.access);
        node.access = targetFinalState.mergeWith(node.access);
        if (wasPrivate && !"<init>".equals(node.name) && (node.access & 2) != 2) {
            privateChanged.add(node.name + node.desc);
        }
    }
}

