/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forge.transformers;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraftforge.coremod.api.ASMAPI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

record MethodRedirector() implements ITransformer<ClassNode>
{
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    private static final Replacement[] REPLACEMENTS = new Replacement[]{new Replacement(ASMAPI.MethodType.VIRTUAL, "finalizeSpawn", "(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/world/DifficultyInstance;Lnet/minecraft/world/entity/EntitySpawnReason;Lnet/minecraft/world/entity/SpawnGroupData;)Lnet/minecraft/world/entity/SpawnGroupData;", (Target[])GSON.fromJson((Reader)new InputStreamReader(MethodRedirector.sneak(() -> MethodRedirector.class.getModule().getResourceAsStream("coremods/finalize_spawn_targets.json"))), Target[].class), insn -> ASMAPI.buildMethodCall((ASMAPI.MethodType)ASMAPI.MethodType.STATIC, (String)"net/minecraftforge/event/ForgeEventFactory", (String)"onFinalizeSpawn", (String)"(Lnet/minecraft/world/entity/Mob;Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/world/DifficultyInstance;Lnet/minecraft/world/entity/EntitySpawnReason;Lnet/minecraft/world/entity/SpawnGroupData;)Lnet/minecraft/world/entity/SpawnGroupData;"))};

    private static <T> T sneak(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public TransformerVoteResult castVote(ITransformerVotingContext context) {
        return TransformerVoteResult.YES;
    }

    @NotNull
    public Set<ITransformer.Target> targets() {
        return Arrays.stream(REPLACEMENTS).map(Replacement::targets).flatMap(Arrays::stream).map(Target::className).map(ITransformer.Target::targetClass).collect(Collectors.toUnmodifiableSet());
    }

    @NotNull
    public ClassNode transform(ClassNode clazz, ITransformerVotingContext context) {
        for (Replacement replacement : REPLACEMENTS) {
            for (String methodString : MethodRedirector.getClassTargetMethods(clazz, replacement)) {
                String methodDesc;
                int splitPos;
                String methodName = methodString.substring(0, splitPos = methodString.indexOf(40));
                MethodNode method = ASMAPI.findMethodNode((ClassNode)clazz, (String)methodName, (String)(methodDesc = methodString.substring(splitPos)));
                if (method == null) {
                    LOGGER.error("Failed to redirect method call for {}! Method {} not found in class {}! This is a Forge bug, and is likely due to a Minecraft update changing something.", (Object)replacement.name, (Object)methodString, (Object)clazz.name);
                    continue;
                }
                for (AbstractInsnNode insn : method.instructions) {
                    if (!MethodRedirector.shouldReplace(insn, replacement)) continue;
                    MethodInsnNode methodInsn = (MethodInsnNode)insn;
                    MethodInsnNode redirection = (MethodInsnNode)replacement.factory.apply(methodInsn);
                    LOGGER.debug("Redirecting method call {}{} to {}{} inside of {}.{}", (Object)methodInsn.name, (Object)methodInsn.desc, (Object)redirection.name, (Object)redirection.desc, (Object)clazz.name, (Object)method.name);
                    ASMAPI.insertInsn((MethodNode)method, (AbstractInsnNode)methodInsn, (AbstractInsnNode)redirection, (ASMAPI.InsertMode)ASMAPI.InsertMode.REMOVE_ORIGINAL);
                }
            }
        }
        return clazz;
    }

    private static boolean shouldReplace(AbstractInsnNode insn, Replacement replacement) {
        return insn.getOpcode() == replacement.type.toOpcode() && replacement.name.equals(((MethodInsnNode)insn).name) && replacement.desc.equals(((MethodInsnNode)insn).desc);
    }

    private static List<String> getClassTargetMethods(ClassNode clazz, Replacement replacement) {
        for (Target t : replacement.targets) {
            if (!t.className.equals(clazz.name)) continue;
            ArrayList<String> targets = new ArrayList<String>(Arrays.asList(t.methods));
            for (MethodNode method : clazz.methods) {
                if ((method.access & 0x1000) == 0) continue;
                targets.add(method.name + method.desc);
            }
            return targets;
        }
        return List.of();
    }

    record Replacement(ASMAPI.MethodType type, String name, String desc, Target[] targets, UnaryOperator<MethodInsnNode> factory) {
    }

    record Target(@SerializedName(value="class") String className, String[] methods) {
    }
}

