/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.formdev.flatlaf.ui.FlatPanelUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class TmmPanelUI
extends FlatPanelUI {
    protected static String CLASS = "class";
    protected static String ROUNDED_PANEL = "roundedPanel";
    protected static String BORDER_RADIUS = "borderRadius";

    public static ComponentUI createUI(JComponent c) {
        return FlatUIUtils.canUseSharedUI((JComponent)c) ? FlatUIUtils.createSharedUI(TmmPanelUI.class, () -> new TmmPanelUI(true)) : new TmmPanelUI(false);
    }

    protected TmmPanelUI(boolean shared) {
        super(shared);
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            Object panelClass = c.getClientProperty(CLASS);
            if (panelClass != null && panelClass instanceof String && ROUNDED_PANEL.equals(panelClass.toString())) {
                this.updateRoundedPanel(g, c);
            } else {
                super.update(g, c);
            }
        }
    }

    private void updateRoundedPanel(Graphics g, JComponent c) {
        int radius = 15;
        Object borderRadius = c.getClientProperty(BORDER_RADIUS);
        if (borderRadius != null && borderRadius instanceof Integer) {
            radius = (Integer)borderRadius;
        }
        Graphics2D g2D = (Graphics2D)g;
        RenderingHints savedRenderingHints = g2D.getRenderingHints();
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(c.getBackground());
        g.fillRoundRect(0, 0, c.getWidth(), c.getHeight(), radius, radius);
        g2D.setRenderingHints(savedRenderingHints);
    }
}

